package com.ejie.aa21b.dao;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa21b.seguridad.Aa21bSeguridad;
import com.ejie.aa21b.util.Aa21bConstantes;

@Repository
@Transactional
public class ComunDaoImpl implements ComunDao {
	private JdbcTemplate jdbcTemplate;
	private static final Logger logger = LoggerFactory
			.getLogger(ComunDaoImpl.class);

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	@Override
	public boolean bloquear(String campoClave, String valorClave) {
		ComunDaoImpl.logger.info("M�todo bloquear");
		String codTabla = campoClave.substring(Math.max(
				campoClave.length() - 2, 0));
		String usuario = "";
		try {
			usuario = new Aa21bSeguridad().getUsuario().getPersonaXLNET()
					.getCodigo();
			// usuario = "VDIAZSAN";
		} catch (Exception e) {
		}
		String query = "UPDATE AA21B" + codTabla + "S01 SET BLOQ" + codTabla
				+ "=?, USUB" + codTabla + "=? WHERE " + campoClave
				+ "=? AND (BLOQ" + codTabla + "=? OR UPPER(USUB" + codTabla
				+ ")=UPPER(?))";

		// 1 = BLOQUEADA POR OTRO USUARIO
		// 0 = LIBRE (SE PUEDE MODIFICAR)

		ComunDaoImpl.logger.info("SQL = " + query);
		ComunDaoImpl.logger.info("PARAM1=" + 1);
		ComunDaoImpl.logger.info("PARAM2=" + usuario);
		ComunDaoImpl.logger.info("PARAM3=" + valorClave);
		ComunDaoImpl.logger.info("PARAM4=" + 0);
		ComunDaoImpl.logger.info("PARAM5=" + usuario);

		return this.jdbcTemplate.update(query, 1, usuario, valorClave, 0,
				usuario) > 0;
	}

	@Override
	public boolean bloquearSiAlta(String campoClave, String valorClave) {
		ComunDaoImpl.logger.info("M�todo bloquearSiAlta");
		String codTabla = campoClave.substring(Math.max(
				campoClave.length() - 2, 0));
		String usuario = "";
		try {
			usuario = new Aa21bSeguridad().getUsuario().getPersonaXLNET()
					.getCodigo();
		} catch (Exception e) {
		}
		String query = "UPDATE AA21B" + codTabla + "S01 SET BLOQ" + codTabla
				+ "=?, USUB" + codTabla + "=? WHERE " + campoClave
				+ "=? AND (BLOQ" + codTabla + "=? OR UPPER(USUB" + codTabla
				+ ")=UPPER(?)) AND SIT" + codTabla + "=?";

		// 1 = BLOQUEADA POR OTRO USUARIO
		// 0 = LIBRE (SE PUEDE MODIFICAR)

		ComunDaoImpl.logger.info("SQL = " + query);
		ComunDaoImpl.logger.info("PARAM1=" + codTabla);
		ComunDaoImpl.logger.info("PARAM2=" + 1);
		ComunDaoImpl.logger.info("PARAM3=" + usuario);
		ComunDaoImpl.logger.info("PARAM4=" + valorClave);
		ComunDaoImpl.logger.info("PARAM5=" + 0);
		ComunDaoImpl.logger.info("PARAM6=" + usuario);

		return this.jdbcTemplate.update(query, 1, usuario, valorClave, 0,
				usuario, Aa21bConstantes.SITUACION_ALTA) > 0;
	}

	@Override
	public boolean desbloquear(String campoClave, String valorClave) {
		ComunDaoImpl.logger.info("M�todo desbloquear");
		String codTabla = campoClave.substring(Math.max(
				campoClave.length() - 2, 0));
		String usuario = "";
		try {
			usuario = new Aa21bSeguridad().getUsuario().getPersonaXLNET()
					.getCodigo();
			// usuario = "VDIAZSAN";
		} catch (Exception e) {
		}
		String query = "UPDATE AA21B" + codTabla + "S01 SET BLOQ" + codTabla
				+ "=?, USUB" + codTabla + "=? WHERE " + campoClave
				+ "=? AND UPPER(USUB" + codTabla + ")=UPPER(?)";

		ComunDaoImpl.logger.info("SQL = " + query);
		ComunDaoImpl.logger.info("PARAM1=" + codTabla);
		ComunDaoImpl.logger.info("PARAM2=" + 0);
		ComunDaoImpl.logger.info("PARAM3=null");
		ComunDaoImpl.logger.info("PARAM4=" + valorClave);
		ComunDaoImpl.logger.info("PARAM5=" + usuario);

		return this.jdbcTemplate.update(query, 0, null, valorClave, usuario) > 0;
	}
}