package com.ejie.aa21b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa21b.model.Aa21b20s01;
import com.ejie.aa21b.model.Aa21b29s01;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa21b29s01DaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class Aa21b29s01DaoImpl implements Aa21b29s01Dao {
	private JdbcTemplate jdbcTemplate;
	private static final Logger logger = LoggerFactory
			.getLogger(Aa21b29s01DaoImpl.class);

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa21b29s01> rwMap = new RowMapper<Aa21b29s01>() {
		public Aa21b29s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa21b29s01(resultSet.getString("CSERV29"),
					resultSet.getString("CEXPE29"),
					resultSet.getString("AEXPE29"),
					resultSet.getInt("NEXPE29"), resultSet.getLong("CRESPO29"),
					resultSet.getDate("FRESPO29"),
					resultSet.getString("DRESPO29"));
		}
	};

	private RowMapper<Aa21b29s01> rwMapPK = new RowMapper<Aa21b29s01>() {
		public Aa21b29s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa21b29s01(resultSet.getString("CSERV29"),
					resultSet.getString("CEXPE29"),
					resultSet.getString("AEXPE29"),
					resultSet.getInt("NEXPE29"), resultSet.getLong("CRESPO29"),
					resultSet.getDate("FRESPO29"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Aa21b29s01>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa21b29s01>>() {
		public JerarquiaDto<Aa21b29s01> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Aa21b29s01 aa21b29s01 = new Aa21b29s01(
					resultSet.getString("CSERV29"),
					resultSet.getString("CEXPE29"),
					resultSet.getString("AEXPE29"),
					resultSet.getInt("NEXPE29"), resultSet.getLong("CRESPO29"),
					resultSet.getDate("FRESPO29"),
					resultSet.getString("DRESPO29"));

			JerarquiaDto<Aa21b29s01> jerarquia = new JerarquiaDto<Aa21b29s01>();
			jerarquia.setModel(aa21b29s01);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Aa21b29s01 table.
	 * 
	 * @param aa21b29s01
	 *            Aa21b29s01
	 * @return Aa21b29s01
	 */
	public Aa21b29s01 add(Aa21b29s01 aa21b29s01) {
		Aa21b29s01DaoImpl.logger
				.info("Método add: añade una entrada en el histórico");
		String query = "INSERT INTO AA21B29S01 (CSERV29, CEXPE29, AEXPE29, NEXPE29, CRESPO29, FRESPO29) VALUES (?,?,?,?,?,?)";

		Aa21b29s01DaoImpl.logger.info("SQL = " + query);
		Aa21b29s01DaoImpl.logger.info("PARAM1=" + aa21b29s01.getCserv29());
		Aa21b29s01DaoImpl.logger.info("PARAM2=" + aa21b29s01.getCexpe29());
		Aa21b29s01DaoImpl.logger.info("PARAM3=" + aa21b29s01.getAexpe29());
		Aa21b29s01DaoImpl.logger.info("PARAM4=" + aa21b29s01.getNexpe29());
		Aa21b29s01DaoImpl.logger.info("PARAM5=" + aa21b29s01.getCrespo29());
		Aa21b29s01DaoImpl.logger.info("PARAM7=" + aa21b29s01.getFrespo29());

		this.jdbcTemplate.update(query, aa21b29s01.getCserv29(),
				aa21b29s01.getCexpe29(), aa21b29s01.getAexpe29(),
				aa21b29s01.getNexpe29(), aa21b29s01.getCrespo29(),
				aa21b29s01.getFrespo29());

		/*
		 * StringBuffer query = new StringBuffer();
		 * query.append(" 	MERGE INTO AA21B29S01 h USING DUAL "); query.append(
		 * " 	ON(h.CSERV29=? AND CEXPE29=? AND AEXPE29=? AND NEXPE29=? AND CRESPO29=?)"
		 * ); query.append(" 	WHEN NOT MATCHED THEN"); query.append(
		 * "  INSERT (CSERV29, CEXPE29, AEXPE29, NEXPE29, CRESPO29, FRESPO29)");
		 * query.append("  VALUES (?,?,?,?,?,?)"); // String query = //
		 * "INSERT INTO AA21B29S01 (CSERV29, CEXPE29, AEXPE29, NEXPE29, CRESPO29, FRESPO29) VALUES (?,?,?,?,?,?)"
		 * ;
		 * 
		 * Aa21b29s01DaoImpl.logger.info("SQL = " + query);
		 * Aa21b29s01DaoImpl.logger.info("PARAM1=" + aa21b29s01.getCserv29());
		 * Aa21b29s01DaoImpl.logger.info("PARAM2=" + aa21b29s01.getCexpe29());
		 * Aa21b29s01DaoImpl.logger.info("PARAM3=" + aa21b29s01.getAexpe29());
		 * Aa21b29s01DaoImpl.logger.info("PARAM4=" + aa21b29s01.getNexpe29());
		 * Aa21b29s01DaoImpl.logger.info("PARAM5=" + aa21b29s01.getCrespo29());
		 * Aa21b29s01DaoImpl.logger.info("PARAM6=" + aa21b29s01.getCserv29());
		 * Aa21b29s01DaoImpl.logger.info("PARAM7=" + aa21b29s01.getCexpe29());
		 * Aa21b29s01DaoImpl.logger.info("PARAM8=" + aa21b29s01.getAexpe29());
		 * Aa21b29s01DaoImpl.logger.info("PARAM9=" + aa21b29s01.getNexpe29());
		 * Aa21b29s01DaoImpl.logger.info("PARAM10=" + aa21b29s01.getCrespo29());
		 * Aa21b29s01DaoImpl.logger.info("PARAM11=" + aa21b29s01.getFrespo29());
		 * 
		 * this.jdbcTemplate.update(query.toString(), aa21b29s01.getCserv29(),
		 * aa21b29s01.getCexpe29(), aa21b29s01.getAexpe29(),
		 * aa21b29s01.getNexpe29(), aa21b29s01.getCrespo29(),
		 * aa21b29s01.getCserv29(), aa21b29s01.getCexpe29(),
		 * aa21b29s01.getAexpe29(), aa21b29s01.getNexpe29(),
		 * aa21b29s01.getCrespo29(), aa21b29s01.getFrespo29());
		 */
		return aa21b29s01;
	}

	/**
	 * Updates a single row in the Aa21b29s01 table.
	 * 
	 * @param aa21b29s01
	 *            Aa21b29s01
	 * @return Aa21b29s01
	 */
	public Aa21b29s01 update(Aa21b29s01 aa21b29s01) {
		Aa21b29s01DaoImpl.logger.info("Método update");
		String query = "UPDATE AA21B29S01 SET  WHERE CSERV29=? AND CEXPE29=? AND AEXPE29=? AND NEXPE29=? AND CRESPO29=? AND FRESPO29=?";

		Aa21b29s01DaoImpl.logger.info("SQL = " + query);
		Aa21b29s01DaoImpl.logger.info("PARAM1=" + aa21b29s01.getCserv29());
		Aa21b29s01DaoImpl.logger.info("PARAM2=" + aa21b29s01.getCexpe29());
		Aa21b29s01DaoImpl.logger.info("PARAM3=" + aa21b29s01.getAexpe29());
		Aa21b29s01DaoImpl.logger.info("PARAM4=" + aa21b29s01.getNexpe29());
		Aa21b29s01DaoImpl.logger.info("PARAM5=" + aa21b29s01.getCrespo29());
		Aa21b29s01DaoImpl.logger.info("PARAM7=" + aa21b29s01.getFrespo29());

		this.jdbcTemplate.update(query, aa21b29s01.getCserv29(),
				aa21b29s01.getCexpe29(), aa21b29s01.getAexpe29(),
				aa21b29s01.getNexpe29(), aa21b29s01.getCrespo29(),
				aa21b29s01.getFrespo29());
		return aa21b29s01;
	}

	/**
	 * Actualiza el ceserv en todos los responabls
	 * 
	 * @param aa21b29s01
	 * @param nuevoAexpe
	 * @param nuevoNexpe
	 * @return
	 */
	public int update(Aa21b20s01 aa21b29s01, String nuevoCexpe,
			long nuevoAexpe, int nuevoNexpe) {
		Aa21b29s01DaoImpl.logger.info("Método update");
		String query = "UPDATE AA21B29S01 SET CEXPE29=?,AEXPE29=? , NEXPE29=?  WHERE CSERV29=? AND CEXPE29=? AND AEXPE29=? AND NEXPE29=?";

		Aa21b29s01DaoImpl.logger.info("SQL = " + query);
		Aa21b29s01DaoImpl.logger.info("PARAM1=" + nuevoCexpe);
		Aa21b29s01DaoImpl.logger.info("PARAM2=" + nuevoAexpe);
		Aa21b29s01DaoImpl.logger.info("PARAM3=" + nuevoNexpe);
		Aa21b29s01DaoImpl.logger.info("PARAM4=" + aa21b29s01.getCserv20());
		Aa21b29s01DaoImpl.logger.info("PARAM5=" + aa21b29s01.getCexpe20());
		Aa21b29s01DaoImpl.logger.info("PARAM6=" + aa21b29s01.getAexpe20());
		Aa21b29s01DaoImpl.logger.info("PARAM7=" + aa21b29s01.getNexpe20());
		return this.jdbcTemplate.update(query, nuevoCexpe, nuevoAexpe,
				nuevoNexpe, aa21b29s01.getCserv20(), aa21b29s01.getCexpe20(),
				aa21b29s01.getAexpe20(), aa21b29s01.getNexpe20());

	}

	/**
	 * Finds a single row in the Aa21b29s01 table.
	 * 
	 * @param aa21b29s01
	 *            Aa21b29s01
	 * @return Aa21b29s01
	 */
	@Transactional(readOnly = true)
	public Aa21b29s01 find(Aa21b29s01 aa21b29s01) {
		Aa21b29s01DaoImpl.logger.info("Método find");
		String query = "SELECT t1.CSERV29 CSERV29, t1.CEXPE29 CEXPE29, t1.AEXPE29 AEXPE29, t1.NEXPE29 NEXPE29, t1.CRESPO29 CRESPO29, t1.FRESPO29 FRESPO29, t2.DUSU15 DRESPO29 FROM AA21B29S01 t1 LEFT JOIN AA21B15S01 t2 ON t1.CRESPO29 = t2.CUSU15 WHERE t1.CSERV29 = ?   AND t1.CEXPE29 = ?   AND t1.AEXPE29 = ?   AND t1.NEXPE29 = ?   AND t1.CRESPO29 = ?   AND t1.FRESPO29 = ?  ";

		List<Aa21b29s01> aa21b29s01List = this.jdbcTemplate.query(query,
				this.rwMap, aa21b29s01.getCserv29(), aa21b29s01.getCexpe29(),
				aa21b29s01.getAexpe29(), aa21b29s01.getNexpe29(),
				aa21b29s01.getCrespo29(), aa21b29s01.getFrespo29());

		Aa21b29s01DaoImpl.logger.info("SQL = " + query);
		Aa21b29s01DaoImpl.logger.info("PARAM1=" + aa21b29s01.getCserv29());
		Aa21b29s01DaoImpl.logger.info("PARAM2=" + aa21b29s01.getCexpe29());
		Aa21b29s01DaoImpl.logger.info("PARAM3=" + aa21b29s01.getAexpe29());
		Aa21b29s01DaoImpl.logger.info("PARAM4=" + aa21b29s01.getNexpe29());
		Aa21b29s01DaoImpl.logger.info("PARAM5=" + aa21b29s01.getCrespo29());
		Aa21b29s01DaoImpl.logger.info("PARAM7=" + aa21b29s01.getFrespo29());
		return (Aa21b29s01) DataAccessUtils.uniqueResult(aa21b29s01List);
	}

	/**
	 * Removes a single row in the Aa21b29s01 table.
	 * 
	 * @param aa21b29s01
	 *            Aa21b29s01
	 * @return
	 */
	public void remove(Aa21b29s01 aa21b29s01) {
		Aa21b29s01DaoImpl.logger.info("Método remove");
		String query = "DELETE FROM AA21B29S01 WHERE CSERV29=? AND CEXPE29=? AND AEXPE29=? AND NEXPE29=? AND CRESPO29=? AND FRESPO29=?";

		Aa21b29s01DaoImpl.logger.info("SQL = " + query);
		Aa21b29s01DaoImpl.logger.info("PARAM1=" + aa21b29s01.getCserv29());
		Aa21b29s01DaoImpl.logger.info("PARAM2=" + aa21b29s01.getCexpe29());
		Aa21b29s01DaoImpl.logger.info("PARAM3=" + aa21b29s01.getAexpe29());
		Aa21b29s01DaoImpl.logger.info("PARAM4=" + aa21b29s01.getNexpe29());
		Aa21b29s01DaoImpl.logger.info("PARAM5=" + aa21b29s01.getCrespo29());
		Aa21b29s01DaoImpl.logger.info("PARAM7=" + aa21b29s01.getFrespo29());
		this.jdbcTemplate.update(query, aa21b29s01.getCserv29(),
				aa21b29s01.getCexpe29(), aa21b29s01.getAexpe29(),
				aa21b29s01.getNexpe29(), aa21b29s01.getCrespo29(),
				aa21b29s01.getFrespo29());
	}

	/**
	 * Finds a list of rows in the Aa21b29s01 table.
	 * 
	 * @param aa21b29s01
	 *            Aa21b29s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa21b29s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa21b29s01> findAll(Aa21b29s01 aa21b29s01,
			JQGridRequestDto jqGridRequestDto) {
		Aa21b29s01DaoImpl.logger.info("Método findAll");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CSERV29 CSERV29,t1.CEXPE29 CEXPE29,t1.AEXPE29 AEXPE29,t1.NEXPE29 NEXPE29,t1.CRESPO29 CRESPO29,t1.FRESPO29 FRESPO29 ");
		query.append(",t2.DUSU15 DRESPO29 ");
		query.append("FROM AA21B29S01 t1 ");
		query.append(" LEFT JOIN AA21B15S01 t2 ON t1.CRESPO29 = t2.CUSU15 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa21b29s01);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		Aa21b29s01DaoImpl.logger.info("findAll");
		Aa21b29s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b29s01DaoImpl.logger.info("PARAMS" + params);

		return (List<Aa21b29s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Aa21b29s01 table using like.
	 * 
	 * @param aa21b29s01
	 *            Aa21b29s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa21b29s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa21b29s01> findAllLike(Aa21b29s01 aa21b29s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {

		Aa21b29s01DaoImpl.logger.info("Método findAllLike");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CSERV29 CSERV29,t1.CEXPE29 CEXPE29,t1.AEXPE29 AEXPE29,t1.NEXPE29 NEXPE29,t1.CRESPO29 CRESPO29,t1.FRESPO29 FRESPO29 ");
		query.append(",t2.DUSU15 DRESPO29 ");
		query.append("FROM AA21B29S01 t1 ");
		query.append(" LEFT JOIN AA21B15S01 t2 ON t1.CRESPO29 = t2.CUSU15 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa21b29s01, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		Aa21b29s01DaoImpl.logger.info("findAllLike");
		Aa21b29s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b29s01DaoImpl.logger.info("PARAMS" + params);
		return (List<Aa21b29s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Aa21b29s01 table.
	 * 
	 * @param aa21b29s01
	 *            Aa21b29s01
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa21b29s01 aa21b29s01) {

		Aa21b29s01DaoImpl.logger.info("Método findAllCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA21B29S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa21b29s01);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		Aa21b29s01DaoImpl.logger.info("findAllCount");
		Aa21b29s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b29s01DaoImpl.logger.info("PARAMS" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Aa21b29s01 table using like.
	 * 
	 * @param aa21b29s01
	 *            Aa21b29s01
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Aa21b29s01 aa21b29s01, Boolean startsWith) {

		Aa21b29s01DaoImpl.logger.info("Método findAllLikeCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA21B29S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa21b29s01, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		Aa21b29s01DaoImpl.logger.info("findAllLikeCount");
		Aa21b29s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b29s01DaoImpl.logger.info("PARAMS" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Aa21b29s01 selected for rup_table
	 * 
	 * @param aa21b29s01
	 *            Aa21b29s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa21b29s01>>
	 */
	@Override
	public List<TableRowDto<Aa21b29s01>> reorderSelection(
			Aa21b29s01 aa21b29s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {

		Aa21b29s01DaoImpl.logger.info("Método reorderSelection");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CSERV29 CSERV29,t1.CEXPE29 CEXPE29,t1.AEXPE29 AEXPE29,t1.NEXPE29 NEXPE29,t1.CRESPO29 CRESPO29,t1.FRESPO29 FRESPO29 ");
		// FROM
		query.append(",t2.DUSU15 DRESPO29 ");
		query.append("FROM AA21B29S01 t1 ");
		query.append(" LEFT JOIN AA21B15S01 t2 ON t1.CRESPO29 = t2.CUSU15 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa21b29s01, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Aa21b29s01.class, filterParamList,
				"CSERV29,CEXPE29,AEXPE29,NEXPE29,CRESPO29,FRESPO29");

		Aa21b29s01DaoImpl.logger.info("reorderSelection");
		Aa21b29s01DaoImpl.logger.info("SQL = "
				+ sbReorderSelectionSQL.toString());
		Aa21b29s01DaoImpl.logger.info("PARAMs=" + filterParamList);

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa21b29s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Aa21b29s01
	 * @param searchParams
	 *            Aa21b29s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa21b29s01>>
	 */
	@Override
	public List<TableRowDto<Aa21b29s01>> search(Aa21b29s01 filterParams,
			Aa21b29s01 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {

		Aa21b29s01DaoImpl.logger.info("Método search");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CSERV29 CSERV29,t1.CEXPE29 CEXPE29,t1.AEXPE29 AEXPE29,t1.NEXPE29 NEXPE29,t1.CRESPO29 CRESPO29,t1.FRESPO29 FRESPO29 ");
		query.append(",t2.DUSU15 DRESPO29 ");
		// FROM
		query.append("FROM AA21B29S01 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		query.append(" LEFT JOIN AA21B15S01 t2 ON t1.CRESPO29 = t2.CUSU15 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Aa21b29s01.class, filterParamList,
				searchSQL, searchParamList, from_alias,
				"CSERV29,CEXPE29,AEXPE29,NEXPE29,CRESPO29,FRESPO29");

		Aa21b29s01DaoImpl.logger.info("search");
		Aa21b29s01DaoImpl.logger.info("SQL = "
				+ sbReorderSelectionSQL.toString());
		Aa21b29s01DaoImpl.logger.info("PARAMs=" + filterParamList);

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa21b29s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filteraa21b29s01
	 *            Aa21b29s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Aa21b29s01 filteraa21b29s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {

		Aa21b29s01DaoImpl.logger.info("Método removeMultiple");
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.CSERV29 CSERV29,t1.CEXPE29 CEXPE29,t1.AEXPE29 AEXPE29,t1.NEXPE29 NEXPE29,t1.CRESPO29 CRESPO29,t1.FRESPO29 FRESPO29 ");
		// FROM
		query.append(",t2.DUSU15 DRESPO29 ");
		query.append("FROM AA21B29S01 t1 ");
		query.append(" LEFT JOIN AA21B15S01 t2 ON t1.CRESPO29 = t2.CUSU15 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa21b29s01,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Aa21b29s01.class,
						query, params,
						"CSERV29,CEXPE29,AEXPE29,NEXPE29,CRESPO29,FRESPO29");
		Aa21b29s01DaoImpl.logger.info("removeMultiple");
		Aa21b29s01DaoImpl.logger
				.info("SQL = " + sbRemoveMultipleSQL.toString());
		Aa21b29s01DaoImpl.logger.info("PARAMs=" + params);
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa21b29s01 table.
	 * 
	 * @param filterAa21b29s01
	 *            Aa21b29s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa21b29s01>>
	 */
	@Override
	public List<JerarquiaDto<Aa21b29s01>> findAllLikeJerarquia(
			Aa21b29s01 filterAa21b29s01, JQGridRequestDto jqGridRequestDto) {

		Aa21b29s01DaoImpl.logger.info("Método findAllLikeJerarquia");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CSERV29 CSERV29,t1.CEXPE29 CEXPE29,t1.AEXPE29 AEXPE29,t1.NEXPE29 NEXPE29,t1.CRESPO29 CRESPO29,t1.FRESPO29 FRESPO29 ");
		query.append(",t2.DUSU15 DRESPO29 ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA21B29S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA21B29S01");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		query.append(" LEFT JOIN AA21B15S01 t2 ON t1.CRESPO29 = t2.CUSU15 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa21b29s01, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "CSERV29,CEXPE29,AEXPE29,NEXPE29,CRESPO29,FRESPO29",
				"ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa21b29s01DaoImpl.logger.info("findAllLikeJerarquia");
		Aa21b29s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b29s01DaoImpl.logger.info("PARAMs=" + params);
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa21b29s01
	 *            Aa21b29s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Aa21b29s01 filterAa21b29s01,
			JQGridRequestDto jqGridRequestDto) {

		Aa21b29s01DaoImpl.logger.info("Método findAllLikeCountJerarquia");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA21B29S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA21B29S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa21b29s01, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere,
				"CSERV29,CEXPE29,AEXPE29,NEXPE29,CRESPO29,FRESPO29",
				"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa21b29s01DaoImpl.logger.info("findAllLikeCountJerarquia");
		Aa21b29s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b29s01DaoImpl.logger.info("PARAMs=" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa21b29s01
	 *            Aa21b29s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa21b29s01>>
	 */
	@Override
	public List<TableRowDto<Aa21b29s01>> findAllChild(
			Aa21b29s01 filterAa21b29s01, JQGridRequestDto jqGridRequestDto) {
		Aa21b29s01DaoImpl.logger.info("Método findAllChild");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA21B29S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA21B29S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa21b29s01, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere,
				"CSERV29,CEXPE29,AEXPE29,NEXPE29,CRESPO29,FRESPO29",
				"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa21b29s01DaoImpl.logger.info("findAllChild");
		Aa21b29s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b29s01DaoImpl.logger.info("PARAMs=" + params);
		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<Aa21b29s01>(this.rwMapPK,
						"CSERV29,CEXPE29,AEXPE29,NEXPE29,CRESPO29,FRESPO29"),
				params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa21b29s01 entity
	 * 
	 * @param aa21b29s01
	 *            Aa21b29s01 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa21b29s01 aa21b29s01) {

		StringBuilder where = new StringBuilder(
				Aa21b29s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa21b29s01 != null && aa21b29s01.getCserv29() != null) {
			where.append(" AND t1.CSERV29 = ?");
			params.add(aa21b29s01.getCserv29());
		}
		if (aa21b29s01 != null && aa21b29s01.getCexpe29() != null) {
			where.append(" AND t1.CEXPE29 = ?");
			params.add(aa21b29s01.getCexpe29());
		}
		if (aa21b29s01 != null && aa21b29s01.getAexpe29() != null) {
			where.append(" AND t1.AEXPE29 = ?");
			params.add(aa21b29s01.getAexpe29());
		}
		if (aa21b29s01 != null && aa21b29s01.getNexpe29() != null) {
			where.append(" AND t1.NEXPE29 = ?");
			params.add(aa21b29s01.getNexpe29());
		}
		if (aa21b29s01 != null && aa21b29s01.getCrespo29() != null) {
			where.append(" AND t1.CRESPO29 = ?");
			params.add(aa21b29s01.getCrespo29());
		}
		if (aa21b29s01 != null && aa21b29s01.getFrespo29() != null) {
			where.append(" AND t1.FRESPO29 = ?");
			params.add(aa21b29s01.getFrespo29());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa21b29s01 entity
	 * 
	 * @param aa21b29s01
	 *            Aa21b29s01 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Aa21b29s01 aa21b29s01,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Aa21b29s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa21b29s01 != null && aa21b29s01.getCserv29() != null) {
			where.append(" AND t1.CSERV29 = ? ");
			params.add(aa21b29s01.getCserv29());
		}
		if (aa21b29s01 != null && aa21b29s01.getCexpe29() != null) {
			where.append(" AND t1.CEXPE29 = ?");
			params.add(aa21b29s01.getCexpe29());
		}
		if (aa21b29s01 != null && aa21b29s01.getAexpe29() != null) {
			where.append(" AND t1.AEXPE29 = ?");
			params.add(aa21b29s01.getAexpe29());
		}
		if (aa21b29s01 != null && aa21b29s01.getNexpe29() != null) {
			where.append(" AND t1.NEXPE29 = ?");
			params.add(aa21b29s01.getNexpe29());
		}
		if (aa21b29s01 != null && aa21b29s01.getCrespo29() != null) {
			where.append(" AND t1.CRESPO29 = ?");
			params.add(aa21b29s01.getCrespo29());
		}
		if (aa21b29s01 != null && aa21b29s01.getFrespo29() != null) {
			where.append(" AND t1.FRESPO29 = ?");
			params.add(aa21b29s01.getFrespo29());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
