package com.ejie.aa21b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa21b.model.Aa21b20s01;
import com.ejie.aa21b.model.Aa21b25s01;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa21b25s01DaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class Aa21b25s01DaoImpl implements Aa21b25s01Dao {
	private JdbcTemplate jdbcTemplate;
	private static final Logger logger = LoggerFactory
			.getLogger(Aa21b25s01DaoImpl.class);

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa21b25s01> rwMap = new RowMapper<Aa21b25s01>() {
		public Aa21b25s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Aa21b25s01 dato = new Aa21b25s01(resultSet.getLong("CSERV25"),
					resultSet.getString("CEXPE25"),
					resultSet.getLong("AEXPE25"), resultSet.getInt("NEXPE25"),
					resultSet.getString("TDOCU25"),
					resultSet.getInt("CDOCU25"), resultSet.getInt("NDOCU25"),
					resultSet.getString("TEXTO25"),
					resultSet.getDate("FANOT25"), resultSet.getLong("AANOT25"),
					resultSet.getLong("NANOT25"),
					resultSet.getString("DDOCU25"),
					resultSet.getString("EDOCU25"));
			dato.setExtdocu25(resultSet.getString("EXTDOCU25"));
			dato.setCodpid25(resultSet.getString("CODPID25"));
			dato.setCtype25(resultSet.getString("CTYPE25"));
			return dato;
		}
	};

	private RowMapper<Aa21b25s01> rwMapPK = new RowMapper<Aa21b25s01>() {
		public Aa21b25s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa21b25s01(resultSet.getLong("CSERV25"),
					resultSet.getString("CEXPE25"),
					resultSet.getLong("AEXPE25"), resultSet.getInt("NEXPE25"),
					resultSet.getString("TDOCU25"),
					resultSet.getInt("CDOCU25"), resultSet.getInt("NDOCU25"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Aa21b25s01>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa21b25s01>>() {
		public JerarquiaDto<Aa21b25s01> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Aa21b25s01 aa21b25s01 = new Aa21b25s01(
					resultSet.getLong("CSERV25"),
					resultSet.getString("CEXPE25"),
					resultSet.getLong("AEXPE25"), resultSet.getInt("NEXPE25"),
					resultSet.getString("TDOCU25"),
					resultSet.getInt("CDOCU25"), resultSet.getInt("NDOCU25"),
					resultSet.getString("TEXTO25"),
					resultSet.getDate("FANOT25"), resultSet.getLong("AANOT25"),
					resultSet.getLong("NANOT25"),
					resultSet.getString("DDOCU25"),
					resultSet.getString("EDOCU25"));

			JerarquiaDto<Aa21b25s01> jerarquia = new JerarquiaDto<Aa21b25s01>();
			jerarquia.setModel(aa21b25s01);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Aa21b25s01 table.
	 * 
	 * @param aa21b25s01
	 *            Aa21b25s01
	 * @return Aa21b25s01
	 */
	public Aa21b25s01 add(Aa21b25s01 aa21b25s01) {

		Aa21b25s01DaoImpl.logger.info("M�todo add");

		Integer correlativoDocExp = this
				.obtenerCorrelativoDocExpediente(aa21b25s01);

		aa21b25s01.setNdocu25(correlativoDocExp);
		String query = "INSERT INTO AA21B25S01 (CSERV25, CEXPE25, AEXPE25, NEXPE25, TDOCU25, CDOCU25, NDOCU25, TEXTO25, FANOT25, AANOT25, NANOT25,CODPID25,EXTDOCU25,CTYPE25) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		Aa21b25s01DaoImpl.logger.info("SQL = " + query);
		Aa21b25s01DaoImpl.logger.info("PARAM1=" + aa21b25s01.getCserv25());
		Aa21b25s01DaoImpl.logger.info("PARAM2=" + aa21b25s01.getCexpe25());
		Aa21b25s01DaoImpl.logger.info("PARAM3=" + aa21b25s01.getAexpe25());
		Aa21b25s01DaoImpl.logger.info("PARAM4=" + aa21b25s01.getNexpe25());
		Aa21b25s01DaoImpl.logger.info("PARAM5=" + aa21b25s01.getTdocu25());
		Aa21b25s01DaoImpl.logger.info("PARAM6=" + aa21b25s01.getCdocu25());
		Aa21b25s01DaoImpl.logger.info("PARAM7=" + correlativoDocExp);
		Aa21b25s01DaoImpl.logger.info("PARAM8=" + aa21b25s01.getTexto25());
		Aa21b25s01DaoImpl.logger.info("PARAM9=" + aa21b25s01.getFanot25());
		Aa21b25s01DaoImpl.logger.info("PARAM10=" + aa21b25s01.getAanot25());
		Aa21b25s01DaoImpl.logger.info("PARAM11=" + aa21b25s01.getNanot25());
		Aa21b25s01DaoImpl.logger.info("PARAM12=" + aa21b25s01.getCodpid25());
		Aa21b25s01DaoImpl.logger.info("PARAM13=" + aa21b25s01.getExtdocu25());
		Aa21b25s01DaoImpl.logger.info("PARAM14=" + aa21b25s01.getCtype25());
		this.jdbcTemplate.update(query, aa21b25s01.getCserv25(),
				aa21b25s01.getCexpe25(), aa21b25s01.getAexpe25(),
				aa21b25s01.getNexpe25(), aa21b25s01.getTdocu25(),
				aa21b25s01.getCdocu25(), correlativoDocExp,
				aa21b25s01.getTexto25(), aa21b25s01.getFanot25(),
				aa21b25s01.getAanot25(), aa21b25s01.getNanot25(),
				aa21b25s01.getCodpid25(), aa21b25s01.getExtdocu25(),
				aa21b25s01.getCtype25());
		return aa21b25s01;
	}

	/**
	 * Finds rows in the Doc Exp table using like.
	 * 
	 * @param docExp
	 *            Aa21b25s01
	 * 
	 * @return Integer
	 */

	@Transactional(readOnly = true)
	public Integer obtenerCorrelativoDocExpediente(Aa21b25s01 docExp) {

		Aa21b25s01DaoImpl.logger.info("M�todo obtenerCorrelativoDocExpediente");
		StringBuffer query = new StringBuffer(
				"SELECT  MAX(NDOCU25) FROM Aa21b25s01 where CSERV25 = ? AND CEXPE25 = ? AND AEXPE25 = ? AND NEXPE25 = ? ");
		List<Object> params = new ArrayList<Object>();
		params.add(docExp.getCserv25());
		params.add(docExp.getCexpe25());
		params.add(docExp.getAexpe25());
		params.add(docExp.getNexpe25());
		Aa21b25s01DaoImpl.logger.info("obtenerCorrelativoExpediente");
		Aa21b25s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b25s01DaoImpl.logger.info("PARAMs=" + params);
		return Integer.valueOf(this.jdbcTemplate.queryForInt(query.toString(),
				params.toArray())) + 1;
	}

	/**
	 * Updates a single row in the Aa21b25s01 table.
	 * 
	 * @param aa21b25s01
	 *            Aa21b25s01
	 * @return Aa21b25s01
	 */
	public Aa21b25s01 update(Aa21b25s01 aa21b25s01) {
		Aa21b25s01DaoImpl.logger.info("M�todo update");
		String query = "UPDATE AA21B25S01 SET TEXTO25=?, FANOT25=?, AANOT25=?, NANOT25=?, codpid25=?, extdocu25=?,CTYPE25=? WHERE CSERV25=? AND CEXPE25=? AND AEXPE25=? AND NEXPE25=? AND TDOCU25=? AND CDOCU25=? AND NDOCU25=?";

		Aa21b25s01DaoImpl.logger.info("SQL = " + query);
		Aa21b25s01DaoImpl.logger.info("PARAM1=" + aa21b25s01.getTexto25());
		Aa21b25s01DaoImpl.logger.info("PARAM2=" + aa21b25s01.getFanot25());
		Aa21b25s01DaoImpl.logger.info("PARAM3=" + aa21b25s01.getAanot25());
		Aa21b25s01DaoImpl.logger.info("PARAM4=" + aa21b25s01.getNanot25());
		Aa21b25s01DaoImpl.logger.info("PARAM5=" + aa21b25s01.getCodpid25());
		Aa21b25s01DaoImpl.logger.info("PARAM6=" + aa21b25s01.getExtdocu25());
		Aa21b25s01DaoImpl.logger.info("PARAM7=" + aa21b25s01.getCtype25());

		Aa21b25s01DaoImpl.logger.info("PARAM6pk=" + aa21b25s01.getCserv25());
		Aa21b25s01DaoImpl.logger.info("PARAM7pk=" + aa21b25s01.getCexpe25());
		Aa21b25s01DaoImpl.logger.info("PARAM8pk=" + aa21b25s01.getAexpe25());
		Aa21b25s01DaoImpl.logger.info("PARAM9pk=" + aa21b25s01.getNexpe25());
		Aa21b25s01DaoImpl.logger.info("PARAM10pk=" + aa21b25s01.getTdocu25());
		Aa21b25s01DaoImpl.logger.info("PARAM11pk=" + aa21b25s01.getCdocu25());
		Aa21b25s01DaoImpl.logger.info("PARAM12pk=" + aa21b25s01.getNdocu25());

		this.jdbcTemplate.update(query, aa21b25s01.getTexto25(),
				aa21b25s01.getFanot25(), aa21b25s01.getAanot25(),
				aa21b25s01.getNanot25(), aa21b25s01.getCodpid25(),
				aa21b25s01.getExtdocu25(), aa21b25s01.getCtype25(),
				aa21b25s01.getCserv25(), aa21b25s01.getCexpe25(),
				aa21b25s01.getAexpe25(), aa21b25s01.getNexpe25(),
				aa21b25s01.getTdocu25(), aa21b25s01.getCdocu25(),
				aa21b25s01.getNdocu25());
		return aa21b25s01;
	}

	/**
	 * Actualiza el nuevoCexpe de todos los documentos del expediente
	 * 
	 * @param aa21b25s01
	 * @param nuevoCserv
	 * @param nuevoAexpe
	 * @param nuevoNexpe
	 * @return
	 */
	public int update(Aa21b20s01 aa21b25s01, String nuevoCexpe,
			long nuevoAexpe, int nuevoNexpe) {
		Aa21b25s01DaoImpl.logger.info("M�todo update");
		String query = "UPDATE AA21B25S01 SET CEXPE25=?, AEXPE25=?, NEXPE25=? WHERE CSERV25=? AND CEXPE25=? AND AEXPE25=? AND NEXPE25=?";

		Aa21b25s01DaoImpl.logger.info("SQL = " + query);
		Aa21b25s01DaoImpl.logger.info("PARAM1=" + nuevoCexpe);
		Aa21b25s01DaoImpl.logger.info("PARAM1=" + nuevoAexpe);
		Aa21b25s01DaoImpl.logger.info("PARAM1=" + nuevoNexpe);
		Aa21b25s01DaoImpl.logger.info("PARAM2pk=" + aa21b25s01.getCserv20());
		Aa21b25s01DaoImpl.logger.info("PARAM3pk=" + aa21b25s01.getCexpe20());
		Aa21b25s01DaoImpl.logger.info("PARAM4pk=" + aa21b25s01.getAexpe20());
		Aa21b25s01DaoImpl.logger.info("PARAM5pk=" + aa21b25s01.getNexpe20());

		return this.jdbcTemplate.update(query, nuevoCexpe, nuevoAexpe,
				nuevoNexpe, aa21b25s01.getCserv20(), aa21b25s01.getCexpe20(),
				aa21b25s01.getAexpe20(), aa21b25s01.getNexpe20());

	}

	/**
	 * Finds a single row in the Aa21b25s01 table.
	 * 
	 * @param aa21b25s01
	 *            Aa21b25s01
	 * @return Aa21b25s01
	 */
	@Transactional(readOnly = true)
	public Aa21b25s01 find(Aa21b25s01 aa21b25s01) {
		Aa21b25s01DaoImpl.logger.info("M�todo find");
		String query = "SELECT t1.CTYPE25 CTYPE25,t1.EXTDOCU25 EXTDOCU25,t1.CODPID25 CODPID25,t1.CSERV25 CSERV25, t1.CEXPE25 CEXPE25, t1.AEXPE25 AEXPE25, t1.NEXPE25 NEXPE25, t1.TDOCU25 TDOCU25, t1.CDOCU25 CDOCU25, t1.NDOCU25 NDOCU25, t1.TEXTO25 TEXTO25, t1.FANOT25 FANOT25, t1.AANOT25 AANOT25, t1.NANOT25 NANOT25, t2.DDOCU05 DDOCU25, t2.EDOCU05 EDOCU25 FROM AA21B25S01 t1 LEFT JOIN AA21B05S01 t2 ON t1.CDOCU25 = t2.CDOCU05  WHERE t1.CSERV25 = ?   AND t1.CEXPE25 = ?   AND t1.AEXPE25 = ?   AND t1.NEXPE25 = ?   AND t1.TDOCU25 = ?   AND t1.CDOCU25 = ?   AND t1.NDOCU25 = ?  ";

		Aa21b25s01DaoImpl.logger.info("SQL = " + query);
		Aa21b25s01DaoImpl.logger.info("PARAM1pk=" + aa21b25s01.getCserv25());
		Aa21b25s01DaoImpl.logger.info("PARAM2pk=" + aa21b25s01.getCexpe25());
		Aa21b25s01DaoImpl.logger.info("PARAM3pk=" + aa21b25s01.getAexpe25());
		Aa21b25s01DaoImpl.logger.info("PARAM4pk=" + aa21b25s01.getNexpe25());
		Aa21b25s01DaoImpl.logger.info("PARAM5pk=" + aa21b25s01.getTdocu25());
		Aa21b25s01DaoImpl.logger.info("PARAM6pk=" + aa21b25s01.getCdocu25());
		Aa21b25s01DaoImpl.logger.info("PARAM7pk=" + aa21b25s01.getNdocu25());

		List<Aa21b25s01> aa21b25s01List = this.jdbcTemplate.query(query,
				this.rwMap, aa21b25s01.getCserv25(), aa21b25s01.getCexpe25(),
				aa21b25s01.getAexpe25(), aa21b25s01.getNexpe25(),
				aa21b25s01.getTdocu25(), aa21b25s01.getCdocu25(),
				aa21b25s01.getNdocu25());
		return (Aa21b25s01) DataAccessUtils.uniqueResult(aa21b25s01List);
	}

	/**
	 * Removes a single row in the Aa21b25s01 table.
	 * 
	 * @param aa21b25s01
	 *            Aa21b25s01
	 * @return
	 */
	public void remove(Aa21b25s01 aa21b25s01) {
		Aa21b25s01DaoImpl.logger.info("M�todo remove");
		String query = "DELETE FROM AA21B25S01 WHERE CSERV25=? AND CEXPE25=? AND AEXPE25=? AND NEXPE25=? AND TDOCU25=? AND CDOCU25=? AND NDOCU25=?";

		Aa21b25s01DaoImpl.logger.info("SQL = " + query);
		Aa21b25s01DaoImpl.logger.info("PARAM1pk=" + aa21b25s01.getCserv25());
		Aa21b25s01DaoImpl.logger.info("PARAM2pk=" + aa21b25s01.getCexpe25());
		Aa21b25s01DaoImpl.logger.info("PARAM3pk=" + aa21b25s01.getAexpe25());
		Aa21b25s01DaoImpl.logger.info("PARAM4pk=" + aa21b25s01.getNexpe25());
		Aa21b25s01DaoImpl.logger.info("PARAM5pk=" + aa21b25s01.getTdocu25());
		Aa21b25s01DaoImpl.logger.info("PARAM6pk=" + aa21b25s01.getCdocu25());
		Aa21b25s01DaoImpl.logger.info("PARAM7pk=" + aa21b25s01.getNdocu25());
		this.jdbcTemplate.update(query, aa21b25s01.getCserv25(),
				aa21b25s01.getCexpe25(), aa21b25s01.getAexpe25(),
				aa21b25s01.getNexpe25(), aa21b25s01.getTdocu25(),
				aa21b25s01.getCdocu25(), aa21b25s01.getNdocu25());
	}

	/**
	 * Finds a list of rows in the Aa21b25s01 table.
	 * 
	 * @param aa21b25s01
	 *            Aa21b25s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa21b25s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa21b25s01> findAll(Aa21b25s01 aa21b25s01,
			JQGridRequestDto jqGridRequestDto) {

		Aa21b25s01DaoImpl.logger.info("M�todo findAll");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CTYPE25 CTYPE25,t1.EXTDOCU25 EXTDOCU25,t1.CODPID25 CODPID25,t1.CSERV25 CSERV25,t1.CEXPE25 CEXPE25,t1.AEXPE25 AEXPE25,t1.NEXPE25 NEXPE25,t1.TDOCU25 TDOCU25,t1.CDOCU25 CDOCU25,t1.NDOCU25 NDOCU25,t1.TEXTO25 TEXTO25,t1.FANOT25 FANOT25,t1.AANOT25 AANOT25,t1.NANOT25 NANOT25 ");
		query.append(",t2.DDOCU05 DDOCU25, t2.EDOCU05 EDOCU25 ");
		query.append("FROM AA21B25S01 t1 ");
		query.append(" LEFT JOIN AA21B05S01 t2 ON t1.CDOCU25 = t2.CDOCU05");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa21b25s01);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		Aa21b25s01DaoImpl.logger.info("findAll");
		Aa21b25s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b25s01DaoImpl.logger.info("PARAMS" + params);

		return (List<Aa21b25s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Aa21b25s01 table using like.
	 * 
	 * @param aa21b25s01
	 *            Aa21b25s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa21b25s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa21b25s01> findAllLike(Aa21b25s01 aa21b25s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		Aa21b25s01DaoImpl.logger.info("M�todo findAll");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CTYPE25 CTYPE25,t1.EXTDOCU25 EXTDOCU25,t1.CODPID25 CODPID25,t1.CSERV25 CSERV25,t1.CEXPE25 CEXPE25,t1.AEXPE25 AEXPE25,t1.NEXPE25 NEXPE25,t1.TDOCU25 TDOCU25,t1.CDOCU25 CDOCU25,t1.NDOCU25 NDOCU25,t1.TEXTO25 TEXTO25,t1.FANOT25 FANOT25,t1.AANOT25 AANOT25,t1.NANOT25 NANOT25 ");
		query.append(",t2.DDOCU05 DDOCU25, t2.EDOCU05 EDOCU25 ");
		query.append("FROM AA21B25S01 t1 ");
		query.append(" LEFT JOIN AA21B05S01 t2 ON t1.CDOCU25 = t2.CDOCU05");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa21b25s01, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		Aa21b25s01DaoImpl.logger.info("findAll");
		Aa21b25s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b25s01DaoImpl.logger.info("PARAMS" + params);

		return (List<Aa21b25s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Aa21b25s01 table.
	 * 
	 * @param aa21b25s01
	 *            Aa21b25s01
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa21b25s01 aa21b25s01) {

		Aa21b25s01DaoImpl.logger.info("M�todo findAllCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA21B25S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa21b25s01);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		Aa21b25s01DaoImpl.logger.info("findAllCount");
		Aa21b25s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b25s01DaoImpl.logger.info("PARAMS" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Aa21b25s01 table using like.
	 * 
	 * @param aa21b25s01
	 *            Aa21b25s01
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Aa21b25s01 aa21b25s01, Boolean startsWith) {
		Aa21b25s01DaoImpl.logger.info("M�todo findAllLikeCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA21B25S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa21b25s01, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		Aa21b25s01DaoImpl.logger.info("findAllLikeCount");
		Aa21b25s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b25s01DaoImpl.logger.info("PARAMS" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Aa21b25s01 selected for rup_table
	 * 
	 * @param aa21b25s01
	 *            Aa21b25s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa21b25s01>>
	 */
	@Override
	public List<TableRowDto<Aa21b25s01>> reorderSelection(
			Aa21b25s01 aa21b25s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {

		Aa21b25s01DaoImpl.logger.info("M�todo reorderSelection");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CSERV25 CSERV25,t1.CEXPE25 CEXPE25,t1.AEXPE25 AEXPE25,t1.NEXPE25 NEXPE25,t1.TDOCU25 TDOCU25,t1.CDOCU25 CDOCU25,t1.NDOCU25 NDOCU25,t1.TEXTO25 TEXTO25,t1.FANOT25 FANOT25,t1.AANOT25 AANOT25,t1.NANOT25 NANOT25 ");
		query.append(",t2.DDOCU05 DDOCU25, t2.EDOCU05 EDOCU25 ");
		// FROM
		query.append("FROM AA21B25S01 t1 ");
		query.append(" LEFT JOIN AA21B05S01 t2 ON t1.CDOCU25 = t2.CDOCU05");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa21b25s01, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Aa21b25s01.class, filterParamList,
				"CSERV25,CEXPE25,AEXPE25,NEXPE25,TDOCU25,CDOCU25,NDOCU25");

		Aa21b25s01DaoImpl.logger.info("reorderSelection");
		Aa21b25s01DaoImpl.logger.info("SQL = "
				+ sbReorderSelectionSQL.toString());
		Aa21b25s01DaoImpl.logger.info("PARAMs=" + filterParamList);
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa21b25s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Aa21b25s01
	 * @param searchParams
	 *            Aa21b25s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa21b25s01>>
	 */
	@Override
	public List<TableRowDto<Aa21b25s01>> search(Aa21b25s01 filterParams,
			Aa21b25s01 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {

		Aa21b25s01DaoImpl.logger.info("M�todo search");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CSERV25 CSERV25,t1.CEXPE25 CEXPE25,t1.AEXPE25 AEXPE25,t1.NEXPE25 NEXPE25,t1.TDOCU25 TDOCU25,t1.CDOCU25 CDOCU25,t1.NDOCU25 NDOCU25,t1.TEXTO25 TEXTO25,t1.FANOT25 FANOT25,t1.AANOT25 AANOT25,t1.NANOT25 NANOT25 ");
		query.append(",t2.DDOCU05 DDOCU25, t2.EDOCU05 EDOCU25 ");
		// FROM
		query.append("FROM AA21B25S01 t1 ");
		query.append(" LEFT JOIN AA21B05S01 t2 ON t1.CDOCU25 = t2.CDOCU05");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Aa21b25s01.class, filterParamList,
				searchSQL, searchParamList, from_alias,
				"CSERV25,CEXPE25,AEXPE25,NEXPE25,TDOCU25,CDOCU25,NDOCU25");

		Aa21b25s01DaoImpl.logger.info("search");
		Aa21b25s01DaoImpl.logger.info("SQL = "
				+ sbReorderSelectionSQL.toString());
		Aa21b25s01DaoImpl.logger.info("PARAMs=" + filterParamList);

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa21b25s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filteraa21b25s01
	 *            Aa21b25s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Aa21b25s01 filteraa21b25s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {

		Aa21b25s01DaoImpl.logger.info("M�todo removeMultiple");
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.CSERV25 CSERV25,t1.CEXPE25 CEXPE25,t1.AEXPE25 AEXPE25,t1.NEXPE25 NEXPE25,t1.TDOCU25 TDOCU25,t1.CDOCU25 CDOCU25,t1.NDOCU25 NDOCU25,t1.TEXTO25 TEXTO25,t1.FANOT25 FANOT25,t1.AANOT25 AANOT25,t1.NANOT25 NANOT25 ");
		query.append(",t2.DDOCU05 DDOCU25, t2.EDOCU05 EDOCU25 ");
		// FROM
		query.append("FROM AA21B25S01 t1 ");
		query.append(" LEFT JOIN AA21B05S01 t2 ON t1.CDOCU25 = t2.CDOCU05");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa21b25s01,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Aa21b25s01.class,
						query, params,
						"CSERV25,CEXPE25,AEXPE25,NEXPE25,TDOCU25,CDOCU25,NDOCU25");
		Aa21b25s01DaoImpl.logger.info("removeMultiple");
		Aa21b25s01DaoImpl.logger
				.info("SQL = " + sbRemoveMultipleSQL.toString());
		Aa21b25s01DaoImpl.logger.info("PARAMs=" + params);

		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa21b25s01 table.
	 * 
	 * @param filterAa21b25s01
	 *            Aa21b25s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa21b25s01>>
	 */
	@Override
	public List<JerarquiaDto<Aa21b25s01>> findAllLikeJerarquia(
			Aa21b25s01 filterAa21b25s01, JQGridRequestDto jqGridRequestDto) {

		Aa21b25s01DaoImpl.logger.info("M�todo findAllLikeJerarquia");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CSERV25 CSERV25,t1.CEXPE25 CEXPE25,t1.AEXPE25 AEXPE25,t1.NEXPE25 NEXPE25,t1.TDOCU25 TDOCU25,t1.CDOCU25 CDOCU25,t1.NDOCU25 NDOCU25,t1.TEXTO25 TEXTO25,t1.FANOT25 FANOT25,t1.AANOT25 AANOT25,t1.NANOT25 NANOT25 ");
		query.append(",t2.DDOCU05 DDOCU25, t2.EDOCU05 EDOCU25 ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA21B25S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA21B25S01");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FROM

		query.append(" LEFT JOIN AA21B05S01 t2 ON t1.CDOCU25 = t2.CDOCU05");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa21b25s01, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere,
				"CSERV25,CEXPE25,AEXPE25,NEXPE25,TDOCU25,CDOCU25,NDOCU25",
				"ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa21b25s01DaoImpl.logger.info("findAllLikeJerarquia");
		Aa21b25s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b25s01DaoImpl.logger.info("PARAMs=" + params);
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa21b25s01
	 *            Aa21b25s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Aa21b25s01 filterAa21b25s01,
			JQGridRequestDto jqGridRequestDto) {

		Aa21b25s01DaoImpl.logger.info("M�todo findAllLikeCountJerarquia");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA21B25S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA21B25S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa21b25s01, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere,
				"CSERV25,CEXPE25,AEXPE25,NEXPE25,TDOCU25,CDOCU25,NDOCU25",
				"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa21b25s01DaoImpl.logger.info("findAllLikeCountJerarquia");
		Aa21b25s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b25s01DaoImpl.logger.info("PARAMs=" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Finds a single row in the Aa21b25s01 table.
	 * 
	 * @param aa21b25s01
	 *            Aa21b25s01
	 * @return Aa21b25s01
	 */
	public Aa21b25s01 findDocExpediente(Aa21b25s01 aa21b25s01) {
		Aa21b25s01DaoImpl.logger.info("Método findDocExpediente");
		String query = "SELECT t1.CTYPE25 CTYPE25,t1.EXTDOCU25 EXTDOCU25,t1.CODPID25 CODPID25,t1.CSERV25 CSERV25, t1.CEXPE25 CEXPE25, t1.AEXPE25 AEXPE25, t1.NEXPE25 NEXPE25, t1.TDOCU25 TDOCU25, t1.CDOCU25 CDOCU25, t1.NDOCU25 NDOCU25, t1.TEXTO25 TEXTO25, t1.FANOT25 FANOT25, t1.AANOT25 AANOT25, t1.NANOT25 NANOT25, t2.DDOCU05 DDOCU25, t2.EDOCU05 EDOCU25 FROM AA21B25S01 t1 LEFT JOIN AA21B05S01 t2 ON t1.CDOCU25 = t2.CDOCU05  WHERE t1.CSERV25 = ?   AND t1.CEXPE25 = ?   AND t1.AEXPE25 = ?   AND t1.NEXPE25 = ?   AND t1.TDOCU25 = ?   AND t1.CDOCU25 = ?   AND t1.NDOCU25 = ?  ";

		Aa21b25s01DaoImpl.logger.info("SQL = " + query);
		Aa21b25s01DaoImpl.logger.info("PARAM1pk=" + aa21b25s01.getCserv25());
		Aa21b25s01DaoImpl.logger.info("PARAM2pk=" + aa21b25s01.getCexpe25());
		Aa21b25s01DaoImpl.logger.info("PARAM3pk=" + aa21b25s01.getAexpe25());
		Aa21b25s01DaoImpl.logger.info("PARAM4pk=" + aa21b25s01.getNexpe25());
		Aa21b25s01DaoImpl.logger.info("PARAM5pk=" + aa21b25s01.getTdocu25());
		Aa21b25s01DaoImpl.logger.info("PARAM6pk=" + aa21b25s01.getCdocu25());
		Aa21b25s01DaoImpl.logger.info("PARAM7pk=" + aa21b25s01.getNdocu25());

		List<Aa21b25s01> aa21b25s01List = this.jdbcTemplate.query(query,
				this.rwMap, aa21b25s01.getCserv25(), aa21b25s01.getCexpe25(),
				aa21b25s01.getAexpe25(), aa21b25s01.getNexpe25(),
				aa21b25s01.getTdocu25(), aa21b25s01.getCdocu25(),
				aa21b25s01.getNdocu25());
		return (Aa21b25s01) DataAccessUtils.uniqueResult(aa21b25s01List);
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa21b25s01
	 *            Aa21b25s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa21b25s01>>
	 */
	@Override
	public List<TableRowDto<Aa21b25s01>> findAllChild(
			Aa21b25s01 filterAa21b25s01, JQGridRequestDto jqGridRequestDto) {

		Aa21b25s01DaoImpl.logger.info("M�todo findAllChild");

		// FROM
		// StringBuilder from = new StringBuilder("FROM AA21B25S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA21B25S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa21b25s01, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere,
				"CSERV25,CEXPE25,AEXPE25,NEXPE25,TDOCU25,CDOCU25,NDOCU25",
				"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa21b25s01DaoImpl.logger.info("findAllChild");
		Aa21b25s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b25s01DaoImpl.logger.info("PARAMs=" + params);
		return this.jdbcTemplate
				.query(query.toString(),
						new RowNumResultSetExtractor<Aa21b25s01>(this.rwMapPK,
								"CSERV25,CEXPE25,AEXPE25,NEXPE25,TDOCU25,CDOCU25,NDOCU25"),
						params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa21b25s01 entity
	 * 
	 * @param aa21b25s01
	 *            Aa21b25s01 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa21b25s01 aa21b25s01) {

		StringBuilder where = new StringBuilder(
				Aa21b25s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa21b25s01 != null && aa21b25s01.getCserv25() != null) {
			where.append(" AND t1.CSERV25 = ?");
			params.add(aa21b25s01.getCserv25());
		}
		if (aa21b25s01 != null && aa21b25s01.getCexpe25() != null) {
			where.append(" AND t1.CEXPE25 = ?");
			params.add(aa21b25s01.getCexpe25());
		}
		if (aa21b25s01 != null && aa21b25s01.getAexpe25() != null) {
			where.append(" AND t1.AEXPE25 = ?");
			params.add(aa21b25s01.getAexpe25());
		}
		if (aa21b25s01 != null && aa21b25s01.getNexpe25() != null) {
			where.append(" AND t1.NEXPE25 = ?");
			params.add(aa21b25s01.getNexpe25());
		}
		if (aa21b25s01 != null && aa21b25s01.getTdocu25() != null) {
			where.append(" AND t1.TDOCU25 = ?");
			params.add(aa21b25s01.getTdocu25());
		}
		if (aa21b25s01 != null && aa21b25s01.getCdocu25() != null) {
			where.append(" AND t1.CDOCU25 = ?");
			params.add(aa21b25s01.getCdocu25());
		}
		if (aa21b25s01 != null && aa21b25s01.getNdocu25() != null) {
			where.append(" AND t1.NDOCU25 = ?");
			params.add(aa21b25s01.getNdocu25());
		}
		if (aa21b25s01 != null && aa21b25s01.getTexto25() != null) {
			where.append(" AND t1.TEXTO25 = ?");
			params.add(aa21b25s01.getTexto25());
		}
		if (aa21b25s01 != null && aa21b25s01.getFanot25() != null) {
			where.append(" AND t1.FANOT25 = ?");
			params.add(aa21b25s01.getFanot25());
		}
		if (aa21b25s01 != null && aa21b25s01.getAanot25() != null) {
			where.append(" AND t1.AANOT25 = ?");
			params.add(aa21b25s01.getAanot25());
		}
		if (aa21b25s01 != null && aa21b25s01.getNanot25() != null) {
			where.append(" AND t1.NANOT25 = ?");
			params.add(aa21b25s01.getNanot25());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa21b25s01 entity
	 * 
	 * @param aa21b25s01
	 *            Aa21b25s01 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Aa21b25s01 aa21b25s01,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Aa21b25s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa21b25s01 != null && aa21b25s01.getCserv25() != null) {
			where.append(" AND t1.CSERV25 = ?");
			params.add(aa21b25s01.getCserv25());
		}
		if (aa21b25s01 != null && aa21b25s01.getCexpe25() != null) {
			where.append(" AND t1.CEXPE25 = ?");
			params.add(aa21b25s01.getCexpe25());
		}
		if (aa21b25s01 != null && aa21b25s01.getAexpe25() != null) {
			where.append(" AND t1.AEXPE25 = ?");
			params.add(aa21b25s01.getAexpe25());
		}
		if (aa21b25s01 != null && aa21b25s01.getNexpe25() != null) {
			where.append(" AND t1.NEXPE25 = ?");
			params.add(aa21b25s01.getNexpe25());
		}
		if (aa21b25s01 != null && aa21b25s01.getTdocu25() != null) {
			where.append(" AND UPPER(t1.TDOCU25) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa21b25s01.getTdocu25().toUpperCase() + "%");
			} else {
				params.add("%" + aa21b25s01.getTdocu25().toUpperCase() + "%");
			}
			where.append(" AND t1.TDOCU25 IS NOT NULL");
		}
		if (aa21b25s01 != null && aa21b25s01.getCdocu25() != null) {
			where.append(" AND t1.CDOCU25 = ?");
			params.add(aa21b25s01.getCdocu25());
		}
		if (aa21b25s01 != null && aa21b25s01.getNdocu25() != null) {
			where.append(" AND t1.NDOCU25 = ?");
			params.add(aa21b25s01.getNdocu25());
		}
		if (aa21b25s01 != null && aa21b25s01.getTexto25() != null) {
			where.append(" AND UPPER(t1.TEXTO25) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa21b25s01.getTexto25().toUpperCase() + "%");
			} else {
				params.add("%" + aa21b25s01.getTexto25().toUpperCase() + "%");
			}
			where.append(" AND t1.TEXTO25 IS NOT NULL");
		}
		if (aa21b25s01 != null && aa21b25s01.getFanot25() != null) {
			where.append(" AND t1.FANOT25 = ?");
			params.add(aa21b25s01.getFanot25());
		}
		if (aa21b25s01 != null && aa21b25s01.getAanot25() != null) {
			where.append(" AND t1.AANOT25 = ?");
			params.add(aa21b25s01.getAanot25());
		}
		if (aa21b25s01 != null && aa21b25s01.getNanot25() != null) {
			where.append(" AND t1.NANOT25 = ?");
			params.add(aa21b25s01.getNanot25());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
