package com.ejie.aa21b.dao;

import java.util.List;

import com.ejie.aa21b.model.Aa21b02s01;
import com.ejie.aa21b.model.Aa21b07s01;
import com.ejie.aa21b.model.Aa21b13s01;
import com.ejie.aa21b.model.Aa21b14s01;
import com.ejie.aa21b.model.Aa21b15s01;
import com.ejie.aa21b.model.Aa21b20s01;
import com.ejie.aa21b.model.Aa21b20s01Consultas;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa21b20s01Dao  
 * 
 *  
 */

public interface Aa21b20s01Dao {

	/**
	 * Inserts a single row in the Aa21b20s01 table.
	 * 
	 * @param aa21b20s01
	 *            Aa21b20s01
	 * @return Aa21b20s01
	 */
	Aa21b20s01 add(Aa21b20s01 aa21b20s01);

	/**
	 * Updates a single row in the Aa21b20s01 table.
	 * 
	 * @param aa21b20s01
	 *            Aa21b20s01
	 * @return Aa21b20s01
	 */
	Aa21b20s01 update(Aa21b20s01 aa21b20s01);

	/**
	 * Finds a single row in the Aa21b20s01 table.
	 * 
	 * @param aa21b20s01
	 *            Aa21b20s01
	 * @return Aa21b20s01
	 */
	Aa21b20s01 find(Aa21b20s01 aa21b20s01);

	/**
	 * Removes a single row in the Aa21b20s01 table.
	 * 
	 * @param aa21b20s01
	 *            Aa21b20s01
	 */
	void remove(Aa21b20s01 aa21b20s01);

	/**
	 * Finds a List of rows in the Aa21b20s01 table.
	 * 
	 * @param aa21b20s01
	 *            Aa21b20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List
	 */
	List<Aa21b20s01> findAll(Aa21b20s01 aa21b20s01,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds rows in the Aa21b20s01 table using like.
	 * 
	 * @param aa21b20s01
	 *            Aa21b20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Aa21b20s01> findAllLike(Aa21b20s01 aa21b20s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Finds rows in the Aa21b20s01 table using like.
	 * 
	 * @param aa21b20s01
	 *            Aa21b20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Aa21b20s01> findAllLikeConFase(Aa21b20s01 aa21b20s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter in the Aa21b20s01 table.
	 * 
	 * @param filterAa21b20s01
	 *            Aa21b20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(Aa21b20s01 filterAa21b20s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Counts rows in the Aa21b20s01 table using like.
	 * 
	 * @param aa21b20s01
	 *            Aa21b20s01
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Aa21b20s01 aa21b20s01, Boolean startsWith);

	/**
	 * Counts rows in the Aa21b20s01 table using like.
	 * 
	 * @param aa21b20s01
	 *            Aa21b20s01
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCountCopiaDocFaseExp(Aa21b20s01 aa21b20s01,
			Boolean startsWith);

	/**
	 * Counts rows in the Aa21b20s01 table using like.
	 * 
	 * @param aa21b20s01
	 *            Aa21b20s01
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCountConFase(Aa21b20s01 aa21b20s01, Boolean startsWith);

	/**
	 * Counts rows in the Aa21b20s01 table.
	 * 
	 * @param aa21b20s01
	 *            Aa21b20s01
	 * @return Long
	 */
	Long findAllCount(Aa21b20s01 aa21b20s01);

	/**
	 * Reorder selection.
	 * 
	 * @param filterAa21b20s01
	 *            Aa21b20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa21b20s01>>
	 */
	List<TableRowDto<Aa21b20s01>> reorderSelection(Aa21b20s01 filterAa21b20s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Reorder selection.
	 * 
	 * @param filterAa21b20s01
	 *            Aa21b20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa21b20s01>>
	 */
	List<TableRowDto<Aa21b20s01>> reorderSelectionConFase(
			Aa21b20s01 filterAa21b20s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Searches in the Usuario table.
	 * 
	 * @param filterAa21b20s01
	 *            Aa21b20s01
	 * @param searchAa21b20s01
	 *            Aa21b20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa21b20s01>>
	 */
	List<TableRowDto<Aa21b20s01>> search(Aa21b20s01 filterAa21b20s01,
			Aa21b20s01 searchAa21b20s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Filter in the hierarchical Aa21b20s01 table.
	 * 
	 * @param filterAa21b20s01
	 *            Aa21b20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa21b20s01>>
	 */
	List<JerarquiaDto<Aa21b20s01>> findAllLikeJerarquia(
			Aa21b20s01 filterAa21b20s01, JQGridRequestDto jqGridRequestDto);

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa21b20s01
	 *            Aa21b20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	Long findAllLikeCountJerarquia(Aa21b20s01 filterAa21b20s01,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa21b20s01
	 *            Aa21b20s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa21b20s01>>
	 */
	List<TableRowDto<Aa21b20s01>> findAllChild(Aa21b20s01 filterAa21b20s01,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * 
	 * @param aa21b20s01
	 *            Aa21b20s01
	 * @return Aa21b20s01
	 */
	Aa21b20s01 updateBloqueos(Aa21b20s01 aa21b20s01);

	/**
	 * 
	 * @param grupo
	 *            String
	 * @return List<Aa21b20s01>
	 */
	List<Aa21b20s01> findExpAsociados(String grupo);

	/**
	 * 
	 * @param filterAa21b20s01
	 *            Aa21b20s01Consultas
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param listaServicios
	 *            List<Aa21b13s01>
	 * @param listaTiposExpedientes
	 *            List<Aa21b02s01>
	 * @param listaResponsables
	 *            List<Aa21b15s01>
	 * @param listaArchivos
	 *            List<Aa21b14s01>
	 * @param listaEstados
	 *            List<Aa21b07s01>
	 * @return List<Aa21b20s01Consultas>
	 */
	List<Aa21b20s01Consultas> findAllLikeConsultas(
			Aa21b20s01Consultas filterAa21b20s01,
			JQGridRequestDto jqGridRequestDto, List<Aa21b13s01> listaServicios,
			List<Aa21b02s01> listaTiposExpedientes,
			List<Aa21b15s01> listaResponsables, List<Aa21b14s01> listaArchivos,
			List<Aa21b07s01> listaEstados, Boolean startsWith);

	/**
	 * 
	 * @param expAsociado
	 *            Aa21b20s01
	 * @return Aa21b20s01
	 */
	Aa21b20s01 findPorReferencia(Aa21b20s01 expAsociado);

	List<Aa21b20s01> findAllLikeMultiples(Aa21b20s01 filterAa21b20s01,
			JQGridRequestDto jqGridRequestDto, List<Aa21b13s01> listaServicios,
			List<Aa21b02s01> listaTiposExpedientes,
			List<Aa21b15s01> listaResponsables, List<Aa21b14s01> listaArchivos,
			List<Aa21b07s01> listaEstados, boolean b);

	Long findAllLikeCountMultiples(Aa21b20s01 aa21b20s01,
			List<Aa21b13s01> listaServicios,
			List<Aa21b02s01> listaTiposExpedientes,
			List<Aa21b15s01> listaResponsables, List<Aa21b14s01> listaArchivos,
			List<Aa21b07s01> listaEstados, boolean b);

	List<TableRowDto<Aa21b20s01>> reorderSelectionMultiples(
			Aa21b20s01 filterAa21b20s01, JQGridRequestDto jqGridRequestDto,
			List<Aa21b13s01> listaServicios,
			List<Aa21b02s01> listaTiposExpedientes,
			List<Aa21b15s01> listaResponsables, List<Aa21b14s01> listaArchivos,
			List<Aa21b07s01> listaEstados, boolean startsWith);

	/**
	 * Actualiza el servicio del registro de entrada
	 * 
	 * @param aa21b20s01
	 * @param nuevoCserv
	 * @param nuevoAexpe
	 * @param nuevoNexpe
	 * @return
	 */
	public Aa21b20s01 update(Aa21b20s01 aa21b20s01, String nuevoCserv,
			long nuevoAexpe, int nuevoNexpe);

	public Integer obtenerCorrelativoExpediente(Aa21b20s01 expediente);

	String obtenerCorrelativoUbica();

	public Aa21b20s01 updateModificacionEspecial(Aa21b20s01 expediente);

	/**
	 * Finds a single row in the Aa21b20s01 table.
	 * 
	 * @param aa21b20s01
	 *            Aa21b20s01
	 * @return Aa21b20s01
	 */
	Aa21b20s01 findConGrupoTipoExp(Aa21b20s01 aa21b20s01);
}
