package com.ejie.aa21b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa21b.model.Aa21b13s01;
import com.ejie.aa21b.model.Aa21b15s01;
import com.ejie.aa21b.util.Aa21bConstantes;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa21b15s01DaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class Aa21b15s01DaoImpl implements Aa21b15s01Dao {
	private JdbcTemplate jdbcTemplate;
	private static final Logger logger = LoggerFactory
			.getLogger(Aa21b15s01DaoImpl.class);

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa21b15s01> rwMap = new RowMapper<Aa21b15s01>() {
		public Aa21b15s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa21b15s01(resultSet.getString("CUSU15"),
					resultSet.getString("DUSU15"),
					resultSet.getString("CSERV15"),
					resultSet.getString("SITU15"),
					resultSet.getString("DSERV15"),
					resultSet.getString("ESERV15"),
					resultSet.getString("SITUSERV"),
					resultSet.getString("USUB15"),
					resultSet.getString("UXLNET15"), "");
		}
	};

	private RowMapper<Aa21b15s01> rwMapSinServicio = new RowMapper<Aa21b15s01>() {
		public Aa21b15s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa21b15s01(resultSet.getString("CUSU15"),
					resultSet.getString("DUSU15"),
					resultSet.getString("CSERV15"),
					resultSet.getString("SITU15"),
					resultSet.getString("USUB15"), "");
		}
	};

	private RowMapper<Aa21b15s01> rwMapDusu = new RowMapper<Aa21b15s01>() {
		public Aa21b15s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Aa21b15s01 usuario = new Aa21b15s01();
			usuario.setDusu15(resultSet.getString("DUSU15"));
			return usuario;
		}
	};

	private RowMapper<Aa21b15s01> rwMapPK = new RowMapper<Aa21b15s01>() {
		public Aa21b15s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa21b15s01(resultSet.getString("CUSU15"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Aa21b15s01>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa21b15s01>>() {
		public JerarquiaDto<Aa21b15s01> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Aa21b15s01 aa21b15s01 = new Aa21b15s01(
					resultSet.getString("CUSU15"),
					resultSet.getString("DUSU15"),
					resultSet.getString("CSERV15"),
					resultSet.getString("SITU15"),
					resultSet.getString("DSERV15"),
					resultSet.getString("ESERV15"),
					resultSet.getString("SITUSERV"),
					resultSet.getString("USUB15"),
					resultSet.getString("UXLNET15"), "");

			JerarquiaDto<Aa21b15s01> jerarquia = new JerarquiaDto<Aa21b15s01>();
			jerarquia.setModel(aa21b15s01);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Aa21b15s01 table.
	 * 
	 * @param aa21b15s01
	 *            Aa21b15s01
	 * @return Aa21b15s01
	 */
	public Aa21b15s01 add(Aa21b15s01 aa21b15s01) {
		Aa21b15s01DaoImpl.logger.info("Metodo add");
		Integer correlativoUsuario = this.obtenerCorrelativoUsuario(aa21b15s01
				.getCserv15());
		// Si el correlativo es 1, significa que es el primer usuario para el
		// servicio
		// por lo que le añado el codigo del servicio por delante para
		// inicializar la cuenta de correlativos
		if (correlativoUsuario == 1) {
			correlativoUsuario = Integer
					.valueOf(aa21b15s01.getCserv15() + "01");
		}

		aa21b15s01.setCusu15(correlativoUsuario.toString());
		String query = "INSERT INTO AA21B15S01 (CUSU15, DUSU15, CSERV15, SITU15, BLOQ15, USUB15, UXLNET15) VALUES (?,?,?,?,?,?,?)";
		Aa21b15s01DaoImpl.logger.info("SQL = " + query);
		Aa21b15s01DaoImpl.logger.info("PARAM1=" + correlativoUsuario);
		Aa21b15s01DaoImpl.logger.info("PARAM2=" + aa21b15s01.getDusu15());
		Aa21b15s01DaoImpl.logger.info("PARAM3=" + aa21b15s01.getCserv15());
		Aa21b15s01DaoImpl.logger.info("PARAM4=" + aa21b15s01.getSitu15());
		Aa21b15s01DaoImpl.logger.info("PARAM5=" + 0);
		Aa21b15s01DaoImpl.logger.info("PARAM6=null");
		Aa21b15s01DaoImpl.logger.info("PARAM7=" + aa21b15s01.getUxlnet15());
		this.jdbcTemplate.update(query, correlativoUsuario,
				aa21b15s01.getDusu15(), aa21b15s01.getCserv15(),
				aa21b15s01.getSitu15(), 0, null, aa21b15s01.getUxlnet15());
		return aa21b15s01;
	}

	/**
	 * Finds rows in the Usuarios table using like.
	 * 
	 * @param servicio
	 *            String
	 * @return Integer
	 */
	@Transactional(readOnly = true)
	public Integer obtenerCorrelativoUsuario(String servicio) {
		Aa21b15s01DaoImpl.logger.info("obtenerCorrelativoUsuario");
		StringBuffer query;
		if (servicio.length() == 2)
			query = new StringBuffer(
					"SELECT  MAX(CUSU15) FROM Aa21b15s01 where SUBSTR(CUSU15,0,2) = ? ");
		else
			// es menor que 10
			query = new StringBuffer(
					"SELECT  MAX(CUSU15) FROM Aa21b15s01 where SUBSTR(CUSU15,0,1) = ? ");
		List<Object> params = new ArrayList<Object>();
		params.add(servicio);
		Aa21b15s01DaoImpl.logger.info("obtenerCorrelativoUsuario");
		Aa21b15s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b15s01DaoImpl.logger.info("PARAMs=" + params);
		return Integer.valueOf(this.jdbcTemplate.queryForInt(query.toString(),
				params.toArray())) + 1;
	}

	/**
	 * Updates a single row in the Aa21b15s01 table.
	 * 
	 * @param aa21b15s01
	 *            Aa21b15s01
	 * @return Aa21b15s01
	 */
	public Aa21b15s01 update(Aa21b15s01 aa21b15s01) {
		Aa21b15s01DaoImpl.logger.info("update");
		String query = "UPDATE AA21B15S01 SET DUSU15=?, CSERV15=?, SITU15=?  WHERE CUSU15=?";
		Aa21b15s01DaoImpl.logger.info("SQL = " + query);
		Aa21b15s01DaoImpl.logger.info("PARAM1=" + aa21b15s01.getDusu15());
		Aa21b15s01DaoImpl.logger.info("PARAM2=" + aa21b15s01.getCserv15());
		Aa21b15s01DaoImpl.logger.info("PARAM3=" + aa21b15s01.getSitu15());
		Aa21b15s01DaoImpl.logger.info("PARAM4pk=" + aa21b15s01.getCusu15());

		this.jdbcTemplate.update(query, aa21b15s01.getDusu15(),
				aa21b15s01.getCserv15(), aa21b15s01.getSitu15(),
				aa21b15s01.getCusu15());
		return aa21b15s01;
	}

	/**
	 * Updates bloqueos in the Aa21b15s01 table.
	 * 
	 * @param aa21b15s01
	 *            Aa21b15s01
	 * @return Aa21b15s01
	 */
	public Aa21b15s01 updateBloqueos(Aa21b15s01 aa21b15s01) {
		Aa21b15s01DaoImpl.logger.info("updateBloqueos");
		if (aa21b15s01 != null && aa21b15s01.getCusu15() != null) {
			String query = "UPDATE AA21B15S01 SET BLOQ15=?, USUB15=? WHERE CUSU15=?";
			Aa21b15s01DaoImpl.logger.info("SQL = " + query);
			Aa21b15s01DaoImpl.logger.info("PARAM1=" + aa21b15s01.getBloq15());
			Aa21b15s01DaoImpl.logger.info("PARAM2=" + aa21b15s01.getUsub15());
			Aa21b15s01DaoImpl.logger.info("PARAM3pk=" + aa21b15s01.getCusu15());
			this.jdbcTemplate.update(query, aa21b15s01.getBloq15(),
					aa21b15s01.getUsub15(), aa21b15s01.getCusu15());
		} else if (aa21b15s01 != null && aa21b15s01.getCserv15() != null) {
			String query = "UPDATE AA21B15S01 SET BLOQ15=?, USUB15=? WHERE CSERV15=?";
			Aa21b15s01DaoImpl.logger.info("SQL = " + query);
			Aa21b15s01DaoImpl.logger.info("PARAM1=" + 0);
			Aa21b15s01DaoImpl.logger.info("PARAM2=null");
			this.jdbcTemplate.update(query, 0, null, aa21b15s01.getCserv15());
		} else {
			String query = "UPDATE AA21B15S01 SET BLOQ15=?, USUB15=? ";
			Aa21b15s01DaoImpl.logger.info("SQL = " + query);
			Aa21b15s01DaoImpl.logger.info("PARAM1=" + 0);
			Aa21b15s01DaoImpl.logger.info("PARAM2=null");
			this.jdbcTemplate.update(query, 0, null);
		}
		return aa21b15s01;
	}

	/**
	 * Finds a single row in the Aa21b15s01 table.
	 * 
	 * @param aa21b15s01
	 *            Aa21b15s01
	 * @return Aa21b15s01
	 */
	@Transactional(readOnly = true)
	public Aa21b15s01 find(Aa21b15s01 aa21b15s01) {
		Aa21b15s01DaoImpl.logger.info("find");
		StringBuffer query = new StringBuffer(
				"SELECT t1.CUSU15 CUSU15, t1.DUSU15 DUSU15, t1.CSERV15 CSERV15, t1.SITU15 SITU15,t1.USUB15 USUB15, t1.UXLNET15 UXLNET15, t13.CSERV13||' - '||t13.DSERV13 DSERV15, t13.CSERV13||' - '||t13.ESERV13 ESERV15, t13.SITU13 SITUSERV FROM AA21B15S01 t1 LEFT JOIN AA21B13S01 t13 ON t1.CSERV15 = t13.CSERV13  ");
		String param = "";
		if (aa21b15s01.getCusu15() != null) {
			query.append(" WHERE t1.CUSU15 = ? ");
			param = aa21b15s01.getCusu15();
		} else {
			query.append(" WHERE t1.UXLNET15 = ? ");
			param = aa21b15s01.getUxlnet15();
		}
		Aa21b15s01DaoImpl.logger.info("SQL = " + query);
		Aa21b15s01DaoImpl.logger.info("PARAM1pk=" + param);
		List<Aa21b15s01> aa21b15s01List = this.jdbcTemplate.query(
				query.toString(), this.rwMap, param);
		return (Aa21b15s01) DataAccessUtils.uniqueResult(aa21b15s01List);
	}

	/**
	 * Finds a single row in the Aa21b15s01 table.
	 * 
	 * @param aa21b15s01
	 *            Aa21b15s01
	 * @return Aa21b15s01
	 */
	@Transactional(readOnly = true)
	public Aa21b15s01 findXLNET(Aa21b15s01 aa21b15s01) {
		Aa21b15s01DaoImpl.logger.info("find");
		String query = "SELECT t1.CUSU15 CUSU15, t1.DUSU15 DUSU15, t1.CSERV15 CSERV15, t1.SITU15 SITU15,t1.USUB15 USUB15, t1.UXLNET15 UXLNET15, t13.CSERV13||' - '||t13.DSERV13 DSERV15, t13.CSERV13||' - '||t13.ESERV13 ESERV15, t13.SITU13 SITUSERV FROM AA21B15S01 t1 LEFT JOIN AA21B13S01 t13 ON t1.CSERV15 = t13.CSERV13 WHERE t1.UXLNET15 = ?  ";

		// 20160912 - INIGO
		query = query.concat(" and SITU15=? ");

		Aa21b15s01DaoImpl.logger.info("SQL = " + query);
		Aa21b15s01DaoImpl.logger.info("PARAM1pk=" + aa21b15s01.getUxlnet15());
		List<Aa21b15s01> aa21b15s01List = this.jdbcTemplate.query(query,
				this.rwMap, aa21b15s01.getUxlnet15(),
				Aa21bConstantes.SITUACION_ALTA);
		return (Aa21b15s01) DataAccessUtils.uniqueResult(aa21b15s01List);
	}

	/**
	 * Removes a single row in the Aa21b15s01 table.
	 * 
	 * @param aa21b15s01
	 *            Aa21b15s01
	 * @return
	 */
	public void remove(Aa21b15s01 aa21b15s01) {
		Aa21b15s01DaoImpl.logger.info("remove");
		String query = "DELETE FROM AA21B15S01 WHERE CUSU15=?";
		Aa21b15s01DaoImpl.logger.info("SQL = " + query);
		Aa21b15s01DaoImpl.logger.info("PARAM1pk=" + aa21b15s01.getCusu15());
		this.jdbcTemplate.update(query, aa21b15s01.getCusu15());
	}

	/**
	 * Finds a list of rows in the Aa21b15s01 table.
	 * 
	 * @param aa21b15s01
	 *            Aa21b15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa21b15s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa21b15s01> findAll(Aa21b15s01 aa21b15s01,
			JQGridRequestDto jqGridRequestDto) {
		Aa21b15s01DaoImpl.logger.info("Metodo findAll");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CUSU15 CUSU15,t1.DUSU15 DUSU15,t1.CSERV15 CSERV15,t1.SITU15 SITU15,t1.USUB15 USUB15, t1.UXLNET15 UXLNET15, ");
		query.append(" t13.CSERV13||' - '||t13.DSERV13 DSERV15, t13.CSERV13||' - '||t13.ESERV13 ESERV15, t13.SITU13 SITUSERV ");
		query.append("FROM AA21B15S01 t1 LEFT JOIN AA21B13S01 t13 ON t1.CSERV15 = t13.CSERV13");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa21b15s01);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		Aa21b15s01DaoImpl.logger.info("findAll");
		Aa21b15s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b15s01DaoImpl.logger.info("PARAMS" + params);
		return (List<Aa21b15s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Aa21b15s01 table using like.
	 * 
	 * @param aa21b15s01
	 *            Aa21b15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param listaServicios
	 *            List<Aa21b13s01>
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa21b15s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa21b15s01> findAllLike(Aa21b15s01 aa21b15s01,
			JQGridRequestDto jqGridRequestDto, List<Aa21b13s01> listaServicios,
			Boolean startsWith) {
		Aa21b15s01DaoImpl.logger.info("Metodo findAllLike");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CUSU15 CUSU15,t1.DUSU15 DUSU15,t1.CSERV15 CSERV15,t1.SITU15 SITU15,t1.USUB15 USUB15, t1.UXLNET15 UXLNET15, ");
		query.append(" t13.CSERV13||' - '||t13.DSERV13 DSERV15, t13.CSERV13||' - '||t13.ESERV13 ESERV15, t13.SITU13 SITUSERV ");
		query.append("FROM AA21B15S01 t1 LEFT JOIN AA21B13S01 t13 ON t1.cserv15 = t13.cserv13 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa21b15s01,
				listaServicios, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		Aa21b15s01DaoImpl.logger.info("findAllLike");
		Aa21b15s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b15s01DaoImpl.logger.info("PARAMS" + params);
		return (List<Aa21b15s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Aa21b15s01 table.
	 * 
	 * @param aa21b15s01
	 *            Aa21b15s01
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa21b15s01 aa21b15s01) {
		Aa21b15s01DaoImpl.logger.info("Metodo findAllCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA21B15S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa21b15s01);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa21b15s01DaoImpl.logger.info("findAllCount");
		Aa21b15s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b15s01DaoImpl.logger.info("PARAMS" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Aa21b15s01 table using like.
	 * 
	 * @param aa21b15s01
	 *            Aa21b15s01
	 * @param listaServicios
	 *            List<Aa21b13s01>
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Aa21b15s01 aa21b15s01,
			List<Aa21b13s01> listaServicios, Boolean startsWith) {
		Aa21b15s01DaoImpl.logger.info("Metodo findAllLikeCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA21B15S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa21b15s01,
				listaServicios, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa21b15s01DaoImpl.logger.info("findAllLikeCount");
		Aa21b15s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b15s01DaoImpl.logger.info("PARAMS" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Aa21b15s01 selected for rup_table
	 * 
	 * @param aa21b15s01
	 *            Aa21b15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa21b15s01>>
	 */
	@Override
	public List<TableRowDto<Aa21b15s01>> reorderSelection(
			Aa21b15s01 aa21b15s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		Aa21b15s01DaoImpl.logger.info("Metodo reorderSelection");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CUSU15 CUSU15,t1.DUSU15 DUSU15,t1.CSERV15 CSERV15,t1.SITU15 SITU15,t1.USUB15 USUB15, t1.UXLNET15 UXLNET15, ");
		query.append(" t13.CSERV13||' - '||t13.DSERV13 DSERV15, t13.CSERV13||' - '||t13.ESERV13 ESERV15, t13.SITU13 SITUSERV ");
		// FROM
		query.append("FROM AA21B15S01 t1 LEFT JOIN AA21B13S01 t13 ON t1.CSERV15 = t13.CSERV13");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa21b15s01, null,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Aa21b15s01.class, filterParamList,
				"CUSU15");

		Aa21b15s01DaoImpl.logger.info("reorderSelection");
		Aa21b15s01DaoImpl.logger.info("SQL = "
				+ sbReorderSelectionSQL.toString());
		Aa21b15s01DaoImpl.logger.info("PARAMs=" + filterParamList);
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa21b15s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Aa21b15s01
	 * @param searchParams
	 *            Aa21b15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa21b15s01>>
	 */
	@Override
	public List<TableRowDto<Aa21b15s01>> search(Aa21b15s01 filterParams,
			Aa21b15s01 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		Aa21b15s01DaoImpl.logger.info("Metodo search");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CUSU15 CUSU15,t1.DUSU15 DUSU15,t1.CSERV15 CSERV15,t1.SITU15 SITU15,t1.USUB15 USUB15, t1.UXLNET15 UXLNET15, ");
		query.append(" t13.CSERV13||' - '||t13.DSERV13 DSERV15, t13.CSERV13||' - '||t13.ESERV13 ESERV15, t13.SITU13 SITUSERV ");
		// FROM
		query.append("FROM AA21B15S01 t1 LEFT JOIN AA21B13S01 t13 ON t1.CSERV15 = t13.CSERV13");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				null, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, null, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Aa21b15s01.class, filterParamList,
				searchSQL, searchParamList, from_alias, "CUSU15");

		Aa21b15s01DaoImpl.logger.info("search");
		Aa21b15s01DaoImpl.logger.info("SQL = "
				+ sbReorderSelectionSQL.toString());
		Aa21b15s01DaoImpl.logger.info("PARAMs=" + filterParamList);

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa21b15s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filteraa21b15s01
	 *            Aa21b15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Aa21b15s01 filteraa21b15s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		Aa21b15s01DaoImpl.logger.info("Metodo removeMultiple");
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.CUSU15 CUSU15,t1.DUSU15 DUSU15,t1.CSERV15 CSERV15,t1.SITU15 SITU15,t1.USUB15 USUB15, t1.UXLNET15 UXLNET15, ");
		query.append(" t13.CSERV13||' - '||t13.DSERV13 DSERV15, t13.CSERV13||' - '||t13.ESERV13 ESERV15, t13.SITU13 SITUSERV ");
		// FROM
		query.append("FROM AA21B15S01 t1 LEFT JOIN AA21B13S01 t13 ON t1.CSERV15 = t13.CSERV13");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa21b15s01,
				null, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Aa21b15s01.class,
						query, params, "CUSU15");
		Aa21b15s01DaoImpl.logger.info("removeMultiple");
		Aa21b15s01DaoImpl.logger
				.info("SQL = " + sbRemoveMultipleSQL.toString());
		Aa21b15s01DaoImpl.logger.info("PARAMs=" + params);
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa21b15s01 table.
	 * 
	 * @param filterAa21b15s01
	 *            Aa21b15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa21b15s01>>
	 */
	@Override
	public List<JerarquiaDto<Aa21b15s01>> findAllLikeJerarquia(
			Aa21b15s01 filterAa21b15s01, JQGridRequestDto jqGridRequestDto) {
		Aa21b15s01DaoImpl.logger.info("Metodo findAllLikeJerarquia");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CUSU15 CUSU15,t1.DUSU15 DUSU15,t1.CSERV15 CSERV15,t1.SITU15 SITU15,t1.USUB15 USUB15, t1.UXLNET15 UXLNET15, ")
				.append(" t13.CSERV13||' - '||t13.DSERV13 DSERV15, t13.CSERV13||' - '||t13.ESERV13 ESERV15, t13.SITU13 SITUSERV ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA21B15S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA21B15S01");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		query.append(" LEFT JOIN AA21B13S01 t13 ON t1.CSERV15 = t13.CSERV13 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAa21b15s01, null,
				false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "CUSU15", "ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa21b15s01DaoImpl.logger.info("findAllLikeJerarquia");
		Aa21b15s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b15s01DaoImpl.logger.info("PARAMs=" + params);
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa21b15s01
	 *            Aa21b15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Aa21b15s01 filterAa21b15s01,
			JQGridRequestDto jqGridRequestDto) {
		Aa21b15s01DaoImpl.logger.info("Metodo findAllLikeCountJerarquia");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA21B15S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA21B15S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAa21b15s01, null,
				false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "CUSU15", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa21b15s01DaoImpl.logger.info("findAllLikeCountJerarquia");
		Aa21b15s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b15s01DaoImpl.logger.info("PARAMs=" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa21b15s01
	 *            Aa21b15s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa21b15s01>>
	 */
	@Override
	public List<TableRowDto<Aa21b15s01>> findAllChild(
			Aa21b15s01 filterAa21b15s01, JQGridRequestDto jqGridRequestDto) {

		Aa21b15s01DaoImpl.logger.info("Metodo findAllChild");

		// FROM
		// StringBuilder from = new StringBuilder("FROM AA21B15S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA21B15S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAa21b15s01, null,
				false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "CUSU15", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa21b15s01DaoImpl.logger.info("findAllChild");
		Aa21b15s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b15s01DaoImpl.logger.info("PARAMs=" + params);
		return this.jdbcTemplate
				.query(query.toString(),
						new RowNumResultSetExtractor<Aa21b15s01>(this.rwMapPK,
								"CUSU15"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa21b15s01 entity
	 * 
	 * @param aa21b15s01
	 *            Aa21b15s01 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa21b15s01 aa21b15s01) {

		StringBuilder where = new StringBuilder(
				Aa21b15s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa21b15s01 != null && aa21b15s01.getCusu15() != null) {
			where.append(" AND t1.CUSU15 = ?");
			params.add(aa21b15s01.getCusu15());
		}
		if (aa21b15s01 != null && aa21b15s01.getDusu15() != null) {
			where.append(" AND t1.DUSU15 = ?");
			params.add(aa21b15s01.getDusu15());
		}
		if (aa21b15s01 != null && aa21b15s01.getCserv15() != null) {
			where.append(" AND t1.CSERV15 = ?");
			params.add(aa21b15s01.getCserv15());
		}
		if (aa21b15s01 != null && aa21b15s01.getSitu15() != null) {
			where.append(" AND t1.SITU15 = ?");
			params.add(aa21b15s01.getSitu15());
		}
		if (aa21b15s01 != null && aa21b15s01.getUxlnet15() != null) {
			where.append(" AND t1.UXLNET15 = ?");
			params.add(aa21b15s01.getUxlnet15());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa21b15s01 entity
	 * 
	 * @param aa21b15s01
	 *            Aa21b15s01 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Aa21b15s01 aa21b15s01,
			List<Aa21b13s01> listaServicios, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Aa21b15s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (listaServicios != null) {
			if (listaServicios.size() > 0) {
				where.append(" AND ");
				Aa21b13s01 serviciosAux = null;
				for (Iterator<Aa21b13s01> iterator = listaServicios.iterator(); iterator
						.hasNext();) {

					serviciosAux = (Aa21b13s01) iterator.next();
					where.append(" t1.CSERV15 = ? ");
					params.add(serviciosAux.getCServ13());
					if (iterator.hasNext()) {
						where.append(" OR ");
					}
				}
			}
		}

		if (aa21b15s01 != null && aa21b15s01.getCserv15() != null
				&& aa21b15s01.getCserv15().equals("sinServicio")) {
			where.append(" AND CSERV15 is null ");
		}

		if (aa21b15s01 != null && aa21b15s01.getCusu15() != null) {
			where.append(" AND UPPER(t1.CUSU15) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa21b15s01.getCusu15().toUpperCase() + "%");
			} else {
				params.add("%" + aa21b15s01.getCusu15().toUpperCase() + "%");
			}
			where.append(" AND t1.CUSU15 IS NOT NULL");
		}
		if (aa21b15s01 != null && aa21b15s01.getDusu15() != null) {
			where.append(" AND UPPER(t1.DUSU15) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa21b15s01.getDusu15().toUpperCase() + "%");
			} else {
				params.add("%" + aa21b15s01.getDusu15().toUpperCase() + "%");
			}
			where.append(" AND t1.DUSU15 IS NOT NULL");
		}

		if (aa21b15s01 != null && aa21b15s01.getSitu15() != null) {
			where.append(" AND UPPER(t1.SITU15) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa21b15s01.getSitu15().toUpperCase() + "%");
			} else {
				params.add("%" + aa21b15s01.getSitu15().toUpperCase() + "%");
			}
			where.append(" AND t1.SITU15 IS NOT NULL");
		}

		if (aa21b15s01 != null && aa21b15s01.getBloq15() != null) {
			where.append(" AND t1.BLOQ15 = ?");
			params.add(aa21b15s01.getBloq15());
		}

		if (aa21b15s01 != null && aa21b15s01.getUxlnet15() != null) {
			where.append(" AND t1.UXLNET15 = ?");
			params.add(aa21b15s01.getUxlnet15());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	private Map<String, Object> getWhereLikeMapRespServicio(
			Aa21b15s01 aa21b15s01, List<Aa21b13s01> listaServicios,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Aa21b15s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		where.append(" AND t1.SITU15 = 'A' ");

		if (aa21b15s01 != null && aa21b15s01.getCserv15() != null) {
			where.append(" AND t1.CSERV15 = ? ");
			params.add(aa21b15s01.getCserv15());
		}
		if (aa21b15s01 != null && aa21b15s01.getCservOld15() != null) {
			where.append(" AND t1.CSERVOLD15 = ? ");
			params.add(aa21b15s01.getCservOld15());
		}

		if (aa21b15s01 != null && aa21b15s01.getDusu15() != null) {
			where.append(" AND UPPER(t1.DUSU15) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa21b15s01.getDusu15().toUpperCase() + "%");
			} else {
				params.add("%" + aa21b15s01.getDusu15().toUpperCase() + "%");
			}
			where.append(" AND t1.DUSU15 IS NOT NULL");
		}
		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	@Override
	public List<Aa21b15s01> findUsu(Aa21b15s01 aa21b15s01, Boolean startsWith) {
		Aa21b15s01DaoImpl.logger.info("Metodo findUsu");
		List<Object> params = new ArrayList<Object>();

		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		StringBuilder query = new StringBuilder(
				"SELECT DISTINCT t1.DUSU15 DUSU15 ");
		query.append("FROM AA21B15S01 t1 ");
		if (aa21b15s01 != null && aa21b15s01.getDusu15() != null) {
			where.append(" AND UPPER(t1.DUSU15) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add("%" + aa21b15s01.getDusu15().toUpperCase() + "%");
			} else {
				params.add("%" + aa21b15s01.getDusu15().toUpperCase() + "%");
			}
		}
		query.append(where);
		StringBuilder order = new StringBuilder(" ORDER BY DUSU15 asc ");
		query.append(order);

		Aa21b15s01DaoImpl.logger.info("findDepartamento");
		Aa21b15s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b15s01DaoImpl.logger.info("PARAMs=" + params);
		return (List<Aa21b15s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMapDusu, params.toArray());
	}

	@Override
	public List<Aa21b15s01> findAllLikeSinServicio(Aa21b15s01 filterAa21b15s01,
			JQGridRequestDto jqGridRequestDto, boolean startsWith) {
		// TODO Auto-generated method stub
		Aa21b15s01DaoImpl.logger.info("Metodo findAllLikeSinServicio");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CUSU15 CUSU15,t1.DUSU15 DUSU15,t1.CSERV15 CSERV15,t1.SITU15 SITU15,t1.USUB15 USUB15 ");
		query.append("FROM AA21B15S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAa21b15s01, null,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		Aa21b15s01DaoImpl.logger.info("findAllLikeSinServicio");
		Aa21b15s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b15s01DaoImpl.logger.info("PARAMS" + params);
		return (List<Aa21b15s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMapSinServicio, params.toArray());
	}

	@Override
	public List<Aa21b15s01> findAllLikeRespServicio(
			Aa21b15s01 filterAa21b15s01, JQGridRequestDto jqGridRequestDto,
			boolean startsWith) {
		// TODO Auto-generated method stub
		Aa21b15s01DaoImpl.logger.info("Metodo findAllLikeRespServicio");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CUSU15 CUSU15,t1.DUSU15 DUSU15,t1.CSERV15 CSERV15,t1.SITU15 SITU15,t1.USUB15 USUB15, t1.CSERVOLD15 CSERVOLD15 ");
		query.append("FROM AA21B15S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapRespServicio(
				filterAa21b15s01, null, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		Aa21b15s01DaoImpl.logger.info("findAllLikeRespServicio");
		Aa21b15s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b15s01DaoImpl.logger.info("PARAMS" + params);
		return (List<Aa21b15s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMapSinServicio, params.toArray());
	}

	@Override
	public Long findAllLikeCountSinServicio(Aa21b15s01 aa21b15s01,
			boolean startsWith) {
		// TODO Auto-generated method stub
		Aa21b15s01DaoImpl.logger.info("Metodo findAllLikeCountSinServicio");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA21B15S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa21b15s01, null,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa21b15s01DaoImpl.logger.info("findAllLikeCountSinServicio");
		Aa21b15s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b15s01DaoImpl.logger.info("PARAMS" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	@Override
	public Long findAllLikeCountRespServicio(Aa21b15s01 aa21b15s01,
			boolean startsWith) {
		// TODO Auto-generated method stub
		Aa21b15s01DaoImpl.logger.info("Metodo findAllLikeCountRespServicio");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA21B15S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapRespServicio(aa21b15s01,
				null, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa21b15s01DaoImpl.logger.info("findAllLikeCountRespServicio");
		Aa21b15s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b15s01DaoImpl.logger.info("PARAMS" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	@Override
	public void updateAsignados(ArrayList<String> listaUsuAsig,
			Aa21b13s01 servicio) {
		// TODO Auto-generated method stub

		for (int i = 0; i < listaUsuAsig.size(); i++) {

			Aa21b15s01DaoImpl.logger.info("updateAsignados");
			String query = "UPDATE AA21B15S01 SET CSERV15=? WHERE CUSU15=?";
			Aa21b15s01DaoImpl.logger.info("SQL = " + query);
			Aa21b15s01DaoImpl.logger.info("PARAM1=" + servicio.getCServ13());
			Aa21b15s01DaoImpl.logger.info("PARAM2pk=" + listaUsuAsig.get(i));

			this.jdbcTemplate.update(query, servicio.getCServ13(),
					listaUsuAsig.get(i));
		}
	}

	@Override
	public void removeAsignados(ArrayList<String> listaDesagregar) {
		// TODO Auto-generated method stub

		for (int i = 0; i < listaDesagregar.size(); i++) {
			Aa21b15s01DaoImpl.logger.info("removeAsignados");
			// String query = "UPDATE AA21B15S01 SET CSERV15=?  WHERE CUSU15=?";
			// Cambio update por delete, no tiene sentido tener usuarios sin
			// servicio
			String query = "DELETE FROM AA21B15S01 WHERE  CUSU15=?";
			Aa21b15s01DaoImpl.logger.info("SQL = " + query);
			// Aa21b15s01DaoImpl.logger.info("PARAM1= ");
			Aa21b15s01DaoImpl.logger.info("PARAM2pk=" + listaDesagregar.get(i));
			// he quitado parametro null en primera posicion
			this.jdbcTemplate.update(query, listaDesagregar.get(i));
		}

	}

	/**
	 * @param cusu15
	 *            Long
	 * @return boolean
	 * 
	 */
	public boolean existeUsuarioExp(String cusu15) {
		Aa21b15s01DaoImpl.logger.info("Metodo existeUsuarioExp");
		String query = "SELECT COUNT(1) FROM AA21B20S01 WHERE CRESPO20 = ?";
		Aa21b15s01DaoImpl.logger.info("SQL " + query);
		Aa21b15s01DaoImpl.logger.info("PARAM1 " + cusu15);
		return this.jdbcTemplate.queryForInt(query, cusu15) > 0;
	}

	/**
	 * @param aa21b15s01
	 *            Aa21b15s01 Long
	 * @return boolean
	 * 
	 */
	public boolean existeUsuario(Aa21b15s01 aa21b15s01) {
		Aa21b15s01DaoImpl.logger.info("Metodo existeUsuario");
		String query = "SELECT COUNT(1) FROM AA21B15S01 WHERE UXLNET15 = ?";
		Aa21b15s01DaoImpl.logger.info("SQL " + query);
		Aa21b15s01DaoImpl.logger.info("PARAM1 " + aa21b15s01.getUxlnet15());
		return this.jdbcTemplate.queryForInt(query, aa21b15s01.getUxlnet15()) > 0;
	}

	@Override
	public List<Aa21b15s01> findAllComboUsuariosServicios(
			List<Aa21b15s01> listaUsuarios, JQGridRequestDto jqGridRequestDto) {
		Aa21b15s01DaoImpl.logger.info("Metodo findAllComboUsuariosServicios");

		StringBuilder query = new StringBuilder(
				"SELECT  t1.CUSU15 CUSU15,t1.DUSU15 DUSU15,t1.CSERV15 CSERV15,t1.SITU15 SITU15,t1.USUB15 USUB15, t1.UXLNET15 UXLNET15, ");
		query.append(" t13.CSERV13||' - '||t13.DSERV13 DSERV15, t13.CSERV13||' - '||t13.ESERV13 ESERV15, t13.SITU13 SITUSERV ");
		query.append("FROM AA21B15S01 t1 LEFT JOIN AA21B13S01 t13 ON t1.CSERV15 = t13.CSERV13");

		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereMapComboUsuariosServicios(listaUsuarios);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		Aa21b15s01DaoImpl.logger.info("findAllComboTiposExpServicio");
		Aa21b15s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b15s01DaoImpl.logger.info("PARAMs=" + params);

		return (List<Aa21b15s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * 
	 * @param listaUsuarios
	 *            List<Aa21b15s01>
	 * @return Map<String, ?>
	 */
	private Map<String, ?> getWhereMapComboUsuariosServicios(
			List<Aa21b15s01> listaUsuarios) {
		StringBuilder where = new StringBuilder(
				Aa21b15s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (listaUsuarios != null) {
			if (listaUsuarios.size() > 0) {
				where.append(" AND ");
				Aa21b15s01 serviciosAux = null;
				for (Iterator<Aa21b15s01> iterator = listaUsuarios.iterator(); iterator
						.hasNext();) {

					serviciosAux = (Aa21b15s01) iterator.next();
					where.append(" t1.CSERV15 = ? ");
					params.add(serviciosAux.getCserv15());
					if (iterator.hasNext()) {
						where.append(" OR ");
					}
				}
			}
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
}
