package com.ejie.aa21b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa21b.model.Aa21b13s01;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa21b13s01DaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class Aa21b13s01DaoImpl implements Aa21b13s01Dao {
	private JdbcTemplate jdbcTemplate;
	private static final Logger logger = LoggerFactory
			.getLogger(Aa21b13s01DaoImpl.class);

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa21b13s01> rwMap = new RowMapper<Aa21b13s01>() {
		public Aa21b13s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa21b13s01(resultSet.getString("CSERV13"),
					resultSet.getString("DSERV13"),
					resultSet.getString("ESERV13"),
					resultSet.getString("SITU13"),
					resultSet.getString("USUB13"));
		}
	};

	private RowMapper<Aa21b13s01> rwMapPK = new RowMapper<Aa21b13s01>() {
		public Aa21b13s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa21b13s01(resultSet.getString("CSERV13"));
		}
	};

	private RowMapper<Aa21b13s01> rwMapDServ = new RowMapper<Aa21b13s01>() {
		public Aa21b13s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Aa21b13s01 responsable = new Aa21b13s01();
			responsable.setDServ13(resultSet.getString("DSERV13"));
			responsable.setEServ13(resultSet.getString("ESERV13"));
			responsable.setCServ13(resultSet.getString("CSERV13"));
			return responsable;
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Aa21b13s01>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa21b13s01>>() {
		public JerarquiaDto<Aa21b13s01> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Aa21b13s01 aa21b13s01 = new Aa21b13s01(
					resultSet.getString("CSERV13"),
					resultSet.getString("DSERV13"),
					resultSet.getString("ESERV13"),
					resultSet.getString("SITU13"),
					resultSet.getString("USUB13"));

			JerarquiaDto<Aa21b13s01> jerarquia = new JerarquiaDto<Aa21b13s01>();
			jerarquia.setModel(aa21b13s01);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Aa21b13s01 table.
	 * 
	 * @param aa21b13s01
	 *            Aa21b13s01
	 * @return Aa21b13s01
	 */
	public Aa21b13s01 add(Aa21b13s01 aa21b13s01) {
		Aa21b13s01DaoImpl.logger.info("Método add");

		Long correlativo = obtenerCorrelativoServicio();
		String query = "INSERT INTO AA21B13S01 (CSERV13, DSERV13, ESERV13, SITU13, BLOQ13, USUB13) VALUES (?,?,?,?,?,?)";

		Aa21b13s01DaoImpl.logger.info("SQL = " + query);
		Aa21b13s01DaoImpl.logger.info("PARAM1=" + correlativo.toString());
		Aa21b13s01DaoImpl.logger.info("PARAM2=" + aa21b13s01.getDServ13());
		Aa21b13s01DaoImpl.logger.info("PARAM3=" + aa21b13s01.getEServ13());
		Aa21b13s01DaoImpl.logger.info("PARAM4=" + aa21b13s01.getSitu13());
		Aa21b13s01DaoImpl.logger.info("PARAM7=" + 0);
		Aa21b13s01DaoImpl.logger.info("PARAM8=null");

		this.jdbcTemplate.update(query, correlativo.toString(),
				aa21b13s01.getDServ13(), aa21b13s01.getEServ13(),
				aa21b13s01.getSitu13(), 0, null);
		aa21b13s01.setCServ13(correlativo.toString());
		return aa21b13s01;
	}

	/**
	 * Finds rows in the Responsables tramitación table using like.
	 * 
	 * @return Integer
	 */

	@Transactional(readOnly = true)
	public Long obtenerCorrelativoServicio() {

		Aa21b13s01DaoImpl.logger.info("Método obtenerCorrelativoServicio");
		StringBuffer query = new StringBuffer(" ");
		query.append(" SELECT ");
		query.append(" * FROM");
		query.append("  (SELECT (t1.cserv13+1)");
		query.append("  FROM");
		query.append("    (SELECT 0 AS cserv13 FROM dual");
		query.append("    UNION ALL");
		query.append("    SELECT cserv13 FROM aa21b13s01");
		query.append("    ) t1");
		query.append("   LEFT JOIN aa21b13s01 t2");
		query.append("   ON t1.cserv13+1   = t2.cserv13");
		query.append("   WHERE t2.cserv13 IS NULL");
		query.append("  )");
		query.append(" WHERE rownum = 1");
		List<Object> params = new ArrayList<Object>();
		Aa21b13s01DaoImpl.logger.info("obtenerCorrelativoServicio");
		Aa21b13s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b13s01DaoImpl.logger.info("PARAMs=" + params);
		return (this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray()));
	}

	/**
	 * Updates a single row in the Aa21b13s01 table.
	 * 
	 * @param aa21b13s01
	 *            Aa21b13s01
	 * @return Aa21b13s01
	 */
	public Aa21b13s01 update(Aa21b13s01 aa21b13s01) {
		Aa21b13s01DaoImpl.logger.info("Método update");
		String query = "UPDATE AA21B13S01 SET DSERV13=?, ESERV13=?, SITU13=? WHERE CSERV13=?";

		Aa21b13s01DaoImpl.logger.info("SQL = " + query);
		Aa21b13s01DaoImpl.logger.info("PARAM1=" + aa21b13s01.getDServ13());
		Aa21b13s01DaoImpl.logger.info("PARAM2=" + aa21b13s01.getEServ13());
		Aa21b13s01DaoImpl.logger.info("PARAM3=" + aa21b13s01.getSitu13());
		Aa21b13s01DaoImpl.logger.info("PARAM4pk=" + aa21b13s01.getCServ13());

		this.jdbcTemplate.update(query, aa21b13s01.getDServ13(),
				aa21b13s01.getEServ13(), aa21b13s01.getSitu13(),
				aa21b13s01.getCServ13());
		return aa21b13s01;
	}

	/**
	 * Updates bloqueos in the Aa21b13s01 table.
	 * 
	 * @param aa21b13s01
	 *            Aa21b13s01
	 * @return Aa21b13s01
	 */
	public Aa21b13s01 updateBloqueos(Aa21b13s01 aa21b13s01) {
		Aa21b13s01DaoImpl.logger.info("Método updateBloqueos");
		if (aa21b13s01 != null) {
			String query = "UPDATE AA21B13S01 SET BLOQ13=?, USUB13=? WHERE CSERV13=?";

			Aa21b13s01DaoImpl.logger.info("SQL = " + query);
			Aa21b13s01DaoImpl.logger.info("PARAM1=" + aa21b13s01.getBloq13());
			Aa21b13s01DaoImpl.logger.info("PARAM2=" + aa21b13s01.getUsub13());
			Aa21b13s01DaoImpl.logger
					.info("PARAM3pk=" + aa21b13s01.getCServ13());

			this.jdbcTemplate.update(query, aa21b13s01.getBloq13(),
					aa21b13s01.getUsub13(), aa21b13s01.getCServ13());
		} else {
			String query = "UPDATE AA21B13S01 SET BLOQ13=?, USUB13=? ";
			Aa21b13s01DaoImpl.logger.info("SQL = " + query);
			Aa21b13s01DaoImpl.logger.info("PARAM1=" + 0);
			Aa21b13s01DaoImpl.logger.info("PARAM2=null");

			this.jdbcTemplate.update(query, 0, null);
		}
		return aa21b13s01;
	}

	/**
	 * Finds a single row in the Aa21b13s01 table.
	 * 
	 * @param aa21b13s01
	 *            Aa21b13s01
	 * @return Aa21b13s01
	 */
	@Transactional(readOnly = true)
	public Aa21b13s01 find(Aa21b13s01 aa21b13s01) {
		Aa21b13s01DaoImpl.logger.info("Método find");
		String query = "SELECT t1.CSERV13 CSERV13, t1.DSERV13 DSERV13, t1.ESERV13 ESERV13, t1.SITU13 SITU13,t1.USUB13 USUB13 FROM AA21B13S01 t1  WHERE t1.CSERV13 = ?  ";

		Aa21b13s01DaoImpl.logger.info("SQL = " + query);
		Aa21b13s01DaoImpl.logger.info("PARAM1pk=" + aa21b13s01.getCServ13());

		List<Aa21b13s01> aa21b13s01List = this.jdbcTemplate.query(query,
				this.rwMap, aa21b13s01.getCServ13());
		return (Aa21b13s01) DataAccessUtils.uniqueResult(aa21b13s01List);
	}

	/**
	 * Removes a single row in the Aa21b13s01 table.
	 * 
	 * @param aa21b13s01
	 *            Aa21b13s01
	 * @return
	 */
	public void remove(Aa21b13s01 aa21b13s01) {
		Aa21b13s01DaoImpl.logger.info("Método remove");
		String query = "DELETE FROM AA21B13S01 WHERE CSERV13=?";
		Aa21b13s01DaoImpl.logger.info("SQL = " + query);
		Aa21b13s01DaoImpl.logger.info("PARAM1pk=" + aa21b13s01.getCServ13());
		this.jdbcTemplate.update(query, aa21b13s01.getCServ13());
	}

	/**
	 * Finds a list of rows in the Aa21b13s01 table.
	 * 
	 * @param aa21b13s01
	 *            Aa21b13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa21b13s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa21b13s01> findAll(Aa21b13s01 aa21b13s01,
			JQGridRequestDto jqGridRequestDto) {
		Aa21b13s01DaoImpl.logger.info("Método findAll");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CSERV13 CSERV13,t1.DSERV13 DSERV13,t1.ESERV13 ESERV13,t1.SITU13 SITU13,t1.USUB13 USUB13 ");
		query.append("FROM AA21B13S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa21b13s01);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		Aa21b13s01DaoImpl.logger.info("findAll");
		Aa21b13s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b13s01DaoImpl.logger.info("PARAMS" + params);

		return (List<Aa21b13s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Aa21b13s01 table using like.
	 * 
	 * @param aa21b13s01
	 *            Aa21b13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa21b13s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa21b13s01> findAllLike(Aa21b13s01 aa21b13s01,
			JQGridRequestDto jqGridRequestDto, List<Aa21b13s01> listaServicios,
			Boolean startsWith) {

		Aa21b13s01DaoImpl.logger.info("Método findAllLike");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CSERV13 CSERV13,t1.DSERV13 DSERV13,t1.ESERV13 ESERV13,t1.SITU13 SITU13,t1.USUB13 USUB13 ");
		query.append("FROM AA21B13S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa21b13s01,
				listaServicios, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		Aa21b13s01DaoImpl.logger.info("findAllLike");
		Aa21b13s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b13s01DaoImpl.logger.info("PARAMS" + params);

		return (List<Aa21b13s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Aa21b13s01 table.
	 * 
	 * @param aa21b13s01
	 *            Aa21b13s01
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa21b13s01 aa21b13s01) {
		Aa21b13s01DaoImpl.logger.info("Método findAllCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA21B13S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa21b13s01);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		Aa21b13s01DaoImpl.logger.info("findAllCount");
		Aa21b13s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b13s01DaoImpl.logger.info("PARAMS" + params);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Aa21b13s01 table using like.
	 * 
	 * @param aa21b13s01
	 *            Aa21b13s01
	 * @param listaServicios
	 *            List<Aa21b13s01>
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Aa21b13s01 aa21b13s01,
			List<Aa21b13s01> listaServicios, Boolean startsWith) {

		Aa21b13s01DaoImpl.logger.info("Método findAllLikeCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA21B13S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa21b13s01,
				listaServicios, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		Aa21b13s01DaoImpl.logger.info("findAllLikeCount");
		Aa21b13s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b13s01DaoImpl.logger.info("PARAMS" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Aa21b13s01 selected for rup_table
	 * 
	 * @param aa21b13s01
	 *            Aa21b13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa21b13s01>>
	 */
	@Override
	public List<TableRowDto<Aa21b13s01>> reorderSelection(
			Aa21b13s01 aa21b13s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {

		Aa21b13s01DaoImpl.logger.info("Método reorderSelection");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CSERV13 CSERV13,t1.DSERV13 DSERV13,t1.ESERV13 ESERV13,t1.SITU13 SITU13,t1.USUB13 USUB13 ");
		// FROM
		query.append("FROM AA21B13S01 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa21b13s01, null,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Aa21b13s01.class, filterParamList,
				"CSERV13");

		Aa21b13s01DaoImpl.logger.info("reorderSelection");
		Aa21b13s01DaoImpl.logger.info("SQL = "
				+ sbReorderSelectionSQL.toString());
		Aa21b13s01DaoImpl.logger.info("PARAMs=" + filterParamList);

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa21b13s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Aa21b13s01
	 * @param searchParams
	 *            Aa21b13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa21b13s01>>
	 */
	@Override
	public List<TableRowDto<Aa21b13s01>> search(Aa21b13s01 filterParams,
			Aa21b13s01 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {

		Aa21b13s01DaoImpl.logger.info("Método search");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CSERV13 CSERV13,t1.DSERV13 DSERV13,t1.ESERV13 ESERV13,t1.SITU13 SITU13,t1.USUB13 USUB13 ");
		// FROM
		query.append("FROM AA21B13S01 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				null, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, null, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Aa21b13s01.class, filterParamList,
				searchSQL, searchParamList, from_alias, "CSERV13");

		Aa21b13s01DaoImpl.logger.info("search");
		Aa21b13s01DaoImpl.logger.info("SQL = "
				+ sbReorderSelectionSQL.toString());
		Aa21b13s01DaoImpl.logger.info("PARAMs=" + filterParamList);

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa21b13s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filteraa21b13s01
	 *            Aa21b13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Aa21b13s01 filteraa21b13s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {

		Aa21b13s01DaoImpl.logger.info("Método removeMultiple");
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.CSERV13 CSERV13,t1.DSERV13 DSERV13,t1.ESERV13 ESERV13,t1.SITU13 SITU13,t1.USUB13 USUB13 ");
		// FROM
		query.append("FROM AA21B13S01 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa21b13s01,
				null, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Aa21b13s01.class,
						query, params, "CSERV13");

		Aa21b13s01DaoImpl.logger.info("removeMultiple");
		Aa21b13s01DaoImpl.logger
				.info("SQL = " + sbRemoveMultipleSQL.toString());
		Aa21b13s01DaoImpl.logger.info("PARAMs=" + params);
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa21b13s01 table.
	 * 
	 * @param filterAa21b13s01
	 *            Aa21b13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa21b13s01>>
	 */
	@Override
	public List<JerarquiaDto<Aa21b13s01>> findAllLikeJerarquia(
			Aa21b13s01 filterAa21b13s01, JQGridRequestDto jqGridRequestDto) {
		Aa21b13s01DaoImpl.logger.info("Método findAllLikeJerarquia");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CSERV13 CSERV13,t1.DSERV13 DSERV13,t1.ESERV13 ESERV13,t1.SITU13 SITU13,t1.USUB13 USUB13 ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA21B13S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA21B13S01");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAa21b13s01, null,
				false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "CSERV13", "ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa21b13s01DaoImpl.logger.info("findAllLikeJerarquia");
		Aa21b13s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b13s01DaoImpl.logger.info("PARAMs=" + params);
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa21b13s01
	 *            Aa21b13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Aa21b13s01 filterAa21b13s01,
			JQGridRequestDto jqGridRequestDto) {
		Aa21b13s01DaoImpl.logger.info("Método findAllLikeCountJerarquia");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA21B13S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA21B13S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAa21b13s01, null,
				false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "CSERV13", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa21b13s01DaoImpl.logger.info("findAllLikeCountJerarquia");
		Aa21b13s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b13s01DaoImpl.logger.info("PARAMs=" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa21b13s01
	 *            Aa21b13s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa21b13s01>>
	 */
	@Override
	public List<TableRowDto<Aa21b13s01>> findAllChild(
			Aa21b13s01 filterAa21b13s01, JQGridRequestDto jqGridRequestDto) {

		Aa21b13s01DaoImpl.logger.info("Método findAllChild");

		// FROM
		// StringBuilder from = new StringBuilder("FROM AA21B13S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA21B13S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAa21b13s01, null,
				false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "CSERV13", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa21b13s01DaoImpl.logger.info("findAllChild");
		Aa21b13s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b13s01DaoImpl.logger.info("PARAMs=" + params);
		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<Aa21b13s01>(this.rwMapPK,
						"CSERV13"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa21b13s01 entity
	 * 
	 * @param aa21b13s01
	 *            Aa21b13s01 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa21b13s01 aa21b13s01) {

		StringBuilder where = new StringBuilder(
				Aa21b13s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa21b13s01 != null && aa21b13s01.getCServ13() != null) {
			where.append(" AND t1.CSERV13 = ?");
			params.add(aa21b13s01.getCServ13());
		}
		if (aa21b13s01 != null && aa21b13s01.getDServ13() != null) {
			where.append(" AND t1.DSERV13 = ?");
			params.add(aa21b13s01.getDServ13());
		}
		if (aa21b13s01 != null && aa21b13s01.getEServ13() != null) {
			where.append(" AND t1.ESERV13 = ?");
			params.add(aa21b13s01.getEServ13());
		}
		if (aa21b13s01 != null && aa21b13s01.getSitu13() != null) {
			where.append(" AND t1.SITU13 = ?");
			params.add(aa21b13s01.getSitu13());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa21b13s01 entity
	 * 
	 * @param aa21b13s01
	 *            Aa21b13s01 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Aa21b13s01 aa21b13s01,
			List<Aa21b13s01> listaServicios, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Aa21b13s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa21b13s01 != null && aa21b13s01.getCServ13() != null) {
			where.append(" AND t1.CSERV13=?");
			params.add(aa21b13s01.getCServ13());
		}
		if (aa21b13s01 != null && aa21b13s01.getDServ13() != null) {
			where.append(" AND UPPER(t1.DSERV13) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa21b13s01.getDServ13().toUpperCase() + "%");
			} else {
				params.add("%" + aa21b13s01.getDServ13().toUpperCase() + "%");
			}
			where.append(" AND t1.DSERV13 IS NOT NULL");
		}
		if (aa21b13s01 != null && aa21b13s01.getEServ13() != null) {
			where.append(" AND UPPER(t1.ESERV13) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa21b13s01.getEServ13().toUpperCase() + "%");
			} else {
				params.add("%" + aa21b13s01.getEServ13().toUpperCase() + "%");
			}
			where.append(" AND t1.ESERV13 IS NOT NULL");
		}
		if (aa21b13s01 != null && aa21b13s01.getSitu13() != null) {
			where.append(" AND UPPER(t1.SITU13) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa21b13s01.getSitu13().toUpperCase() + "%");
			} else {
				params.add("%" + aa21b13s01.getSitu13().toUpperCase() + "%");
			}
			where.append(" AND t1.SITU13 IS NOT NULL");
		}

		if (aa21b13s01 != null && aa21b13s01.getBloq13() != null) {
			where.append(" AND t1.BLOQ13 = ?");
			params.add(aa21b13s01.getBloq13());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	@Override
	public List<Aa21b13s01> findServicio(Aa21b13s01 servicio, Boolean startsWith) {
		Aa21b13s01DaoImpl.logger.info("Método findServicio");
		List<Object> params = new ArrayList<Object>();

		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		StringBuilder order = new StringBuilder("");
		StringBuilder query = new StringBuilder(
				"SELECT DISTINCT t1.DSERV13 DSERV13, t1.ESERV13 ESERV13, t1.CSERV13 CSERV13 ");
		query.append("FROM AA21B13S01 t1 ");
		if (servicio != null && servicio.getDServ13() != null) {
			where.append(" AND UPPER(t1.DSERV13) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add("%" + servicio.getDServ13().toUpperCase() + "%");
			} else {
				params.add("%" + servicio.getDServ13().toUpperCase() + "%");
			}

			order = new StringBuilder(" ORDER BY DSERV13 asc ");
		}
		if (servicio != null && servicio.getEServ13() != null) {
			where.append(" AND UPPER(t1.ESERV13) like ? ESCAPE '\\'");
			if (startsWith) {
				params.add("%" + servicio.getEServ13().toUpperCase() + "%");
			} else {
				params.add("%" + servicio.getEServ13().toUpperCase() + "%");
			}

			order = new StringBuilder(" ORDER BY ESERV13 asc ");

		}
		query.append(where);
		query.append(order);

		Aa21b13s01DaoImpl.logger.info("findServicio");
		Aa21b13s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b13s01DaoImpl.logger.info("PARAMs=" + params);

		return (List<Aa21b13s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMapDServ, params.toArray());
	}

	/**
	 * @param cserv13
	 *            String
	 * @return boolean
	 * 
	 */
	public boolean existeServicioExp(String cserv13) {
		Aa21b13s01DaoImpl.logger.info("Método existeServicioExp");
		String query = "SELECT COUNT(1) FROM AA21B20S01 WHERE CSERV20 = ?";
		Aa21b13s01DaoImpl.logger.info("SQL " + query);
		Aa21b13s01DaoImpl.logger.info("PARAM1 " + cserv13);
		return this.jdbcTemplate.queryForInt(query, cserv13) > 0;
	}

	@Override
	public boolean existeServicioUsuarios(String cServ13) {
		Aa21b13s01DaoImpl.logger.info("Método existeServicioUsuarios");
		String query = "SELECT COUNT(1) FROM AA21B15S01 WHERE CSERV15 = ?";
		Aa21b13s01DaoImpl.logger.info("SQL " + query);
		Aa21b13s01DaoImpl.logger.info("PARAM1 " + cServ13);
		return this.jdbcTemplate.queryForInt(query, cServ13) > 0;
	}
}
