package com.ejie.aa21b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa21b.model.Aa21b07s01;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa21b07s01DaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class Aa21b07s01DaoImpl implements Aa21b07s01Dao {
	private JdbcTemplate jdbcTemplate;
	private static final Logger logger = LoggerFactory
			.getLogger(Aa21b07s01DaoImpl.class);

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa21b07s01> rwMap = new RowMapper<Aa21b07s01>() {
		public Aa21b07s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa21b07s01(resultSet.getString("CESTA07"),
					resultSet.getString("DESTA07"),
					resultSet.getString("EESTA07"),
					resultSet.getString("SITU07"),
					resultSet.getString("USUB07"));
		}
	};

	private RowMapper<Aa21b07s01> rwMapPK = new RowMapper<Aa21b07s01>() {
		public Aa21b07s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa21b07s01(resultSet.getString("CESTA07"));
		}
	};

	private RowMapper<Aa21b07s01> rwMapDesta = new RowMapper<Aa21b07s01>() {
		public Aa21b07s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Aa21b07s01 estadoExp = new Aa21b07s01();
			estadoExp.setDesta07(resultSet.getString("DESTA07"));
			estadoExp.setEesta07(resultSet.getString("EESTA07"));
			return estadoExp;
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Aa21b07s01>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa21b07s01>>() {
		public JerarquiaDto<Aa21b07s01> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Aa21b07s01 aa21b07s01 = new Aa21b07s01(
					resultSet.getString("CESTA07"),
					resultSet.getString("DESTA07"),
					resultSet.getString("EESTA07"),
					resultSet.getString("SITU07"),
					resultSet.getString("USUB07"));

			JerarquiaDto<Aa21b07s01> jerarquia = new JerarquiaDto<Aa21b07s01>();
			jerarquia.setModel(aa21b07s01);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Aa21b07s01 table.
	 * 
	 * @param aa21b07s01
	 *            Aa21b07s01
	 * @return Aa21b07s01
	 */
	public Aa21b07s01 add(Aa21b07s01 aa21b07s01) {

		Aa21b07s01DaoImpl.logger.info("Método add");

		Integer correlativoEstadoExp = this
				.obtenerCorrelativoEstadoExpediente();

		aa21b07s01.setCesta07(correlativoEstadoExp.toString());
		String query = "INSERT INTO AA21B07S01 (CESTA07, DESTA07, EESTA07, SITU07, BLOQ07, USUB07) VALUES (?,?,?,?,?,?)";

		Aa21b07s01DaoImpl.logger.info("SQL = " + query);
		Aa21b07s01DaoImpl.logger.info("PARAM1=" + correlativoEstadoExp);
		Aa21b07s01DaoImpl.logger.info("PARAM2=" + aa21b07s01.getDesta07());
		Aa21b07s01DaoImpl.logger.info("PARAM3=" + aa21b07s01.getEesta07());
		Aa21b07s01DaoImpl.logger.info("PARAM4=" + aa21b07s01.getSitu07());
		Aa21b07s01DaoImpl.logger.info("PARAM7=" + 0);
		Aa21b07s01DaoImpl.logger.info("PARAM8=null");

		this.jdbcTemplate.update(query, correlativoEstadoExp,
				aa21b07s01.getDesta07(), aa21b07s01.getEesta07(),
				aa21b07s01.getSitu07(), 0, null);
		return aa21b07s01;
	}

	/**
	 * Finds rows in the Estados expediente table using like.
	 * 
	 * @return Integer
	 */
	@Transactional(readOnly = true)
	public Integer obtenerCorrelativoEstadoExpediente() {
		StringBuffer query = new StringBuffer(
				"SELECT  MAX(CESTA07) FROM Aa21b07s01 ");
		List<Object> params = new ArrayList<Object>();

		return Integer.valueOf(this.jdbcTemplate.queryForInt(query.toString(),
				params.toArray())) + 1;
	}

	/**
	 * Updates a single row in the Aa21b07s01 table.
	 * 
	 * @param aa21b07s01
	 *            Aa21b07s01
	 * @return Aa21b07s01
	 */
	public Aa21b07s01 update(Aa21b07s01 aa21b07s01) {
		Aa21b07s01DaoImpl.logger.info("Método update");
		String query = "UPDATE AA21B07S01 SET DESTA07=?, EESTA07=?, SITU07=? WHERE CESTA07=?";

		Aa21b07s01DaoImpl.logger.info("SQL = " + query);
		Aa21b07s01DaoImpl.logger.info("PARAM1=" + aa21b07s01.getDesta07());
		Aa21b07s01DaoImpl.logger.info("PARAM2=" + aa21b07s01.getEesta07());
		Aa21b07s01DaoImpl.logger.info("PARAM3=" + aa21b07s01.getSitu07());
		Aa21b07s01DaoImpl.logger.info("PARAM4pk=" + aa21b07s01.getCesta07());

		this.jdbcTemplate.update(query, aa21b07s01.getDesta07(),
				aa21b07s01.getEesta07(), aa21b07s01.getSitu07(),
				aa21b07s01.getCesta07());
		return aa21b07s01;
	}

	/**
	 * Updates bloqueos in the Aa21b07s01 table.
	 * 
	 * @param aa21b07s01
	 *            Aa21b07s01
	 * @return Aa21b07s01
	 */
	public Aa21b07s01 updateBloqueos(Aa21b07s01 aa21b07s01) {
		Aa21b07s01DaoImpl.logger.info("Método updateBloqueos");
		if (aa21b07s01 != null) {
			String query = "UPDATE AA21B07S01 SET BLOQ07=?, USUB07=? WHERE CESTA07=?";

			Aa21b07s01DaoImpl.logger.info("SQL = " + query);
			Aa21b07s01DaoImpl.logger.info("PARAM1=" + aa21b07s01.getBloq07());
			Aa21b07s01DaoImpl.logger.info("PARAM2=" + aa21b07s01.getUsub07());
			Aa21b07s01DaoImpl.logger
					.info("PARAM3pk=" + aa21b07s01.getCesta07());

			this.jdbcTemplate.update(query, aa21b07s01.getBloq07(),
					aa21b07s01.getUsub07(), aa21b07s01.getCesta07());
		} else {
			String query = "UPDATE AA21B07S01 SET BLOQ07=?, USUB07=? ";

			Aa21b07s01DaoImpl.logger.info("SQL = " + query);
			Aa21b07s01DaoImpl.logger.info("PARAM1=" + 0);
			Aa21b07s01DaoImpl.logger.info("PARAM2=null");

			this.jdbcTemplate.update(query, 0, null);
		}
		return aa21b07s01;
	}

	/**
	 * Finds a single row in the Aa21b07s01 table.
	 * 
	 * @param aa21b07s01
	 *            Aa21b07s01
	 * @return Aa21b07s01
	 */
	@Transactional(readOnly = true)
	public Aa21b07s01 find(Aa21b07s01 aa21b07s01) {
		Aa21b07s01DaoImpl.logger.info("Método find");

		String query = "SELECT t1.CESTA07 CESTA07, t1.DESTA07 DESTA07, t1.EESTA07 EESTA07, t1.SITU07 SITU07, t1.USUB07 USUB07 FROM AA21B07S01 t1  WHERE t1.CESTA07 = ?  ";

		Aa21b07s01DaoImpl.logger.info("SQL = " + query);
		Aa21b07s01DaoImpl.logger.info("PARAM1pk=" + aa21b07s01.getCesta07());

		List<Aa21b07s01> aa21b07s01List = this.jdbcTemplate.query(query,
				this.rwMap, aa21b07s01.getCesta07());

		return (Aa21b07s01) DataAccessUtils.uniqueResult(aa21b07s01List);
	}

	/**
	 * Removes a single row in the Aa21b07s01 table.
	 * 
	 * @param aa21b07s01
	 *            Aa21b07s01
	 * @return
	 */
	public void remove(Aa21b07s01 aa21b07s01) {
		Aa21b07s01DaoImpl.logger.info("Método remove");
		String query = "DELETE FROM AA21B07S01 WHERE CESTA07=?";
		Aa21b07s01DaoImpl.logger.info("SQL = " + query);
		Aa21b07s01DaoImpl.logger.info("PARAM1pk=" + aa21b07s01.getCesta07());
		this.jdbcTemplate.update(query, aa21b07s01.getCesta07());
	}

	/**
	 * Finds a list of rows in the Aa21b07s01 table.
	 * 
	 * @param aa21b07s01
	 *            Aa21b07s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa21b07s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa21b07s01> findAll(Aa21b07s01 aa21b07s01,
			JQGridRequestDto jqGridRequestDto) {

		Aa21b07s01DaoImpl.logger
				.info("Estados de expedientes-->Método findAll");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CESTA07 CESTA07,t1.DESTA07 DESTA07,t1.EESTA07 EESTA07,t1.SITU07 SITU07,t1.USUB07 USUB07 ");
		query.append("FROM AA21B07S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa21b07s01);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		Aa21b07s01DaoImpl.logger.info("findAll");
		Aa21b07s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b07s01DaoImpl.logger.info("PARAMS" + params);

		return (List<Aa21b07s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Aa21b07s01 table using like.
	 * 
	 * @param aa21b07s01
	 *            Aa21b07s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa21b07s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa21b07s01> findAllLike(Aa21b07s01 aa21b07s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		Aa21b07s01DaoImpl.logger.info("Método findAllLike");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CESTA07 CESTA07,t1.DESTA07 DESTA07,t1.EESTA07 EESTA07,t1.SITU07 SITU07,t1.USUB07 USUB07 ");
		query.append("FROM AA21B07S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa21b07s01, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		Aa21b07s01DaoImpl.logger.info("findAllLike");
		Aa21b07s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b07s01DaoImpl.logger.info("PARAMS" + params);

		return (List<Aa21b07s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Aa21b07s01 table.
	 * 
	 * @param aa21b07s01
	 *            Aa21b07s01
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa21b07s01 aa21b07s01) {
		Aa21b07s01DaoImpl.logger.info("Método findAllCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA21B07S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa21b07s01);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		Aa21b07s01DaoImpl.logger.info("findAllCount");
		Aa21b07s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b07s01DaoImpl.logger.info("PARAMS" + params);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Aa21b07s01 table using like.
	 * 
	 * @param aa21b07s01
	 *            Aa21b07s01
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Aa21b07s01 aa21b07s01, Boolean startsWith) {

		Aa21b07s01DaoImpl.logger.info("Método findAllLikeCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA21B07S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa21b07s01, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		Aa21b07s01DaoImpl.logger.info("findAllLikeCount");
		Aa21b07s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b07s01DaoImpl.logger.info("PARAMS" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Aa21b07s01 selected for rup_table
	 * 
	 * @param aa21b07s01
	 *            Aa21b07s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa21b07s01>>
	 */
	@Override
	public List<TableRowDto<Aa21b07s01>> reorderSelection(
			Aa21b07s01 aa21b07s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {

		Aa21b07s01DaoImpl.logger.info("Método reorderSelection");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CESTA07 CESTA07,t1.DESTA07 DESTA07,t1.EESTA07 EESTA07,t1.SITU07 SITU07,t1.USUB07 USUB07 ");
		// FROM
		query.append("FROM AA21B07S01 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa21b07s01, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Aa21b07s01.class, filterParamList,
				"CESTA07");

		Aa21b07s01DaoImpl.logger.info("reorderSelection");
		Aa21b07s01DaoImpl.logger.info("SQL = "
				+ sbReorderSelectionSQL.toString());
		Aa21b07s01DaoImpl.logger.info("PARAMs=" + filterParamList);

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa21b07s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Aa21b07s01
	 * @param searchParams
	 *            Aa21b07s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa21b07s01>>
	 */
	@Override
	public List<TableRowDto<Aa21b07s01>> search(Aa21b07s01 filterParams,
			Aa21b07s01 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {

		Aa21b07s01DaoImpl.logger.info("Método search");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CESTA07 CESTA07,t1.DESTA07 DESTA07,t1.EESTA07 EESTA07,t1.SITU07 SITU07,t1.USUB07 USUB07 ");
		// FROM
		query.append("FROM AA21B07S01 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Aa21b07s01.class, filterParamList,
				searchSQL, searchParamList, from_alias, "CESTA07");

		Aa21b07s01DaoImpl.logger.info("search");
		Aa21b07s01DaoImpl.logger.info("SQL = "
				+ sbReorderSelectionSQL.toString());
		Aa21b07s01DaoImpl.logger.info("PARAMs=" + filterParamList);

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa21b07s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filteraa21b07s01
	 *            Aa21b07s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Aa21b07s01 filteraa21b07s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {

		Aa21b07s01DaoImpl.logger.info("Método removeMultiple");
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.CESTA07 CESTA07,t1.DESTA07 DESTA07,t1.EESTA07 EESTA07,t1.SITU07 SITU07,t1.USUB07 USUB07 ");
		// FROM
		query.append("FROM AA21B07S01 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa21b07s01,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Aa21b07s01.class,
						query, params, "CESTA07");

		Aa21b07s01DaoImpl.logger.info("removeMultiple");
		Aa21b07s01DaoImpl.logger
				.info("SQL = " + sbRemoveMultipleSQL.toString());
		Aa21b07s01DaoImpl.logger.info("PARAMs=" + params);
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa21b07s01 table.
	 * 
	 * @param filterAa21b07s01
	 *            Aa21b07s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa21b07s01>>
	 */
	@Override
	public List<JerarquiaDto<Aa21b07s01>> findAllLikeJerarquia(
			Aa21b07s01 filterAa21b07s01, JQGridRequestDto jqGridRequestDto) {

		Aa21b07s01DaoImpl.logger.info("Método findAllLikeJerarquia");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CESTA07 CESTA07,t1.DESTA07 DESTA07,t1.EESTA07 EESTA07,t1.SITU07 SITU07,t1.USUB07 USUB07 ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA21B07S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA21B07S01");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa21b07s01, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "CESTA07", "ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa21b07s01DaoImpl.logger.info("findAllLikeJerarquia");
		Aa21b07s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b07s01DaoImpl.logger.info("PARAMs=" + params);
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa21b07s01
	 *            Aa21b07s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Aa21b07s01 filterAa21b07s01,
			JQGridRequestDto jqGridRequestDto) {

		Aa21b07s01DaoImpl.logger.info("Método findAllLikeCountJerarquia");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA21B07S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA21B07S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa21b07s01, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "CESTA07", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa21b07s01DaoImpl.logger.info("findAllLikeCountJerarquia");
		Aa21b07s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b07s01DaoImpl.logger.info("PARAMs=" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa21b07s01
	 *            Aa21b07s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa21b07s01>>
	 */
	@Override
	public List<TableRowDto<Aa21b07s01>> findAllChild(
			Aa21b07s01 filterAa21b07s01, JQGridRequestDto jqGridRequestDto) {

		Aa21b07s01DaoImpl.logger.info("Método findAllChild");

		// FROM
		// StringBuilder from = new StringBuilder("FROM AA21B07S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA21B07S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa21b07s01, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "CESTA07", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		Aa21b07s01DaoImpl.logger.info("findAllChild");
		Aa21b07s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b07s01DaoImpl.logger.info("PARAMs=" + params);

		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<Aa21b07s01>(this.rwMapPK,
						"CESTA07"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa21b07s01 entity
	 * 
	 * @param aa21b07s01
	 *            Aa21b07s01 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa21b07s01 aa21b07s01) {

		StringBuilder where = new StringBuilder(
				Aa21b07s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa21b07s01 != null && aa21b07s01.getCesta07() != null) {
			where.append(" AND t1.CESTA07 = ?");
			params.add(aa21b07s01.getCesta07());
		}
		if (aa21b07s01 != null && aa21b07s01.getDesta07() != null) {
			where.append(" AND t1.DESTA07 = ?");
			params.add(aa21b07s01.getDesta07());
		}
		if (aa21b07s01 != null && aa21b07s01.getEesta07() != null) {
			where.append(" AND t1.EESTA07 = ?");
			params.add(aa21b07s01.getEesta07());
		}
		if (aa21b07s01 != null && aa21b07s01.getSitu07() != null) {
			where.append(" AND t1.SITU07 = ?");
			params.add(aa21b07s01.getSitu07());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa21b07s01 entity
	 * 
	 * @param aa21b07s01
	 *            Aa21b07s01 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Aa21b07s01 aa21b07s01,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Aa21b07s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa21b07s01 != null && aa21b07s01.getCesta07() != null) {
			where.append(" AND UPPER(t1.CESTA07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa21b07s01.getCesta07().toUpperCase() + "%");
			} else {
				params.add("%" + aa21b07s01.getCesta07().toUpperCase() + "%");
			}
			where.append(" AND t1.CESTA07 IS NOT NULL");
		}
		if (aa21b07s01 != null && aa21b07s01.getDesta07() != null) {
			where.append(" AND UPPER(t1.DESTA07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa21b07s01.getDesta07().toUpperCase() + "%");
			} else {
				params.add("%" + aa21b07s01.getDesta07().toUpperCase() + "%");
			}
			where.append(" AND t1.DESTA07 IS NOT NULL");
		}
		if (aa21b07s01 != null && aa21b07s01.getEesta07() != null) {
			where.append(" AND UPPER(t1.EESTA07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa21b07s01.getEesta07().toUpperCase() + "%");
			} else {
				params.add("%" + aa21b07s01.getEesta07().toUpperCase() + "%");
			}
			where.append(" AND t1.EESTA07 IS NOT NULL");
		}
		if (aa21b07s01 != null && aa21b07s01.getSitu07() != null) {
			where.append(" AND UPPER(t1.SITU07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa21b07s01.getSitu07().toUpperCase() + "%");
			} else {
				params.add("%" + aa21b07s01.getSitu07().toUpperCase() + "%");
			}
			where.append(" AND t1.SITU07 IS NOT NULL");
		}
		if (aa21b07s01 != null && aa21b07s01.getBloq07() != null) {
			where.append(" AND t1.BLOQ07 = ?");
			params.add(aa21b07s01.getBloq07());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	@Override
	public List<Aa21b07s01> findEstadoExpediente(Aa21b07s01 estadoExp,
			Boolean startsWith) {

		Aa21b07s01DaoImpl.logger.info("Método findEstadoExpediente");
		List<Object> params = new ArrayList<Object>();

		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		StringBuilder order = new StringBuilder("");
		StringBuilder query = new StringBuilder(
				"SELECT DISTINCT t1.DESTA07 DESTA07, t1.EESTA07 EESTA07 ");
		query.append("FROM AA21B07S01 t1 ");
		if (estadoExp != null && estadoExp.getDesta07() != null) {
			where.append(" AND UPPER(t1.DESTA07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add("%" + estadoExp.getDesta07().toUpperCase() + "%");
			} else {
				params.add("%" + estadoExp.getDesta07().toUpperCase() + "%");
			}

			order = new StringBuilder(" ORDER BY DESTA07 asc ");
		}
		if (estadoExp != null && estadoExp.getEesta07() != null) {
			where.append(" AND UPPER(t1.EESTA07) like ? ESCAPE '\\'");
			if (startsWith) {
				params.add("%" + estadoExp.getEesta07().toUpperCase() + "%");
			} else {
				params.add("%" + estadoExp.getEesta07().toUpperCase() + "%");
			}

			order = new StringBuilder(" ORDER BY EESTA07 asc ");

		}
		query.append(where);
		query.append(order);

		Aa21b07s01DaoImpl.logger.info("findEstadoExpediente");
		Aa21b07s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b07s01DaoImpl.logger.info("PARAMs=" + params);

		return (List<Aa21b07s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMapDesta, params.toArray());
	}

	/**
	 * @param cesta07
	 *            String
	 * @return boolean
	 * 
	 */
	public boolean existeEstadoExpExp(String cesta07) {
		Aa21b07s01DaoImpl.logger.info("Método existeDepartamento");
		String query = "SELECT COUNT(1) FROM AA21B20S01 WHERE CESTA20 = ?";
		Aa21b07s01DaoImpl.logger.info("SQL " + query);
		Aa21b07s01DaoImpl.logger.info("PARAM1 " + cesta07);
		return this.jdbcTemplate.queryForInt(query, cesta07) > 0;
	}

}
