package com.ejie.aa21b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa21b.model.Aa21b05s01;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa21b05s01DaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class Aa21b05s01DaoImpl implements Aa21b05s01Dao {
	private JdbcTemplate jdbcTemplate;
	private static final Logger logger = LoggerFactory
			.getLogger(Aa21b05s01DaoImpl.class);

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa21b05s01> rwMap = new RowMapper<Aa21b05s01>() {
		public Aa21b05s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa21b05s01(resultSet.getInt("CDOCU05"),
					resultSet.getString("DDOCU05"),
					resultSet.getString("EDOCU05"),
					resultSet.getString("SITU05"),
					resultSet.getString("USUB05"));
		}
	};

	private RowMapper<Aa21b05s01> rwMapPK = new RowMapper<Aa21b05s01>() {
		public Aa21b05s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa21b05s01(resultSet.getInt("CDOCU05"));
		}
	};

	private RowMapper<Aa21b05s01> rwMapDdocu = new RowMapper<Aa21b05s01>() {
		public Aa21b05s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Aa21b05s01 tipoDocumento = new Aa21b05s01();
			tipoDocumento.setDdocu05(resultSet.getString("DDOCU05"));
			tipoDocumento.setEdocu05(resultSet.getString("EDOCU05"));
			return tipoDocumento;
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Aa21b05s01>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa21b05s01>>() {
		public JerarquiaDto<Aa21b05s01> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Aa21b05s01 aa21b05s01 = new Aa21b05s01(resultSet.getInt("CDOCU05"),
					resultSet.getString("DDOCU05"),
					resultSet.getString("EDOCU05"),
					resultSet.getString("SITU05"),
					resultSet.getString("USUB05"));

			JerarquiaDto<Aa21b05s01> jerarquia = new JerarquiaDto<Aa21b05s01>();
			jerarquia.setModel(aa21b05s01);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Aa21b05s01 table.
	 * 
	 * @param aa21b05s01
	 *            Aa21b05s01
	 * @return Aa21b05s01
	 */
	public Aa21b05s01 add(Aa21b05s01 aa21b05s01) {
		Aa21b05s01DaoImpl.logger.info("M�todo add");
		Integer correlativoTipoDoc = this.obtenerCorrelativoTipoDocumento();
		aa21b05s01.setCdocu05(correlativoTipoDoc);
		String query = "INSERT INTO AA21B05S01 (CDOCU05, DDOCU05, EDOCU05, SITU05, BLOQ05, USUB05) VALUES (?,?,?,?,?,?)";

		Aa21b05s01DaoImpl.logger.info("SQL = " + query);
		Aa21b05s01DaoImpl.logger.info("PARAM1=" + correlativoTipoDoc);
		Aa21b05s01DaoImpl.logger.info("PARAM2=" + aa21b05s01.getDdocu05());
		Aa21b05s01DaoImpl.logger.info("PARAM3=" + aa21b05s01.getEdocu05());
		Aa21b05s01DaoImpl.logger.info("PARAM4=" + aa21b05s01.getSitu05());
		Aa21b05s01DaoImpl.logger.info("PARAM7=" + 0);
		Aa21b05s01DaoImpl.logger.info("PARAM8=null");

		this.jdbcTemplate.update(query, correlativoTipoDoc,
				aa21b05s01.getDdocu05(), aa21b05s01.getEdocu05(),
				aa21b05s01.getSitu05(), 0, null);
		return aa21b05s01;
	}

	/**
	 * Finds rows in the Tipos documentos table using like.
	 * 
	 * @return Integer
	 */
	@Transactional(readOnly = true)
	public Integer obtenerCorrelativoTipoDocumento() {
		Aa21b05s01DaoImpl.logger.info("M�todo obtenerCorrelativoTipoDocumento");
		StringBuffer query = new StringBuffer(
				"SELECT  MAX(CDOCU05) FROM Aa21b05s01 ");
		List<Object> params = new ArrayList<Object>();

		Aa21b05s01DaoImpl.logger.info("SQL = " + query);
		Aa21b05s01DaoImpl.logger.info("PARAM=" + params);

		return Integer.valueOf(this.jdbcTemplate.queryForInt(query.toString(),
				params.toArray())) + 1;
	}

	/**
	 * Updates a single row in the Aa21b05s01 table.
	 * 
	 * @param aa21b05s01
	 *            Aa21b05s01
	 * @return Aa21b05s01
	 */
	public Aa21b05s01 update(Aa21b05s01 aa21b05s01) {
		Aa21b05s01DaoImpl.logger.info("M�todo update");
		String query = "UPDATE AA21B05S01 SET DDOCU05=?, EDOCU05=?, SITU05=? WHERE CDOCU05=?";

		Aa21b05s01DaoImpl.logger.info("SQL = " + query);
		Aa21b05s01DaoImpl.logger.info("PARAM1=" + aa21b05s01.getDdocu05());
		Aa21b05s01DaoImpl.logger.info("PARAM2=" + aa21b05s01.getEdocu05());
		Aa21b05s01DaoImpl.logger.info("PARAM3=" + aa21b05s01.getSitu05());
		Aa21b05s01DaoImpl.logger.info("PARAM4pk=" + aa21b05s01.getCdocu05());

		this.jdbcTemplate.update(query, aa21b05s01.getDdocu05(),
				aa21b05s01.getEdocu05(), aa21b05s01.getSitu05(),
				aa21b05s01.getCdocu05());
		return aa21b05s01;
	}

	/**
	 * Updates bloqueos in the Aa21b05s01 table.
	 * 
	 * @param aa21b05s01
	 *            Aa21b05s01
	 * @return Aa21b05s01
	 */
	public Aa21b05s01 updateBloqueos(Aa21b05s01 aa21b05s01) {
		Aa21b05s01DaoImpl.logger.info("M�todo updateBloqueos");
		if (aa21b05s01 != null) {
			String query = "UPDATE AA21B05S01 SET BLOQ05=?, USUB05=? WHERE CDOCU05=?";
			Aa21b05s01DaoImpl.logger.info("SQL = " + query);
			Aa21b05s01DaoImpl.logger.info("PARAM1=" + aa21b05s01.getBloq05());
			Aa21b05s01DaoImpl.logger.info("PARAM2=" + aa21b05s01.getUsub05());
			Aa21b05s01DaoImpl.logger
					.info("PARAM3pk=" + aa21b05s01.getCdocu05());

			this.jdbcTemplate.update(query, aa21b05s01.getBloq05(),
					aa21b05s01.getUsub05(), aa21b05s01.getCdocu05());
		} else {
			String query = "UPDATE AA21B05S01 SET BLOQ05=?, USUB05=? ";
			Aa21b05s01DaoImpl.logger.info("SQL = " + query);
			Aa21b05s01DaoImpl.logger.info("PARAM1=" + 0);
			Aa21b05s01DaoImpl.logger.info("PARAM2=null");

			this.jdbcTemplate.update(query, 0, null);
		}
		return aa21b05s01;
	}

	/**
	 * Finds a single row in the Aa21b05s01 table.
	 * 
	 * @param aa21b05s01
	 *            Aa21b05s01
	 * @return Aa21b05s01
	 */
	@Transactional(readOnly = true)
	public Aa21b05s01 find(Aa21b05s01 aa21b05s01) {
		Aa21b05s01DaoImpl.logger.info("M�todo find");
		String query = "SELECT t1.CDOCU05 CDOCU05, t1.DDOCU05 DDOCU05, t1.EDOCU05 EDOCU05, t1.SITU05 SITU05, t1.USUB05 USUB05 FROM AA21B05S01 t1  WHERE t1.CDOCU05 = ?  ";

		Aa21b05s01DaoImpl.logger.info("SQL = " + query);
		Aa21b05s01DaoImpl.logger.info("PARAM1pk=" + aa21b05s01.getCdocu05());

		List<Aa21b05s01> aa21b05s01List = this.jdbcTemplate.query(query,
				this.rwMap, aa21b05s01.getCdocu05());
		return (Aa21b05s01) DataAccessUtils.uniqueResult(aa21b05s01List);
	}

	/**
	 * Removes a single row in the Aa21b05s01 table.
	 * 
	 * @param aa21b05s01
	 *            Aa21b05s01
	 * @return
	 */
	public void remove(Aa21b05s01 aa21b05s01) {
		Aa21b05s01DaoImpl.logger.info("M�todo remove");
		String query = "DELETE FROM AA21B05S01 WHERE CDOCU05=?";
		Aa21b05s01DaoImpl.logger.info("SQL = " + query);
		Aa21b05s01DaoImpl.logger.info("PARAM1pk=" + aa21b05s01.getCdocu05());
		this.jdbcTemplate.update(query, aa21b05s01.getCdocu05());
	}

	/**
	 * Finds a list of rows in the Aa21b05s01 table.
	 * 
	 * @param aa21b05s01
	 *            Aa21b05s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa21b05s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa21b05s01> findAll(Aa21b05s01 aa21b05s01,
			JQGridRequestDto jqGridRequestDto) {
		Aa21b05s01DaoImpl.logger.info("M�todo findAll");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CDOCU05 CDOCU05,t1.DDOCU05 DDOCU05,t1.EDOCU05 EDOCU05,t1.SITU05 SITU05,t1.USUB05 USUB05 ");
		query.append("FROM AA21B05S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa21b05s01);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		Aa21b05s01DaoImpl.logger.info("findAll");
		Aa21b05s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b05s01DaoImpl.logger.info("PARAMS" + params);
		return (List<Aa21b05s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Aa21b05s01 table using like.
	 * 
	 * @param aa21b05s01
	 *            Aa21b05s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa21b05s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa21b05s01> findAllLike(Aa21b05s01 aa21b05s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		Aa21b05s01DaoImpl.logger.info("M�todo findAllLike");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CDOCU05 CDOCU05,t1.DDOCU05 DDOCU05,t1.EDOCU05 EDOCU05,t1.SITU05 SITU05, t1.USUB05 USUB05 ");
		query.append("FROM AA21B05S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa21b05s01, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		Aa21b05s01DaoImpl.logger.info("findAllLike");
		Aa21b05s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b05s01DaoImpl.logger.info("PARAMS" + params);
		return (List<Aa21b05s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Aa21b05s01 table.
	 * 
	 * @param aa21b05s01
	 *            Aa21b05s01
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa21b05s01 aa21b05s01) {
		Aa21b05s01DaoImpl.logger.info("M�todo findAllCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA21B05S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa21b05s01);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa21b05s01DaoImpl.logger.info("findAllCount");
		Aa21b05s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b05s01DaoImpl.logger.info("PARAMS" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Aa21b05s01 table using like.
	 * 
	 * @param aa21b05s01
	 *            Aa21b05s01
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Aa21b05s01 aa21b05s01, Boolean startsWith) {
		Aa21b05s01DaoImpl.logger.info("M�todo findAllLikeCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA21B05S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa21b05s01, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa21b05s01DaoImpl.logger.info("findAllLikeCount");
		Aa21b05s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b05s01DaoImpl.logger.info("PARAMS" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Aa21b05s01 selected for rup_table
	 * 
	 * @param aa21b05s01
	 *            Aa21b05s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa21b05s01>>
	 */
	@Override
	public List<TableRowDto<Aa21b05s01>> reorderSelection(
			Aa21b05s01 aa21b05s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {

		Aa21b05s01DaoImpl.logger.info("M�todo reorderSelection");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CDOCU05 CDOCU05,t1.DDOCU05 DDOCU05,t1.EDOCU05 EDOCU05,t1.SITU05 SITU05, t1.USUB05 USUB05 ");
		// FROM
		query.append("FROM AA21B05S01 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa21b05s01, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Aa21b05s01.class, filterParamList,
				"CDOCU05");

		Aa21b05s01DaoImpl.logger.info("reorderSelection");
		Aa21b05s01DaoImpl.logger.info("SQL = "
				+ sbReorderSelectionSQL.toString());
		Aa21b05s01DaoImpl.logger.info("PARAMs=" + filterParamList);

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa21b05s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Aa21b05s01
	 * @param searchParams
	 *            Aa21b05s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa21b05s01>>
	 */
	@Override
	public List<TableRowDto<Aa21b05s01>> search(Aa21b05s01 filterParams,
			Aa21b05s01 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {

		Aa21b05s01DaoImpl.logger.info("M�todo search");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CDOCU05 CDOCU05,t1.DDOCU05 DDOCU05,t1.EDOCU05 EDOCU05,t1.SITU05 SITU05,t1.USUB05 USUB05 ");
		// FROM
		query.append("FROM AA21B05S01 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Aa21b05s01.class, filterParamList,
				searchSQL, searchParamList, from_alias, "CDOCU05");

		Aa21b05s01DaoImpl.logger.info("search");
		Aa21b05s01DaoImpl.logger.info("SQL = "
				+ sbReorderSelectionSQL.toString());
		Aa21b05s01DaoImpl.logger.info("PARAMs=" + filterParamList);

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa21b05s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filteraa21b05s01
	 *            Aa21b05s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Aa21b05s01 filteraa21b05s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {

		Aa21b05s01DaoImpl.logger.info("M�todo removeMultiple");
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.CDOCU05 CDOCU05,t1.DDOCU05 DDOCU05,t1.EDOCU05 EDOCU05,t1.SITU05 SITU05, t1.USUB05 USUB05 ");
		// FROM
		query.append("FROM AA21B05S01 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa21b05s01,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Aa21b05s01.class,
						query, params, "CDOCU05");

		Aa21b05s01DaoImpl.logger.info("removeMultiple");
		Aa21b05s01DaoImpl.logger
				.info("SQL = " + sbRemoveMultipleSQL.toString());
		Aa21b05s01DaoImpl.logger.info("PARAMs=" + params);
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa21b05s01 table.
	 * 
	 * @param filterAa21b05s01
	 *            Aa21b05s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa21b05s01>>
	 */
	@Override
	public List<JerarquiaDto<Aa21b05s01>> findAllLikeJerarquia(
			Aa21b05s01 filterAa21b05s01, JQGridRequestDto jqGridRequestDto) {

		Aa21b05s01DaoImpl.logger.info("M�todo findAllLikeJerarquia");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CDOCU05 CDOCU05,t1.DDOCU05 DDOCU05,t1.EDOCU05 EDOCU05,t1.SITU05 SITU05, t1.USUB05 USUB05 ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA21B05S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA21B05S01");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa21b05s01, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "CDOCU05", "ID_PADRE", "NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa21b05s01DaoImpl.logger.info("findAllLikeJerarquia");
		Aa21b05s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b05s01DaoImpl.logger.info("PARAMs=" + params);
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa21b05s01
	 *            Aa21b05s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Aa21b05s01 filterAa21b05s01,
			JQGridRequestDto jqGridRequestDto) {
		Aa21b05s01DaoImpl.logger.info("M�todo findAllLikeCountJerarquia");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA21B05S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA21B05S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa21b05s01, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "CDOCU05", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa21b05s01DaoImpl.logger.info("findAllLikeCountJerarquia");
		Aa21b05s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b05s01DaoImpl.logger.info("PARAMs=" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa21b05s01
	 *            Aa21b05s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa21b05s01>>
	 */
	@Override
	public List<TableRowDto<Aa21b05s01>> findAllChild(
			Aa21b05s01 filterAa21b05s01, JQGridRequestDto jqGridRequestDto) {

		Aa21b05s01DaoImpl.logger.info("M�todo findAllChild");

		// FROM
		// StringBuilder from = new StringBuilder("FROM AA21B05S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA21B05S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this
				.getWhereLikeMap(filterAa21b05s01, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "CDOCU05", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa21b05s01DaoImpl.logger.info("findAllChild");
		Aa21b05s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b05s01DaoImpl.logger.info("PARAMs=" + params);
		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<Aa21b05s01>(this.rwMapPK,
						"CDOCU05"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa21b05s01 entity
	 * 
	 * @param aa21b05s01
	 *            Aa21b05s01 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa21b05s01 aa21b05s01) {

		StringBuilder where = new StringBuilder(
				Aa21b05s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa21b05s01 != null && aa21b05s01.getCdocu05() != null) {
			where.append(" AND t1.CDOCU05 = ?");
			params.add(aa21b05s01.getCdocu05());
		}
		if (aa21b05s01 != null && aa21b05s01.getDdocu05() != null) {
			where.append(" AND t1.DDOCU05 = ?");
			params.add(aa21b05s01.getDdocu05());
		}
		if (aa21b05s01 != null && aa21b05s01.getEdocu05() != null) {
			where.append(" AND t1.EDOCU05 = ?");
			params.add(aa21b05s01.getEdocu05());
		}
		if (aa21b05s01 != null && aa21b05s01.getSitu05() != null) {
			where.append(" AND t1.SITU05 = ?");
			params.add(aa21b05s01.getSitu05());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa21b05s01 entity
	 * 
	 * @param aa21b05s01
	 *            Aa21b05s01 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Aa21b05s01 aa21b05s01,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Aa21b05s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa21b05s01 != null && aa21b05s01.getCdocu05() != null) {
			where.append(" AND t1.CDOCU05 = ?");
			params.add(aa21b05s01.getCdocu05());
		}
		if (aa21b05s01 != null && aa21b05s01.getDdocu05() != null) {
			where.append(" AND UPPER(t1.DDOCU05) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa21b05s01.getDdocu05().toUpperCase() + "%");
			} else {
				params.add("%" + aa21b05s01.getDdocu05().toUpperCase() + "%");
			}
			where.append(" AND t1.DDOCU05 IS NOT NULL");
		}
		if (aa21b05s01 != null && aa21b05s01.getEdocu05() != null) {
			where.append(" AND UPPER(t1.EDOCU05) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa21b05s01.getEdocu05().toUpperCase() + "%");
			} else {
				params.add("%" + aa21b05s01.getEdocu05().toUpperCase() + "%");
			}
			where.append(" AND t1.EDOCU05 IS NOT NULL");
		}
		if (aa21b05s01 != null && aa21b05s01.getSitu05() != null) {
			where.append(" AND UPPER(t1.SITU05) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa21b05s01.getSitu05().toUpperCase() + "%");
			} else {
				params.add("%" + aa21b05s01.getSitu05().toUpperCase() + "%");
			}
			where.append(" AND t1.SITU05 IS NOT NULL");
		}

		if (aa21b05s01 != null && aa21b05s01.getBloq05() != null) {
			where.append(" AND t1.BLOQ05 = ?");
			params.add(aa21b05s01.getBloq05());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	@Override
	public List<Aa21b05s01> findTipoDocumento(Aa21b05s01 tipoDocumento,
			Boolean startsWith) {

		Aa21b05s01DaoImpl.logger.info("M�todo findAllChild");
		List<Object> params = new ArrayList<Object>();

		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		StringBuilder order = new StringBuilder("");
		StringBuilder query = new StringBuilder(
				"SELECT DISTINCT t1.DDOCU05 DDOCU05, t1.EDOCU05 EDOCU05 ");
		query.append("FROM AA21B05S01 t1 ");
		if (tipoDocumento != null && tipoDocumento.getDdocu05() != null) {
			where.append(" AND UPPER(t1.DDOCU05) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add("%" + tipoDocumento.getDdocu05().toUpperCase() + "%");
			} else {
				params.add("%" + tipoDocumento.getDdocu05().toUpperCase() + "%");
			}

			order = new StringBuilder(" ORDER BY DDOCU05 asc ");
		}
		if (tipoDocumento != null && tipoDocumento.getEdocu05() != null) {
			where.append(" AND UPPER(t1.EDOCU05) like ? ESCAPE '\\'");
			if (startsWith) {
				params.add("%" + tipoDocumento.getEdocu05().toUpperCase() + "%");
			} else {
				params.add("%" + tipoDocumento.getEdocu05().toUpperCase() + "%");
			}

			order = new StringBuilder(" ORDER BY EDOCU05 asc ");

		}
		query.append(where);
		query.append(order);

		Aa21b05s01DaoImpl.logger.info("findTipoDocumento");
		Aa21b05s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b05s01DaoImpl.logger.info("PARAMs=" + params);
		return (List<Aa21b05s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMapDdocu, params.toArray());
	}

	/**
	 * @param cdocu05
	 *            Long
	 * @return boolean
	 * 
	 */
	public boolean existeTipoDocExp(Integer cdocu05) {
		Aa21b05s01DaoImpl.logger.info("M�todo existeDepartamento");
		String query = "SELECT COUNT(1) FROM AA21B25S01 WHERE CDOCU25 = ?";
		Aa21b05s01DaoImpl.logger.info("SQL " + query);
		Aa21b05s01DaoImpl.logger.info("PARAM1 " + cdocu05);
		return this.jdbcTemplate.queryForInt(query, cdocu05.toString()) > 0;
	}

}
