package com.ejie.aa21b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa21b.model.Aa21b02s01;
import com.ejie.aa21b.model.Aa21b13s01;
import com.ejie.aa21b.seguridad.Aa21bSeguridad;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa21b02s01DaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class Aa21b02s01DaoImpl implements Aa21b02s01Dao {
	private JdbcTemplate jdbcTemplate;
	private static final Logger logger = LoggerFactory
			.getLogger(Aa21b02s01DaoImpl.class);

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa21b02s01> rwMap = new RowMapper<Aa21b02s01>() {
		public Aa21b02s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa21b02s01(resultSet.getString("CSERV02"),
					resultSet.getString("CTIPOE02"),
					resultSet.getString("CTRAMI02"),
					resultSet.getString("DTIPOE02"),
					resultSet.getString("ETIPOE02"),
					resultSet.getString("SITU02"),
					resultSet.getString("USUB02"));
		}
	};

	private RowMapper<Aa21b02s01> rwMapGrupos = new RowMapper<Aa21b02s01>() {
		public Aa21b02s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Aa21b02s01 tipoExpAgrup = new Aa21b02s01();
			tipoExpAgrup.setCserv02(resultSet.getString("CSERV02"));
			tipoExpAgrup.setCtipoe02(resultSet.getString("CTIPOE02"));
			tipoExpAgrup.setCtrami02(resultSet.getString("CTRAMI02"));
			tipoExpAgrup.setDtipoe02(resultSet.getString("DTIPOE02"));
			tipoExpAgrup.setEtipoe02(resultSet.getString("ETIPOE02"));
			tipoExpAgrup.setSitu02(resultSet.getString("SITU02"));
			tipoExpAgrup.setUsub02(resultSet.getString("USUB02"));
			tipoExpAgrup.setCodGrupo30(resultSet.getInt("CODGRUPO"));
			tipoExpAgrup.setDesGrupo30(resultSet.getString("DESGRUPO"));

			return tipoExpAgrup;

		}
	};

	private RowMapper<Aa21b02s01> rwMapPK = new RowMapper<Aa21b02s01>() {
		public Aa21b02s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa21b02s01(resultSet.getString("CSERV02"),
					resultSet.getString("CTIPOE02"));
		}
	};

	private RowMapper<Aa21b02s01> rwMapDtipoExp = new RowMapper<Aa21b02s01>() {
		public Aa21b02s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Aa21b02s01 tipoExp = new Aa21b02s01();
			tipoExp.setCtipoe02(resultSet.getString("CTIPOE02"));
			tipoExp.setDtipoe02(resultSet.getString("DTIPOE02"));
			tipoExp.setEtipoe02(resultSet.getString("ETIPOE02"));
			return tipoExp;
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Aa21b02s01>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa21b02s01>>() {
		public JerarquiaDto<Aa21b02s01> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Aa21b02s01 aa21b02s01 = new Aa21b02s01(
					resultSet.getString("CSERV02"),
					resultSet.getString("CTIPOE02"),
					resultSet.getString("CTRAMI02"),
					resultSet.getString("DTIPOE02"),
					resultSet.getString("ETIPOE02"),
					resultSet.getString("SITU02"),
					resultSet.getString("USUB02"));

			JerarquiaDto<Aa21b02s01> jerarquia = new JerarquiaDto<Aa21b02s01>();
			jerarquia.setModel(aa21b02s01);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Aa21b02s01 table.
	 * 
	 * @param aa21b02s01
	 *            Aa21b02s01aa
	 * @return Aa21b02s01
	 */
	public Aa21b02s01 add(Aa21b02s01 aa21b02s01) {
		Aa21b02s01DaoImpl.logger.info("Método add");
		String query = "INSERT INTO AA21B02S01 (CSERV02, CTIPOE02, CTRAMI02, DTIPOE02, ETIPOE02, SITU02, BLOQ02, USUB02) VALUES (?,?,?,?,?,?,?,?)";

		Aa21b02s01DaoImpl.logger.info("SQL = " + query);
		Aa21b02s01DaoImpl.logger.info("PARAM1=" + aa21b02s01.getCserv02());
		Aa21b02s01DaoImpl.logger.info("PARAM2=" + aa21b02s01.getCtipoe02());
		Aa21b02s01DaoImpl.logger.info("PARAM3=" + aa21b02s01.getCtrami02());
		Aa21b02s01DaoImpl.logger.info("PARAM4=" + aa21b02s01.getDtipoe02());
		Aa21b02s01DaoImpl.logger.info("PARAM5=" + aa21b02s01.getEtipoe02());
		Aa21b02s01DaoImpl.logger.info("PARAM6=" + aa21b02s01.getSitu02());
		Aa21b02s01DaoImpl.logger.info("PARAM7=" + 0);
		Aa21b02s01DaoImpl.logger.info("PARAM8=null");

		this.jdbcTemplate.update(query, aa21b02s01.getCserv02(),
				aa21b02s01.getCtipoe02(), aa21b02s01.getCtrami02(),
				aa21b02s01.getDtipoe02(), aa21b02s01.getEtipoe02(),
				aa21b02s01.getSitu02(), 0, null);
		return aa21b02s01;
	}

	/**
	 * Finds rows in the Tipos expedientes table using like.
	 * 
	 * @param aa21b02s01
	 *            Aa21b02s01
	 * @return Integer
	 */
	@Transactional(readOnly = true)
	public Integer obtenerCorrelativoTipoExpediente(Aa21b02s01 aa21b02s01) {
		Aa21b02s01DaoImpl.logger
				.info("Método obtenerCorrelativoTipoExpediente");
		StringBuffer query = new StringBuffer(
				"SELECT MAX(CTIPOE02) FROM Aa21b02s01 where CSERV02 = ? ");
		List<Object> params = new ArrayList<Object>();
		if (aa21b02s01 != null && aa21b02s01.getCserv02() != null) {
			params.add(aa21b02s01.getCserv02());
		}
		Aa21b02s01DaoImpl.logger.info("obtenerCorrelativoTipoExpediente");
		Aa21b02s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b02s01DaoImpl.logger.info("PARAMs=" + params);
		return Integer.valueOf(this.jdbcTemplate.queryForInt(query.toString(),
				params.toArray())) + 1;
	}

	/**
	 * Updates a single row in the Aa21b02s01 table.
	 * 
	 * @param aa21b02s01
	 *            Aa21b02s01
	 * @return Aa21b02s01
	 */
	public Aa21b02s01 update(Aa21b02s01 aa21b02s01) {
		Aa21b02s01DaoImpl.logger.info("Método update");
		String query = "UPDATE AA21B02S01 SET CTRAMI02=?, DTIPOE02=?, ETIPOE02=?, SITU02=? WHERE CSERV02=? AND CTIPOE02=?";

		Aa21b02s01DaoImpl.logger.info("SQL = " + query);
		Aa21b02s01DaoImpl.logger.info("PARAM1=" + aa21b02s01.getCtrami02());
		Aa21b02s01DaoImpl.logger.info("PARAM2=" + aa21b02s01.getDtipoe02());
		Aa21b02s01DaoImpl.logger.info("PARAM3=" + aa21b02s01.getEtipoe02());
		Aa21b02s01DaoImpl.logger.info("PARAM4=" + aa21b02s01.getSitu02());
		Aa21b02s01DaoImpl.logger.info("PARAM5=" + aa21b02s01.getEtipoe02());
		Aa21b02s01DaoImpl.logger.info("PARAM6pk=" + aa21b02s01.getCserv02());
		Aa21b02s01DaoImpl.logger.info("PARAM7pk=" + aa21b02s01.getCtipoe02());

		this.jdbcTemplate.update(query, aa21b02s01.getCtrami02(),
				aa21b02s01.getDtipoe02(), aa21b02s01.getEtipoe02(),
				aa21b02s01.getSitu02(), aa21b02s01.getCserv02(),
				aa21b02s01.getCtipoe02());
		return aa21b02s01;
	}

	/**
	 * Updates bloqueos in the Aa21b05s01 table.
	 * 
	 * @param aa21b02s01
	 *            Aa21b02s01
	 * @return Aa21b02s01
	 */
	public Aa21b02s01 updateBloqueos(Aa21b02s01 aa21b02s01) {
		Aa21b02s01DaoImpl.logger.info("Método updateBloqueos");
		if (aa21b02s01 != null && aa21b02s01.getCtipoe02() != null) {
			String query = "UPDATE AA21B02S01 SET BLOQ02=?, USUB02=? WHERE CSERV02=? AND CTIPOE02=? ";
			Aa21b02s01DaoImpl.logger.info("SQL = " + query);

			Aa21b02s01DaoImpl.logger.info("PARAM1=" + aa21b02s01.getBloq02());
			Aa21b02s01DaoImpl.logger.info("PARAM2=" + aa21b02s01.getUsub02());
			Aa21b02s01DaoImpl.logger
					.info("PARAM3pk=" + aa21b02s01.getCserv02());
			Aa21b02s01DaoImpl.logger.info("PARAM4pk="
					+ aa21b02s01.getCtipoe02());

			this.jdbcTemplate.update(query, aa21b02s01.getBloq02(),
					aa21b02s01.getUsub02(), aa21b02s01.getCserv02(),
					aa21b02s01.getCtipoe02());
		} else if (aa21b02s01 != null && aa21b02s01.getCserv02() != null) {
			String query = "UPDATE AA21B02S01 SET BLOQ02=?, USUB02=? WHERE CSERV02=? ";

			Aa21b02s01DaoImpl.logger.info("SQL = " + query);

			Aa21b02s01DaoImpl.logger.info("PARAM1=" + 0);
			Aa21b02s01DaoImpl.logger.info("PARAM2=null");
			Aa21b02s01DaoImpl.logger.info("PARAM3=" + aa21b02s01.getCserv02());

			this.jdbcTemplate.update(query, 0, null, aa21b02s01.getCserv02());
		} else {
			String query = "UPDATE AA21B02S01 SET BLOQ02=?, USUB02=? ";

			Aa21b02s01DaoImpl.logger.info("SQL = " + query);

			Aa21b02s01DaoImpl.logger.info("PARAM1=" + 0);
			Aa21b02s01DaoImpl.logger.info("PARAM2=null");

			this.jdbcTemplate.update(query, 0, null);
		}
		return aa21b02s01;
	}

	/**
	 * Finds a single row in the Aa21b02s01 table.
	 * 
	 * @param aa21b02s01
	 *            Aa21b02s01
	 * @return Aa21b02s01
	 */
	@Transactional(readOnly = true)
	public Aa21b02s01 find(Aa21b02s01 aa21b02s01) {
		Aa21b02s01DaoImpl.logger.info("Método find");
		String query = "SELECT t1.CSERV02 CSERV02, t1.CTIPOE02 CTIPOE02, t1.CTRAMI02 CTRAMI02, t1.DTIPOE02 DTIPOE02, t1.ETIPOE02 ETIPOE02, t1.SITU02 SITU02, t1.BLOQ02 BLOQ02, t1.USUB02 USUB02 FROM AA21B02S01 t1  WHERE t1.CSERV02 = ?   AND t1.CTIPOE02 = ?  ";

		Aa21b02s01DaoImpl.logger.info("SQL = " + query);

		Aa21b02s01DaoImpl.logger.info("PARAM1k=" + aa21b02s01.getCserv02());
		Aa21b02s01DaoImpl.logger.info("PARAM2k=" + aa21b02s01.getCtipoe02());

		List<Aa21b02s01> aa21b02s01List = this.jdbcTemplate.query(query,
				this.rwMap, aa21b02s01.getCserv02(), aa21b02s01.getCtipoe02());

		return (Aa21b02s01) DataAccessUtils.uniqueResult(aa21b02s01List);
	}

	/**
	 * Removes a single row in the Aa21b02s01 table.
	 * 
	 * @param aa21b02s01
	 *            Aa21b02s01
	 * @return
	 */
	public void remove(Aa21b02s01 aa21b02s01) {
		Aa21b02s01DaoImpl.logger.info("Método remove");
		String query = "DELETE FROM AA21B02S01 WHERE CSERV02=? AND CTIPOE02=?";

		Aa21b02s01DaoImpl.logger.info("SQL = " + query);

		Aa21b02s01DaoImpl.logger.info("PARAM1k=" + aa21b02s01.getCserv02());
		Aa21b02s01DaoImpl.logger.info("PARAM2k=" + aa21b02s01.getCtipoe02());

		this.jdbcTemplate.update(query, aa21b02s01.getCserv02(),
				aa21b02s01.getCtipoe02());
	}

	/**
	 * Finds a list of rows in the Aa21b02s01 table.
	 * 
	 * @param aa21b02s01
	 *            Aa21b02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa21b02s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa21b02s01> findAll(Aa21b02s01 aa21b02s01,
			JQGridRequestDto jqGridRequestDto) {
		Aa21b02s01DaoImpl.logger.info("Tipos de expedientes-->Método findAll ");

		StringBuilder query = new StringBuilder(
				"SELECT  t1.CSERV02 CSERV02,t1.CTIPOE02 CTIPOE02,t1.CTRAMI02 CTRAMI02,t1.DTIPOE02 DTIPOE02,t1.ETIPOE02 ETIPOE02,t1.SITU02 SITU02,t1.BLOQ02 BLOQ02,t1.USUB02 USUB02 ");
		query.append("FROM AA21B02S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa21b02s01);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		Aa21b02s01DaoImpl.logger.info("findAll");
		Aa21b02s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b02s01DaoImpl.logger.info("PARAMS" + params);

		return (List<Aa21b02s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Aa21b02s01 table using like.
	 * 
	 * @param aa21b02s01
	 *            Aa21b02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param listaServicios
	 *            List<Aa21b13s01>
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa21b02s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa21b02s01> findAllLike(Aa21b02s01 aa21b02s01,
			JQGridRequestDto jqGridRequestDto, List<Aa21b13s01> listaServicios,
			Boolean startsWith) {

		Aa21b02s01DaoImpl.logger.info("Método findAllLike");
		StringBuilder query = new StringBuilder(
				"SELECT  t1.CSERV02 CSERV02,t1.CTIPOE02 CTIPOE02,t1.CTRAMI02 CTRAMI02,t1.DTIPOE02 DTIPOE02,t1.ETIPOE02 ETIPOE02,t1.SITU02 SITU02,t1.BLOQ02 BLOQ02,t1.USUB02 USUB02 ");
		query.append("FROM AA21B02S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa21b02s01,
				listaServicios, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}
		Aa21b02s01DaoImpl.logger.info("findAllLike");
		Aa21b02s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b02s01DaoImpl.logger.info("PARAMS" + params);

		return (List<Aa21b02s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Aa21b02s01 table.
	 * 
	 * @param aa21b02s01
	 *            Aa21b02s01
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa21b02s01 aa21b02s01) {

		Aa21b02s01DaoImpl.logger.info("Método findAllCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA21B02S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa21b02s01);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		Aa21b02s01DaoImpl.logger.info("findAllCount");
		Aa21b02s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b02s01DaoImpl.logger.info("PARAMS" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Aa21b02s01 table using like.
	 * 
	 * @param aa21b02s01
	 *            Aa21b02s01
	 * @param listaServicios
	 *            List<Aa21b13s01>
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Aa21b02s01 aa21b02s01,
			List<Aa21b13s01> listaServicios, boolean startsWith) {

		Aa21b02s01DaoImpl.logger.info("Método findAllLikeCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA21B02S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa21b02s01,
				listaServicios, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa21b02s01DaoImpl.logger.info("findAllLikeCount");
		Aa21b02s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b02s01DaoImpl.logger.info("PARAMS" + params);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Aa21b02s01 selected for rup_table
	 * 
	 * @param aa21b02s01
	 *            Aa21b02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa21b02s01>>
	 */
	@Override
	public List<TableRowDto<Aa21b02s01>> reorderSelection(
			Aa21b02s01 aa21b02s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {

		Aa21b02s01DaoImpl.logger.info("Método reorderSelection");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CSERV02 CSERV02,t1.CTIPOE02 CTIPOE02,t1.CTRAMI02 CTRAMI02,t1.DTIPOE02 DTIPOE02,t1.ETIPOE02 ETIPOE02,t1.SITU02 SITU02,t1.BLOQ02 BLOQ02,t1.USUB02 USUB02 ");
		// FROM
		query.append("FROM AA21B02S01 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa21b02s01, null,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Aa21b02s01.class, filterParamList,
				"CSERV02||'-'||CTIPOE02");

		Aa21b02s01DaoImpl.logger.info("reorderSelection");
		Aa21b02s01DaoImpl.logger.info("SQL = "
				+ sbReorderSelectionSQL.toString());
		Aa21b02s01DaoImpl.logger.info("PARAMs=" + filterParamList);

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa21b02s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Aa21b02s01
	 * @param searchParams
	 *            Aa21b02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa21b02s01>>
	 */
	@Override
	public List<TableRowDto<Aa21b02s01>> search(Aa21b02s01 filterParams,
			Aa21b02s01 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {

		Aa21b02s01DaoImpl.logger.info("Método search");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CSERV02 CSERV02,t1.CTIPOE02 CTIPOE02,t1.CTRAMI02 CTRAMI02,t1.DTIPOE02 DTIPOE02,t1.ETIPOE02 ETIPOE02,t1.SITU02 SITU02,t1.BLOQ02 BLOQ02,t1.USUB02 USUB02 ");
		// FROM
		query.append("FROM AA21B02S01 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				null, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, null, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Aa21b02s01.class, filterParamList,
				searchSQL, searchParamList, from_alias,
				"CSERV02||'-'||CTIPOE02");

		Aa21b02s01DaoImpl.logger.info("search");
		Aa21b02s01DaoImpl.logger.info("SQL = "
				+ sbReorderSelectionSQL.toString());
		Aa21b02s01DaoImpl.logger.info("PARAMs=" + filterParamList);

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa21b02s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filteraa21b02s01
	 *            Aa21b02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Aa21b02s01 filteraa21b02s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {

		Aa21b02s01DaoImpl.logger.info("Método removeMultiple");
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.CSERV02 CSERV02,t1.CTIPOE02 CTIPOE02,t1.CTRAMI02 CTRAMI02,t1.DTIPOE02 DTIPOE02,t1.ETIPOE02 ETIPOE02,t1.SITU02 SITU02,t1.BLOQ02 BLOQ02,t1.USUB02 USUB02 ");
		// FROM
		query.append("FROM AA21B02S01 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa21b02s01,
				null, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Aa21b02s01.class,
						query, params, "CSERV02||'-'||CTIPOE02");

		Aa21b02s01DaoImpl.logger.info("removeMultiple");
		Aa21b02s01DaoImpl.logger
				.info("SQL = " + sbRemoveMultipleSQL.toString());
		Aa21b02s01DaoImpl.logger.info("PARAMs=" + params);
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa21b02s01 table.
	 * 
	 * @param filterAa21b02s01
	 *            Aa21b02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa21b02s01>>
	 */
	@Override
	public List<JerarquiaDto<Aa21b02s01>> findAllLikeJerarquia(
			Aa21b02s01 filterAa21b02s01, JQGridRequestDto jqGridRequestDto) {

		Aa21b02s01DaoImpl.logger.info("Método findAllLikeJerarquia");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CSERV02 CSERV02,t1.CTIPOE02 CTIPOE02,t1.CTRAMI02 CTRAMI02,t1.DTIPOE02 DTIPOE02,t1.ETIPOE02 ETIPOE02,t1.SITU02 SITU02,t1.BLOQ02 BLOQ02,t1.USUB02 USUB02 ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA21B02S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA21B02S01");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAa21b02s01, null,
				false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "CSERV02||'-'||CTIPOE02", "ID_PADRE", "NOMBRE",
				from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");

		Aa21b02s01DaoImpl.logger.info("findAllLikeJerarquia");
		Aa21b02s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b02s01DaoImpl.logger.info("PARAMs=" + params);
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa21b02s01
	 *            Aa21b02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Aa21b02s01 filterAa21b02s01,
			JQGridRequestDto jqGridRequestDto) {

		Aa21b02s01DaoImpl.logger.info("Método findAllLikeCountJerarquia");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA21B02S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA21B02S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAa21b02s01, null,
				false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "CSERV02||'-'||CTIPOE02",
				"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		Aa21b02s01DaoImpl.logger.info("findAllLikeCountJerarquia");
		Aa21b02s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b02s01DaoImpl.logger.info("PARAMs=" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa21b02s01
	 *            Aa21b02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa21b02s01>>
	 */
	@Override
	public List<TableRowDto<Aa21b02s01>> findAllChild(
			Aa21b02s01 filterAa21b02s01, JQGridRequestDto jqGridRequestDto) {

		Aa21b02s01DaoImpl.logger.info("Método findAllChild");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA21B02S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA21B02S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAa21b02s01, null,
				false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "CSERV02||'-'||CTIPOE02",
				"ID_PADRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		Aa21b02s01DaoImpl.logger.info("findAllChild");
		Aa21b02s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b02s01DaoImpl.logger.info("PARAMs=" + params);
		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<Aa21b02s01>(this.rwMapPK,
						"CSERV02||'-'||CTIPOE02"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa21b02s01 entity
	 * 
	 * @param aa21b02s01
	 *            Aa21b02s01 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa21b02s01 aa21b02s01) {

		StringBuilder where = new StringBuilder(
				Aa21b02s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa21b02s01 != null && aa21b02s01.getCserv02() != null) {
			where.append(" AND t1.CSERV02 = ?");
			params.add(aa21b02s01.getCserv02());
		}
		if (aa21b02s01 != null && aa21b02s01.getCtipoe02() != null) {
			where.append(" AND t1.CTIPOE02 = ?");
			params.add(aa21b02s01.getCtipoe02());
		}
		if (aa21b02s01 != null && aa21b02s01.getCtrami02() != null) {
			where.append(" AND t1.CTRAMI02 = ?");
			params.add(aa21b02s01.getCtrami02());
		}
		if (aa21b02s01 != null && aa21b02s01.getDtipoe02() != null) {
			where.append(" AND t1.DTIPOE02 = ?");
			params.add(aa21b02s01.getDtipoe02());
		}
		if (aa21b02s01 != null && aa21b02s01.getEtipoe02() != null) {
			where.append(" AND t1.ETIPOE02 = ?");
			params.add(aa21b02s01.getEtipoe02());
		}
		if (aa21b02s01 != null && aa21b02s01.getSitu02() != null
				&& aa21b02s01.getSitu02().length() > 0) {
			where.append(" AND t1.SITU02 = ?");
			params.add(aa21b02s01.getSitu02());
		}
		if (aa21b02s01 != null && aa21b02s01.getBloq02() != null) {
			where.append(" AND t1.BLOQ02 = ?");
			params.add(aa21b02s01.getBloq02());
		}
		if (aa21b02s01 != null && aa21b02s01.getUsub02() != null) {
			where.append(" AND t1.USUB02 = ?");
			params.add(aa21b02s01.getUsub02());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	private Map<String, ?> getWhereMapComboTipoExpServ(
			List<Aa21b02s01> listaServicios) {

		StringBuilder where = new StringBuilder(
				Aa21b02s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();
		where.append(" AND CTRAMI02 = ?");
		params.add("1");
		if (listaServicios != null) {
			if (listaServicios.size() > 0) {
				where.append(" AND ");
				Aa21b02s01 serviciosAux = null;
				for (Iterator<Aa21b02s01> iterator = listaServicios.iterator(); iterator
						.hasNext();) {

					serviciosAux = (Aa21b02s01) iterator.next();
					where.append(" t1.CSERV02 = ? ");
					params.add(serviciosAux.getCserv02());
					if (iterator.hasNext()) {
						where.append(" OR ");
					}
				}
			}
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa21b02s01 entity
	 * 
	 * @param aa21b02s01
	 *            Aa21b02s01 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Aa21b02s01 aa21b02s01,
			List<Aa21b13s01> listaServicios, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Aa21b02s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (listaServicios != null) {
			if (listaServicios.size() > 0) {
				where.append(" AND (");
				Aa21b13s01 serviciosAux = null;
				for (Iterator<Aa21b13s01> iterator = listaServicios.iterator(); iterator
						.hasNext();) {

					serviciosAux = (Aa21b13s01) iterator.next();
					where.append(" t1.CSERV02 = ? ");
					params.add(serviciosAux.getCServ13());
					if (iterator.hasNext()) {
						where.append(" OR ");
					}
				}
				where.append(" )");
			}
		}

		if (aa21b02s01 != null && aa21b02s01.getCtipoe02() != null) {
			where.append(" AND UPPER(t1.CTIPOE02) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa21b02s01.getCtipoe02().toUpperCase() + "%");
			} else {
				params.add("%" + aa21b02s01.getCtipoe02().toUpperCase() + "%");
			}
			where.append(" AND t1.CTIPOE02 IS NOT NULL");
		}
		if (aa21b02s01 != null && aa21b02s01.getCtrami02() != null) {
			where.append(" AND UPPER(t1.CTRAMI02) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa21b02s01.getCtrami02().toUpperCase() + "%");
			} else {
				params.add("%" + aa21b02s01.getCtrami02().toUpperCase() + "%");
			}
			where.append(" AND t1.CTRAMI02 IS NOT NULL");
		}
		if (aa21b02s01 != null && aa21b02s01.getDtipoe02() != null) {
			where.append(" AND UPPER(t1.DTIPOE02) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa21b02s01.getDtipoe02().toUpperCase() + "%");
			} else {
				params.add("%" + aa21b02s01.getDtipoe02().toUpperCase() + "%");
			}
			where.append(" AND t1.DTIPOE02 IS NOT NULL");
		}
		if (aa21b02s01 != null && aa21b02s01.getEtipoe02() != null) {
			where.append(" AND UPPER(t1.ETIPOE02) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa21b02s01.getEtipoe02().toUpperCase() + "%");
			} else {
				params.add("%" + aa21b02s01.getEtipoe02().toUpperCase() + "%");
			}
			where.append(" AND t1.ETIPOE02 IS NOT NULL");
		}
		if (aa21b02s01 != null && aa21b02s01.getSitu02() != null) {
			where.append(" AND UPPER(t1.SITU02) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa21b02s01.getSitu02().toUpperCase() + "%");
			} else {
				params.add("%" + aa21b02s01.getSitu02().toUpperCase() + "%");
			}
			where.append(" AND t1.SITU02 IS NOT NULL");
		}
		if (aa21b02s01 != null && aa21b02s01.getBloq02() != null) {
			where.append(" AND t1.BLOQ02 = ?");
			params.add(aa21b02s01.getBloq02());
		}
		if (aa21b02s01 != null && aa21b02s01.getUsub02() != null) {
			where.append(" AND UPPER(t1.USUB02) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa21b02s01.getUsub02().toUpperCase() + "%");
			} else {
				params.add("%" + aa21b02s01.getUsub02().toUpperCase() + "%");
			}
			where.append(" AND t1.USUB02 IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	/**
	 * Finds a list of rows in the Aa21b02s01 table.
	 * 
	 * @param listaServicios
	 *            List<Aa21b02s01>
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa21b02s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa21b02s01> findAllComboTiposExpServicio(
			List<Aa21b02s01> listaServicios, JQGridRequestDto jqGridRequestDto) {

		Aa21b02s01DaoImpl.logger.info("Método findAllComboTiposExpServicio");

		StringBuilder query = new StringBuilder(
				"SELECT  t1.CSERV02 CSERV02,t1.CTIPOE02 CTIPOE02,t1.CTRAMI02 CTRAMI02,t1.DTIPOE02 DTIPOE02,t1.ETIPOE02 ETIPOE02,t1.SITU02 SITU02,t1.BLOQ02 BLOQ02,t1.USUB02 USUB02 ");
		query.append("FROM AA21B02S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this
				.getWhereMapComboTipoExpServ(listaServicios);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		Aa21b02s01DaoImpl.logger.info("findAllComboTiposExpServicio");
		Aa21b02s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b02s01DaoImpl.logger.info("PARAMs=" + params);

		return (List<Aa21b02s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	@Transactional(readOnly = true)
	public List<Aa21b02s01> findAllComboTiposExpServicioConsulta(
			List<Aa21b02s01> listaServicios, JQGridRequestDto jqGridRequestDto) {

		Aa21b02s01DaoImpl.logger
				.info("Método findAllComboTiposExpServicioConsulta");

		StringBuilder query = new StringBuilder(
				"SELECT  t1.CSERV02 CSERV02,t1.CTIPOE02 CTIPOE02,t1.CTRAMI02 CTRAMI02,t1.DTIPOE02 DTIPOE02,t1.ETIPOE02 ETIPOE02,t1.SITU02 SITU02,t1.BLOQ02 BLOQ02,t1.USUB02 USUB02 ");
		query.append("FROM AA21B02S01 t1 WHERE 1=1 ");

		ArrayList<String> params = new ArrayList<String>();

		String strServicios = "";
		if (listaServicios != null) {
			if (listaServicios.size() > 0) {
				Aa21b02s01 serviciosAux = null;
				for (Iterator<Aa21b02s01> iterator = listaServicios.iterator(); iterator
						.hasNext();) {
					serviciosAux = (Aa21b02s01) iterator.next();
					strServicios = strServicios.concat(",").concat(
							serviciosAux.getCserv02());
				}
			}
		}
		if (strServicios.length() > 0) {
			strServicios = strServicios.replaceFirst(",", "");
			query.append("AND t1.CSERV02 IN (?)");
			params.add(strServicios);
		}

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		Aa21b02s01DaoImpl.logger.info("findAllComboTiposExpServicio");
		Aa21b02s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b02s01DaoImpl.logger.info("PARAMs=" + params);

		return (List<Aa21b02s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	@Override
	public List<Aa21b02s01> findTipoExpediente(Aa21b02s01 tipoExpediente,
			Boolean startsWith) {

		Aa21b02s01DaoImpl.logger.info("Método findTipoExpediente");
		// TODO Auto-generated method stub
		List<Object> params = new ArrayList<Object>();
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		StringBuilder order = new StringBuilder("");
		StringBuilder query = new StringBuilder(
				"SELECT DISTINCT t1.CTIPOE02 CTIPOE02,t1.DTIPOE02 DTIPOE02, t1.ETIPOE02 ETIPOE02 ");
		query.append("FROM AA21B02S01 t1 ");
		if (tipoExpediente != null && tipoExpediente.getCserv02() != null) {
			where.append(" AND t1.CSERV02 = ? ");
			params.add(tipoExpediente.getCserv02());
		}
		if (tipoExpediente != null && tipoExpediente.getDtipoe02() != null) {
			where.append(" AND UPPER(t1.DTIPOE02) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add("%" + tipoExpediente.getDtipoe02().toUpperCase()
						+ "%");
			} else {
				params.add("%" + tipoExpediente.getDtipoe02().toUpperCase()
						+ "%");
			}

			order = new StringBuilder(" ORDER BY DTIPOE02 asc ");
		}
		if (tipoExpediente != null && tipoExpediente.getEtipoe02() != null) {
			where.append(" AND UPPER(t1.ETIPOE02) like ? ESCAPE '\\'");
			if (startsWith) {
				params.add("%" + tipoExpediente.getEtipoe02().toUpperCase()
						+ "%");
			} else {
				params.add("%" + tipoExpediente.getEtipoe02().toUpperCase()
						+ "%");
			}

			order = new StringBuilder(" ORDER BY ETIPOE02 asc ");

		}
		query.append(where);
		query.append(order);

		Aa21b02s01DaoImpl.logger.info("findTipoExpediente");
		Aa21b02s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b02s01DaoImpl.logger.info("PARAMs=" + params);

		return (List<Aa21b02s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMapDtipoExp, params.toArray());
	}

	/**
	 * @param ctipoe02
	 *            String
	 * @return boolean
	 * 
	 */
	public boolean existeTipoExpExp(String ctipoe02, int nserv02) {
		Aa21b02s01DaoImpl.logger.info("Método existeTipoExpExp");
		String query = "SELECT COUNT(1) FROM AA21B20S01 WHERE CEXPE20 = ? and CSERV20= ?";
		Aa21b02s01DaoImpl.logger.info("SQL " + query);
		Aa21b02s01DaoImpl.logger.info("PARAM1 " + ctipoe02);
		Aa21b02s01DaoImpl.logger.info("PARAM2 " + nserv02);
		return this.jdbcTemplate.queryForInt(query, ctipoe02, nserv02) > 0;
	}

	@Override
	public boolean compruebaBloqueosServicio(Aa21b02s01 aa21b02s01Aux) {
		// TODO Auto-generated method stub
		String usuario = new Aa21bSeguridad().getUsuario().getPersonaXLNET()
				.getCodigo();
		Aa21b02s01DaoImpl.logger.info("Método compruebaBloqueosServicio");
		String query = "SELECT COUNT(1) FROM AA21B02S01 WHERE BLOQ02 = ? AND USUB02 = ? AND CSERV02 = ?";
		Aa21b02s01DaoImpl.logger.info("SQL " + query);
		Aa21b02s01DaoImpl.logger.info("PARAM1 " + aa21b02s01Aux.getBloq02());
		Aa21b02s01DaoImpl.logger.info("PARAM2 " + usuario);
		return this.jdbcTemplate.queryForInt(query, 1, usuario,
				aa21b02s01Aux.getCserv02()) > 0;
	}

	@Override
	public void updateEstadosServicio(Aa21b02s01 aa21b02s01Aux) {
		Aa21b02s01DaoImpl.logger.info("Método updateEstadosServicio");
		String query = "UPDATE AA21B02S01 SET SITU02=? WHERE CSERV02=? ";

		Aa21b02s01DaoImpl.logger.info("SQL = " + query);
		Aa21b02s01DaoImpl.logger.info("PARAM1=" + aa21b02s01Aux.getSitu02());
		Aa21b02s01DaoImpl.logger.info("PARAM2=" + aa21b02s01Aux.getCserv02());

		this.jdbcTemplate.update(query, aa21b02s01Aux.getSitu02(),
				aa21b02s01Aux.getCserv02());

	}

	@Override
	public void removeTiposServicio(Aa21b02s01 aa21b02s01) {
		// TODO Auto-generated method stub
		Aa21b02s01DaoImpl.logger.info("Método remove");
		String query = "DELETE FROM AA21B02S01 WHERE CSERV02=? ";

		Aa21b02s01DaoImpl.logger.info("SQL = " + query);

		Aa21b02s01DaoImpl.logger.info("PARAM1k=" + aa21b02s01.getCserv02());

		this.jdbcTemplate.update(query, aa21b02s01.getCserv02());
	}

	private Map<String, Object> getWhereLikeMapJerarTipoExp(
			Aa21b02s01 aa21b02s01, List<Aa21b13s01> listaServicios,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Aa21b02s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa21b02s01 != null) {
			if (aa21b02s01.getCserv02() != null) {
				where.append(" AND (");
				where.append(" t1.CSERV02 = ? ");
				where.append(" )");
				params.add(aa21b02s01.getCserv02());
			}
			if (aa21b02s01.getCtipoe02() != null) {
				where.append(" AND (");
				where.append(" t1.CTIPOE02 = ? ");
				where.append(" )");
				params.add(aa21b02s01.getCtipoe02());
			}
			if (aa21b02s01.getDtipoe02() != null) {
				where.append(" AND UPPER(t1.DTIPOE02) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add("%" + aa21b02s01.getDtipoe02().toUpperCase()
							+ "%");
				} else {
					params.add("%" + aa21b02s01.getDtipoe02().toUpperCase()
							+ "%");
				}
			}
			if (aa21b02s01.getEtipoe02() != null) {
				where.append(" AND UPPER(t1.ETIPOE02) like ? ESCAPE  '\\'");
				if (startsWith) {
					params.add("%" + aa21b02s01.getEtipoe02().toUpperCase()
							+ "%");
				} else {
					params.add("%" + aa21b02s01.getEtipoe02().toUpperCase()
							+ "%");
				}
			}

		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	@Override
	public List<Aa21b02s01> findAllLikeJerarTipoExp(
			Aa21b02s01 filterAa21b02s01, JQGridRequestDto jqGridRequestDto,
			boolean startsWith) {
		// TODO Auto-generated method stub
		Aa21b02s01DaoImpl.logger.info("Metodo findAllLikeRespServicio");
		StringBuilder query = new StringBuilder(
				"SELECT NVL(t2.CODGRUPO30,0) as CODGRUPO, NVL(t2.DESGRUPO30,'---') AS DESGRUPO, t1.CSERV02 CSERV02,t1.CTIPOE02 CTIPOE02,t1.CTRAMI02 CTRAMI02,t1.DTIPOE02 DTIPOE02,t1.ETIPOE02 ETIPOE02,t1.SITU02 SITU02,t1.BLOQ02 BLOQ02,t1.USUB02 USUB02 ");
		query.append("FROM AA21B02S01 t1, AA21B30S01 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapJerarTipoExp(
				filterAa21b02s01, null, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE t1.CTIPOE02=t2.CTIPOE30 (+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		query.append(" order by CODGRUPO30, ctipoe02");
		List<?> params = (List<?>) mapaWhere.get("params");

		// if (jqGridRequestDto != null) {
		// query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		// }
		Aa21b02s01DaoImpl.logger.info("findAllLikeRespServicio");
		Aa21b02s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b02s01DaoImpl.logger.info("PARAMS" + params);
		return (List<Aa21b02s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMapGrupos, params.toArray());
	}

	/**
	 * Counts rows in the Aa21b02s01 table using like.
	 * 
	 * @param filterAa21b02s01
	 *            Aa21b02s01
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCountJerarTipoExp(Aa21b02s01 filterAa21b02s01,
			boolean startsWith) {

		Aa21b02s01DaoImpl.logger.info("Método findAllLikeCountJerarTipoExp");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA21B02S01 t1, AA21B30S01 t2");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMapJerarTipoExp(
				filterAa21b02s01, null, startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE t1.CTIPOE02=t2.CTIPOE30 (+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa21b02s01DaoImpl.logger.info("findAllLikeCountJerarTipoExp");
		Aa21b02s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b02s01DaoImpl.logger.info("PARAMS" + params);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

}
