package com.ejie.aa21b.dao;

import java.util.List;

import com.ejie.aa21b.model.Aa21b02s01;
import com.ejie.aa21b.model.Aa21b13s01;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa21b02s01Dao  
 * 
 *  
 */

public interface Aa21b02s01Dao {

	/**
	 * Inserts a single row in the Aa21b02s01 table.
	 * 
	 * @param aa21b02s01
	 *            Aa21b02s01
	 * @return Aa21b02s01
	 */
	Aa21b02s01 add(Aa21b02s01 aa21b02s01);

	/**
	 * Updates a single row in the Aa21b02s01 table.
	 * 
	 * @param aa21b02s01
	 *            Aa21b02s01
	 * @return Aa21b02s01
	 */
	Aa21b02s01 update(Aa21b02s01 aa21b02s01);

	/**
	 * Finds a single row in the Aa21b02s01 table.
	 * 
	 * @param aa21b02s01
	 *            Aa21b02s01
	 * @return Aa21b02s01
	 */
	Aa21b02s01 find(Aa21b02s01 aa21b02s01);

	/**
	 * Removes a single row in the Aa21b02s01 table.
	 * 
	 * @param aa21b02s01
	 *            Aa21b02s01
	 */
	void remove(Aa21b02s01 aa21b02s01);

	/**
	 * Finds a List of rows in the Aa21b02s01 table.
	 * 
	 * @param aa21b02s01
	 *            Aa21b02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List
	 */
	List<Aa21b02s01> findAll(Aa21b02s01 aa21b02s01,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds rows in the Aa21b02s01 table using like.
	 * 
	 * @param aa21b02s01
	 *            Aa21b02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param listaServicios
	 *            List<Aa21b13s01>
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Aa21b02s01> findAllLike(Aa21b02s01 aa21b02s01,
			JQGridRequestDto jqGridRequestDto, List<Aa21b13s01> listaServicios,
			Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter in the Aa21b02s01 table.
	 * 
	 * @param filterAa21b02s01
	 *            Aa21b02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(Aa21b02s01 filterAa21b02s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Counts rows in the Aa21b02s01 table using like.
	 * 
	 * @param aa21b02s01
	 *            Aa21b02s01
	 * @param listaServicios
	 *            Boolean
	 * @param b
	 * @return Long
	 */
	Long findAllLikeCount(Aa21b02s01 aa21b02s01,
			List<Aa21b13s01> listaServicios, boolean b);

	/**
	 * Counts rows in the Aa21b02s01 table.
	 * 
	 * @param aa21b02s01
	 *            Aa21b02s01
	 * @return Long
	 */
	Long findAllCount(Aa21b02s01 aa21b02s01);

	/**
	 * Reorder selection.
	 * 
	 * @param filterAa21b02s01
	 *            Aa21b02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa21b02s01>>
	 */
	List<TableRowDto<Aa21b02s01>> reorderSelection(Aa21b02s01 filterAa21b02s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Searches in the Usuario table.
	 * 
	 * @param filterAa21b02s01
	 *            Aa21b02s01
	 * @param searchAa21b02s01
	 *            Aa21b02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa21b02s01>>
	 */
	List<TableRowDto<Aa21b02s01>> search(Aa21b02s01 filterAa21b02s01,
			Aa21b02s01 searchAa21b02s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Filter in the hierarchical Aa21b02s01 table.
	 * 
	 * @param filterAa21b02s01
	 *            Aa21b02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa21b02s01>>
	 */
	List<JerarquiaDto<Aa21b02s01>> findAllLikeJerarquia(
			Aa21b02s01 filterAa21b02s01, JQGridRequestDto jqGridRequestDto);

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa21b02s01
	 *            Aa21b02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	Long findAllLikeCountJerarquia(Aa21b02s01 filterAa21b02s01,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa21b02s01
	 *            Aa21b02s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa21b02s01>>
	 */
	List<TableRowDto<Aa21b02s01>> findAllChild(Aa21b02s01 filterAa21b02s01,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * 
	 * @param tipoExpediente
	 *            Aa21b02s01
	 * @param c
	 *            Boolean
	 * @return List<Aa21b02s01>
	 */
	List<Aa21b02s01> findTipoExpediente(Aa21b02s01 tipoExpediente, Boolean c);

	/**
	 * 
	 * @param aa21b02s01
	 *            Aa21b02s01
	 * @return Aa21b02s01
	 */
	Aa21b02s01 updateBloqueos(Aa21b02s01 aa21b02s01);

	/**
	 * 
	 * @param listaServicios
	 *            List<Aa21b02s01>
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa21b02s01>
	 */
	List<Aa21b02s01> findAllComboTiposExpServicio(
			List<Aa21b02s01> listaServicios, JQGridRequestDto jqGridRequestDto);

	List<Aa21b02s01> findAllComboTiposExpServicioConsulta(
			List<Aa21b02s01> listaServicios, JQGridRequestDto jqGridRequestDto);

	/**
	 * 
	 * @param ctipoe02
	 *            String
	 * @return boolean
	 */
	boolean existeTipoExpExp(String ctipoe02, int nserv02);

	/**
	 * 
	 * @param aa21b02s01Aux
	 *            Aa21b02s01
	 * @return boolean
	 */
	boolean compruebaBloqueosServicio(Aa21b02s01 aa21b02s01Aux);

	/**
	 * 
	 * @param aa21b02s01Aux
	 *            Aa21b02s01
	 */
	void updateEstadosServicio(Aa21b02s01 aa21b02s01Aux);

	/**
	 * 
	 * @param aa21b02s01
	 *            Aa21b02s01
	 */
	void removeTiposServicio(Aa21b02s01 aa21b02s01);

	List<Aa21b02s01> findAllLikeJerarTipoExp(Aa21b02s01 filterAa21b02s01,
			JQGridRequestDto jqGridRequestDto, boolean b);

	Long findAllLikeCountJerarTipoExp(Aa21b02s01 filterAa21b02s01, boolean b);

}
