package com.ejie.aa21b.dao;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.aa21b.model.Aa21b01s01;
import com.ejie.aa21b.model.Aa21b02s01;
import com.ejie.aa21b.model.Aa21b13s01;
import com.ejie.aa21b.seguridad.Aa21bSeguridad;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa21b01s01DaoImpl  
 * 
 *  
 */

@Repository
@Transactional
public class Aa21b01s01DaoImpl implements Aa21b01s01Dao {
	private JdbcTemplate jdbcTemplate;
	// private DefaultLobHandler defaultLobHandler;
	private static final Logger logger = LoggerFactory
			.getLogger(Aa21b01s01DaoImpl.class);

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Aa21b01s01> rwMap = new RowMapper<Aa21b01s01>() {
		public Aa21b01s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Aa21b01s01 kk = new Aa21b01s01(resultSet.getString("CSERV01"),
					resultSet.getString("CTIPOE01"),
					resultSet.getLong("CFASE01"),
					resultSet.getString("DFASE01"),
					resultSet.getString("SITU01"), resultSet.getInt("BLOQ01"),

					resultSet.getString("TDOCU01"),
					resultSet.getString("USUB01"),
					resultSet.getString("EFASE01"),
					// resultSet.getBytes("DOCU01"),
					resultSet.getString("EXTDOCU01"));
			kk.setCodPid01(resultSet.getString("CODPID01"));
			return kk;
		}
	};

	private RowMapper<Aa21b01s01> rwMapDocFase = new RowMapper<Aa21b01s01>() {
		public Aa21b01s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Aa21b01s01 kk = new Aa21b01s01(resultSet.getString("CSERV01"),
					resultSet.getString("CTIPOE01"),
					resultSet.getLong("CFASE01"),
					resultSet.getString("TDOCU01"),
					resultSet.getString("EXTDOCU01"));
			kk.setCodPid01(resultSet.getString("CODPID01"));
			return kk;
		}
	};

	private RowMapper<Aa21b01s01> rwMapPK = new RowMapper<Aa21b01s01>() {
		public Aa21b01s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Aa21b01s01(resultSet.getString("CSERV01"),
					resultSet.getString("CTIPOE01"),
					resultSet.getLong("CFASE01"));
		}
	};

	private RowMapper<Aa21b01s01> rwMapDfase = new RowMapper<Aa21b01s01>() {
		public Aa21b01s01 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			Aa21b01s01 faseExp = new Aa21b01s01();
			faseExp.setDfase01(resultSet.getString("DFASE01"));
			faseExp.setEfase01(resultSet.getString("EFASE01"));
			faseExp.setCfase01(new Long(resultSet.getString("CFASE01")));
			return faseExp;
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Aa21b01s01>> rwMapJerarquia = new RowMapper<JerarquiaDto<Aa21b01s01>>() {
		public JerarquiaDto<Aa21b01s01> mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {

			Aa21b01s01 aa21b01s01 = new Aa21b01s01(
					resultSet.getString("CSERV01"),
					resultSet.getString("CTIPOE01"),
					resultSet.getLong("CFASE01"),
					resultSet.getString("DFASE01"),
					resultSet.getString("SITU01"), resultSet.getInt("BLOQ01"),
					resultSet.getString("TDOCU01"),
					resultSet.getString("USUB01"),
					resultSet.getString("EFASE01"),
					// defaultLobHandler.getBlobAsBytes(resultSet, "DOCU01"),
					resultSet.getString("EXTDOCU01"));

			JerarquiaDto<Aa21b01s01> jerarquia = new JerarquiaDto<Aa21b01s01>();
			jerarquia.setModel(aa21b01s01);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Aa21b01s01 table.
	 * 
	 * @param aa21b01s01
	 *            Aa21b01s01
	 * @return Aa21b01s01
	 */
	public Aa21b01s01 add(Aa21b01s01 aa21b01s01) {

		Aa21b01s01DaoImpl.logger.info("Método add");
		Long correlativoFase = this.obtenerCorrelativoFase(aa21b01s01);
		aa21b01s01.setCfase01(correlativoFase);
		String query = "INSERT INTO AA21B01S01 (CSERV01, CTIPOE01, CFASE01, DFASE01, SITU01, BLOQ01, TDOCU01, USUB01, EFASE01, EXTDOCU01,CODPID01) VALUES (?,?,?,?,?,?,?,?,?,?,?)";

		Aa21b01s01DaoImpl.logger.info("SQL = " + query);

		Aa21b01s01DaoImpl.logger.info("PARAM1="
				+ aa21b01s01.getCserv01().trim());
		Aa21b01s01DaoImpl.logger.info("PARAM2=" + aa21b01s01.getCtipoe01());
		Aa21b01s01DaoImpl.logger.info("PARAM3=" + correlativoFase);
		Aa21b01s01DaoImpl.logger.info("PARAM4=" + aa21b01s01.getDfase01());
		Aa21b01s01DaoImpl.logger.info("PARAM5=" + aa21b01s01.getSitu01());
		Aa21b01s01DaoImpl.logger.info("PARAM6=" + 0);

		Aa21b01s01DaoImpl.logger.info("PARAM7=" + aa21b01s01.getTdocu01());
		Aa21b01s01DaoImpl.logger.info("PARAM8=null");
		Aa21b01s01DaoImpl.logger.info("PARAM9=" + aa21b01s01.getEfase01());
		Aa21b01s01DaoImpl.logger.info("PARAM10=" + aa21b01s01.getCodPid01());
		this.jdbcTemplate.update(query, aa21b01s01.getCserv01(),
				aa21b01s01.getCtipoe01(), correlativoFase,
				aa21b01s01.getDfase01(), aa21b01s01.getSitu01(), 0,
				aa21b01s01.getTdocu01(), null, aa21b01s01.getEfase01(),
				aa21b01s01.getExtdocu01(), aa21b01s01.getCodPid01());
		Aa21b01s01DaoImpl.logger.info("SQL" + query);
		return aa21b01s01;
	}

	/**
	 * Finds rows in the Fases tramitación table using like.
	 * 
	 * @param aa21b01s01
	 *            Aa21b01s01
	 * @return Integer
	 */

	@Transactional(readOnly = true)
	public Long obtenerCorrelativoFase(Aa21b01s01 aa21b01s01) {

		Aa21b01s01DaoImpl.logger.info("Método obtenerCorrelativoFase");
		StringBuffer query = new StringBuffer(
				"SELECT  MAX(CFASE01) FROM Aa21b01s01 where CSERV01 = ? AND CTIPOE01 = ?");
		List<Object> params = new ArrayList<Object>();
		params.add(aa21b01s01.getCserv01());
		params.add(aa21b01s01.getCtipoe01());
		Aa21b01s01DaoImpl.logger.info("obtenerCorrelativoFase");
		Aa21b01s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b01s01DaoImpl.logger.info("PARAMs=" + params);
		return Long.valueOf(this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray())) + 1;
	}

	/**
	 * Updates a single row in the Aa21b01s01 table.
	 * 
	 * @param aa21b01s01
	 *            Aa21b01s01
	 * @return Aa21b01s01
	 */
	public Aa21b01s01 update(Aa21b01s01 aa21b01s01) {
		Aa21b01s01DaoImpl.logger.info("Método update");

		String query = "UPDATE AA21B01S01 SET DFASE01=?, SITU01=?,  TDOCU01=?, EFASE01=?, EXTDOCU01=?,CODPID01=? WHERE CSERV01=? AND CTIPOE01=? AND CFASE01=?";

		Aa21b01s01DaoImpl.logger.info("SQL = " + query);

		Aa21b01s01DaoImpl.logger.info("PARAM1=" + aa21b01s01.getDfase01());
		Aa21b01s01DaoImpl.logger.info("PARAM2=" + aa21b01s01.getSitu01());

		Aa21b01s01DaoImpl.logger.info("PARAM3=" + aa21b01s01.getTdocu01());
		Aa21b01s01DaoImpl.logger.info("PARAM4=" + aa21b01s01.getEfase01());
		Aa21b01s01DaoImpl.logger.info("PARAM5=" + aa21b01s01.getExtdocu01());
		Aa21b01s01DaoImpl.logger.info("PARAM6=" + aa21b01s01.getCodPid01());
		Aa21b01s01DaoImpl.logger.info("PARAM7k=" + aa21b01s01.getCserv01());
		Aa21b01s01DaoImpl.logger.info("PARAM8k=" + aa21b01s01.getCtipoe01());
		Aa21b01s01DaoImpl.logger.info("PARAM9k=" + aa21b01s01.getCfase01());

		this.jdbcTemplate.update(query, aa21b01s01.getDfase01(),
				aa21b01s01.getSitu01(), aa21b01s01.getTdocu01(),
				aa21b01s01.getEfase01(), aa21b01s01.getExtdocu01(),
				aa21b01s01.getCodPid01(), aa21b01s01.getCserv01(),
				aa21b01s01.getCtipoe01(), aa21b01s01.getCfase01());
		return aa21b01s01;
	}

	/**
	 * Updates a single row in the Aa21b01s01 table.
	 * 
	 * @param aa21b01s01
	 *            Aa21b01s01
	 * @return Aa21b01s01
	 */
	public Aa21b01s01 updateBloqueos(Aa21b01s01 aa21b01s01) {
		Aa21b01s01DaoImpl.logger.info("Método updateBloqueos");
		if (aa21b01s01 != null && aa21b01s01.getCtipoe01() != null
				&& aa21b01s01.getCfase01() != null) {
			String query = "UPDATE AA21B01S01 SET BLOQ01=?, USUB01=? WHERE CSERV01=? AND CTIPOE01=? AND CFASE01=?";

			Aa21b01s01DaoImpl.logger.info("SQL = " + query);

			Aa21b01s01DaoImpl.logger.info("PARAM1=" + aa21b01s01.getBloq01());
			Aa21b01s01DaoImpl.logger.info("PARAM2=" + aa21b01s01.getUsub01());
			Aa21b01s01DaoImpl.logger.info("PARAM3k=" + aa21b01s01.getCserv01());
			Aa21b01s01DaoImpl.logger
					.info("PARAM4k=" + aa21b01s01.getCtipoe01());
			Aa21b01s01DaoImpl.logger.info("PARAM5k=" + aa21b01s01.getCfase01());

			this.jdbcTemplate.update(query, aa21b01s01.getBloq01(),
					aa21b01s01.getUsub01(), aa21b01s01.getCserv01(),
					aa21b01s01.getCtipoe01(), aa21b01s01.getCfase01());
		} else if (aa21b01s01 != null && aa21b01s01.getCserv01() != null) {
			String query = "UPDATE AA21B01S01 SET BLOQ01=?, USUB01=? WHERE CSERV01=? ";

			Aa21b01s01DaoImpl.logger.info("SQL = " + query);

			Aa21b01s01DaoImpl.logger.info("PARAM1=" + 0);
			Aa21b01s01DaoImpl.logger.info("PARAM2=null");

			this.jdbcTemplate.update(query, 0, null, aa21b01s01.getCserv01());
		} else {
			String query = "UPDATE AA21B01S01 SET BLOQ01=?, USUB01=? ";

			Aa21b01s01DaoImpl.logger.info("SQL = " + query);

			Aa21b01s01DaoImpl.logger.info("PARAM1=" + 0);
			Aa21b01s01DaoImpl.logger.info("PARAM2=null");

			this.jdbcTemplate.update(query, 0, null);
		}

		return aa21b01s01;
	}

	/**
	 * Finds a single row in the Aa21b01s01 table.
	 * 
	 * @param aa21b01s01
	 *            Aa21b01s01
	 * @return Aa21b01s01
	 */
	@Transactional(readOnly = true)
	public Aa21b01s01 find(Aa21b01s01 aa21b01s01) {
		Aa21b01s01DaoImpl.logger.info("Método find");
		String query = "SELECT t1.CODPID01 codPID01, t1.CSERV01 CSERV01, t1.CTIPOE01 CTIPOE01, t1.CFASE01 CFASE01, t1.DFASE01 DFASE01, t1.SITU01 SITU01, t1.BLOQ01 BLOQ01,  t1.TDOCU01 TDOCU01, t1.USUB01 USUB01, t1.EFASE01 EFASE01, t1.EXTDOCU01 EXTDOCU01 FROM AA21B01S01 t1 WHERE t1.CSERV01 = ?   AND t1.CTIPOE01 = ?   AND t1.CFASE01 = ?  ";

		Aa21b01s01DaoImpl.logger.info("SQL = " + query);

		Aa21b01s01DaoImpl.logger.info("PARAM1k=" + aa21b01s01.getCserv01());
		Aa21b01s01DaoImpl.logger.info("PARAM2k=" + aa21b01s01.getCtipoe01());
		Aa21b01s01DaoImpl.logger.info("PARAM3k=" + aa21b01s01.getCfase01());

		List<Aa21b01s01> aa21b01s01List = this.jdbcTemplate.query(query,
				this.rwMap, aa21b01s01.getCserv01(), aa21b01s01.getCtipoe01(),
				aa21b01s01.getCfase01());
		return (Aa21b01s01) DataAccessUtils.uniqueResult(aa21b01s01List);
	}

	/**
	 * Removes a single row in the Aa21b01s01 table.
	 * 
	 * @param aa21b01s01
	 *            Aa21b01s01
	 * @return
	 */
	public void remove(Aa21b01s01 aa21b01s01) {
		Aa21b01s01DaoImpl.logger.info("Método remove");
		String query = "DELETE FROM AA21B01S01 WHERE CSERV01=? AND CTIPOE01=? AND CFASE01=?";

		Aa21b01s01DaoImpl.logger.info("SQL = " + query);

		Aa21b01s01DaoImpl.logger.info("PARAM1k=" + aa21b01s01.getCserv01());
		Aa21b01s01DaoImpl.logger.info("PARAM2k=" + aa21b01s01.getCtipoe01());
		Aa21b01s01DaoImpl.logger.info("PARAM3k=" + aa21b01s01.getCfase01());

		this.jdbcTemplate.update(query, aa21b01s01.getCserv01(),
				aa21b01s01.getCtipoe01(), aa21b01s01.getCfase01());
	}

	/**
	 * Finds a list of rows in the Aa21b01s01 table.
	 * 
	 * @param aa21b01s01
	 *            Aa21b01s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Aa21b01s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa21b01s01> findAll(Aa21b01s01 aa21b01s01,
			JQGridRequestDto jqGridRequestDto) {
		Aa21b01s01DaoImpl.logger.info("Método findAll");

		StringBuilder query = new StringBuilder(
				"SELECT  t1.CODPID01 codPID01, t1.CSERV01 CSERV01,t1.CTIPOE01 CTIPOE01,t1.CFASE01 CFASE01,t1.DFASE01 DFASE01,t1.SITU01 SITU01,t1.BLOQ01 BLOQ01,t1.TDOCU01 TDOCU01,t1.USUB01 USUB01,t1.EFASE01 EFASE01,t1.EXTDOCU01 EXTDOCU01 ");
		// query.append(",t2.CODPID23 DOCU01 ");
		query.append("FROM AA21B01S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa21b01s01);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		Aa21b01s01DaoImpl.logger.info("findAll");
		Aa21b01s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b01s01DaoImpl.logger.info("PARAMS" + params);

		return (List<Aa21b01s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Aa21b01s01 table using like.
	 * 
	 * @param aa21b01s01
	 *            Aa21b01s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param listaServicios
	 *            List<Aa21b13s01>
	 * @param listaTiposExpedientes
	 *            List<Aa21b02s01>
	 * @param startsWith
	 *            Boolean
	 * @return List<Aa21b01s01>
	 */
	@Transactional(readOnly = true)
	public List<Aa21b01s01> findAllLike(Aa21b01s01 aa21b01s01,
			JQGridRequestDto jqGridRequestDto, List<Aa21b13s01> listaServicios,
			List<Aa21b02s01> listaTiposExpedientes, Boolean startsWith) {

		Aa21b01s01DaoImpl.logger.info("Método findAllLike");

		StringBuilder query = new StringBuilder(
				"SELECT  t1.CODPID01 codPID01, t1.CSERV01 CSERV01,t1.CTIPOE01 CTIPOE01,t1.CFASE01 CFASE01,t1.DFASE01 DFASE01,t1.SITU01 SITU01,t1.BLOQ01 BLOQ01,t1.TDOCU01 TDOCU01,t1.USUB01 USUB01,t1.EFASE01 EFASE01,t1.EXTDOCU01 EXTDOCU01 ");
		// query.append(",t2.CODPID23 DOCU01 ");
		query.append("FROM AA21B01S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa21b01s01,
				listaServicios, listaTiposExpedientes, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		Aa21b01s01DaoImpl.logger.info("findalllike");
		Aa21b01s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b01s01DaoImpl.logger.info("PARAMS = " + params);

		return (List<Aa21b01s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Aa21b01s01 table.
	 * 
	 * @param aa21b01s01
	 *            Aa21b01s01
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Aa21b01s01 aa21b01s01) {
		Aa21b01s01DaoImpl.logger.info("Método findAllCount");
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA21B01S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(aa21b01s01);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa21b01s01DaoImpl.logger.info("findAllCount");
		Aa21b01s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b01s01DaoImpl.logger.info("PARAMS=" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Aa21b01s01 table using like.
	 * 
	 * @param aa21b01s01
	 *            Aa21b01s01
	 * @param listaServicios
	 *            List<Aa21b13s01>
	 * @param listaTiposExpedientes
	 *            List<Aa21b02s01>
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Aa21b01s01 aa21b01s01,
			List<Aa21b13s01> listaServicios,
			List<Aa21b02s01> listaTiposExpedientes, Boolean startsWith) {

		Aa21b01s01DaoImpl.logger.info("Método findAllLikeCount");

		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AA21B01S01 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa21b01s01,
				listaServicios, listaTiposExpedientes, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa21b01s01DaoImpl.logger.info("findAllLikeCount");
		Aa21b01s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b01s01DaoImpl.logger.info("PARAMs=" + params);

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Aa21b01s01 selected for rup_table
	 * 
	 * @param aa21b01s01
	 *            Aa21b01s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa21b01s01>>
	 */
	@Override
	public List<TableRowDto<Aa21b01s01>> reorderSelection(
			Aa21b01s01 aa21b01s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {

		Aa21b01s01DaoImpl.logger.info("Método reorderSelection");

		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CSERV01 CSERV01,t1.CTIPOE01 CTIPOE01,t1.CFASE01 CFASE01,t1.DFASE01 DFASE01,t1.SITU01 SITU01,t1.BLOQ01 BLOQ01,t1.TDOCU01 TDOCU01,t1.USUB01 USUB01,t1.EFASE01 EFASE01,t1.EXTDOCU01 EXTDOCU01 ");
		// query.append(",t2.CODPID23 DOCU01 ");
		// FROM
		query.append("FROM AA21B01S01 t1 ");

		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(aa21b01s01, null, null,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Aa21b01s01.class, filterParamList,
				"CSERV01||'-'||CTIPOE01||'-'||CFASE01");

		Aa21b01s01DaoImpl.logger.info("reorderSelection");
		Aa21b01s01DaoImpl.logger.info("SQL = "
				+ sbReorderSelectionSQL.toString());
		Aa21b01s01DaoImpl.logger.info("PARAMs=" + filterParamList);

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa21b01s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Aa21b01s01
	 * @param searchParams
	 *            Aa21b01s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa21b01s01>>
	 */
	@Override
	public List<TableRowDto<Aa21b01s01>> search(Aa21b01s01 filterParams,
			Aa21b01s01 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {

		Aa21b01s01DaoImpl.logger.info("Método search");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CSERV01 CSERV01,t1.CTIPOE01 CTIPOE01,t1.CFASE01 CFASE01,t1.DFASE01 DFASE01,t1.SITU01 SITU01,t1.BLOQ01 BLOQ01,t1.TDOCU01 TDOCU01,t1.USUB01 USUB01,t1.EFASE01 EFASE01,t1.EXTDOCU01 EXTDOCU01 ");
		// query.append(",t2.CODPID23 DOCU01 ");
		// FROM
		query.append("FROM AA21B01S01 t1 ");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				null, null, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, null, null, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Aa21b01s01.class, filterParamList,
				searchSQL, searchParamList, from_alias,
				"CSERV01||'-'||CTIPOE01||'-'||CFASE01");

		Aa21b01s01DaoImpl.logger.info("search");
		Aa21b01s01DaoImpl.logger.info("SQL = "
				+ sbReorderSelectionSQL.toString());
		Aa21b01s01DaoImpl.logger.info("PARAMs=" + filterParamList);
		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Aa21b01s01>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filteraa21b01s01
	 *            Aa21b01s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Aa21b01s01 filteraa21b01s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {

		Aa21b01s01DaoImpl.logger.info("Método removeMultiple");
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.CSERV01 CSERV01,t1.CTIPOE01 CTIPOE01,t1.CFASE01 CFASE01,t1.DFASE01 DFASE01,t1.SITU01 SITU01,t1.BLOQ01 BLOQ01,t1.TDOCU01 TDOCU01,t1.USUB01 USUB01,t1.EFASE01 EFASE01,t1.EXTDOCU01 EXTDOCU01 ");
		// query.append(",t2.CODPID23 DOCU01 ");
		// FROM
		query.append("FROM AA21B01S01 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filteraa21b01s01,
				null, null, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto, Aa21b01s01.class,
						query, params, "CSERV01||'-'||CTIPOE01||'-'||CFASE01");

		Aa21b01s01DaoImpl.logger.info("removeMultiple");
		Aa21b01s01DaoImpl.logger
				.info("SQL = " + sbRemoveMultipleSQL.toString());
		Aa21b01s01DaoImpl.logger.info("PARAMs=" + params);

		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Aa21b01s01 table.
	 * 
	 * @param filterAa21b01s01
	 *            Aa21b01s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa21b01s01>>
	 */
	@Override
	public List<JerarquiaDto<Aa21b01s01>> findAllLikeJerarquia(
			Aa21b01s01 filterAa21b01s01, JQGridRequestDto jqGridRequestDto) {

		Aa21b01s01DaoImpl.logger.info("Método findAllLikeJerarquia");
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.CSERV01 CSERV01,t1.CTIPOE01 CTIPOE01,t1.CFASE01 CFASE01,t1.DFASE01 DFASE01,t1.SITU01 SITU01,t1.BLOQ01 BLOQ01,t1.TDOCU01 TDOCU01,t1.USUB01 USUB01,t1.EFASE01 EFASE01,t1.EXTDOCU01 EXTDOCU01 ");
		// query.append(",t2.CODPID23 DOCU01 ");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA21B01S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA21B01S01");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAa21b01s01, null,
				null, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "CSERV01||'-'||CTIPOE01||'-'||CFASE01", "ID_PADRE",
				"NOMBRE", from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");

		Aa21b01s01DaoImpl.logger.info("findAllLikeJerarquia");
		Aa21b01s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b01s01DaoImpl.logger.info("PARAMs=" + params);
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa21b01s01
	 *            Aa21b01s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(Aa21b01s01 filterAa21b01s01,
			JQGridRequestDto jqGridRequestDto) {

		Aa21b01s01DaoImpl.logger.info("Método findAllLikeCountJerarquia");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA21B01S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA21B01S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAa21b01s01, null,
				null, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere,
				"CSERV01||'-'||CTIPOE01||'-'||CFASE01", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa21b01s01DaoImpl.logger.info("findAllLikeCountJerarquia");
		Aa21b01s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b01s01DaoImpl.logger.info("PARAMs=" + params);
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa21b01s01
	 *            Aa21b01s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa21b01s01>>
	 */
	@Override
	public List<TableRowDto<Aa21b01s01>> findAllChild(
			Aa21b01s01 filterAa21b01s01, JQGridRequestDto jqGridRequestDto) {

		Aa21b01s01DaoImpl.logger.info("Método findAllChild");
		// FROM
		// StringBuilder from = new StringBuilder("FROM AA21B01S01 t1 ");
		List<String> from = new ArrayList<String>();
		from.add("AA21B01S01");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.EJIE = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(filterAa21b01s01, null,
				null, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere,
				"CSERV01||'-'||CTIPOE01||'-'||CFASE01", "ID_PADRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		Aa21b01s01DaoImpl.logger.info("findAllChild");
		Aa21b01s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b01s01DaoImpl.logger.info("PARAMs=" + params);
		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<Aa21b01s01>(this.rwMapPK,
						"CSERV01||'-'||CTIPOE01||'-'||CFASE01"), params
						.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa21b01s01 entity
	 * 
	 * @param aa21b01s01
	 *            Aa21b01s01 Bean with the criteria values to filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(Aa21b01s01 aa21b01s01) {

		StringBuilder where = new StringBuilder(
				Aa21b01s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (aa21b01s01 != null && aa21b01s01.getCserv01() != null) {
			where.append(" AND t1.CSERV01 = ?");
			params.add(aa21b01s01.getCserv01());
		}
		if (aa21b01s01 != null && aa21b01s01.getCtipoe01() != null) {
			where.append(" AND t1.CTIPOE01 = ?");
			params.add(aa21b01s01.getCtipoe01());
		}
		if (aa21b01s01 != null && aa21b01s01.getCfase01() != null) {
			where.append(" AND t1.CFASE01 = ?");
			params.add(aa21b01s01.getCfase01());
		}
		if (aa21b01s01 != null && aa21b01s01.getDfase01() != null) {
			where.append(" AND t1.DFASE01 = ?");
			params.add(aa21b01s01.getDfase01());
		}
		if (aa21b01s01 != null && aa21b01s01.getSitu01() != null) {
			where.append(" AND t1.SITU01 = ?");
			params.add(aa21b01s01.getSitu01());
		}
		if (aa21b01s01 != null && aa21b01s01.getBloq01() != null) {
			where.append(" AND t1.BLOQ01 = ?");
			params.add(aa21b01s01.getBloq01());
		}

		if (aa21b01s01 != null && aa21b01s01.getTdocu01() != null) {
			where.append(" AND t1.TDOCU01 = ?");
			params.add(aa21b01s01.getTdocu01());
		}
		if (aa21b01s01 != null && aa21b01s01.getUsub01() != null) {
			where.append(" AND t1.USUB01 = ?");
			params.add(aa21b01s01.getUsub01());
		}
		if (aa21b01s01 != null && aa21b01s01.getEfase01() != null) {
			where.append(" AND t1.EFASE01 = ?");
			params.add(aa21b01s01.getEfase01());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Aa21b01s01 entity
	 * 
	 * @param aa21b01s01
	 *            Aa21b01s01 Bean with the criteria values to filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(Aa21b01s01 aa21b01s01,
			List<Aa21b13s01> listaServicios,
			List<Aa21b02s01> listaTiposExpedientes, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Aa21b01s01DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (listaServicios != null) {
			if (listaServicios.size() > 0) {
				where.append(" AND (");
				Aa21b13s01 serviciosAux = null;
				for (Iterator<Aa21b13s01> iterator = listaServicios.iterator(); iterator
						.hasNext();) {

					serviciosAux = (Aa21b13s01) iterator.next();
					where.append(" t1.CSERV01 = ? ");
					params.add(serviciosAux.getCServ13());
					if (iterator.hasNext()) {
						where.append(" OR ");
					}
				}
				where.append(") ");
			}
		}

		if (listaTiposExpedientes != null) {
			if (listaTiposExpedientes.size() > 0) {
				where.append(" AND (");
				Aa21b02s01 serviciosAux = null;
				for (Iterator<Aa21b02s01> iterator = listaTiposExpedientes
						.iterator(); iterator.hasNext();) {

					serviciosAux = (Aa21b02s01) iterator.next();
					where.append(" t1.CTIPOE01 = ? ");
					params.add(serviciosAux.getCtipoe02());
					if (iterator.hasNext()) {
						where.append(" OR ");
					}
				}
				where.append(") ");
			}
		}
		if (aa21b01s01 != null && aa21b01s01.getCfase01() != null) {
			where.append(" AND t1.CFASE01 = ?");
			params.add(aa21b01s01.getCfase01());
		}

		if (aa21b01s01 != null && aa21b01s01.getDfase01() != null) {
			where.append(" AND UPPER(t1.DFASE01) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa21b01s01.getDfase01().toUpperCase() + "%");
			} else {
				params.add("%" + aa21b01s01.getDfase01().toUpperCase() + "%");
			}
			where.append(" AND t1.DFASE01 IS NOT NULL");
		}
		if (aa21b01s01 != null && aa21b01s01.getSitu01() != null) {
			where.append(" AND UPPER(t1.SITU01) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa21b01s01.getSitu01().toUpperCase() + "%");
			} else {
				params.add("%" + aa21b01s01.getSitu01().toUpperCase() + "%");
			}
			where.append(" AND t1.SITU01 IS NOT NULL");
		}
		if (aa21b01s01 != null && aa21b01s01.getBloq01() != null) {
			where.append(" AND t1.BLOQ01 = ?");
			params.add(aa21b01s01.getBloq01());
		}

		if (aa21b01s01 != null && aa21b01s01.getTdocu01() != null) {
			where.append(" AND UPPER(t1.TDOCU01) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa21b01s01.getTdocu01().toUpperCase() + "%");
			} else {
				params.add("%" + aa21b01s01.getTdocu01().toUpperCase() + "%");
			}
			where.append(" AND t1.TDOCU01 IS NOT NULL");
		}
		if (aa21b01s01 != null && aa21b01s01.getUsub01() != null) {
			where.append(" AND UPPER(t1.USUB01) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa21b01s01.getUsub01().toUpperCase() + "%");
			} else {
				params.add("%" + aa21b01s01.getUsub01().toUpperCase() + "%");
			}
			where.append(" AND t1.USUB01 IS NOT NULL");
		}
		if (aa21b01s01 != null && aa21b01s01.getEfase01() != null) {
			where.append(" AND UPPER(t1.EFASE01) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(aa21b01s01.getEfase01().toUpperCase() + "%");
			} else {
				params.add("%" + aa21b01s01.getEfase01().toUpperCase() + "%");
			}
			where.append(" AND t1.EFASE01 IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;

	@Override
	public List<Aa21b01s01> findFase(Aa21b01s01 faseExp, Boolean startsWith) {

		Aa21b01s01DaoImpl.logger.info("Método findAllChild");
		// TODO Auto-generated method stub
		List<Object> params = new ArrayList<Object>();

		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		StringBuilder order = new StringBuilder("");
		StringBuilder query = new StringBuilder(
				"SELECT DISTINCT t1.DFASE01 DFASE01, t1.EFASE01 EFASE01, t1.CFASE01 CFASE01 ");
		query.append("FROM AA21B01S01 t1 ");
		if (faseExp != null && faseExp.getDfase01() != null) {
			where.append(" AND UPPER(t1.DFASE01) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add("%" + faseExp.getDfase01().toUpperCase() + "%");
			} else {
				params.add("%" + faseExp.getDfase01().toUpperCase() + "%");
			}

			order = new StringBuilder(" ORDER BY DFASE01 asc ");
		}
		if (faseExp != null && faseExp.getEfase01() != null) {
			where.append(" AND UPPER(t1.EFASE01) like ? ESCAPE '\\'");
			if (startsWith) {
				params.add("%" + faseExp.getEfase01().toUpperCase() + "%");
			} else {
				params.add("%" + faseExp.getEfase01().toUpperCase() + "%");
			}

			order = new StringBuilder(" ORDER BY EFASE01 asc ");

		}
		query.append(where);
		query.append(order);

		Aa21b01s01DaoImpl.logger.info("findFase");
		Aa21b01s01DaoImpl.logger.info("SQL = " + query.toString());
		Aa21b01s01DaoImpl.logger.info("PARAMs=" + params);
		return (List<Aa21b01s01>) this.jdbcTemplate.query(query.toString(),
				this.rwMapDfase, params.toArray());
	}

	@Override
	public void updateDocumentoFase(Aa21b01s01 aa21b01s01) {
		// TODO Auto-generated method stub
		Aa21b01s01DaoImpl.logger.info("Método update documento fase");

		String query = "UPDATE AA21B01S01 SET CODPID01=? WHERE CSERV01=? AND CTIPOE01=? AND CFASE01=? ";

		Aa21b01s01DaoImpl.logger.info("SQL = " + query);

		Aa21b01s01DaoImpl.logger.info("PARAM1=" + aa21b01s01.getCodPid01());
		Aa21b01s01DaoImpl.logger.info("PARAM2pk=" + aa21b01s01.getCserv01());
		Aa21b01s01DaoImpl.logger.info("PARAM3pk=" + aa21b01s01.getCtipoe01());
		Aa21b01s01DaoImpl.logger.info("PARAM4pk=" + aa21b01s01.getCfase01());
		this.jdbcTemplate.update(query, aa21b01s01.getCodPid01(),
				aa21b01s01.getCserv01(), aa21b01s01.getCtipoe01(),
				aa21b01s01.getCfase01());

	}

	@Override
	public Aa21b01s01 addDocumentoFase(Aa21b01s01 aa21b01s01)
			throws SQLException, IOException {
		Aa21b01s01DaoImpl.logger.info("Método add documento fase");
		updateDocumentoFase(aa21b01s01);

		return aa21b01s01;
	}

	/**
	 * @param cfase01
	 *            Long
	 * @return boolean
	 * 
	 */
	public boolean existeFaseExpExp(Long cfase01, long cserv01, String ctipoe01) {
		Aa21b01s01DaoImpl.logger.info("Método existeFaseExpExp");
		String query = "SELECT COUNT(1) FROM AA21B21S01 WHERE CFASE21 = ? and CSERV21=? and CEXPE21=?";
		Aa21b01s01DaoImpl.logger.info("SQL " + query);
		Aa21b01s01DaoImpl.logger.info("PARAM1 " + cfase01);
		Aa21b01s01DaoImpl.logger.info("PARAM2 " + cserv01);
		Aa21b01s01DaoImpl.logger.info("PARAM3 " + ctipoe01);
		return this.jdbcTemplate.queryForInt(query, cfase01.toString(),
				cserv01, ctipoe01) > 0;
	}

	@Override
	public boolean compruebaBloqueosFasePorServicio(Aa21b01s01 aa21b01s01Aux) {
		// TODO Auto-generated method stub
		String usuario = new Aa21bSeguridad().getUsuario().getPersonaXLNET()
				.getCodigo();
		Aa21b01s01DaoImpl.logger
				.info("Método compruebaBloqueosFasePorServicio");
		String query = "SELECT COUNT(1) FROM AA21B01S01 WHERE BLOQ01 = ? AND USUB01 != ? AND CSERV01 = ?";
		Aa21b01s01DaoImpl.logger.info("SQL " + query);
		Aa21b01s01DaoImpl.logger.info("PARAM1 " + aa21b01s01Aux.getBloq01());
		Aa21b01s01DaoImpl.logger.info("PARAM2 " + usuario);
		return this.jdbcTemplate.queryForInt(query, 1, usuario,
				aa21b01s01Aux.getCserv01()) > 0;
	}

	@Override
	public void updateEstadosServicio(Aa21b01s01 aa21b01s01Aux) {
		Aa21b01s01DaoImpl.logger.info("Método updateEstadosServicio");

		String query = "UPDATE AA21B01S01 SET SITU01=? WHERE CSERV01=? ";

		Aa21b01s01DaoImpl.logger.info("SQL = " + query);

		Aa21b01s01DaoImpl.logger.info("PARAM1=" + aa21b01s01Aux.getSitu01());
		Aa21b01s01DaoImpl.logger.info("PARAM2=" + aa21b01s01Aux.getCserv01());

		this.jdbcTemplate.update(query, aa21b01s01Aux.getSitu01(),
				aa21b01s01Aux.getCserv01());

	}

	@Override
	public Aa21b01s01 findDocumentoFase(Aa21b01s01 aa21b01s01) {
		// TODO Auto-generated method stub
		Aa21b01s01DaoImpl.logger.info("Método find");
		String query = "SELECT t1.CSERV01 CSERV01, t1.CTIPOE01 CTIPOE01, t1.CFASE01 CFASE01,  t1.TDOCU01 TDOCU01, t1.EXTDOCU01 EXTDOCU01, t1.CODPID01 codPID01 FROM AA21B01S01 t1   WHERE t1.CSERV01 = ?   AND t1.CTIPOE01 = ?   AND t1.CFASE01 = ?  ";

		Aa21b01s01DaoImpl.logger.info("SQL = " + query);

		Aa21b01s01DaoImpl.logger.info("PARAM1k=" + aa21b01s01.getCserv01());
		Aa21b01s01DaoImpl.logger.info("PARAM2k=" + aa21b01s01.getCtipoe01());
		Aa21b01s01DaoImpl.logger.info("PARAM3k=" + aa21b01s01.getCfase01());

		List<Aa21b01s01> aa21b01s01List = this.jdbcTemplate.query(query,
				this.rwMapDocFase, aa21b01s01.getCserv01(),
				aa21b01s01.getCtipoe01(), aa21b01s01.getCfase01());
		return (Aa21b01s01) DataAccessUtils.uniqueResult(aa21b01s01List);
	}

	@Override
	public void removeFasesServicio(Aa21b01s01 aa21b01s01) {
		// TODO Auto-generated method stub
		Aa21b01s01DaoImpl.logger.info("Método removeFasesServicio");
		String query = "DELETE FROM AA21B01S01 WHERE CSERV01=?";

		Aa21b01s01DaoImpl.logger.info("SQL = " + query);

		Aa21b01s01DaoImpl.logger.info("PARAM1k=" + aa21b01s01.getCserv01());

		this.jdbcTemplate.update(query, aa21b01s01.getCserv01());
	}

	@Override
	public void removeFasesTipoServicio(Aa21b02s01 aa21b02s01) {
		// TODO Auto-generated method stub
		Aa21b01s01DaoImpl.logger.info("Método removeFasesServicio");
		String query = "DELETE FROM AA21B01S01 WHERE CSERV01=? and CTIPOE01=?";

		Aa21b01s01DaoImpl.logger.info("SQL = " + query);

		Aa21b01s01DaoImpl.logger.info("PARAM1k=" + aa21b02s01.getCserv02());
		Aa21b01s01DaoImpl.logger.info("PARAM2=" + aa21b02s01.getCtipoe02());

		this.jdbcTemplate.update(query, aa21b02s01.getCserv02(),
				aa21b02s01.getCtipoe02());
	}

	@Override
	public void removeDocumentoFase(Aa21b01s01 aa21b01s01) {

		aa21b01s01.setCodPid01("");
		updateDocumentoFase(aa21b01s01);
	}

}
