package com.ejie.aa21b.dao;

import java.io.IOException;
import java.sql.SQLException;
import java.util.List;

import com.ejie.aa21b.model.Aa21b01s01;
import com.ejie.aa21b.model.Aa21b02s01;
import com.ejie.aa21b.model.Aa21b13s01;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Aa21b01s01Dao  
 * 
 *  
 */

public interface Aa21b01s01Dao {

	/**
	 * Inserts a single row in the Aa21b01s01 table.
	 * 
	 * @param aa21b01s01
	 *            Aa21b01s01
	 * @return Aa21b01s01
	 */
	Aa21b01s01 add(Aa21b01s01 aa21b01s01);

	/**
	 * Updates a single row in the Aa21b01s01 table.
	 * 
	 * @param aa21b01s01
	 *            Aa21b01s01
	 * @return Aa21b01s01
	 */
	Aa21b01s01 update(Aa21b01s01 aa21b01s01);

	/**
	 * Finds a single row in the Aa21b01s01 table.
	 * 
	 * @param aa21b01s01
	 *            Aa21b01s01
	 * @return Aa21b01s01
	 */
	Aa21b01s01 find(Aa21b01s01 aa21b01s01);

	/**
	 * Removes a single row in the Aa21b01s01 table.
	 * 
	 * @param aa21b01s01
	 *            Aa21b01s01
	 */
	void remove(Aa21b01s01 aa21b01s01);

	/**
	 * Finds a List of rows in the Aa21b01s01 table.
	 * 
	 * @param aa21b01s01
	 *            Aa21b01s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List
	 */
	List<Aa21b01s01> findAll(Aa21b01s01 aa21b01s01,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds rows in the Aa21b01s01 table using like.
	 * 
	 * @param aa21b01s01
	 *            Aa21b01s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param listaServicios
	 * @param listaTiposExpedientes
	 * @param startsWith
	 *            Boolean
	 * @return List
	 */
	List<Aa21b01s01> findAllLike(Aa21b01s01 aa21b01s01,
			JQGridRequestDto jqGridRequestDto, List<Aa21b13s01> listaServicios,
			List<Aa21b02s01> listaTiposExpedientes, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter in the Aa21b01s01 table.
	 * 
	 * @param filterAa21b01s01
	 *            Aa21b01s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	void removeMultiple(Aa21b01s01 filterAa21b01s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Counts rows in the Aa21b01s01 table using like.
	 * 
	 * @param aa21b01s01
	 *            Aa21b01s01
	 * @param listaTiposExpedientes
	 * @param listaServicios
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	Long findAllLikeCount(Aa21b01s01 aa21b01s01,
			List<Aa21b13s01> listaServicios,
			List<Aa21b02s01> listaTiposExpedientes, Boolean startsWith);

	/**
	 * Counts rows in the Aa21b01s01 table.
	 * 
	 * @param aa21b01s01
	 *            Aa21b01s01
	 * @return Long
	 */
	Long findAllCount(Aa21b01s01 aa21b01s01);

	/**
	 * Reorder selection.
	 * 
	 * @param filterAa21b01s01
	 *            Aa21b01s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa21b01s01>>
	 */
	List<TableRowDto<Aa21b01s01>> reorderSelection(Aa21b01s01 filterAa21b01s01,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Searches in the Usuario table.
	 * 
	 * @param filterAa21b01s01
	 *            Aa21b01s01
	 * @param searchAa21b01s01
	 *            Aa21b01s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Aa21b01s01>>
	 */
	List<TableRowDto<Aa21b01s01>> search(Aa21b01s01 filterAa21b01s01,
			Aa21b01s01 searchAa21b01s01, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE JERARQUIA
	 */

	/**
	 * Filter in the hierarchical Aa21b01s01 table.
	 * 
	 * @param filterAa21b01s01
	 *            Aa21b01s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Aa21b01s01>>
	 */
	List<JerarquiaDto<Aa21b01s01>> findAllLikeJerarquia(
			Aa21b01s01 filterAa21b01s01, JQGridRequestDto jqGridRequestDto);

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAa21b01s01
	 *            Aa21b01s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	Long findAllLikeCountJerarquia(Aa21b01s01 filterAa21b01s01,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAa21b01s01
	 *            Aa21b01s01
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Aa21b01s01>>
	 */
	List<TableRowDto<Aa21b01s01>> findAllChild(Aa21b01s01 filterAa21b01s01,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * 
	 * @param aa21b01s01
	 *            Aa21b01s01
	 * @return Aa21b01s01
	 */
	Aa21b01s01 updateBloqueos(Aa21b01s01 aa21b01s01);

	/**
	 * 
	 * @param faseExp
	 *            Aa21b01s01
	 * @param c
	 *            Boolean
	 * @return List<Aa21b01s01>
	 */
	List<Aa21b01s01> findFase(Aa21b01s01 faseExp, Boolean c);

	/**
	 * 
	 * @param aa21b01s01
	 *            Aa21b01s01
	 */
	void updateDocumentoFase(Aa21b01s01 aa21b01s01);

	/**
	 * 
	 * @param aa21b01s01
	 *            Aa21b01s01
	 * @return Aa21b01s01
	 * @throws SQLException
	 *             Exception
	 * @throws IOException
	 *             Exception
	 */
	Aa21b01s01 addDocumentoFase(Aa21b01s01 aa21b01s01) throws SQLException,
			IOException;

	/**
	 * 
	 * @param cfase01
	 *            Long
	 * @return boolean
	 */
	boolean existeFaseExpExp(Long cfase01, long cserv01, String ctipoe01);

	/**
	 * 
	 * @param aa21b01s01Aux
	 *            Aa21b01s01
	 * @return boolean
	 */
	boolean compruebaBloqueosFasePorServicio(Aa21b01s01 aa21b01s01Aux);

	/**
	 * 
	 * @param aa21b01s01Aux
	 *            Aa21b01s01
	 */
	void updateEstadosServicio(Aa21b01s01 aa21b01s01Aux);

	/**
	 * 
	 * @param aa21b01s01
	 *            Aa21b01s01
	 * @return Aa21b01s01
	 */
	Aa21b01s01 findDocumentoFase(Aa21b01s01 aa21b01s01);

	/**
	 * 
	 * @param aa21b01s01
	 *            Aa21b01s01
	 */
	void removeFasesServicio(Aa21b01s01 aa21b01s01);

	/**
	 * 
	 * @param aa21b01s01
	 *            Aa21b01s01
	 */
	void removeDocumentoFase(Aa21b01s01 aa21b01s01);

	void removeFasesTipoServicio(Aa21b02s01 aa21b02s01);

}
