<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="default-page-master" page-height="21cm" page-width="29.5cm" margin-top="0.5cm" margin-bottom="0.5cm" margin-left="1cm" margin-right="1cm">
				<fo:region-body margin-top="2.5cm" margin-bottom="0cm" font-family="Helvetica,Times,Courier" font-size="14pt" line-height="16pt"/>
				<fo:region-before margin-right="1cm" extent="1.9cm"/>
				<fo:region-after extent="0cm"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence master-reference="default-page-master" >
				<fo:static-content flow-name="xsl-region-before">
					<fo:table table-layout="fixed">
						<fo:table-column column-width="2.5cm"/>
						<fo:table-column column-width="22cm"/>
						<fo:table-column column-width="3.5cm"/>
						<fo:table-body display-align="center">
							<fo:table-row>
								<fo:table-cell text-align="left">
									<fo:block>
											<fo:inline font-size="8pt">
												<xsl:value-of select="servicios/fecha"/>
											</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center" padding-start="25pt">
									<fo:block>
										<xsl:element name="fo:external-graphic">
											<xsl:attribute name="src">url('<xsl:value-of select="servicios/imgLogoUrl"/>')</xsl:attribute>
										</xsl:element>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right">
									<fo:block>
										<fo:inline font-size="8pt" font-weight="bold" font-style="italic">
										 <fo:page-number/> / 
										<fo:page-number-citation ref-id="TheVeryLastPage"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:static-content>
				<!-- fo:static-content flow-name="xsl-region-after">
               		<fo:table>
					<fo:table-column column-width="proportional-column-width(1)"/>
						<fo:table-body display-align="center">
							<fo:table-row>
								<fo:table-cell>
									<fo:block font-size="11pt" text-align="center">
										<fo:inline>Prueba de pie</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:static-content-->
				
				<fo:flow flow-name="xsl-region-body">
					<xsl:for-each select="servicios">
						<xsl:for-each select="servicio">
							<fo:block>
							<xsl:if test="position() != last()"><xsl:attribute name="break-after">page</xsl:attribute></xsl:if>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:block>
									<xsl:text>&#xA;</xsl:text>
								</fo:block>
								<fo:table width="100%" space-before.optimum="4pt" space-after.optimum="4pt">
									<fo:table-column column-width="100%"/>
									<fo:table-body>
										<fo:table-row>
											<fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
												<fo:block>
													<fo:inline font-size="18pt" font-weight="bold" font-style="italic">Zerbitzu, mota eta espediente faseen zerrenda</fo:inline>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
								<fo:block>
									<xsl:text>&#xA;</xsl:text>
								</fo:block>
								<fo:table width="100%" space-before.optimum="4pt" space-after.optimum="4pt">
									<fo:table-column column-width="4cm"/>
									<fo:table-column column-width="1cm"/>
									<fo:table-column column-width="10cm"/>
									<fo:table-column column-width="2cm"/>
									<fo:table-column column-width="5cm"/>
									<fo:table-column column-width="2.5cm"/>
									<fo:table-body>
										<fo:table-row>
											<fo:table-cell text-align="right" padding-before="10pt" padding-after="10pt" padding-end="3pt">
												<fo:block>
													<fo:inline font-size="9pt" font-weight="bold" font-style="italic">Zerbitzua:</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="left" padding-before="10pt" padding-after="10pt" padding-end="6pt">
												<fo:block>
													<fo:inline font-size="9pt" font-style="italic"><xsl:value-of select="cserv13"/></fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="left" padding-before="10pt" padding-after="10pt">
												<fo:block>
													<fo:inline font-size="9pt" font-style="italic"><xsl:value-of select="eserv13"/> </fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell padding-before="10pt" padding-after="10pt">
												<fo:block/>
											</fo:table-cell>
											<fo:table-cell text-align="center" padding-before="10pt" padding-after="10pt" padding-end="3pt">
												<fo:block>
													<fo:inline font-size="9pt" font-weight="bold" font-style="italic">Egoera:</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="left" padding-before="10pt" padding-after="10pt">
												<fo:block>
													<fo:inline font-size="9pt" font-style="italic"><xsl:value-of select="situ13"/></fo:inline>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
								<fo:block>
									<xsl:text>&#xA;</xsl:text>
								</fo:block>
								<fo:table width="100%" space-before.optimum="6pt" space-after.optimum="6pt">
									<fo:table-column column-width="0.8cm"/>
									<fo:table-column column-width="3cm"/>
									<fo:table-column column-width="7cm"/>
									<fo:table-column column-width="2cm"/>
									<fo:table-column column-width="2cm"/>
									<fo:table-column column-width="2cm"/>
									<fo:table-column column-width="7cm"/>
									<fo:table-column column-width="2cm"/>
									<fo:table-column column-width="0.8cm"/>
									<fo:table-body>
										<fo:table-row border-after-color="black" border-after-style="solid" border-after-width="2pt" border-before-color="black" border-before-style="solid" border-before-width="2pt">
											<fo:table-cell>
												<fo:block/>
											</fo:table-cell>
											<fo:table-cell padding-end="14pt" padding-before="3pt" padding-after="3pt">
												<fo:block text-align="right">
													<fo:inline font-size="9pt" font-weight="bold" font-style="italic">Esp. codea.</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell padding-end="14pt" padding-before="3pt" padding-after="3pt">
										 		<fo:block text-align="center">
													<fo:inline font-size="9pt" font-weight="bold" font-style="italic">Deskribapena</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell padding-end="14pt" padding-before="3pt" padding-after="3pt">
										 		<fo:block text-align="center">
													<fo:inline font-size="9pt" font-weight="bold" font-style="italic">Tramitagarria </fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell padding-end="14pt" padding-before="3pt" padding-after="3pt">
										 		<fo:block text-align="center">
													<fo:inline font-size="9pt" font-weight="bold" font-style="italic">Egoera </fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell padding-end="3pt" padding-before="3pt" padding-after="3pt">
										 		<fo:block text-align="center">
													<fo:inline font-size="9pt" font-weight="bold" font-style="italic">Fase kod.</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell padding-end="3pt" padding-before="3pt" padding-after="3pt">
										 		<fo:block text-align="center">
													<fo:inline font-size="9pt" font-weight="bold" font-style="italic">Deskribapena</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell padding-end="3pt" padding-before="3pt" padding-after="3pt">
										 		<fo:block text-align="center">
													<fo:inline font-size="9pt" font-weight="bold" font-style="italic">Egoera</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell>
												<fo:block/>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell padding-before="6pt" padding-after="6pt">
												<fo:block/>
											</fo:table-cell>
										</fo:table-row>
										<xsl:for-each select="registro">
											<fo:table-row>
												<fo:table-cell>
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell padding-after="6pt" padding-before="3pt" padding-end="14pt">
													<fo:block font-size="7pt" text-align="right">
														<xsl:value-of select="ctipoe02"></xsl:value-of>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding-after="6pt" padding-before="3pt" padding-end="14pt">	
													<fo:block font-size="7pt" text-align="center">
														<xsl:value-of select="etipoe02"></xsl:value-of>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding-after="6pt" padding-before="3pt" padding-start="3pt" padding-end="3pt">	
													<fo:block font-size="7pt" text-align="center">
														<xsl:value-of select="ctrami02"></xsl:value-of>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding-after="6pt" padding-before="3pt" padding-start="3pt" padding-end="3pt">	
													<fo:block font-size="7pt" text-align="center">
														<xsl:value-of select="situ02"></xsl:value-of>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding-after="6pt" padding-before="3pt" padding-start="3pt" padding-end="3pt">	
													<fo:block font-size="7pt" text-align="center">
														<xsl:value-of select="cfase01"></xsl:value-of>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding-after="6pt" padding-before="3pt" padding-start="3pt" padding-end="3pt">	
													<fo:block font-size="7pt" text-align="center">
														<xsl:value-of select="efase01"></xsl:value-of>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding-after="6pt" padding-before="3pt" padding-start="3pt" padding-end="3pt">	
													<fo:block font-size="7pt" text-align="center">
														<xsl:value-of select="situ01"></xsl:value-of>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell>
													<fo:block/>
												</fo:table-cell>
												</fo:table-row>
										</xsl:for-each>
									</fo:table-body>
								</fo:table>

								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:block>
									<xsl:text>&#xA;</xsl:text>
								</fo:block>
							</fo:block>
							
						</xsl:for-each>
					</xsl:for-each>
					<fo:block id="TheVeryLastPage"> </fo:block>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
</xsl:stylesheet>
