<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="default-page-master" page-height="21cm" page-width="29.5cm" margin-top="0.5cm" margin-bottom="0.5cm" margin-left="1cm" margin-right="1cm">
				<fo:region-body margin-top="2.5cm" margin-bottom="0cm" font-family="Helvetica,Times,Courier" font-size="14pt" line-height="16pt"/>
				<fo:region-before margin-right="1cm" extent="1.9cm"/>
				<fo:region-after extent="0cm"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence master-reference="default-page-master" >
				<fo:static-content flow-name="xsl-region-before">
					<fo:table table-layout="fixed">
						<fo:table-column column-width="2.5cm"/>
						<fo:table-column column-width="22cm"/>
						<fo:table-column column-width="3.5cm"/>
						<fo:table-body display-align="center">
							<fo:table-row>
								<fo:table-cell text-align="left">
									<fo:block>
											<fo:inline font-size="8pt">
												<xsl:value-of select="expedientes/fecha"/>
											</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center" padding-start="25pt">
									<fo:block>
										<xsl:element name="fo:external-graphic">
											<xsl:attribute name="src">url('<xsl:value-of select="expedientes/imgLogoUrl"/>')</xsl:attribute>
										</xsl:element>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right">
									<fo:block>
										<fo:inline font-size="8pt" font-weight="bold" font-style="italic">
										Pág. <fo:page-number/> de 
										<fo:page-number-citation ref-id="TheVeryLastPage"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:static-content>
				<fo:flow flow-name="xsl-region-body">
					<xsl:for-each select="expedientes">
						<xsl:for-each select="servicio">
							<fo:block>
							<xsl:if test="position() != last()"><xsl:attribute name="break-after">page</xsl:attribute></xsl:if>
								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:block>
									<xsl:text>&#xA;</xsl:text>
								</fo:block>
								<fo:table width="100%" space-before.optimum="4pt" space-after.optimum="4pt">
									<fo:table-column column-width="100%"/>
									<fo:table-body>
										<fo:table-row>
											<fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
												<fo:block>
													<fo:inline font-size="18pt" font-weight="bold" font-style="italic">Informe de tramitación de expedientes</fo:inline>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
								<fo:block>
									<xsl:text>&#xA;</xsl:text>
								</fo:block>
								<fo:table width="100%" space-before.optimum="4pt" space-after.optimum="4pt">
									<fo:table-column column-width="2cm"/>
									<fo:table-column column-width="1cm"/>
									<fo:table-column column-width="9cm"/>
									<fo:table-column column-width="2cm"/>
									<fo:table-column column-width="1cm"/>
									<fo:table-column column-width="12.5cm"/>
									<fo:table-body>
										<xsl:for-each select="filtros">
											<xsl:for-each select="filtro">
											<fo:table-row>
												<fo:table-cell text-align="left" padding-before="1pt" padding-after="1pt" padding-end="3pt" number-columns-spanned="6">
													<fo:block>
														<fo:inline font-size="9pt" font-weight="bold" font-style="italic"><xsl:value-of select="valorFiltro"/></fo:inline>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											</xsl:for-each>
										</xsl:for-each>	
										<fo:table-row border-after-color="black" border-after-style="solid" border-after-width="2pt">
											<fo:table-cell text-align="left" padding-before="10pt" padding-after="10pt" padding-end="3pt">
												<fo:block>
													<fo:inline font-size="9pt" font-weight="bold" font-style="italic" text-decoration="underline">Servicio:</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="left" padding-before="10pt" padding-after="10pt" padding-end="6pt">
												<fo:block>
													<fo:inline font-size="9pt" font-style="italic"><xsl:value-of select="cserv20"/></fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="left" padding-before="10pt" padding-after="10pt">
												<fo:block>
													<fo:inline font-size="9pt" font-style="italic"><xsl:value-of select="dserv20"/> </fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="left" padding-before="10pt" padding-after="10pt" padding-end="3pt">
												<fo:block>
													<fo:inline font-size="9pt" font-weight="bold" font-style="italic" text-decoration="underline">Responsable:</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="left" padding-before="10pt" padding-after="10pt" padding-end="6pt">
												<fo:block>
													<fo:inline font-size="9pt" font-style="italic"><xsl:value-of select="crespo20"/></fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell text-align="left" padding-before="10pt" padding-after="10pt" padding-end="6pt">
												<fo:block>
													<fo:inline font-size="9pt" font-style="italic"><xsl:value-of select="responsable"/></fo:inline>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
								<fo:block>
									<xsl:text>&#xA;</xsl:text>
								</fo:block>
								<fo:table width="100%" space-before.optimum="6pt" space-after.optimum="6pt">
									<fo:table-column column-width="0.8cm"/>
									<fo:table-column column-width="1cm"/>
									<fo:table-column column-width="3cm"/>
									<fo:table-column column-width="3cm"/>
									<fo:table-column column-width="3cm"/>
									<fo:table-column column-width="4cm"/>
									<fo:table-column column-width="3cm"/>
									<fo:table-column column-width="8cm"/>
									<fo:table-column column-width="0.8cm"/>
									<fo:table-body>
										<xsl:for-each select="expediente">
											<fo:table-row >
												<fo:table-cell>
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell padding-after="4pt" padding-before="4pt">
													<fo:block font-size="8pt" text-align="left">
														<xsl:value-of select="contador"></xsl:value-of>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding-after="4pt" padding-before="4pt">	
													<fo:block font-size="8pt" text-align="left">
														<xsl:value-of select="refExp"></xsl:value-of>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding-after="4pt" padding-before="4pt">
													<fo:block text-align="left" font-size="8pt" font-weight="bold" font-style="italic">
														Objeto
													</fo:block>
												</fo:table-cell>	
												<fo:table-cell number-columns-spanned="5" padding-after="2pt" padding-before="2pt">	
													<fo:block font-size="8pt" text-align="left">
														<xsl:value-of select="objeto"></xsl:value-of>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>	
												<fo:table-cell padding-after="4pt" padding-before="4pt">
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell padding-after="4pt" padding-before="4pt">
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell padding-after="4pt" padding-before="4pt">
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell padding-after="4pt" padding-before="4pt">
													<fo:block text-align="left" font-size="8pt" font-weight="bold" font-style="italic">
														Municipio
													</fo:block>
												</fo:table-cell>
												<fo:table-cell number-columns-spanned="2" padding-after="4pt" padding-before="4pt">	
													<fo:block font-size="8pt" text-align="left">
														<xsl:value-of select="municipio"></xsl:value-of>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding-after="4pt" padding-before="4pt">
													<fo:block text-align="left" font-size="8pt" font-weight="bold" font-style="italic">
														Departamento
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding-after="4pt" padding-before="4pt">	
													<fo:block font-size="8pt" text-align="left">
														<xsl:value-of select="departamentoCas"></xsl:value-of>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding-after="4pt" padding-before="4pt">
													<fo:block/>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>	
												<fo:table-cell padding-after="4pt" padding-before="4pt">
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell padding-after="4pt" padding-before="4pt">
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell padding-after="4pt" padding-before="4pt">
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell padding-after="4pt" padding-before="4pt">
													<fo:block text-align="left" font-size="8pt" font-weight="bold" font-style="italic">
														F. apertura
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding-after="4pt" padding-before="4pt">	
													<fo:block font-size="8pt" text-align="left">
														<xsl:value-of select="faper"></xsl:value-of>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding-after="4pt" padding-before="4pt">
													<fo:block text-align="left" font-size="8pt" font-weight="bold" font-style="italic">
														F. última fase completada
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding-after="4pt" padding-before="4pt">	
													<fo:block font-size="8pt" text-align="left">
														<xsl:value-of select="fcier"></xsl:value-of>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding-after="4pt" padding-before="4pt">
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell padding-after="4pt" padding-before="4pt">
													<fo:block/>
												</fo:table-cell>
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding-after="4pt" padding-before="4pt">
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell padding-after="4pt" padding-before="4pt">
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell padding-after="4pt" padding-before="4pt">
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell padding-after="4pt" padding-before="4pt">
													<fo:block text-align="left" font-size="8pt" font-weight="bold" font-style="italic">
														Observaciones
													</fo:block>
												</fo:table-cell>
												<fo:table-cell number-columns-spanned="5" padding-after="4pt" padding-before="4pt">	
													<fo:block font-size="8pt" text-align="left">
														<xsl:value-of select="observaciones"></xsl:value-of>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</xsl:for-each>
									</fo:table-body>
								</fo:table>

								<fo:block>
									<fo:leader leader-pattern="space"/>
								</fo:block>
								<fo:block>
									<xsl:text>&#xA;</xsl:text>
								</fo:block>
							</fo:block>
							
						</xsl:for-each>
					</xsl:for-each>
					<fo:block id="TheVeryLastPage"> </fo:block>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
</xsl:stylesheet>
