<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<xsl:variable name="fo:layout-master-set">
		<fo:layout-master-set>
			<fo:simple-page-master master-name="default-page-master" page-height="29.5cm" page-width="21cm" margin-top="0.5cm" margin-bottom="0.5cm" margin-left="1cm" margin-right="1cm">
				<fo:region-body margin-top="2.5cm" margin-bottom="0cm" font-family="Helvetica,Times,Courier" font-size="14pt" line-height="16pt"/>
				<fo:region-before margin-right="1cm" extent="1.9cm"/>
				<fo:region-after extent="0cm"/>
			</fo:simple-page-master>
		</fo:layout-master-set>
	</xsl:variable>
	<xsl:template match="/">
		<fo:root>
			<xsl:copy-of select="$fo:layout-master-set"/>
			<fo:page-sequence master-reference="default-page-master">
				<fo:static-content flow-name="xsl-region-before">
					<fo:table table-layout="fixed">
						<fo:table-column column-width="2.5cm"/>
						<fo:table-column column-width="14cm"/>
						<fo:table-column column-width="2.5cm"/>
						<fo:table-body display-align="center">
							<fo:table-row>
								<fo:table-cell text-align="left">
									<fo:block>
											<fo:inline font-size="8pt">
												<xsl:value-of select="expediente/fecha"/>
											</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="center" padding-start="25pt">
									<fo:block>
										<xsl:element name="fo:external-graphic">
											<xsl:attribute name="src">url('<xsl:value-of select="expediente/imgLogoUrl"/>')</xsl:attribute>
										</xsl:element>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell text-align="right">
									<fo:block>
										<fo:inline font-size="8pt" font-weight="bold" font-style="italic">
										 <fo:page-number/> / 
										<fo:page-number-citation ref-id="TheVeryLastPage"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:static-content>
				<!-- fo:static-content flow-name="xsl-region-after">
               		<fo:table>
					<fo:table-column column-width="proportional-column-width(1)"/>
						<fo:table-body display-align="center">
							<fo:table-row>
								<fo:table-cell>
									<fo:block font-size="11pt" text-align="center">
										<fo:inline>Prueba de pie</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
				</fo:static-content-->
				
				<fo:flow flow-name="xsl-region-body">
					<xsl:for-each select="expediente">
						<fo:block>
						<xsl:if test="position() != last()"><xsl:attribute name="break-after">page</xsl:attribute></xsl:if>
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:block>
								<xsl:text>&#xA;</xsl:text>
							</fo:block>
							<fo:table width="100%" space-before.optimum="4pt" space-after.optimum="4pt">
								<fo:table-column column-width="100%"/>
								<fo:table-body>
									<fo:table-row>
										<fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
											<fo:block>
												<fo:inline font-size="16pt" font-weight="bold" text-decoration="underline">ESPEDIENTEAREN FITXA <xsl:value-of select="refExp"></xsl:value-of></fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
							<fo:block>
								<xsl:text>&#xA;</xsl:text>
							</fo:block>
							
							<fo:table width="100%" space-before.optimum="6pt" space-after.optimum="6pt">
								<fo:table-column column-width="0.8cm"/>
								<fo:table-column/>
								<fo:table-column column-width="13cm"/>
								<fo:table-column column-width="0.8cm"/>
								<fo:table-body>		
									<fo:table-row>
										<fo:table-cell padding-before="6pt" padding-after="6pt">
											<fo:block/>
										</fo:table-cell>
										<fo:table-cell padding-before="3pt" padding-after="3pt">
											<fo:block text-align="left">
												<fo:inline font-size="10pt" font-weight="bold">XEDEA:</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell padding-before="3pt" padding-after="3pt">
									 		<fo:block text-align="left">
												<fo:inline font-size="10pt"><xsl:value-of select="objeto"></xsl:value-of></fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell>
											<fo:block/>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding-before="6pt" padding-after="6pt">
											<fo:block/>
										</fo:table-cell>
										<fo:table-cell padding-before="3pt" padding-after="3pt">
											<fo:block text-align="left">
												<fo:inline font-size="10pt" font-weight="bold">SAILA:</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell padding-before="3pt" padding-after="3pt">
									 		<fo:block text-align="left">
												<fo:inline font-size="10pt"><xsl:value-of select="departamentoEusk"></xsl:value-of></fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell>
											<fo:block/>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>		
							<fo:table width="100%" space-before.optimum="6pt" space-after.optimum="6pt">
								<fo:table-column column-width="0.8cm"/>
								<fo:table-column/>
								<fo:table-column/>
								<fo:table-column/>
								<fo:table-column/>
								<fo:table-column column-width="0.8cm"/>
								<fo:table-body>		
									<fo:table-row>
										<fo:table-cell padding-before="6pt" padding-after="6pt">
											<fo:block/>
										</fo:table-cell>
										<fo:table-cell padding-before="3pt" padding-after="3pt">
											<fo:block text-align="left">
												<fo:inline font-size="10pt" font-weight="bold">PROBINTZIA:</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell padding-before="3pt" padding-after="3pt">
									 		<fo:block text-align="left">
												<fo:inline font-size="10pt"><xsl:value-of select="desProvincia"></xsl:value-of></fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell padding-before="3pt" padding-after="3pt">
											<fo:block text-align="left">
												<fo:inline font-size="10pt" font-weight="bold">HERRIALDEA:</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell padding-before="3pt" padding-after="3pt">
									 		<fo:block text-align="left">
												<fo:inline font-size="10pt"><xsl:value-of select="desMunicipio"></xsl:value-of></fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell>
											<fo:block/>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
							
							<fo:block>
								<xsl:text>&#xA;</xsl:text>
							</fo:block>
							<fo:table width="100%" space-before.optimum="4pt" space-after.optimum="4pt">
								<fo:table-column column-width="100%"/>
								<fo:table-body>
									<fo:table-row>
										<fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
											<fo:block>
												<fo:inline font-size="14pt" font-weight="bold" text-decoration="underline">BESTELAKO DATUAK</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
							<fo:block>
								<xsl:text>&#xA;</xsl:text>
							</fo:block>
							<fo:table width="100%" space-before.optimum="6pt" space-after.optimum="6pt">
								<fo:table-column column-width="0.8cm"/>
								<fo:table-column/>
								<fo:table-column column-width="13cm"/>
								<fo:table-column column-width="0.8cm"/>
								<fo:table-body>
									<fo:table-row>
										<fo:table-cell padding-before="6pt" padding-after="6pt">
											<fo:block/>
										</fo:table-cell>
										<fo:table-cell padding-before="3pt" padding-after="3pt">
											<fo:block text-align="left">
												<fo:inline font-size="10pt" font-weight="bold">1. ZENBATEKOA:</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell padding-before="3pt" padding-after="3pt">
									 		<fo:block text-align="left">
												<fo:inline font-size="10pt"><xsl:value-of select="importeExp"></xsl:value-of></fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell>
											<fo:block/>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding-before="6pt" padding-after="6pt">
											<fo:block/>
										</fo:table-cell>
										<fo:table-cell padding-before="3pt" padding-after="3pt">
											<fo:block text-align="left">
												<fo:inline font-size="10pt" font-weight="bold">2. ZENBATEKOA:</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell padding-before="3pt" padding-after="3pt">
									 		<fo:block text-align="left">
												<fo:inline font-size="10pt"><xsl:value-of select="importeAdj"></xsl:value-of></fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell>
											<fo:block/>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>		
							<fo:table width="100%" space-before.optimum="6pt" space-after.optimum="6pt">
								<fo:table-column column-width="0.8cm"/>
								<fo:table-column/>
								<fo:table-column column-width="13cm"/>
								<fo:table-column column-width="0.8cm"/>
								<fo:table-body>	
									<fo:table-row>
										<fo:table-cell padding-before="6pt" padding-after="6pt">
											<fo:block/>
										</fo:table-cell>
										<fo:table-cell padding-before="3pt" padding-after="3pt">
											<fo:block text-align="left">
												<fo:inline font-size="10pt" font-weight="bold">OHARRAK:</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell padding-before="3pt" padding-after="3pt">
									 		<fo:block text-align="left">
												<fo:inline font-size="10pt"><xsl:value-of select="observaciones"></xsl:value-of></fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell>
											<fo:block/>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding-before="6pt" padding-after="6pt">
											<fo:block/>
										</fo:table-cell>
										<fo:table-cell padding-before="3pt" padding-after="3pt">
											<fo:block text-align="left">
												<fo:inline font-size="10pt" font-weight="bold">INBENTARIO ZK:</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell padding-before="3pt" padding-after="3pt">
									 		<fo:block text-align="left">
												<fo:inline font-size="10pt"><xsl:value-of select="referencia"></xsl:value-of></fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell>
											<fo:block/>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>		
							
							
							
							<fo:block>
								<xsl:text>&#xA;</xsl:text>
							</fo:block>
							<fo:table width="100%" space-before.optimum="4pt" space-after.optimum="4pt">
								<fo:table-column column-width="100%"/>
								<fo:table-body>
									<fo:table-row>
										<fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
											<fo:block>
												<fo:inline font-size="14pt" font-weight="bold" text-decoration="underline">EGOERA</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
							<fo:block>
								<xsl:text>&#xA;</xsl:text>
							</fo:block>
							<fo:table width="100%" space-before.optimum="6pt" space-after.optimum="6pt">
								<fo:table-column column-width="0.8cm"/>
								<fo:table-column/>
								<fo:table-column column-width="13cm"/>
								<fo:table-column column-width="0.8cm"/>
								<fo:table-body>	
									<fo:table-row>
										<fo:table-cell padding-before="10pt" padding-after="6pt">
											<fo:block/>
										</fo:table-cell>
										<fo:table-cell padding-before="3pt" padding-after="3pt">
											<fo:block text-align="left">
												<fo:inline font-size="10pt" font-weight="bold">ARDURADUNA:</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell padding-before="3pt" padding-after="3pt">
									 		<fo:block text-align="left">
												<fo:inline font-size="10pt"><xsl:value-of select="desResponsable"></xsl:value-of></fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell>
											<fo:block/>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding-before="6pt" padding-after="6pt">
											<fo:block/>
										</fo:table-cell>
										<fo:table-cell padding-before="3pt" padding-after="3pt">
											<fo:block text-align="left">
												<fo:inline font-size="10pt" font-weight="bold">ZERBITZUA:</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell padding-before="3pt" padding-after="3pt">
									 		<fo:block text-align="left">
												<fo:inline font-size="10pt"><xsl:value-of select="desServicioEusk"></xsl:value-of></fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell>
											<fo:block/>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>		
							<fo:table width="100%" space-before.optimum="6pt" space-after.optimum="6pt">
								<fo:table-column column-width="0.8cm"/>
								<fo:table-column/>
								<fo:table-column/>
								<fo:table-column/>
								<fo:table-column/>
								<fo:table-column column-width="0.8cm"/>
								<fo:table-body>		
									<fo:table-row>
										<fo:table-cell padding-before="6pt" padding-after="6pt">
											<fo:block/>
										</fo:table-cell>
										<fo:table-cell padding-before="3pt" padding-after="3pt">
											<fo:block text-align="left">
												<fo:inline font-size="10pt" font-weight="bold">IREKITZE D.:</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell padding-before="3pt" padding-after="3pt">
									 		<fo:block text-align="left">
												<fo:inline font-size="10pt"><xsl:value-of select="faper"></xsl:value-of></fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell padding-before="3pt" padding-after="3pt">
											<fo:block text-align="left">
												<fo:inline font-size="10pt" font-weight="bold">ITXIERA D.:</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell padding-before="3pt" padding-after="3pt">
									 		<fo:block text-align="left">
												<fo:inline font-size="10pt"><xsl:value-of select="fcier"></xsl:value-of></fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell>
											<fo:block/>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>		
							<fo:table width="100%" space-before.optimum="6pt" space-after.optimum="6pt">
							<fo:table-column column-width="0.8cm"/>
							<fo:table-column/>
							<fo:table-column column-width="13cm"/>
							<fo:table-column column-width="0.8cm"/>
							<fo:table-body>		
									<fo:table-row>
										<fo:table-cell padding-before="6pt" padding-after="6pt">
											<fo:block/>
										</fo:table-cell>
										<fo:table-cell padding-before="3pt" padding-after="3pt">
											<fo:block text-align="left">
												<fo:inline font-size="10pt" font-weight="bold">EGOERA:</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell padding-before="3pt" padding-after="3pt">
									 		<fo:block text-align="left">
												<fo:inline font-size="10pt"><xsl:value-of select="estadoEusk"></xsl:value-of></fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell>
											<fo:block/>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>		
							<fo:table width="100%" space-before.optimum="6pt" space-after.optimum="6pt">
							<fo:table-column column-width="0.8cm"/>
							<fo:table-column/>
							<fo:table-column/>
							<fo:table-column/>
							<fo:table-column/>
							<fo:table-column column-width="0.8cm"/>
								<fo:table-body>	
									<fo:table-row>
										<fo:table-cell padding-before="6pt" padding-after="6pt">
											<fo:block/>
										</fo:table-cell>
										<fo:table-cell padding-before="3pt" padding-after="3pt">
											<fo:block text-align="left">
												<fo:inline font-size="10pt" font-weight="bold">PROZEDURA:</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell padding-before="3pt" padding-after="3pt">
									 		<fo:block text-align="left">
												<fo:inline font-size="10pt"><xsl:value-of select="desArchivoEusk"></xsl:value-of></fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell padding-before="3pt" padding-after="3pt">
											<fo:block text-align="left">
												<fo:inline font-size="10pt" font-weight="bold">ESPEDIENTE BAJA:</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell padding-before="3pt" padding-after="3pt">
									 		<fo:block text-align="left">
												<fo:inline font-size="10pt"><xsl:value-of select="signatura"></xsl:value-of></fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell>
											<fo:block/>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>		
							
							
							
							<xsl:if test="@tieneFases!='no'">
								<fo:block>
									<xsl:text>&#xA;</xsl:text>
								</fo:block>
								<fo:table width="100%" space-before.optimum="4pt" space-after.optimum="4pt">
									<fo:table-column column-width="100%"/>
									<fo:table-body>
										<fo:table-row>
											<fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
												<fo:block>
													<fo:inline font-size="14pt" font-weight="bold" text-decoration="underline">FASEAK</fo:inline>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
								<fo:block>
									<xsl:text>&#xA;</xsl:text>
								</fo:block>
								<fo:table width="100%" space-before.optimum="6pt" space-after.optimum="6pt">
									<fo:table-column column-width="0.8cm"/>
									<fo:table-column column-width="8cm"/>
									<fo:table-column column-width="4cm"/>
									<fo:table-column column-width="4cm"/>
									<fo:table-column column-width="0.8cm"/>
									<fo:table-body>
										<fo:table-row>
											<fo:table-cell padding-before="6pt" padding-after="6pt">
												<fo:block/>
											</fo:table-cell>
											<fo:table-cell padding-end="14pt" padding-before="3pt" padding-after="3pt">
												<fo:block text-align="left">
													<fo:inline font-size="10pt" font-weight="bold">FASEA</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell padding-end="14pt" padding-before="3pt" padding-after="3pt">
												<fo:block text-align="left">
													<fo:inline font-size="10pt" font-weight="bold">AURREIKUSITAKO D.</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell padding-end="14pt" padding-before="3pt" padding-after="3pt">
												<fo:block text-align="left">
													<fo:inline font-size="10pt" font-weight="bold">D. ERREALA</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell>
												<fo:block/>
											</fo:table-cell>
										</fo:table-row>
										<xsl:for-each select="fasesExp">
											<xsl:for-each select="fase">
												<fo:table-row>
													<fo:table-cell>
														<fo:block/>
													</fo:table-cell>
													<fo:table-cell padding-end="14pt" padding-before="3pt" padding-after="3pt">
												 		<fo:block text-align="left">
															<fo:inline font-size="10pt"><xsl:value-of select="descFaseEusk"></xsl:value-of></fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell padding-end="14pt" padding-before="3pt" padding-after="3pt">
												 		<fo:block text-align="left">
															<fo:inline font-size="10pt"><xsl:value-of select="fecPrevi"></xsl:value-of></fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell padding-end="14pt" padding-before="3pt" padding-after="3pt">
												 		<fo:block text-align="left">
															<fo:inline font-size="10pt"><xsl:value-of select="fecReal"></xsl:value-of></fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell>
														<fo:block/>
													</fo:table-cell>
												</fo:table-row>
											</xsl:for-each>	
										</xsl:for-each>	
									</fo:table-body>
								</fo:table>		
							</xsl:if>
							
							
							<xsl:if test="@tieneDocs!='no'">
								<fo:block>
									<xsl:text>&#xA;</xsl:text>
								</fo:block>
								<fo:table width="100%" space-before.optimum="4pt" space-after.optimum="4pt">
									<fo:table-column column-width="100%"/>
									<fo:table-body>
										<fo:table-row>
											<fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
												<fo:block>
													<fo:inline font-size="14pt" font-weight="bold" text-decoration="underline">DOKUMENTUAK</fo:inline>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
								<fo:block>
									<xsl:text>&#xA;</xsl:text>
								</fo:block>
								<fo:table width="100%" space-before.optimum="6pt" space-after.optimum="6pt">
									<fo:table-column column-width="0.8cm"/>
									<fo:table-column column-width="4cm"/>
									<fo:table-column column-width="8cm"/>
									<fo:table-column column-width="4cm"/>
									<fo:table-column column-width="4cm"/>
									<fo:table-column column-width="0.8cm"/>
									<fo:table-body>
										<fo:table-row>
											<fo:table-cell padding-before="6pt" padding-after="6pt">
												<fo:block/>
											</fo:table-cell>
											<fo:table-cell padding-end="14pt" padding-before="3pt" padding-after="3pt">
												<fo:block text-align="left">
													<fo:inline font-size="10pt" font-weight="bold">DOKUMENTUA</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell padding-end="14pt" padding-before="3pt" padding-after="3pt">
												<fo:block text-align="left">
													<fo:inline font-size="10pt" font-weight="bold">DESKRIBAPENA</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell padding-end="14pt" padding-before="3pt" padding-after="3pt">
												<fo:block text-align="left">
													<fo:inline font-size="10pt" font-weight="bold">ANOTAZIO D.</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell padding-end="14pt" padding-before="3pt" padding-after="3pt">
												<fo:block text-align="left">
													<fo:inline font-size="10pt" font-weight="bold">ANOTAZIO Z.</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell>
												<fo:block/>
											</fo:table-cell>
										</fo:table-row>
										<xsl:for-each select="documentosExp">
											<xsl:for-each select="documento">
												<fo:table-row>
													<fo:table-cell>
														<fo:block/>
													</fo:table-cell>
													<fo:table-cell padding-end="14pt" padding-before="3pt" padding-after="3pt">
												 		<fo:block text-align="left">
															<fo:inline font-size="10pt"><xsl:value-of select="codDocumento"></xsl:value-of></fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell padding-end="14pt" padding-before="3pt" padding-after="3pt">
												 		<fo:block text-align="left">
															<fo:inline font-size="10pt"><xsl:value-of select="descripcionEusk"></xsl:value-of></fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell padding-end="14pt" padding-before="3pt" padding-after="3pt">
												 		<fo:block text-align="left">
															<fo:inline font-size="10pt"><xsl:value-of select="fAnotacion"></xsl:value-of></fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell padding-end="14pt" padding-before="3pt" padding-after="3pt">
												 		<fo:block text-align="left">
															<fo:inline font-size="10pt"><xsl:value-of select="nAnotacion"></xsl:value-of></fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell>
														<fo:block/>
													</fo:table-cell>
												</fo:table-row>
											</xsl:for-each>	
										</xsl:for-each>	
									</fo:table-body>
								</fo:table>
							</xsl:if>			
							<fo:block>
								<xsl:text>&#xA;</xsl:text>
							</fo:block>
							<fo:table width="100%" space-before.optimum="4pt" space-after.optimum="4pt">
								<fo:table-column column-width="100%"/>
								<fo:table-body>
									<fo:table-row>
										<fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
											<fo:block>
												<fo:inline font-size="14pt" font-weight="bold" text-decoration="underline">ELKARTUTAKO ESPEDIENTEAK</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
							<fo:block>
								<xsl:text>&#xA;</xsl:text>
							</fo:block>
							<fo:table width="100%" space-before.optimum="6pt" space-after.optimum="6pt">
								<fo:table-column column-width="0.8cm"/>
								<fo:table-column/>
								<fo:table-column column-width="0.8cm"/>
								<fo:table-body>
									<fo:table-row>
										<fo:table-cell>
											<fo:block/>
										</fo:table-cell>
										<fo:table-cell padding-end="14pt" padding-before="3pt" padding-after="3pt">
								 			<fo:block text-align="left">
								 				<xsl:for-each select="expAsociados">
													<xsl:for-each select="expAsociado">
														<fo:inline font-size="10pt"><xsl:value-of select="referencia"></xsl:value-of></fo:inline><xsl:text>&#x9;</xsl:text>
													</xsl:for-each>
												</xsl:for-each>		
											</fo:block>
										</fo:table-cell>
										<fo:table-cell>
											<fo:block/>
										</fo:table-cell>		
									</fo:table-row>
								</fo:table-body>
							</fo:table>	
							
							<!-- fo:block>
								<xsl:text>&#xA;</xsl:text>
							</fo:block>
							<fo:table width="100%" space-before.optimum="4pt" space-after.optimum="4pt">
								<fo:table-column column-width="100%"/>
								<fo:table-body>
									<fo:table-row>
										<fo:table-cell text-align="center" padding-start="3pt" padding-end="3pt" padding-before="3pt" padding-after="3pt">
											<fo:block>
												<fo:inline font-size="14pt" font-weight="bold" text-decoration="underline">ARDURADUNEN HISTORIKOA</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
							<fo:block>
								<xsl:text>&#xA;</xsl:text>
							</fo:block>
							<fo:table width="100%" space-before.optimum="6pt" space-after.optimum="6pt">
								<fo:table-column column-width="0.8cm"/>
								<fo:table-column column-width="4cm"/>
								<fo:table-column column-width="8cm"/>
								<fo:table-column column-width="4cm"/>
								<fo:table-column column-width="0.8cm"/>
								<fo:table-body>
									<fo:table-row>
										<fo:table-cell padding-before="6pt" padding-after="6pt">
											<fo:block/>
										</fo:table-cell>
										<fo:table-cell padding-end="14pt" padding-before="3pt" padding-after="3pt">
											<fo:block text-align="left">
												<fo:inline font-size="10pt" font-weight="bold">KODEA</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell padding-end="14pt" padding-before="3pt" padding-after="3pt">
											<fo:block text-align="left">
												<fo:inline font-size="10pt" font-weight="bold">IZENA</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell padding-end="14pt" padding-before="3pt" padding-after="3pt">
											<fo:block text-align="left">
												<fo:inline font-size="10pt" font-weight="bold">DATA</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell>
											<fo:block/>
										</fo:table-cell>
									</fo:table-row>
									<xsl:for-each select="historicosResp">
										<xsl:for-each select="respHist">
											<fo:table-row>
												<fo:table-cell>
													<fo:block/>
												</fo:table-cell>
												<fo:table-cell padding-end="14pt" padding-before="3pt" padding-after="3pt">
											 		<fo:block text-align="left">
														<fo:inline font-size="10pt"><xsl:value-of select="codRespHist"></xsl:value-of></fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding-end="14pt" padding-before="3pt" padding-after="3pt">
											 		<fo:block text-align="left">
														<fo:inline font-size="10pt"><xsl:value-of select="descRespHist"></xsl:value-of></fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell padding-end="14pt" padding-before="3pt" padding-after="3pt">
											 		<fo:block text-align="left">
														<fo:inline font-size="10pt"><xsl:value-of select="fRespHist"></xsl:value-of></fo:inline>
													</fo:block>
												</fo:table-cell>
												<fo:table-cell>
													<fo:block/>
												</fo:table-cell>
											</fo:table-row>
										</xsl:for-each>	
									</xsl:for-each>	
								</fo:table-body>
							</fo:table-->		
							
							
							<fo:block>
								<fo:leader leader-pattern="space"/>
							</fo:block>
							<fo:block>
								<xsl:text>&#xA;</xsl:text>
							</fo:block>
						</fo:block>
					</xsl:for-each>
				<fo:block id="TheVeryLastPage"> </fo:block>
			</fo:flow>
		</fo:page-sequence>
		</fo:root>
	</xsl:template>
</xsl:stylesheet>
