/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.mvc.condition;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.mvc.condition.AbstractMediaTypeExpression;
import org.springframework.web.servlet.mvc.condition.AbstractRequestCondition;
import org.springframework.web.servlet.mvc.condition.HeadersRequestCondition;
import org.springframework.web.servlet.mvc.condition.MediaTypeExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProducesRequestCondition
extends AbstractRequestCondition<ProducesRequestCondition> {
    private final List<ProduceMediaTypeExpression> expressions;
    private static final List<ProduceMediaTypeExpression> DEFAULT_EXPRESSION_LIST = Arrays.asList(new ProduceMediaTypeExpression("*/*"));

    public ProducesRequestCondition(String ... produces) {
        this(ProducesRequestCondition.parseExpressions(produces, null));
    }

    public ProducesRequestCondition(String[] produces, String[] headers) {
        this(ProducesRequestCondition.parseExpressions(produces, headers));
    }

    private ProducesRequestCondition(Collection<ProduceMediaTypeExpression> expressions) {
        this.expressions = new ArrayList<ProduceMediaTypeExpression>(expressions);
        Collections.sort(this.expressions);
    }

    private static Set<ProduceMediaTypeExpression> parseExpressions(String[] produces, String[] headers) {
        int n;
        int n2;
        String[] stringArray;
        LinkedHashSet<ProduceMediaTypeExpression> result = new LinkedHashSet<ProduceMediaTypeExpression>();
        if (headers != null) {
            stringArray = headers;
            n2 = headers.length;
            n = 0;
            while (n < n2) {
                String header = stringArray[n];
                HeadersRequestCondition.HeaderExpression expr = new HeadersRequestCondition.HeaderExpression(header);
                if ("Accept".equalsIgnoreCase(expr.name)) {
                    for (MediaType mediaType : MediaType.parseMediaTypes((String)((String)expr.value))) {
                        result.add(new ProduceMediaTypeExpression(mediaType, expr.isNegated));
                    }
                }
                ++n;
            }
        }
        if (produces != null) {
            stringArray = produces;
            n2 = produces.length;
            n = 0;
            while (n < n2) {
                String produce = stringArray[n];
                result.add(new ProduceMediaTypeExpression(produce));
                ++n;
            }
        }
        return result;
    }

    public Set<MediaTypeExpression> getExpressions() {
        return new LinkedHashSet<MediaTypeExpression>(this.expressions);
    }

    public Set<MediaType> getProducibleMediaTypes() {
        LinkedHashSet<MediaType> result = new LinkedHashSet<MediaType>();
        for (ProduceMediaTypeExpression expression : this.expressions) {
            if (expression.isNegated()) continue;
            result.add(expression.getMediaType());
        }
        return result;
    }

    public boolean isEmpty() {
        return this.expressions.isEmpty();
    }

    @Override
    protected List<ProduceMediaTypeExpression> getContent() {
        return this.expressions;
    }

    @Override
    protected String getToStringInfix() {
        return " || ";
    }

    @Override
    public ProducesRequestCondition combine(ProducesRequestCondition other) {
        return !other.expressions.isEmpty() ? other : this;
    }

    @Override
    public ProducesRequestCondition getMatchingCondition(HttpServletRequest request) {
        if (this.isEmpty()) {
            return this;
        }
        LinkedHashSet<ProduceMediaTypeExpression> result = new LinkedHashSet<ProduceMediaTypeExpression>(this.expressions);
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            ProduceMediaTypeExpression expression = (ProduceMediaTypeExpression)iterator.next();
            if (expression.match(request)) continue;
            iterator.remove();
        }
        return result.isEmpty() ? null : new ProducesRequestCondition(result);
    }

    @Override
    public int compareTo(ProducesRequestCondition other, HttpServletRequest request) {
        List<MediaType> acceptedMediaTypes = ProducesRequestCondition.getAcceptedMediaTypes(request);
        MediaType.sortByQualityValue(acceptedMediaTypes);
        for (MediaType acceptedMediaType : acceptedMediaTypes) {
            int otherIndex;
            int thisIndex = this.indexOfEqualMediaType(acceptedMediaType);
            int result = ProducesRequestCondition.compareMatchingMediaTypes(this, thisIndex, other, otherIndex = other.indexOfEqualMediaType(acceptedMediaType));
            if (result != 0) {
                return result;
            }
            thisIndex = this.indexOfIncludedMediaType(acceptedMediaType);
            result = ProducesRequestCondition.compareMatchingMediaTypes(this, thisIndex, other, otherIndex = other.indexOfIncludedMediaType(acceptedMediaType));
            if (result == 0) continue;
            return result;
        }
        return 0;
    }

    private static List<MediaType> getAcceptedMediaTypes(HttpServletRequest request) {
        String acceptHeader = request.getHeader("Accept");
        if (StringUtils.hasLength((String)acceptHeader)) {
            return MediaType.parseMediaTypes((String)acceptHeader);
        }
        return Collections.singletonList(MediaType.ALL);
    }

    private int indexOfEqualMediaType(MediaType mediaType) {
        int i = 0;
        while (i < this.getExpressionsToCompare().size()) {
            MediaType currentMediaType = this.getExpressionsToCompare().get(i).getMediaType();
            if (mediaType.getType().equalsIgnoreCase(currentMediaType.getType()) && mediaType.getSubtype().equalsIgnoreCase(currentMediaType.getSubtype())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int indexOfIncludedMediaType(MediaType mediaType) {
        int i = 0;
        while (i < this.getExpressionsToCompare().size()) {
            if (mediaType.includes(this.getExpressionsToCompare().get(i).getMediaType())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private static int compareMatchingMediaTypes(ProducesRequestCondition condition1, int index1, ProducesRequestCondition condition2, int index2) {
        int result = 0;
        if (index1 != index2) {
            result = index2 - index1;
        } else if (index1 != -1 && index2 != -1) {
            ProduceMediaTypeExpression expr2;
            ProduceMediaTypeExpression expr1 = condition1.getExpressionsToCompare().get(index1);
            result = expr1.compareTo(expr2 = condition2.getExpressionsToCompare().get(index2));
            result = result != 0 ? result : expr1.getMediaType().compareTo(expr2.getMediaType());
        }
        return result;
    }

    private List<ProduceMediaTypeExpression> getExpressionsToCompare() {
        return this.expressions.isEmpty() ? DEFAULT_EXPRESSION_LIST : this.expressions;
    }

    static class ProduceMediaTypeExpression
    extends AbstractMediaTypeExpression {
        ProduceMediaTypeExpression(MediaType mediaType, boolean negated) {
            super(mediaType, negated);
        }

        ProduceMediaTypeExpression(String expression) {
            super(expression);
        }

        protected boolean matchMediaType(HttpServletRequest request) {
            List acceptedMediaTypes = ProducesRequestCondition.getAcceptedMediaTypes(request);
            for (MediaType acceptedMediaType : acceptedMediaTypes) {
                if (!this.getMediaType().isCompatibleWith(acceptedMediaType)) continue;
                return true;
            }
            return false;
        }
    }
}

