/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles;

import java.util.Map;
import org.apache.tiles.Attribute;
import org.apache.tiles.BasicAttributeContext;
import org.apache.tiles.CompareUtil;
import org.apache.tiles.Expression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Definition
extends BasicAttributeContext {
    protected String inherit;
    protected String name = null;

    public Definition() {
    }

    public Definition(Definition definition) {
        super(definition);
        this.name = definition.name;
        this.inherit = definition.inherit;
    }

    public Definition(String name, String template, Map<String, Attribute> attributes) {
        this(name, Attribute.createTemplateAttribute(template), attributes);
    }

    public Definition(String name, Attribute templateAttribute, Map<String, Attribute> attributes) {
        super(attributes);
        this.name = name;
        this.templateAttribute = templateAttribute;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    @Deprecated
    public String getTemplate() {
        if (this.templateAttribute == null) {
            this.templateAttribute = Attribute.createTemplateAttribute(null);
        }
        return (String)this.templateAttribute.getValue();
    }

    @Deprecated
    public void setTemplate(String template) {
        if (this.templateAttribute == null) {
            this.templateAttribute = Attribute.createTemplateAttribute(template);
        } else {
            this.templateAttribute.setValue(template);
        }
    }

    @Deprecated
    public String getRole() {
        if (this.templateAttribute == null) {
            this.templateAttribute = Attribute.createTemplateAttribute(null);
        }
        return this.templateAttribute.getRole();
    }

    @Deprecated
    public void setRole(String role) {
        if (this.templateAttribute == null) {
            this.templateAttribute = Attribute.createTemplateAttribute(null);
        }
        this.templateAttribute.setRole(role);
    }

    @Deprecated
    public Map<String, Attribute> getAttributes() {
        return this.attributes;
    }

    @Deprecated
    public void addAttribute(Attribute attribute) {
        this.putAttribute(attribute.getName(), attribute);
    }

    @Deprecated
    public boolean hasAttributeValue(String key) {
        return this.getAttribute(key) != null;
    }

    @Deprecated
    public void put(String name, Object content) {
        this.put(name, content, null);
    }

    @Deprecated
    public void put(String name, Object content, String role) {
        Attribute attribute = new Attribute(content, (Expression)null, role, (String)null);
        this.putAttribute(name, attribute);
    }

    @Deprecated
    public void put(String name, Object content, Attribute.AttributeType type, String role) {
        Attribute attribute = new Attribute(content, role, type);
        this.putAttribute(name, attribute);
    }

    public void setExtends(String name) {
        this.inherit = name;
    }

    public String getExtends() {
        return this.inherit;
    }

    @Override
    public boolean equals(Object obj) {
        Definition def = (Definition)obj;
        return CompareUtil.nullSafeEquals(this.name, def.name) && CompareUtil.nullSafeEquals(this.inherit, def.inherit) && super.equals(def);
    }

    @Override
    public int hashCode() {
        return CompareUtil.nullSafeHashCode(this.name) + CompareUtil.nullSafeHashCode(this.inherit) + super.hashCode();
    }

    public boolean isExtending() {
        return this.inherit != null;
    }

    public String toString() {
        return "{name=" + this.name + ", template=" + (this.templateAttribute != null ? this.templateAttribute.getValue() : "<null>") + ", role=" + (this.templateAttribute != null ? this.templateAttribute.getRoles() : "<null>") + ", preparerInstance=" + this.preparer + ", attributes=" + this.attributes + "}";
    }
}

