/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.definition.pattern;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tiles.Attribute;
import org.apache.tiles.Definition;
import org.apache.tiles.Expression;
import org.apache.tiles.ListAttribute;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PatternUtil {
    private static final Locale ROOT_LOCALE = new Locale("", "");
    private static final Pattern INVALID_FORMAT_ELEMENT = Pattern.compile("\\Q{\\E[\\D^}]+\\Q}\\E");

    private PatternUtil() {
    }

    public static Definition replacePlaceholders(Definition d, String name, Object ... vars) {
        Attribute nuattr;
        Attribute attr;
        Set attributeNames;
        Definition nudef = new Definition();
        nudef.setExtends(PatternUtil.replace(d.getExtends(), vars));
        nudef.setName(name);
        nudef.setPreparer(PatternUtil.replace(d.getPreparer(), vars));
        Attribute templateAttribute = d.getTemplateAttribute();
        if (templateAttribute != null) {
            nudef.setTemplateAttribute(PatternUtil.replaceVarsInAttribute(templateAttribute, vars));
        }
        if ((attributeNames = d.getLocalAttributeNames()) != null && !attributeNames.isEmpty()) {
            for (String attributeName : attributeNames) {
                attr = d.getLocalAttribute(attributeName);
                nuattr = PatternUtil.replaceVarsInAttribute(attr, vars);
                nudef.putAttribute(PatternUtil.replace(attributeName, vars), nuattr);
            }
        }
        if ((attributeNames = d.getCascadedAttributeNames()) != null && !attributeNames.isEmpty()) {
            for (String attributeName : attributeNames) {
                attr = d.getCascadedAttribute(attributeName);
                nuattr = PatternUtil.replaceVarsInAttribute(attr, vars);
                nudef.putAttribute(PatternUtil.replace(attributeName, vars), nuattr, true);
            }
        }
        return nudef;
    }

    public static <K, V> Map<K, V> createExtractedMap(Map<K, V> map, Set<K> keys) {
        LinkedHashMap<K, V> retValue = new LinkedHashMap<K, V>();
        for (K key : keys) {
            retValue.put(key, map.get(key));
        }
        return retValue;
    }

    private static Attribute replaceVarsInAttribute(Attribute attr, Object ... vars) {
        Attribute nuattr = attr instanceof ListAttribute ? PatternUtil.replaceVarsInListAttribute((ListAttribute)attr, vars) : PatternUtil.replaceVarsInSimpleAttribute(attr, vars);
        return nuattr;
    }

    private static Attribute replaceVarsInSimpleAttribute(Attribute attr, Object ... vars) {
        Object value;
        Attribute nuattr = new Attribute();
        nuattr.setRole(PatternUtil.replace(attr.getRole(), vars));
        nuattr.setRenderer(attr.getRenderer());
        Expression expressionObject = attr.getExpressionObject();
        if (expressionObject != null) {
            Expression newExpressionObject = Expression.createExpression((String)PatternUtil.replace(expressionObject.getExpression(), vars), (String)expressionObject.getLanguage());
            nuattr.setExpressionObject(newExpressionObject);
        }
        if ((value = attr.getValue()) instanceof String) {
            value = PatternUtil.replace((String)value, vars);
        }
        nuattr.setValue(value);
        return nuattr;
    }

    private static Attribute replaceVarsInListAttribute(ListAttribute listAttr, Object ... vars) {
        ListAttribute nuListAttr = new ListAttribute();
        nuListAttr.setInherit(listAttr.isInherit());
        List nuItems = (List)nuListAttr.getValue();
        for (Object item : (List)listAttr.getValue()) {
            if (item instanceof Attribute) {
                Attribute child = (Attribute)item;
                child = PatternUtil.replaceVarsInAttribute(child, vars);
                nuItems.add(child);
                continue;
            }
            nuItems.add(item);
        }
        ListAttribute nuattr = nuListAttr;
        return nuattr;
    }

    private static String replace(String st, Object ... vars) {
        if (st != null && st.indexOf(123) >= 0) {
            Matcher m = INVALID_FORMAT_ELEMENT.matcher(st);
            st = INVALID_FORMAT_ELEMENT.matcher(st).replaceAll("INVALID_FORMAT_ELEMENT");
            st = new MessageFormat(st.replaceAll("'", "'''"), ROOT_LOCALE).format(vars, new StringBuffer(), (FieldPosition)null).toString();
            while (m.find()) {
                st = st.replaceFirst("INVALID_FORMAT_ELEMENT", m.group());
            }
        }
        return st;
    }
}

