/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.context.enhanced;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.tiles.TilesApplicationContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnhancedTilesApplicationContext
implements TilesApplicationContext {
    private final Logger log = LoggerFactory.getLogger(EnhancedTilesApplicationContext.class);
    private TilesApplicationContext rootContext;

    public EnhancedTilesApplicationContext(TilesApplicationContext rootContext) {
        this.rootContext = rootContext;
    }

    public Object getContext() {
        return this.rootContext.getContext();
    }

    public TilesApplicationContext getRootContext() {
        return this.rootContext;
    }

    public void setRootContext(TilesApplicationContext rootContext) {
        this.rootContext = rootContext;
    }

    public Map<String, Object> getApplicationScope() {
        return this.rootContext.getApplicationScope();
    }

    public Map<String, String> getInitParams() {
        return this.rootContext.getInitParams();
    }

    public URL getResource(String path) throws IOException {
        URL rootUrl = this.rootContext.getResource(path);
        if (rootUrl == null) {
            Set<URL> resources = this.getResources(path);
            resources.remove(null);
            if (resources.size() > 0) {
                rootUrl = resources.toArray(new URL[resources.size()])[0];
            }
        }
        return rootUrl;
    }

    public Set<URL> getResources(String path) throws IOException {
        HashSet<URL> resources = new HashSet<URL>();
        resources.addAll(this.rootContext.getResources(path));
        resources.addAll(this.getClasspathResources(path));
        return resources;
    }

    public Set<URL> getClasspathResources(String path) throws IOException {
        HashSet<URL> resources = new HashSet<URL>();
        resources.addAll(this.searchResources(this.getClass().getClassLoader(), path));
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        if (contextLoader != null) {
            resources.addAll(this.searchResources(contextLoader, path));
        }
        if (resources.size() == 0 && path.startsWith("/")) {
            return this.getClasspathResources(path.substring(1));
        }
        return resources;
    }

    protected Set<URL> searchResources(ClassLoader loader, String path) {
        HashSet<URL> resources = new HashSet<URL>();
        try {
            Enumeration<URL> e = loader.getResources(path);
            while (e.hasMoreElements()) {
                resources.add(e.nextElement());
            }
        }
        catch (IOException e) {
            this.log.warn("Unable to retrieved resources from classloader: " + loader, (Throwable)e);
        }
        return resources;
    }
}

