/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.web.startup;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.TilesException;
import org.apache.tiles.servlet.context.ServletTilesApplicationContext;
import org.apache.tiles.servlet.context.ServletUtil;
import org.apache.tiles.startup.TilesInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTilesListener
implements ServletContextListener {
    private Logger log = LoggerFactory.getLogger(AbstractTilesListener.class);
    protected TilesInitializer initializer;

    public void contextInitialized(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        this.initializer = this.createTilesInitializer();
        this.initializer.initialize((TilesApplicationContext)new ServletTilesApplicationContext(servletContext));
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext servletContext = event.getServletContext();
        try {
            ServletUtil.setContainer(servletContext, null);
        }
        catch (TilesException e) {
            this.log.warn("Unable to remove tiles container from service.", (Throwable)e);
        }
    }

    protected abstract TilesInitializer createTilesInitializer();
}

