/*
 * Decompiled with CFR 0.152.
 */
package w11.com.ejie.y31.util.trace.manager;

import com.ejie.y31.exception.Y31JanoServiceOracleGenericException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public class Y31JanoServiceOracleDBConnectionManager {
    private static String ORACLE_JNDI_NAME = "y31.y31DataSource";
    private static DataSource dataSource = null;

    private static DataSource getDataSource() throws Y31JanoServiceOracleGenericException {
        InitialContext context = null;
        try {
            context = new InitialContext();
            if (null == dataSource) {
                dataSource = (DataSource)context.lookup(ORACLE_JNDI_NAME);
            }
        }
        catch (NamingException e) {
            e.printStackTrace();
            throw new Y31JanoServiceOracleGenericException((Throwable)e);
        }
        finally {
            if (context != null) {
                try {
                    context.close();
                }
                catch (NamingException e) {
                    e.printStackTrace();
                    throw new Y31JanoServiceOracleGenericException((Throwable)e);
                }
            }
        }
        return dataSource;
    }

    public static Connection getConnection() throws Y31JanoServiceOracleGenericException {
        try {
            return Y31JanoServiceOracleDBConnectionManager.getDataSource().getConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new Y31JanoServiceOracleGenericException((Throwable)e);
        }
    }

    static {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = Y31JanoServiceOracleDBConnectionManager.class.getClassLoader();
        }
        InputStream inputStream = null;
        inputStream = cl.getResourceAsStream("w11/com/ejie/y31/service/impl/y31.properties");
        if (inputStream == null) {
            inputStream = cl.getResourceAsStream("y31/y31.properties");
        }
        Properties properties = new Properties();
        try {
            if (inputStream != null) {
                properties.load(inputStream);
                if (properties.getProperty("ORACLE_JNDI_NAME") != null && properties.getProperty("ORACLE_JNDI_NAME").length() > 0) {
                    ORACLE_JNDI_NAME = properties.getProperty("ORACLE_JNDI_NAME");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

