/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.util;

import com.ejie.x38.util.StackTraceManager;
import com.ejie.x38.util.StaticsContainer;
import java.io.InputStream;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.WebApplicationContext;

public class WebContextParameterManager
implements ApplicationContextAware {
    private static Logger logger = LoggerFactory.getLogger("com.ejie.x38.util.WebContextParameterManager");
    private WebApplicationContext webApplicationContext;

    @PostConstruct
    public void init() {
        Properties props = new Properties();
        logger.info("Loads the application context parameters");
        StaticsContainer.webAppName = this.webApplicationContext.getServletContext().getInitParameter("webAppName");
        logger.info("The applications name is: " + StaticsContainer.webAppName);
        StaticsContainer.webId = this.webApplicationContext.getId();
        logger.info("The applications Id is: " + StaticsContainer.webId);
        try {
            logger.debug("Loading properties from: " + StaticsContainer.webAppName + "/" + StaticsContainer.webAppName + ".properties");
            InputStream in = this.getClass().getClassLoader().getResourceAsStream(String.valueOf(StaticsContainer.webAppName) + "/" + StaticsContainer.webAppName + ".properties");
            props.load(in);
            in.close();
        }
        catch (Exception e) {
            logger.error(StackTraceManager.getStackTrace(e));
        }
        logger.info("WARs specific Static Content URL is: " + props.getProperty("statics.path"));
        StaticsContainer.staticsUrl = props.getProperty("statics.path");
        logger.info("Applications Model Package is: com.ejie." + StaticsContainer.webAppName + ".model.");
        StaticsContainer.modelPackageName = "com.ejie." + StaticsContainer.webAppName + ".model.";
        logger.info("The URL to access the security provider of the application (\"XLNets\") is: " + props.getProperty("xlnets.path"));
        StaticsContainer.loginUrl = props.getProperty("xlnets.path");
        if (props.getProperty("xlnets.inPortal") != null && props.getProperty("xlnets.inPortal").toLowerCase().equals("true")) {
            logger.info("The application " + StaticsContainer.webAppName + " is integrated in the portals of lote3");
            StaticsContainer.aplicInPortal = true;
        } else {
            logger.info("The application " + StaticsContainer.webAppName + " isn't integrated in the portals of lote3");
            StaticsContainer.aplicInPortal = false;
        }
        if (StaticsContainer.loginUrl == null) {
            logger.error("Login URL is not Set!");
        }
        String weblogicInstance = System.getProperty("weblogic.Name");
        logger.info("The WebLogic Instance Name is: " + weblogicInstance);
        StaticsContainer.weblogicInstance = weblogicInstance;
    }

    public WebApplicationContext getWebApplicationContext() {
        return this.webApplicationContext;
    }

    @Override
    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.webApplicationContext = (WebApplicationContext)context;
    }
}

