/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.util;

import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public final class ObjectConversionManager {
    private static final Map<String, Method> CONVERTERS;

    static {
        Method[] methods;
        CONVERTERS = new HashMap<String, Method>();
        Method[] methodArray = methods = ObjectConversionManager.class.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getParameterTypes().length == 1) {
                CONVERTERS.put(String.valueOf(method.getParameterTypes()[0].getName()) + "_" + method.getReturnType().getName(), method);
            }
            ++n2;
        }
    }

    private ObjectConversionManager() {
    }

    public static <T> T convert(Object from, Class<T> to) {
        if (from == null) {
            return null;
        }
        if (to.isAssignableFrom(from.getClass())) {
            return to.cast(from);
        }
        String converterId = String.valueOf(from.getClass().getName()) + "_" + to.getName();
        Method converter = CONVERTERS.get(converterId);
        if (converter == null) {
            throw new UnsupportedOperationException("Cannot convert from " + from.getClass().getName() + " to " + to.getName() + ". Requested converter does not exist.");
        }
        try {
            return to.cast(converter.invoke(to, from));
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot convert from " + from.getClass().getName() + " to " + to.getName() + ". Conversion failed with " + e.getMessage(), e);
        }
    }

    public static Boolean integerToBoolean(Integer value) {
        return value == 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    public static Integer booleanToInteger(Boolean value) {
        return value != false ? Integer.valueOf(1) : Integer.valueOf(0);
    }

    public static BigDecimal doubleToBigDecimal(Double value) {
        return new BigDecimal(value);
    }

    public static Double bigDecimalToDouble(BigDecimal value) {
        return new Double(value.doubleValue());
    }

    public static String integerToString(Integer value) {
        return value.toString();
    }

    public static Integer stringToInteger(String value) {
        return Integer.valueOf(value);
    }

    public static String booleanToString(Boolean value) {
        return value.toString();
    }

    public static Boolean stringToBoolean(String value) {
        return Boolean.valueOf(value);
    }

    public static String longToString(Long value) {
        return value.toString();
    }

    public static Long stringToLong(String value) {
        if (value.equals("")) {
            return null;
        }
        return Long.valueOf(value);
    }

    public static String bigDecimalToString(BigDecimal value) {
        return value.toString();
    }

    public static BigDecimal stringToBigDecimal(String value) {
        if (value.equals("")) {
            return null;
        }
        return BigDecimal.valueOf(Long.valueOf(value));
    }
}

