/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.serialization;

import com.ejie.x38.serialization.MultiModelDeserializer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.map.module.SimpleModule;

public class UdaModule
extends SimpleModule {
    private static final String NAME = "UdaModule";
    private static final Version VERSION = new Version(1, 0, 0, null);
    private Map<Class<? extends Object>, JsonSerializer<Object>> serializers;
    private Map<Class<Object>, JsonDeserializer<? extends Object>> deserializers;
    private Map<SerializationConfig.Feature, Boolean> serializationConfigFeatures;
    private Map<DeserializationConfig.Feature, Boolean> deserializationConfigFeatures;
    private List<JsonSerialize.Inclusion> serializationInclusions;

    public UdaModule() {
        super(NAME, VERSION);
    }

    @PostConstruct
    public void initialize() {
        if (this.serializers != null) {
            Set<Map.Entry<Class<? extends Object>, JsonSerializer<Object>>> serializerEntrySet = this.serializers.entrySet();
            for (Map.Entry<Class<Object>, Object> entry : serializerEntrySet) {
                this.addSerializer(entry.getKey(), (JsonSerializer)entry.getValue());
            }
        }
        if (this.deserializers != null) {
            Set<Map.Entry<Class<Object>, JsonDeserializer<? extends Object>>> deserializerEntrySet = this.deserializers.entrySet();
            for (Map.Entry<Class<Object>, Object> entry : deserializerEntrySet) {
                this.addDeserializer(entry.getKey(), (JsonDeserializer)entry.getValue());
            }
        }
        this.addDeserializer(Map.class, new MultiModelDeserializer());
    }

    public void setSerializers(Map<Class<? extends Object>, JsonSerializer<Object>> serializers) {
        this.serializers = serializers;
    }

    public void setDeserializers(Map<Class<Object>, JsonDeserializer<? extends Object>> deserializers) {
        this.deserializers = deserializers;
    }

    public Map<SerializationConfig.Feature, Boolean> getSerializationConfigFeatures() {
        return this.serializationConfigFeatures;
    }

    public void setSerializationConfigFeatures(Map<SerializationConfig.Feature, Boolean> serializationConfigFeatures) {
        this.serializationConfigFeatures = serializationConfigFeatures;
    }

    public Map<DeserializationConfig.Feature, Boolean> getDeserializationConfigFeatures() {
        return this.deserializationConfigFeatures;
    }

    public void setDeserializationConfigFeatures(Map<DeserializationConfig.Feature, Boolean> deserializationConfigFeatures) {
        this.deserializationConfigFeatures = deserializationConfigFeatures;
    }

    public List<JsonSerialize.Inclusion> getSerializationInclusions() {
        return this.serializationInclusions;
    }

    public void setSerializationInclusions(List<JsonSerialize.Inclusion> serializationInclusions) {
        this.serializationInclusions = serializationInclusions;
    }
}

