/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.serialization;

import com.ejie.x38.serialization.ThreadSafeCache;
import java.io.IOException;
import java.util.Map;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;

public class CustomSerializer
extends JsonSerializer<Object> {
    protected final Logger logger = LoggerFactory.getLogger(CustomSerializer.class);

    @Override
    public void serialize(Object obj, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
        this.logger.debug("CustomSerializer.serialize()");
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(obj);
        jgen.writeStartObject();
        for (Map.Entry<?, ?> entry : ThreadSafeCache.getMap().entrySet()) {
            String propertyName = (String)entry.getValue();
            if (!beanWrapper.isReadableProperty(propertyName)) continue;
            Object propertyValue = beanWrapper.getPropertyValue(propertyName);
            jgen.writeFieldName((String)entry.getKey());
            if (propertyValue == null) {
                jgen.writeString("");
                continue;
            }
            jgen.writeObject(propertyValue);
        }
        jgen.writeEndObject();
    }
}

