/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.security;

import com.ejie.x38.security.Credentials;
import com.ejie.x38.security.PerimetralSecurityWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.LazyDynaBean;
import org.apache.commons.beanutils.MutableDynaClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserCredentials
implements Credentials {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(UserCredentials.class);
    private String nif = null;
    private String policy = null;
    private String userName = "NULL";
    private String name = "NULL";
    private String surname = "NULL";
    private String fullName = "NULL";
    private String position = "NULL";
    private String uidSession = null;
    private boolean isCertificate = false;
    private String udaValidateSessionId = null;
    private Vector<String> userProfiles = null;
    private boolean destroySessionSecuritySystem = false;
    private DynaBean subjectCert = null;
    private ArrayList<String> userDataProperties = null;

    public UserCredentials() {
    }

    public UserCredentials(Vector<String> userProfiles, String userName, HashMap<String, String> userData, String nif, String uidSession, String position, String udaValidateSessionId, String policy, boolean isCertificate, boolean destroySessionSecuritySystem) {
        this.nif = nif;
        this.userName = userName;
        this.uidSession = uidSession;
        this.position = position;
        this.udaValidateSessionId = udaValidateSessionId;
        this.userProfiles = userProfiles;
        this.isCertificate = isCertificate;
        this.policy = policy;
        this.destroySessionSecuritySystem = destroySessionSecuritySystem;
        this.dinamicSubjectCertLoad(userData);
    }

    public UserCredentials(Vector<String> userProfiles, String userName, String name, String surname, String fullName, String nif, String uidSession, String position, String udaValidateSessionId, String policy, boolean isCertificate, boolean destroySessionSecuritySystem) {
        this.nif = nif;
        this.userName = userName;
        this.name = name;
        this.surname = surname;
        this.fullName = fullName;
        this.uidSession = uidSession;
        this.position = position;
        this.udaValidateSessionId = udaValidateSessionId;
        this.userProfiles = userProfiles;
        this.isCertificate = isCertificate;
        this.policy = policy;
        this.destroySessionSecuritySystem = destroySessionSecuritySystem;
    }

    public UserCredentials(Vector<String> userProfiles, String userName, String nif, String uidSession, String position, String udaValidateSessionId, String policy, boolean isCertificate) {
        this.nif = nif;
        this.userName = userName;
        this.uidSession = uidSession;
        this.position = position;
        this.udaValidateSessionId = udaValidateSessionId;
        this.userProfiles = userProfiles;
        this.isCertificate = isCertificate;
        this.policy = policy;
    }

    @Override
    public String getNif() {
        return this.nif;
    }

    @Override
    public void setNif(String nif) {
        this.nif = nif;
    }

    @Override
    public String getPolicy() {
        return this.policy;
    }

    @Override
    public void setPolicy(String policy) {
        this.policy = policy;
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public void setfullName(String fullName) {
        this.fullName = fullName;
    }

    @Override
    public String getSurname() {
        return this.surname;
    }

    @Override
    public void setSurname(String surname) {
        this.surname = surname;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(String position) {
        this.position = position;
    }

    @Override
    public String getUidSession() {
        return this.uidSession;
    }

    @Override
    public void setUidSession(String uidSession) {
        this.uidSession = uidSession;
    }

    @Override
    public boolean getIsCertificate() {
        return this.isCertificate;
    }

    @Override
    public void setIsCertificate(boolean isCertificate) {
        this.isCertificate = isCertificate;
    }

    @Override
    public String getUdaValidateSessionId() {
        return this.udaValidateSessionId;
    }

    @Override
    public void setUdaValidateSessionId(String udaXLNetsSessionId) {
        this.udaValidateSessionId = udaXLNetsSessionId;
    }

    @Override
    public Vector<String> getUserProfiles() {
        return this.userProfiles;
    }

    @Override
    public void setUserProfiles(Vector<String> userProfiles) {
        this.userProfiles = userProfiles;
    }

    @Override
    public boolean getDestroySessionSecuritySystem() {
        return this.destroySessionSecuritySystem;
    }

    @Override
    public void setDestroySessionSecuritySystem(boolean destroySessionSecuritySystem) {
        this.destroySessionSecuritySystem = destroySessionSecuritySystem;
    }

    public ArrayList<String> getUserDataProperties() {
        return this.userDataProperties;
    }

    @Override
    public String toString() {
        StringBuffer strBuffer = new StringBuffer();
        strBuffer.append("UserCredentials [");
        strBuffer.append("userName=").append(this.userName).append(";");
        if (this.nif != null) {
            strBuffer.append("nif=").append("Object NOT NULL (info protected)").append(";");
        } else {
            strBuffer.append("nif=").append("NULL").append(";");
        }
        strBuffer.append("name=").append(this.name).append(";");
        strBuffer.append("surName=").append(this.surname).append(";");
        strBuffer.append("fullName=").append(this.fullName).append(";");
        if (this.uidSession != null) {
            strBuffer.append("uidSession=").append("Object NOT NULL (info protected)").append(";");
        } else {
            strBuffer.append("uidSession=").append("NULL").append(";");
        }
        strBuffer.append("position=").append(this.position).append(";");
        if (this.udaValidateSessionId != null) {
            strBuffer.append("udaXLNetsSessionId=").append("Object NOT NULL (info protected)").append(";");
        } else {
            strBuffer.append("udaXLNetsSessionId=").append("NULL").append(";");
        }
        if (this.userProfiles != null) {
            if (this.userProfiles.size() > 0) {
                strBuffer.append("userProfiles=").append("Object NOT NULL. Its size is ").append(this.userProfiles.size()).append(" (info protected)").append(";");
            } else {
                strBuffer.append("userProfiles=").append("The user doesn't have permissions").append(";");
            }
        } else {
            strBuffer.append("userProfiles=").append("NULL").append(";");
        }
        if (this.isCertificate) {
            strBuffer.append("isCertificate=").append("true").append(";");
        } else {
            strBuffer.append("isCertificate=").append("false").append(";");
        }
        if (this.policy != null) {
            strBuffer.append("policy=").append("Object NOT NULL (info protected)").append(";");
        } else {
            strBuffer.append("policy=").append("NULL").append(";");
        }
        if (this.destroySessionSecuritySystem) {
            strBuffer.append("destroySessionSecuritySystem=").append("true").append(";");
        } else {
            strBuffer.append("destroySessionSecuritySystem=").append("false").append(";");
        }
        if (this.subjectCert != null) {
            strBuffer.append("subjectCertData=");
            strBuffer.append("{");
            int i = 0;
            while (i < this.userDataProperties.size()) {
                String property = this.userDataProperties.get(i);
                strBuffer.append(property);
                strBuffer.append(":");
                strBuffer.append(this.getSubjectCert(property));
                if (i < this.userDataProperties.size() - 1) {
                    strBuffer.append(", ");
                }
                ++i;
            }
            strBuffer.append("}");
        }
        strBuffer.append("]");
        return strBuffer.toString();
    }

    @Override
    public void loadCredentialsData(PerimetralSecurityWrapper perimetralSecurityWrapper, HttpServletRequest request) {
        this.uidSession = perimetralSecurityWrapper.getUserConnectedUidSession(request);
        this.userName = perimetralSecurityWrapper.getUserConnectedUserName(request);
        this.position = perimetralSecurityWrapper.getUserPosition(request);
        this.userProfiles = perimetralSecurityWrapper.getUserInstances(request);
        this.udaValidateSessionId = perimetralSecurityWrapper.getUdaValidateSessionId(request);
        this.policy = perimetralSecurityWrapper.getPolicy(request);
        this.isCertificate = perimetralSecurityWrapper.getIsCertificate(request);
        this.nif = perimetralSecurityWrapper.getNif(request);
        this.destroySessionSecuritySystem = perimetralSecurityWrapper.getDestroySessionSecuritySystem();
        this.dinamicSubjectCertLoad(perimetralSecurityWrapper.getUserDataInfo(request, this.isCertificate));
        this.afterCredentialsCreation(perimetralSecurityWrapper, request);
        logger.info("The incoming user's Credentials are loading. The data of its credentials is: [uidSession = " + this.uidSession + " ] [userName = " + this.userName + " ] [position = " + this.position + "]");
    }

    private void dinamicSubjectCertLoad(HashMap<String, String> userData) {
        this.name = userData.get("name");
        this.surname = userData.get("surname");
        this.fullName = userData.get("fullName");
        userData.remove("name");
        userData.remove("surname");
        userData.remove("fullName");
        try {
            if (this.isCertificate) {
                Iterator<Map.Entry<String, String>> userDataIterator = userData.entrySet().iterator();
                this.userDataProperties = new ArrayList();
                this.subjectCert = new LazyDynaBean();
                MutableDynaClass subjectCertClass = (MutableDynaClass)this.subjectCert.getDynaClass();
                while (userDataIterator.hasNext()) {
                    Map.Entry<String, String> userDataEntry = userDataIterator.next();
                    this.userDataProperties.add(userDataEntry.getKey());
                    subjectCertClass.add(userDataEntry.getKey(), String.class);
                }
                for (Map.Entry<String, String> userDataEntry : userData.entrySet()) {
                    this.subjectCert.set(userDataEntry.getKey(), userDataEntry.getValue());
                }
            }
        }
        catch (Exception exc) {
            logger.error("It was Produced a error in the subjectCert's info load. All gets of subjectCert will be empties (\"\")", exc);
            this.subjectCert = null;
        }
        userData = null;
    }

    protected void afterCredentialsCreation(PerimetralSecurityWrapper perimetralSecurityWrapper, HttpServletRequest request) {
    }

    @Override
    public boolean containsSubjectCert(String id) {
        if (!id.equals("")) {
            int i = 0;
            while (i < this.userDataProperties.size()) {
                if (this.userDataProperties.get(i).equals(id)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void deleteUserDataProperties(String id) {
        if (!id.equals("")) {
            int i = 0;
            while (i < this.userDataProperties.size()) {
                if (this.userDataProperties.get(i).equals(id)) {
                    this.userDataProperties.remove(i);
                }
                ++i;
            }
        }
    }

    @Override
    public String getSubjectCert(String data) {
        if (this.subjectCert != null) {
            if (this.containsSubjectCert(data)) {
                return (String)this.subjectCert.get(data);
            }
            return "N/A";
        }
        return "";
    }

    @Override
    public void setSubjectCert(String property, String value) {
        if (this.subjectCert != null) {
            if (!this.containsSubjectCert(property)) {
                MutableDynaClass subjectCertClass = (MutableDynaClass)this.subjectCert.getDynaClass();
                subjectCertClass.add(property, String.class);
                this.userDataProperties.add(property);
            }
            this.subjectCert.set(property, value);
        }
    }

    @Override
    public void deleteSubjectCert(String property) {
        if (this.subjectCert != null && this.containsSubjectCert(property)) {
            this.deleteUserDataProperties(property);
            MutableDynaClass subjectCertClass = (MutableDynaClass)this.subjectCert.getDynaClass();
            subjectCertClass.remove(property);
        }
    }
}

