/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.security;

import java.util.concurrent.Semaphore;

public class UdaSecurityPadlock {
    private Semaphore credentialLoad;
    private Long allowedAccessThread;

    protected UdaSecurityPadlock(Long allowedAccessThread) {
        this.allowedAccessThread = allowedAccessThread;
        this.credentialLoad = new Semaphore(1, true);
    }

    protected UdaSecurityPadlock(Long allowedAccessThread, int semaphoreLimit) {
        this.allowedAccessThread = allowedAccessThread;
        this.credentialLoad = new Semaphore(semaphoreLimit, true);
    }

    protected Long getAllowedAccessThread() {
        return this.allowedAccessThread;
    }

    protected void setAllowedAccessThread(Long accessThread) {
        this.allowedAccessThread = accessThread;
    }

    protected boolean allowedAccess(Long accessThread) {
        return this.allowedAccessThread == accessThread;
    }

    protected void acquire() throws InterruptedException {
        this.credentialLoad.acquire();
    }

    protected void freeAllThreads() {
        this.credentialLoad.release(this.credentialLoad.getQueueLength());
    }

    protected void release() {
        this.credentialLoad.release();
    }

    protected boolean tryAcquire() {
        return this.credentialLoad.tryAcquire();
    }
}

