/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.security;

import com.ejie.x38.security.StockUdaSecurityPadlocks;
import com.ejie.x38.security.UdaSecurityPadlock;
import java.util.HashMap;

public class StockUdaSecurityPadlocksImpl
implements StockUdaSecurityPadlocks {
    private final HashMap<String, UdaSecurityPadlock> SecurityPadlocks = new HashMap();

    @Override
    public synchronized void createSecurityPadlock(String sessionId, Long allowedAccessThread) {
        this.SecurityPadlocks.put(this.getBaseSessionId(sessionId), new UdaSecurityPadlock(allowedAccessThread));
    }

    @Override
    public synchronized void createSecurityPadlock(String sessionId, Long allowedAccessThread, int semaphoreLimit) {
        this.SecurityPadlocks.put(this.getBaseSessionId(sessionId), new UdaSecurityPadlock(allowedAccessThread, semaphoreLimit));
    }

    @Override
    public Long getAllowedAccessThread(String sessionId) {
        UdaSecurityPadlock udaSecurityPadlock = this.SecurityPadlocks.get(this.getBaseSessionId(sessionId));
        if (udaSecurityPadlock != null) {
            return udaSecurityPadlock.getAllowedAccessThread();
        }
        return null;
    }

    @Override
    public void setAllowedAccessThread(String sessionId, Long accessThread) {
        UdaSecurityPadlock udaSecurityPadlock = this.SecurityPadlocks.get(this.getBaseSessionId(sessionId));
        if (udaSecurityPadlock != null) {
            udaSecurityPadlock.setAllowedAccessThread(accessThread);
        } else {
            this.createSecurityPadlock(sessionId, accessThread);
        }
    }

    @Override
    public boolean existingSecurityPadlock(String sessionId) {
        UdaSecurityPadlock udaSecurityPadlock = this.SecurityPadlocks.get(this.getBaseSessionId(sessionId));
        return udaSecurityPadlock != null;
    }

    @Override
    public boolean allowedAccess(String sessionId, Long accessThread) throws NullPointerException {
        UdaSecurityPadlock udaSecurityPadlock = this.SecurityPadlocks.get(this.getBaseSessionId(sessionId));
        if (udaSecurityPadlock != null) {
            return udaSecurityPadlock.allowedAccess(accessThread);
        }
        return false;
    }

    @Override
    public void acquire(String sessionId) throws NullPointerException, InterruptedException {
        UdaSecurityPadlock udaSecurityPadlock = this.SecurityPadlocks.get(this.getBaseSessionId(sessionId));
        if (udaSecurityPadlock == null) {
            throw new NullPointerException("The session id don't have a correlation in the object. It need a previous creation.");
        }
        udaSecurityPadlock.acquire();
    }

    @Override
    public void release(String sessionId) throws NullPointerException {
        UdaSecurityPadlock udaSecurityPadlock = this.SecurityPadlocks.get(this.getBaseSessionId(sessionId));
        if (udaSecurityPadlock == null) {
            throw new NullPointerException("The session id don't have a correlation in the object. It need a previous creation.");
        }
        udaSecurityPadlock.release();
    }

    @Override
    public boolean tryAcquire(String sessionId) throws NullPointerException {
        UdaSecurityPadlock udaSecurityPadlock = this.SecurityPadlocks.get(this.getBaseSessionId(sessionId));
        if (udaSecurityPadlock != null) {
            return udaSecurityPadlock.tryAcquire();
        }
        throw new NullPointerException("The session id don't have a correlation in the object. It need a previous creation.");
    }

    @Override
    public void deleteCredentialLoadObject(String sessionId) {
        UdaSecurityPadlock udaSecurityPadlock = this.SecurityPadlocks.get(this.getBaseSessionId(sessionId));
        if (udaSecurityPadlock != null) {
            udaSecurityPadlock.freeAllThreads();
            this.SecurityPadlocks.remove(this.getBaseSessionId(sessionId));
        }
    }

    private String getBaseSessionId(String sessionId) {
        String[] baseSessionId = sessionId.split("!");
        return baseSessionId[0];
    }
}

