/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.security;

import com.ejie.x38.security.AlternativeOriginCredentialsApp;
import com.ejie.x38.security.AlternativeOriginCredentialsAppImp;
import com.ejie.x38.security.Credentials;
import com.ejie.x38.security.ExcludeFilter;
import com.ejie.x38.security.PerimetralSecurityWrapper;
import com.ejie.x38.security.UdaCustomJdbcDaoImpl;
import com.ejie.x38.security.UserCredentials;
import com.ejie.x38.security.XlnetCore;
import com.ejie.x38.util.StaticsContainer;
import com.ejie.x38.util.ThreadStorageManager;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import n38a.exe.N38APISesion;
import n38c.exe.N38API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.w3c.dom.Document;

public class PerimetralSecurityWrapperN38Impl
implements PerimetralSecurityWrapper {
    private static final Logger logger = LoggerFactory.getLogger(PerimetralSecurityWrapperN38Impl.class);
    private Long xlnetCachingPeriod = new Long(0L);
    private String xlnetsDomain = null;
    private boolean destroySessionSecuritySystem = false;
    private String userChangeUrl = null;
    private ExcludeFilter excludeFilter = null;
    private UdaCustomJdbcDaoImpl alternativeStorageUserCredentials = null;
    private HashMap<String, String> anonymousProfile = new HashMap();
    private AlternativeOriginCredentialsApp alternativeOriginCredentialsApp = null;
    private String specificCredentialsName = null;
    private Object specificCredentials = null;

    public PerimetralSecurityWrapperN38Impl() {
        this.anonymousProfile.put("position", "udaAnonymousPosition");
        this.anonymousProfile.put("userProfiles", "udaAnonymousProfile");
    }

    @Override
    public synchronized String validateSession(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws SecurityException {
        String udaXLNetsSessionId = this.getXlnetsUserId(httpRequest);
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        Credentials credentials = null;
        HttpSession httpSession = httpRequest.getSession(true);
        if (authentication != null) {
            credentials = (Credentials)authentication.getCredentials();
        }
        if (credentials != null) {
            if (udaXLNetsSessionId != null) {
                if (this.excludeFilter != null && !this.excludeFilter.accept(httpRequest, httpResponse)) {
                    this.springSecurityContextClean(httpSession);
                    return this.excludeFilter.getAccessDeniedUrl();
                }
                if (credentials.getUdaValidateSessionId().compareTo(udaXLNetsSessionId.toString()) != 0) {
                    logger.info("XLNet's caching of session " + httpSession.getId() + " expired, because the XLNets user has changed");
                    this.authenticationLogContextClean();
                    if (this.userChangeUrl != null) {
                        udaXLNetsSessionId = null;
                        this.springSecurityContextClean(httpSession);
                        return this.userChangeUrl;
                    }
                    if (!this.isN38ApiValid(httpRequest, httpResponse)) {
                        udaXLNetsSessionId = null;
                        this.springSecurityContextClean(httpSession);
                        return "false";
                    }
                    this.loadReloadData(httpRequest, ThreadStorageManager.getCurrentThreadId());
                    httpSession.setAttribute("userChange", (Object)"true");
                } else if (httpSession != null && httpSession.getAttribute("udaTimeStamp") != null && this.reloadData(httpRequest)) {
                    logger.info("XLNet's caching of session " + httpSession.getId() + " expired, after, at least, " + this.xlnetCachingPeriod + " Seconds");
                    if (this.isN38ApiValid(httpRequest, httpResponse)) {
                        this.loadReloadData(httpRequest, ThreadStorageManager.getCurrentThreadId());
                    } else {
                        this.authenticationLogContextClean();
                        udaXLNetsSessionId = null;
                        this.springSecurityContextClean(httpSession);
                        return "false";
                    }
                }
                return "true";
            }
            logger.info("There isn't a correct session of XLNET");
            this.logout(httpRequest, httpResponse);
            this.springSecurityContextClean(httpSession);
            udaXLNetsSessionId = null;
            return "false";
        }
        logger.info("authentication.getCredentials() null");
        if (udaXLNetsSessionId != null && this.isN38ApiValid(httpRequest, httpResponse)) {
            udaXLNetsSessionId = null;
            return "true";
        }
        udaXLNetsSessionId = null;
        return "false";
    }

    @Override
    public String getUserConnectedUserName(HttpServletRequest httpRequest) {
        String userName = null;
        String xlnetUserId = this.getXlnetsUserId(httpRequest);
        HttpSession httpSession = httpRequest.getSession(false);
        Credentials credentials = null;
        Authentication authentication = null;
        authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            credentials = (Credentials)authentication.getCredentials();
        }
        if (httpSession != null) {
            userName = (String)httpSession.getAttribute("userName");
            if (userName != null || credentials != null) {
                if (userName == null) {
                    httpSession.removeAttribute("fullName");
                    httpSession.removeAttribute("destroySessionSecuritySystem");
                    userName = credentials.getUserName();
                } else {
                    httpSession.removeAttribute("userName");
                }
            } else {
                userName = this.loadXlnetsCredentialInfo(httpRequest, xlnetUserId);
            }
        } else {
            userName = this.loadXlnetsCredentialInfo(httpRequest, xlnetUserId);
        }
        logger.trace("Connected User's Name is: " + userName);
        return userName;
    }

    @Override
    public HashMap<String, String> getUserDataInfo(HttpServletRequest httpRequest, boolean isCertificate) {
        Document xmlSesion;
        N38API n38Api;
        HttpSession httpSession = httpRequest.getSession(false);
        String fullName = (String)httpSession.getAttribute("fullName");
        HashMap<Object, Object> userData = new HashMap<String, String>();
        HashMap<String, String> userInfo = null;
        if (isCertificate) {
            n38Api = XlnetCore.getN38API(httpRequest);
            xmlSesion = XlnetCore.getN38ItemSesion(n38Api);
            userData = XlnetCore.getN38SubjectCert(xmlSesion);
        }
        if (fullName != null) {
            userData.put("fullName", fullName);
            userData.put("name", (String)httpSession.getAttribute("name"));
            userData.put("surname", (String)httpSession.getAttribute("surname"));
            httpSession.removeAttribute("name");
            httpSession.removeAttribute("surname");
        } else {
            n38Api = XlnetCore.getN38API(httpRequest);
            if (!XlnetCore.getParameterSession(n38Api, "n38uidOrg").equals("0")) {
                userInfo = XlnetCore.getUserDataInfo(n38Api);
                userData.put("name", userInfo.get("name"));
                userData.put("surname", userInfo.get("surname"));
                userData.put("fullName", userInfo.get("fullName"));
                httpSession.setAttribute("fullName", (Object)userInfo.get("fullName"));
            } else {
                userData.put("name", (String)userData.get("GIVENNAME"));
                userData.put("surname", (String)userData.get("SURNAME"));
                userData.put("fullName", (String)userData.get("CN"));
                httpSession.setAttribute("fullName", userData.get("CN"));
            }
            xmlSesion = null;
            userInfo = null;
        }
        logger.trace("Connected User's data is: " + userData.toString());
        return userData;
    }

    @Override
    public String getUserPosition(HttpServletRequest httpRequest) {
        String userPosition = null;
        userPosition = (String)httpRequest.getSession(false).getAttribute("position");
        httpRequest.getSession(false).removeAttribute("position");
        logger.trace("Connected User's Position is: " + userPosition);
        return userPosition;
    }

    @Override
    public String getUdaValidateSessionId(HttpServletRequest httpRequest) {
        String udaValidateSessionId = null;
        udaValidateSessionId = (String)httpRequest.getSession(false).getAttribute("udaValidateSessionId");
        httpRequest.getSession(false).removeAttribute("udaValidateSessionId");
        logger.trace("Connected UserConnectedUidSession is: " + udaValidateSessionId);
        return udaValidateSessionId;
    }

    @Override
    public Vector<String> getUserInstances(HttpServletRequest httpRequest) {
        Vector userInstances = null;
        userInstances = (Vector)httpRequest.getSession(false).getAttribute("userProfiles");
        httpRequest.getSession(false).removeAttribute("userProfiles");
        logger.trace("Connected UserConnectedUidSession is: " + userInstances);
        return userInstances;
    }

    @Override
    public String getUserConnectedUidSession(HttpServletRequest httpRequest) {
        String userConnectedUidSession = null;
        HttpSession httpSession = httpRequest.getSession(false);
        if (httpSession != null) {
            userConnectedUidSession = (String)httpSession.getAttribute("uidSession");
            httpRequest.getSession(false).removeAttribute("uidSession");
            logger.trace("Connected UserConnectedUidSession is: " + userConnectedUidSession);
        }
        return userConnectedUidSession;
    }

    @Override
    public String getPolicy(HttpServletRequest httpRequest) {
        String userPolicy = null;
        userPolicy = (String)httpRequest.getSession(false).getAttribute("policy");
        httpRequest.getSession(false).removeAttribute("policy");
        logger.trace("Connected User's Policy is: " + userPolicy);
        return userPolicy;
    }

    @Override
    public boolean getIsCertificate(HttpServletRequest httpRequest) {
        String userIsCertificate = null;
        userIsCertificate = (String)httpRequest.getSession(false).getAttribute("isCertificate");
        boolean userBooleanIsCertificate = userIsCertificate.equals("true");
        httpRequest.getSession(false).removeAttribute("isCertificate");
        logger.trace("Connected User's isCertificate is: " + userBooleanIsCertificate);
        return userBooleanIsCertificate;
    }

    @Override
    public String getNif(HttpServletRequest httpRequest) {
        String userNif = null;
        userNif = (String)httpRequest.getSession(false).getAttribute("nif");
        httpRequest.getSession(false).removeAttribute("nif");
        logger.trace("Connected User's nif is: " + userNif);
        return userNif;
    }

    @Override
    public String getURLLogin(String originalURL, boolean ajax) {
        logger.debug("Original URLLogin is :" + originalURL);
        StringBuilder resultURL = new StringBuilder(StaticsContainer.loginUrl);
        if (originalURL != null && !"".equals(originalURL)) {
            resultURL.append("?N38API=");
            resultURL.append(originalURL);
        }
        logger.debug("URLLogin is: " + resultURL);
        return resultURL.toString();
    }

    @Override
    public void logout(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        String uidSession = this.getUserConnectedUidSession(httpRequest);
        if (uidSession == null) {
            N38API n38Api = XlnetCore.getN38API(httpRequest);
            uidSession = XlnetCore.getParameterSession(n38Api, "n38uidsesion");
        }
        logger.info("Proceeding to destroy uidSession: " + uidSession);
        N38APISesion n38ApiSesion = new N38APISesion();
        n38ApiSesion.n38APISesionDestruir(uidSession);
        this.deleteAllXLNetsCookies(httpRequest, httpResponse);
        logger.info("XLNets Session " + uidSession + " destroyed!");
    }

    protected boolean isN38ApiValid(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws SecurityException {
        Document xmlSesion = null;
        HttpSession httpSession = httpRequest.getSession(false);
        HashMap<String, String> userInfo = null;
        N38API n38Api = XlnetCore.getN38API(httpRequest);
        if (n38Api != null) {
            block7: {
                logger.info("Validating the session of XLNets!");
                try {
                    xmlSesion = XlnetCore.getN38ItemSesion(n38Api);
                    if (!XlnetCore.isXlnetSessionContainingErrors(xmlSesion) && !XlnetCore.isXlnetSessionContainingWarnings(xmlSesion)) break block7;
                    logger.info("The XLNET session is invalid");
                    n38Api = null;
                    xmlSesion = null;
                    this.logout(httpRequest, httpResponse);
                    this.authenticationLogContextClean();
                    return false;
                }
                catch (Exception e) {
                    logger.error("isN38ApiValid(): There was an access error in XLNets. it Is possible that you having any problem with the configuration of XLNets or XLNets have some own internal error (Check that the service works correctly).", e);
                    SecurityException sec = new SecurityException("isN38ApiValid(): There was an access error in XLNets. it Is possible that you having any problem with the configuration of XLNets or XLNets have some own internal error (Check that the service works correctly).", e.getCause());
                    throw sec;
                }
            }
            logger.info("XLNET session is valid.");
            if (!XlnetCore.getParameterSession(n38Api, "n38uidOrg").equals("0")) {
                userInfo = XlnetCore.getUserDataInfo(n38Api);
                httpSession.setAttribute("name", (Object)userInfo.get("name"));
                httpSession.setAttribute("surname", (Object)userInfo.get("surname"));
                httpSession.setAttribute("fullName", (Object)userInfo.get("fullName"));
            } else {
                userInfo = XlnetCore.getN38SubjectCert(xmlSesion);
                httpSession.setAttribute("serialNumber", (Object)userInfo.get("SERIALNUMBER"));
                httpSession.setAttribute("name", (Object)userInfo.get("GIVENNAME"));
                httpSession.setAttribute("surname", (Object)userInfo.get("SURNAME"));
                httpSession.setAttribute("fullName", (Object)userInfo.get("CN"));
            }
            if (this.xlnetsDomain == null) {
                this.xlnetsDomain = XlnetCore.getN38DominioComunCookie(xmlSesion);
            }
            n38Api = null;
            xmlSesion = null;
            return true;
        }
        this.deleteAllXLNetsCookies(httpRequest, httpResponse);
        return false;
    }

    private void authenticationLogContextClean() {
        MDC.put("session", "N/A");
        MDC.put("user", "N/A");
        MDC.put("position", "N/A");
    }

    private void springSecurityContextClean(HttpSession httpSession) {
        logger.info("XLNET session is invalid. Proceeding to clean the Security Context Holder.");
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            authentication.setAuthenticated(false);
        }
        SecurityContextHolder.clearContext();
        if (httpSession.getAttribute("SPRING_SECURITY_CONTEXT") != null) {
            httpSession.removeAttribute("SPRING_SECURITY_CONTEXT");
        }
    }

    private void deleteAllXLNetsCookies(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        Cookie[] requestCookies;
        if (this.xlnetsDomain != null && (requestCookies = httpRequest.getCookies()) != null) {
            int i = 0;
            while (i < requestCookies.length) {
                if (requestCookies[i].getName().split("n38").length > 1) {
                    Cookie n38Cookie = requestCookies[i];
                    n38Cookie.setDomain(this.xlnetsDomain);
                    n38Cookie.setMaxAge(0);
                    n38Cookie.setPath("/");
                    httpResponse.addCookie(n38Cookie);
                }
                ++i;
            }
        }
    }

    private String getXlnetsUserId(HttpServletRequest httpRequest) {
        Cookie[] requestCookies = httpRequest.getCookies();
        Cookie n38UidSesion = null;
        Cookie n38UidSistemasXLNetS = null;
        StringBuilder udaXLNetsSessionId = new StringBuilder();
        if (requestCookies != null) {
            int i = 0;
            while (i < requestCookies.length) {
                if (requestCookies[i].getName().equals("n38UidSesion")) {
                    n38UidSesion = requestCookies[i];
                } else if (requestCookies[i].getName().equals("n38UidSistemasXLNetS")) {
                    n38UidSistemasXLNetS = requestCookies[i];
                }
                ++i;
            }
        }
        logger.debug("getXlnetsUserId: udaXlnetsSession value");
        if (n38UidSesion != null && n38UidSistemasXLNetS != null) {
            udaXLNetsSessionId.append(n38UidSistemasXLNetS.getValue()).append("-").append(n38UidSesion.getValue());
            logger.debug("getXlnetsUserId: cookie - n38UidSistemasXLNetS => " + n38UidSistemasXLNetS.getValue());
        } else if (n38UidSesion != null) {
            udaXLNetsSessionId.append(n38UidSesion.getValue());
            logger.debug("getXlnetsUserId: cookie - n38UidSesion => " + n38UidSesion.getValue());
        } else {
            logger.debug("getXlnetsUserId: null");
            return null;
        }
        logger.debug("getXlnetsUserId: udaXlnetsSession value => " + udaXLNetsSessionId.toString());
        return udaXLNetsSessionId.toString();
    }

    protected String loadXlnetsCredentialInfo(HttpServletRequest httpRequest, String xLNetsUserId) {
        String UserName;
        N38API n38Api = XlnetCore.getN38API(httpRequest);
        HttpSession httpSession = httpRequest.getSession(false);
        Document xmlSecurityData = null;
        Vector<String> userProfiles = new Vector<String>();
        String serialNumber = null;
        httpSession.setAttribute("nif", (Object)XlnetCore.getParameterSession(n38Api, "dni"));
        String policy = XlnetCore.getParameterSession(n38Api, "n38certificadopoliticas");
        httpSession.setAttribute("policy", (Object)policy);
        if (!policy.toLowerCase().equals("no")) {
            httpSession.setAttribute("isCertificate", (Object)"true");
        } else {
            httpSession.setAttribute("isCertificate", (Object)"false");
        }
        if (!XlnetCore.getParameterSession(n38Api, "n38uidOrg").equals("0")) {
            UserName = XlnetCore.getParameterSession(n38Api, "n38personasuid");
            httpSession.setAttribute("userName", (Object)UserName);
            httpSession.setAttribute("position", (Object)XlnetCore.getParameterSession(n38Api, "n38puestouid"));
            httpSession.setAttribute("uidSession", (Object)XlnetCore.getParameterSession(n38Api, "n38uidsesion"));
            httpSession.setAttribute("udaValidateSessionId", (Object)xLNetsUserId);
            if (this.alternativeOriginCredentialsApp != null && this.alternativeOriginCredentialsApp.existAditionalsAppCodes(httpRequest)) {
                List<String> appCodes = this.alternativeOriginCredentialsApp.getAppCodes(httpRequest);
                for (String appCode : appCodes) {
                    xmlSecurityData = XlnetCore.getN38ItemSeguridad(n38Api, appCode);
                    if (xmlSecurityData == null) continue;
                    userProfiles.addAll(XlnetCore.searchParameterIntoXlnetSesion(xmlSecurityData, "/n38/elementos/elemento/elemento/elemento/parametro[@id='n38uidobjseguridad']/valor"));
                }
            }
            if ((xmlSecurityData = XlnetCore.getN38ItemSeguridad(n38Api, StaticsContainer.webAppName)) != null) {
                userProfiles.addAll(XlnetCore.searchParameterIntoXlnetSesion(xmlSecurityData, "/n38/elementos/elemento/elemento/elemento/parametro[@id='n38uidobjseguridad']/valor"));
            }
            httpSession.setAttribute("userProfiles", userProfiles);
        } else {
            UserName = (String)httpSession.getAttribute("fullName");
            serialNumber = (String)httpSession.getAttribute("serialNumber");
            httpSession.setAttribute("userName", (Object)UserName);
            httpSession.setAttribute("uidSession", (Object)httpSession.getId());
            httpSession.setAttribute("udaValidateSessionId", (Object)xLNetsUserId);
            Vector<String> userprofile = new Vector<String>();
            if (this.alternativeStorageUserCredentials == null) {
                userprofile.add(this.anonymousProfile.get("userProfiles"));
                httpSession.setAttribute("position", (Object)this.anonymousProfile.get("position"));
            } else {
                userprofile = this.alternativeStorageUserCredentials.loadUserAuthorities(UserName, serialNumber, n38Api);
                httpSession.setAttribute("position", (Object)this.alternativeStorageUserCredentials.loadUserPosition(UserName, serialNumber, n38Api));
            }
            httpSession.removeAttribute("serialNumber");
            httpSession.setAttribute("userProfiles", userprofile);
        }
        httpSession.setAttribute("destroySessionSecuritySystem", (Object)this.destroySessionSecuritySystem);
        return UserName;
    }

    private synchronized void loadReloadData(HttpServletRequest httpRequest, Long currentThreadId) {
        HttpSession session = httpRequest.getSession(false);
        if (session != null && session.getAttribute("reloadData") == null) {
            logger.debug("loadReloadData: " + currentThreadId.toString());
            session.setAttribute("reloadData", (Object)currentThreadId);
        }
    }

    private synchronized boolean reloadData(HttpServletRequest httpRequest) {
        HttpSession httpSession = httpRequest.getSession(false);
        if (httpSession.getAttribute("credentialsLoading") == null && System.currentTimeMillis() - Long.valueOf("" + httpSession.getAttribute("udaTimeStamp")) > this.xlnetCachingPeriod) {
            httpSession.removeAttribute("udaTimeStamp");
            httpSession.setAttribute("udaTimeStamp", (Object)System.currentTimeMillis());
            return true;
        }
        return false;
    }

    public Long getXlnetCachingPeriod() {
        return TimeUnit.SECONDS.convert(this.xlnetCachingPeriod, TimeUnit.MILLISECONDS);
    }

    public String getUserChangeUrl() {
        return this.userChangeUrl;
    }

    public UdaCustomJdbcDaoImpl getAlternativeStorageUserCredentials() {
        return this.alternativeStorageUserCredentials;
    }

    public HashMap<String, String> getAnonymousProfile() {
        return this.anonymousProfile;
    }

    @Override
    public boolean getDestroySessionSecuritySystem() {
        return this.destroySessionSecuritySystem;
    }

    public ExcludeFilter getExcludeFilter() {
        return this.excludeFilter;
    }

    public Object getAlternativeOriginCredentialsApp() {
        return this.alternativeOriginCredentialsApp;
    }

    public Object getSpecificCredentials() {
        return this.specificCredentials;
    }

    @Override
    public Credentials getCredentials() {
        if (this.specificCredentialsName == null) {
            return new UserCredentials();
        }
        try {
            return (Credentials)Class.forName(this.specificCredentialsName).newInstance();
        }
        catch (Exception e) {
            logger.error("getCredentials(): The object specified to the parameter \"SpecificCredentials\" is not correct. The object has not been instantiated", e);
            SecurityException sec = new SecurityException("getCredentials(): The object specified to the parameter \"SpecificCredentials\" is not correct. The object has not been instantiated", e.getCause());
            throw sec;
        }
    }

    public void setXlnetCachingPeriod(Long xlnetCachingPeriod) {
        this.xlnetCachingPeriod = TimeUnit.MILLISECONDS.convert(xlnetCachingPeriod, TimeUnit.SECONDS);
    }

    public void setUserChangeUrl(String userChangeUrl) {
        this.userChangeUrl = userChangeUrl;
    }

    public void setAlternativeStorageUserCredentials(UdaCustomJdbcDaoImpl alternativeStorageUserCredentials) {
        if (alternativeStorageUserCredentials.getPositionByUserdataQuery() == null || alternativeStorageUserCredentials.getAuthoritiesByUserdataQuery() == null) {
            UnsatisfiedDependencyException exc = new UnsatisfiedDependencyException("security-config", "PerimetralSecurityWrapperN38Impl", "alternativeStorageUserCredentials", "The PositionByUserdataQuery parameter and the AuthoritiesByUserdataQuery parameter can't be nulls");
            logger.error("The PositionByUserdataQuery parameter and the AuthoritiesByUserdataQuery parameter can't be nulls.", exc);
            throw exc;
        }
        this.alternativeStorageUserCredentials = alternativeStorageUserCredentials;
    }

    public void setAnonymousCredentials(HashMap<String, String> anonymousProfile) {
        this.anonymousProfile = anonymousProfile;
    }

    @Override
    public void setDestroySessionSecuritySystem(boolean destroySessionSecuritySystem) {
        this.destroySessionSecuritySystem = destroySessionSecuritySystem;
    }

    public void setExcludeFilter(ExcludeFilter excludeFilter) {
        this.excludeFilter = excludeFilter;
    }

    public void setAlternativeOriginCredentialsApp(Object alternativeOriginCredentialsApp) {
        AlternativeOriginCredentialsApp alternativeOriginCredentialsAppObject;
        block6: {
            try {
                if (alternativeOriginCredentialsApp instanceof String) {
                    alternativeOriginCredentialsAppObject = new AlternativeOriginCredentialsAppImp((String)alternativeOriginCredentialsApp);
                    break block6;
                }
                if (alternativeOriginCredentialsApp instanceof List) {
                    List validateAlternativeOriginCredentialsApp = (List)alternativeOriginCredentialsApp;
                    for (Object o : validateAlternativeOriginCredentialsApp) {
                        if (o instanceof String) continue;
                        throw new UnsatisfiedDependencyException("security-config", "PerimetralSecurityWrapperN38Impl", "alternativeOriginCredentialsApp", "The specified object is not correct to the parameter  \"alternativeOriginCredentialsApp\". The object must be instace of String, List <String> or AlternativeOriginCredentialsApp.");
                    }
                    alternativeOriginCredentialsAppObject = new AlternativeOriginCredentialsAppImp((List)alternativeOriginCredentialsApp);
                    break block6;
                }
                if (alternativeOriginCredentialsApp instanceof AlternativeOriginCredentialsApp) {
                    alternativeOriginCredentialsAppObject = (AlternativeOriginCredentialsApp)alternativeOriginCredentialsApp;
                    break block6;
                }
                throw new UnsatisfiedDependencyException("security-config", "PerimetralSecurityWrapperN38Impl", "alternativeOriginCredentialsApp", "The specified object is not correct to the parameter  \"alternativeOriginCredentialsApp\". The object must be instace of String, List <String> or AlternativeOriginCredentialsApp.");
            }
            catch (Exception e) {
                UnsatisfiedDependencyException exc = new UnsatisfiedDependencyException("security-config", "PerimetralSecurityWrapperN38Impl", "alternativeOriginCredentialsApp", "The specified object is not correct to the parameter  \"alternativeOriginCredentialsApp\". The object must be instace of String, List <String> or AlternativeOriginCredentialsApp.");
                logger.error("The specified object is not correct to the parameter  \"alternativeOriginCredentialsApp\". The object must be instace of String, List <String> or AlternativeOriginCredentialsApp.", exc);
                throw exc;
            }
        }
        this.alternativeOriginCredentialsApp = alternativeOriginCredentialsAppObject;
    }

    public void setSpecificCredentials(Object credentials) {
        block7: {
            Object specificCredentials = credentials;
            try {
                try {
                    if (specificCredentials instanceof String) {
                        specificCredentials = Class.forName((String)credentials).newInstance();
                    }
                    if (specificCredentials instanceof Credentials) {
                        this.specificCredentialsName = specificCredentials.getClass().getName();
                        break block7;
                    }
                    throw new UnsatisfiedDependencyException("security-config", "PerimetralSecurityWrapperN38Impl", "setSpecificCredentials", "The specified object is not correct to the parameter  \"SpecificCredentials\". The object must be instace of String (className of a Class than extend the \"Credentials\" Class) or one Bean of a Class than extend the \"Credentials\" Class.");
                }
                catch (Exception e) {
                    throw new UnsatisfiedDependencyException("security-config", "PerimetralSecurityWrapperN38Impl", "setSpecificCredentials", "The specified object is not correct to the parameter  \"SpecificCredentials\". The object must be instace of String (className of a Class than extend the \"Credentials\" Class) or one Bean of a Class than extend the \"Credentials\" Class.");
                }
            }
            finally {
                this.specificCredentials = specificCredentials;
            }
        }
    }
}

