/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.security;

import com.ejie.x38.security.Credentials;
import com.ejie.x38.security.PerimetralSecurityWrapper;
import com.ejie.x38.security.UserCredentials;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.MappingJsonFactory;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.UnsatisfiedDependencyException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.context.WebApplicationContext;

public class PerimetralSecurityWrapperMockImpl
implements PerimetralSecurityWrapper {
    @Autowired
    private WebApplicationContext webApplicationContext;
    private static final Logger logger = LoggerFactory.getLogger(PerimetralSecurityWrapperMockImpl.class);
    private ArrayList<HashMap<String, Object>> principal;
    private String userChangeUrl;
    private Object specificCredentials = null;
    private String specificCredentialsName = null;
    private boolean destroySessionSecuritySystem = false;

    @Override
    public String validateSession(HttpServletRequest httpRequest, HttpServletResponse response) throws SecurityException {
        Credentials credentials = null;
        Authentication authentication = null;
        StringBuilder udaMockSessionId = new StringBuilder();
        HttpSession httpSession = httpRequest.getSession(true);
        Cookie[] requestCookies = httpRequest.getCookies();
        Cookie udaMockUserName = null;
        if (requestCookies != null) {
            int i = 0;
            while (i < requestCookies.length) {
                if (requestCookies[i].getName().equals("udaMockUserName")) {
                    udaMockUserName = requestCookies[i];
                    break;
                }
                ++i;
            }
        }
        if (udaMockUserName != null) {
            udaMockSessionId.append(udaMockUserName.getValue());
            udaMockSessionId.append("-");
            udaMockSessionId.append(httpRequest.getSession(false).getId());
            authentication = SecurityContextHolder.getContext().getAuthentication();
            if (authentication != null) {
                credentials = (Credentials)authentication.getCredentials();
            }
            if (credentials != null && !credentials.getUdaValidateSessionId().equals(udaMockSessionId.toString())) {
                this.authenticationLogContextClean();
                httpSession.setAttribute("reloadData", (Object)"true");
                httpSession.setAttribute("userChange", (Object)"true");
                if (this.userChangeUrl != null) {
                    SecurityContextHolder.clearContext();
                    return this.userChangeUrl;
                }
            }
            return "true";
        }
        return "false";
    }

    @Override
    public String getUserConnectedUidSession(HttpServletRequest httpRequest) {
        if (httpRequest.getSession(false) != null) {
            return httpRequest.getSession(false).getId();
        }
        return "no session available";
    }

    @Override
    public String getUserPosition(HttpServletRequest httpRequest) {
        HashMap<String, Object> user = this.getUserData(this.principal, this.getUserConnectedUserName(httpRequest));
        return (String)user.get("position");
    }

    @Override
    public String getUdaValidateSessionId(HttpServletRequest httpRequest) {
        StringBuilder udaMockSessionId = new StringBuilder();
        udaMockSessionId.append(this.getUserConnectedUserName(httpRequest));
        udaMockSessionId.append("-");
        udaMockSessionId.append(httpRequest.getSession(false).getId());
        return udaMockSessionId.toString();
    }

    @Override
    public String getUserConnectedUserName(HttpServletRequest httpRequest) {
        Cookie[] requestCookies = httpRequest.getCookies();
        Cookie udaMockUserName = null;
        if (requestCookies != null) {
            int i = 0;
            while (i < requestCookies.length) {
                if (requestCookies[i].getName().equals("udaMockUserName")) {
                    udaMockUserName = requestCookies[i];
                    break;
                }
                ++i;
            }
        }
        if (httpRequest.getSession(false).getAttribute("fullName") == null) {
            HashMap<String, Object> user = this.getUserData(this.principal, udaMockUserName.getValue());
            httpRequest.getSession(false).setAttribute("fullName", (Object)((String)user.get("fullName")));
        }
        return udaMockUserName.getValue();
    }

    @Override
    public HashMap<String, String> getUserDataInfo(HttpServletRequest httpRequest, boolean isCertificate) {
        HashMap<String, Object> user = this.getUserData(this.principal, this.getUserConnectedUserName(httpRequest));
        HashMap userData = new HashMap();
        if (isCertificate && user.get("subjectCert") != null) {
            userData = (HashMap)user.get("subjectCert");
        }
        userData.put("name", (String)user.get("name"));
        userData.put("surname", (String)user.get("surname"));
        userData.put("fullName", (String)user.get("fullName"));
        return userData;
    }

    @Override
    public Vector<String> getUserInstances(HttpServletRequest httpRequest) {
        HashMap<String, Object> user = this.getUserData(this.principal, this.getUserConnectedUserName(httpRequest));
        return new Vector<String>((ArrayList)user.get("roles"));
    }

    @Override
    public String getPolicy(HttpServletRequest httpRequest) {
        HashMap<String, Object> user = this.getUserData(this.principal, this.getUserConnectedUserName(httpRequest));
        return (String)user.get("policy");
    }

    @Override
    public boolean getIsCertificate(HttpServletRequest httpRequest) {
        HashMap<String, Object> user = this.getUserData(this.principal, this.getUserConnectedUserName(httpRequest));
        return !((String)user.get("isCertificate")).equals("false");
    }

    @Override
    public String getNif(HttpServletRequest httpRequest) {
        HashMap<String, Object> user = this.getUserData(this.principal, this.getUserConnectedUserName(httpRequest));
        return (String)user.get("nif");
    }

    @Override
    public String getURLLogin(String originalURL, boolean ajax) {
        String dataUsers = null;
        ArrayList usersNames = new ArrayList();
        Iterator<HashMap<String, Object>> usersIterator = this.principal.iterator();
        HashMap<String, String> auxObject = new HashMap<String, String>();
        ObjectMapper mapper = new ObjectMapper();
        StringWriter sw = new StringWriter();
        MappingJsonFactory jsonFactory = new MappingJsonFactory();
        while (usersIterator.hasNext()) {
            auxObject = new HashMap();
            HashMap<String, Object> user = usersIterator.next();
            auxObject.put("i18nCaption", (String)user.get("fullName"));
            auxObject.put("value", (String)user.get("userName"));
            usersNames.add(auxObject);
        }
        try {
            JsonGenerator jsonGenerator = jsonFactory.createJsonGenerator(sw);
            mapper.writeValue(jsonGenerator, usersNames);
            sw.close();
            dataUsers = sw.getBuffer().toString();
            jsonGenerator = null;
            mapper = null;
            jsonFactory = null;
        }
        catch (Exception e) {
            logger.error("Produced a error in the conversion of the mockWrapper usernames. Review your configuration. The response is void.");
            if (!ajax) {
                return String.valueOf(this.webApplicationContext.getServletContext().getContextPath()) + "/mockLoginPage?mockUrl=" + originalURL + "&userNames=\"\"";
            }
            return String.valueOf(this.webApplicationContext.getServletContext().getContextPath()) + "/mockLoginAjaxPage?mockUrl=" + originalURL + "&userNames=\"\"";
        }
        if (!ajax) {
            return String.valueOf(this.webApplicationContext.getServletContext().getContextPath()) + "/mockLoginPage?mockUrl=" + originalURL + "&userNames=" + dataUsers;
        }
        return String.valueOf(this.webApplicationContext.getServletContext().getContextPath()) + "/mockLoginAjaxPage?mockUrl=" + originalURL + "&userNames=" + dataUsers;
    }

    @Override
    public void logout(HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        String uidSession = this.getUserConnectedUidSession(httpRequest);
        logger.info("Proceeding to destroy uidSession: " + uidSession);
        this.springSecurityContextClean();
        Cookie[] requestCookies = httpRequest.getCookies();
        Cookie udaMockUserName = null;
        if (requestCookies != null) {
            int i = 0;
            while (i < requestCookies.length) {
                if (requestCookies[i].getName().equals("udaMockUserName")) {
                    udaMockUserName = requestCookies[i];
                    udaMockUserName.setMaxAge(0);
                    udaMockUserName.setPath("/");
                    httpResponse.addCookie(udaMockUserName);
                    break;
                }
                ++i;
            }
        }
        logger.info("Session " + uidSession + " destroyed!");
    }

    private void springSecurityContextClean() {
        logger.error("Session is invalid. Proceeding to clean the Security Context Holder.");
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            authentication.setAuthenticated(false);
        }
        SecurityContextHolder.clearContext();
    }

    private HashMap<String, Object> getUserData(ArrayList<HashMap<String, Object>> principal, String name) {
        Iterator<HashMap<String, Object>> usersIterator = principal.iterator();
        HashMap<String, Object> user = null;
        while (usersIterator.hasNext()) {
            user = usersIterator.next();
            if (((String)user.get("userName")).equals(name)) break;
        }
        return user;
    }

    private void authenticationLogContextClean() {
        MDC.put("session", "N/A");
        MDC.put("user", "N/A");
        MDC.put("position", "N/A");
    }

    public Object getSpecificCredentials() {
        return this.specificCredentials;
    }

    @Override
    public Credentials getCredentials() {
        if (this.specificCredentialsName == null) {
            return new UserCredentials();
        }
        try {
            return (Credentials)Class.forName(this.specificCredentialsName).newInstance();
        }
        catch (Exception e) {
            logger.error("getCredentials(): The object specified to the parameter \"SpecificCredentials\" is not correct. The object has not been instantiated", e);
            SecurityException sec = new SecurityException("getCredentials(): The object specified to the parameter \"SpecificCredentials\" is not correct. The object has not been instantiated", e.getCause());
            throw sec;
        }
    }

    @Override
    public boolean getDestroySessionSecuritySystem() {
        return this.destroySessionSecuritySystem;
    }

    public ArrayList<HashMap<String, Object>> getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(ArrayList<HashMap<String, Object>> principal) {
        this.principal = principal;
        HashMap<String, Object> userAnonymous = new HashMap<String, Object>();
        ArrayList<String> roles = new ArrayList<String>();
        HashMap subjectCert = new HashMap();
        roles.add("UDAANONYMOUS");
        userAnonymous.put("userName", "udaAnonymousUser");
        userAnonymous.put("name", "uda");
        userAnonymous.put("surName", "Anonymous User");
        userAnonymous.put("fullName", "Uda Anonymous User");
        userAnonymous.put("nif", "00000000a");
        userAnonymous.put("policy", "udaAnonymousPolicy");
        userAnonymous.put("position", "udaAnonymousPosition");
        userAnonymous.put("isCertificate", "no");
        userAnonymous.put("subjectCert", subjectCert);
        userAnonymous.put("roles", roles);
        this.principal.add(userAnonymous);
    }

    public String getUserChangeUrl() {
        return this.userChangeUrl;
    }

    public void setUserChangeUrl(String userChangeUrl) {
        this.userChangeUrl = userChangeUrl;
    }

    public void setSpecificCredentials(Object credentials) {
        block7: {
            Object specificCredentials = credentials;
            try {
                try {
                    if (specificCredentials instanceof String) {
                        specificCredentials = Class.forName((String)credentials).newInstance();
                    }
                    if (specificCredentials instanceof Credentials) {
                        this.specificCredentialsName = specificCredentials.getClass().getName();
                        break block7;
                    }
                    throw new UnsatisfiedDependencyException("security-config", "PerimetralSecurityWrapperN38Impl", "setSpecificCredentials", "The specified object is not correct to the parameter  \"SpecificCredentials\". The object must be instace of String (className of a Class than extend the \"Credentials\" Class) or one Bean of a Class than extend the \"Credentials\" Class.");
                }
                catch (Exception e) {
                    throw new UnsatisfiedDependencyException("security-config", "PerimetralSecurityWrapperN38Impl", "setSpecificCredentials", "The specified object is not correct to the parameter  \"SpecificCredentials\". The object must be instace of String (className of a Class than extend the \"Credentials\" Class) or one Bean of a Class than extend the \"Credentials\" Class.");
                }
            }
            finally {
                this.specificCredentials = specificCredentials;
            }
        }
    }

    @Override
    public void setDestroySessionSecuritySystem(boolean destroySessionSecuritySystem) {
    }
}

