/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.security;

import com.ejie.x38.security.PerimetralSecurityWrapper;
import com.ejie.x38.util.ManagementUrl;
import com.ejie.x38.util.StaticsContainer;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.Ordered;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;

public class MyAuthenticationEntryPoint
implements AuthenticationEntryPoint,
Ordered {
    private static final Logger logger = LoggerFactory.getLogger(MyAuthenticationEntryPoint.class);
    private int order = Integer.MAX_VALUE;
    private PerimetralSecurityWrapper perimetralSecurityWrapper;

    @Override
    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        if (authException != null) {
            logger.debug("Authentication Exception: " + authException.getMessage());
        }
        HttpServletResponse httpResponse = response;
        HttpServletRequest httpRequest = request;
        Cookie[] requestCookies = request.getCookies();
        StringBuilder portalData = new StringBuilder("/");
        boolean isAjax = request.getHeaders("X-Requested-With").hasMoreElements();
        boolean isPortal = false;
        String originalURL = ManagementUrl.getUrl(httpRequest);
        if (StaticsContainer.aplicInPortal && requestCookies != null) {
            int i = 0;
            while (i < requestCookies.length) {
                if (requestCookies[i].getName().equals("r01PortalInfo")) {
                    isPortal = true;
                    portalData.append(requestCookies[i].getValue());
                    StringBuilder host = new StringBuilder(httpRequest.getServerName());
                    if (originalURL.split(":").length > 1) {
                        host.append(":");
                        host.append(httpRequest.getServerPort());
                    }
                    originalURL = originalURL.replaceAll(host.toString(), String.valueOf(host.toString()) + portalData.toString());
                    break;
                }
                ++i;
            }
        }
        logger.info("XLNET Session isn't valid or not created!");
        String url = !isAjax || !isPortal ? this.getPerimetralSecurityWrapper().getURLLogin(originalURL, isAjax) : String.valueOf(this.getPerimetralSecurityWrapper().getURLLogin(originalURL, isAjax)) + "&R01HNoPortal=true";
        logger.info("Redirecting to next URL:" + url);
        httpResponse.sendRedirect(url);
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public PerimetralSecurityWrapper getPerimetralSecurityWrapper() {
        return this.perimetralSecurityWrapper;
    }

    public void setPerimetralSecurityWrapper(PerimetralSecurityWrapper perimetralSecurityWrapper) {
        this.perimetralSecurityWrapper = perimetralSecurityWrapper;
    }
}

