/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.security;

import java.io.IOException;
import java.nio.charset.Charset;
import javax.annotation.Resource;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.web.access.AccessDeniedHandler;

public class MyAccessDeniedHandler
implements AccessDeniedHandler {
    private String errorPage;
    @Resource
    private ReloadableResourceBundleMessageSource messageSource;

    @Override
    public void handle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AccessDeniedException accessDeniedException) throws IOException, ServletException {
        if (!httpServletResponse.isCommitted()) {
            if (!httpServletRequest.getHeaders("X-Requested-With").hasMoreElements()) {
                if (this.errorPage != null) {
                    httpServletRequest.setAttribute("SPRING_SECURITY_403_EXCEPTION", (Object)accessDeniedException);
                    httpServletResponse.setStatus(403);
                    RequestDispatcher dispatcher = httpServletRequest.getRequestDispatcher(this.errorPage);
                    dispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
                } else {
                    String content = accessDeniedException.getMessage();
                    httpServletResponse.setStatus(403);
                    httpServletResponse.setContentLength(content.getBytes(Charset.forName(httpServletResponse.getCharacterEncoding())).length);
                    httpServletResponse.getWriter().print(content);
                    httpServletResponse.flushBuffer();
                }
            } else {
                String message = this.messageSource.getMessage("security.ajaxAccesError", null, LocaleContextHolder.getLocale());
                ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
                httpServletResponse.setStatus(403);
                servletOutputStream.print(message);
                httpServletResponse.flushBuffer();
            }
        }
    }

    public void setErrorPage(String errorPage) {
        if (errorPage != null && !errorPage.startsWith("/")) {
            throw new IllegalArgumentException("errorPage must begin with '/'");
        }
        this.errorPage = errorPage;
    }
}

