/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.reports;

import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.reports.JerarquiaMetadata;
import com.ejie.x38.reports.ReportData;
import java.io.OutputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfSpreadsheetDocument;
import org.odftoolkit.odfdom.doc.table.OdfTable;
import org.odftoolkit.odfdom.doc.table.OdfTableRow;
import org.springframework.web.servlet.view.AbstractView;

public class ODSReportView
extends AbstractView {
    @Override
    protected void renderMergedOutputModel(Map<String, Object> model, HttpServletRequest request, HttpServletResponse response) throws Exception {
        response.setHeader("Content-type", "application/vnd.oasis.opendocument.spreadsheet");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + model.get("fileName") + ".ods\"");
        OdfSpreadsheetDocument osd = OdfSpreadsheetDocument.newSpreadsheetDocument();
        osd.getOrCreateDocumentStyles();
        osd.getTableByName("Sheet1").remove();
        List reportData = (List)model.get("reportData");
        for (ReportData dataSheet : reportData) {
            boolean isJerarquia = dataSheet.isJerarquia();
            boolean isGrouping = dataSheet.isGrouping();
            JerarquiaMetadata jmd = dataSheet.getJerarquiaMetadada();
            LinkedHashMap dataHeader = (LinkedHashMap)dataSheet.getHeaderNames();
            List<Object> modelData = !isJerarquia ? dataSheet.getModelData() : dataSheet.getModelDataJerarquia();
            OdfTable table = OdfTable.newTable((OdfDocument)osd, (int)(modelData.size() + 1), (int)dataHeader.size());
            table.setTableName(dataSheet.getSheetName());
            OdfTableRow tablerow = table.getRowByIndex(0);
            int cellNum = 0;
            int rowNum = 0;
            if (dataSheet.isShowHeaders()) {
                if (isGrouping) {
                    tablerow.getCellByIndex(cellNum++).setStringValue("");
                }
                if (isJerarquia && jmd.isShowFiltered()) {
                    if (!"".equals(jmd.getFilterHeaderName())) {
                        tablerow.getCellByIndex(cellNum++).setStringValue(jmd.getFilterHeaderName());
                    } else {
                        tablerow.getCellByIndex(cellNum++).setStringValue("");
                    }
                }
                for (Map.Entry entry : dataHeader.entrySet()) {
                    if (isGrouping && !dataSheet.isShowGroupColumng() && ((String)entry.getKey()).equals(dataSheet.getGroupColumnName())) continue;
                    tablerow.getCellByIndex(cellNum++).setStringValue((String)entry.getValue());
                }
                ++rowNum;
            }
            String prevGroupValue = "";
            String groupValue = "";
            for (Object object : modelData) {
                tablerow = table.getRowByIndex(rowNum++);
                cellNum = 0;
                int level = 0;
                boolean hasChildren = false;
                if (isGrouping) {
                    groupValue = BeanUtils.getProperty(((JerarquiaDto)object).getModel(), dataSheet.getGroupColumnName());
                    if (!groupValue.equals(prevGroupValue)) {
                        prevGroupValue = groupValue;
                        tablerow.getCellByIndex(cellNum++).setStringValue(groupValue);
                        tablerow = table.getRowByIndex(rowNum++);
                        cellNum = 0;
                    }
                    tablerow.getCellByIndex(cellNum++).setStringValue("");
                }
                if (isJerarquia) {
                    if (jmd.isShowFiltered()) {
                        if (((JerarquiaDto)object).isFilter()) {
                            tablerow.getCellByIndex(cellNum++).setStringValue(jmd.getFilterToken());
                        } else {
                            tablerow.getCellByIndex(cellNum++).setStringValue("");
                        }
                    }
                    level = ((JerarquiaDto)object).getLevel();
                    hasChildren = ((JerarquiaDto)object).isHasChildren();
                    object = ((JerarquiaDto)object).getModel();
                }
                for (Map.Entry entry : dataHeader.entrySet()) {
                    if (isGrouping && !dataSheet.isShowGroupColumng() && ((String)entry.getKey()).equals(dataSheet.getGroupColumnName())) continue;
                    String columnValue = BeanUtils.getProperty(object, (String)entry.getKey());
                    if (isJerarquia) {
                        if (jmd.isShowIcon() && ((String)entry.getKey()).equals(jmd.getIconColumnName())) {
                            columnValue = jmd.getIconCollapsedList().contains(BeanUtils.getProperty(object, jmd.getIconBeanAtribute())) ? String.valueOf(jmd.getIconUnexpanded()) + columnValue : (hasChildren ? String.valueOf(jmd.getIconExpanded()) + columnValue : String.valueOf(jmd.getIconNoChild()) + columnValue);
                        }
                        if (jmd.isShowTabbed() && ((String)entry.getKey()).equals(jmd.getTabColumnName())) {
                            columnValue = String.valueOf(jmd.getTab(level)) + columnValue;
                        }
                    }
                    tablerow.getCellByIndex(cellNum++).setStringValue(columnValue);
                }
            }
        }
        Cookie cookie = new Cookie("fileDownload", "true");
        cookie.setPath("/");
        response.addCookie(cookie);
        osd.save((OutputStream)response.getOutputStream());
    }
}

