/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.remote;

import ch.qos.logback.core.LogbackException;
import com.ejie.x38.log.security.CurrentUserManager;
import com.ejie.x38.security.Credentials;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

public class TransactionMetadata
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(TransactionMetadata.class);
    private SecurityContext securityContext;
    private String ipClient;
    private String noInternalAcces;
    private String serverInstance;

    public TransactionMetadata() {
        this.securityContext = null;
        this.ipClient = "N/A";
        this.noInternalAcces = "N/A";
        this.serverInstance = "N/A";
        TransactionMetadata auxTransactionMetadata = new TransactionMetadata("N/A", "N/A");
        this.setSecurityContext(auxTransactionMetadata.getSecurityContext());
        this.setIpClient(auxTransactionMetadata.getIpClient());
        this.setNoInternalAcces(auxTransactionMetadata.getNoInternalAcces());
        this.setSecurityContext(auxTransactionMetadata.getSecurityContext());
        auxTransactionMetadata = null;
    }

    public TransactionMetadata(String className, String methodName) {
        block3: {
            this.securityContext = null;
            this.ipClient = "N/A";
            this.noInternalAcces = "N/A";
            this.serverInstance = "N/A";
            try {
                this.setSecurityContext(SecurityContextHolder.getContext());
            }
            catch (Exception e) {
                if (e instanceof NullPointerException) break block3;
                throw new LogbackException("Error in the EJB remote calling system. Error accessing to the security context. The application doesn't have a security context", e);
            }
        }
        this.setNoInternalAcces("ejbAcces");
        this.setServerInstance(System.getProperty("weblogic.Name"));
        if (MDC.get("noInternalAcces") != null && (MDC.get("noInternalAcces").equals("httpAcces") || MDC.get("noInternalAcces").equals("ejbAcces"))) {
            this.setIpClient(MDC.get("IPClient"));
        }
        logger.info("Make a remote call. The remote method " + methodName + " of the class " + className + " is invoked");
    }

    public String getNoInternalAcces() {
        return this.noInternalAcces;
    }

    public void setNoInternalAcces(String noInternalAcces) {
        this.noInternalAcces = noInternalAcces;
    }

    public String getServerInstance() {
        return this.serverInstance;
    }

    public void setServerInstance(String serverInstance) {
        this.serverInstance = serverInstance;
    }

    public SecurityContext getSecurityContext() {
        return this.securityContext;
    }

    public void setSecurityContext(SecurityContext securityContext) {
        this.securityContext = securityContext;
    }

    public String getIpClient() {
        return this.ipClient;
    }

    public void setIpClient(String ipClient) {
        this.ipClient = ipClient;
    }

    public void install() {
        MDC.put("noInternalAcces", this.getNoInternalAcces());
        MDC.put("IPClient", this.getIpClient());
        if (this.securityContext != null) {
            Credentials Credentials2 = (Credentials)this.getSecurityContext().getAuthentication().getCredentials();
            SecurityContextHolder.setContext(this.getSecurityContext());
            MDC.put("user", CurrentUserManager.getCurrentUsername());
            MDC.put("session", CurrentUserManager.getCurrentUserN38UidSesion(Credentials2));
            MDC.put("position", CurrentUserManager.getPosition(Credentials2));
        } else {
            logger.info("Remote service has not received the security context of the caller server. If the application has security services, is likely to occur a exception");
        }
        logger.info("The " + System.getProperty("weblogic.Name") + " instance receives a request remote from the instance " + this.getServerInstance());
    }

    public void clear() {
        logger.info("The " + System.getProperty("weblogic.Name") + " has completed the response to the request remote from the instance " + this.getServerInstance());
        MDC.clear();
        SecurityContextHolder.clearContext();
    }
}

