/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.log;

import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.LifeCycle;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusListener;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.StatusPrinter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdaLogStatusListener
extends ContextAwareBase
implements StatusListener,
LifeCycle {
    static final Logger logger = LoggerFactory.getLogger(UdaLogStatusListener.class);
    static final long DEFAULT_RESTROSPECTIVE = 300L;
    boolean isStarted = false;
    long retrospective = 300L;

    private void print(Status status) {
        StringBuilder sb = null;
        if (2 == status.getEffectiveLevel()) {
            sb = new StringBuilder(status.toString());
            StatusPrinter.buildStr(sb, "", status);
            System.out.println(sb);
            sb = null;
        }
    }

    @Override
    public void addStatusEvent(Status status) {
        if (!this.isStarted) {
            return;
        }
        this.print(status);
    }

    private void retrospectivePrint() {
        long now = System.currentTimeMillis();
        StatusManager sm = this.context.getStatusManager();
        List<Status> statusList = sm.getCopyOfStatusList();
        for (Status status : statusList) {
            long timestamp = status.getDate();
            if (now - timestamp >= this.retrospective) continue;
            this.print(status);
        }
    }

    @Override
    public void start() {
        this.isStarted = true;
        if (this.retrospective > 0L) {
            this.retrospectivePrint();
        }
    }

    public void setRetrospective(long retrospective) {
        this.retrospective = retrospective;
    }

    public long getRetrospective() {
        return this.retrospective;
    }

    @Override
    public void stop() {
        this.isStarted = false;
    }

    @Override
    public boolean isStarted() {
        return this.isStarted;
    }
}

