/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.log;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.joran.spi.JoranException;
import java.io.File;
import java.io.FileNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;
import org.springframework.util.SystemPropertyUtils;

public abstract class LogbackConfigurer {
    public static final String CLASSPATH_URL_PREFIX = "classpath:";
    public static final String XML_FILE_EXTENSION = ".xml";
    static final Logger logger = LoggerFactory.getLogger(LogbackConfigurer.class);

    public static void initLogging(String location, boolean printState) throws FileNotFoundException {
        logger.info("Begins the initialization of system logs");
        String resolvedLocation = null;
        File file = null;
        StringBuilder compositeLocator = new StringBuilder(CLASSPATH_URL_PREFIX);
        compositeLocator.append(location);
        if (location.contains(XML_FILE_EXTENSION)) {
            try {
                resolvedLocation = SystemPropertyUtils.resolvePlaceholders(compositeLocator.toString());
                file = ResourceUtils.getFile(resolvedLocation);
                logger.info("Read file => " + file.toString());
            }
            catch (FileNotFoundException fileNotFoundException) {
                try {
                    resolvedLocation = SystemPropertyUtils.resolvePlaceholders(location);
                    file = ResourceUtils.getFile(resolvedLocation);
                    logger.info("Read file => " + file.toString());
                }
                catch (FileNotFoundException fileNotFoundExceptionAbsolut) {
                    logger.error("There has been an error of incorrect path. The route is not included in the application classpath or an absolute path is correct.", fileNotFoundExceptionAbsolut);
                }
            }
            LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
            try {
                JoranConfigurator configurator = new JoranConfigurator();
                configurator.setContext(lc);
                lc.reset();
                configurator.doConfigure(file);
            }
            catch (JoranException je) {
                FileNotFoundException fnfe = new FileNotFoundException("There was an error initializing the system logs (logback). The specified file is incorrect or corrupt. " + je.getMessage());
                throw fnfe;
            }
            if (printState) {
                lc.getStatusManager();
            }
        } else {
            FileNotFoundException exc = new FileNotFoundException("The file specified for logback settings should be an xml file.");
            logger.error("There has been an error of incorrect path. The route is not included in the application classpath or an absolute path is correct.", exc);
            throw exc;
        }
        file = null;
        logger.info("Ends the initialization of system logs");
    }
}

