/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.log;

import com.ejie.x38.log.IncidenceLoggingAdvice;
import com.ejie.x38.log.LoggingManager;
import com.ejie.x38.util.StackTraceManager;
import com.ejie.x38.util.TableManager;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.XLogger;

public class IncidenceLoggingAdviceImpl
implements IncidenceLoggingAdvice {
    private static final Logger logger = LoggerFactory.getLogger(IncidenceLoggingAdviceImpl.class);
    private LoggingManager loggingManager;

    @Override
    public void logIncidence(Object target, Exception exception) {
        Hashtable<String, String> table = TableManager.initTable();
        table.put("criticality", XLogger.Level.ERROR.toString());
        table.put("functionalSubsystem", "Incidence Subsystem");
        table.put("aditionalInfo", StackTraceManager.getStackTrace(exception));
        table.put("message", exception.getMessage());
        this.loggingManager.logIncidences(target.getClass().getName(), logger, table);
    }

    @Override
    public LoggingManager getLoggingManager() {
        return this.loggingManager;
    }

    @Override
    public void setLoggingManager(LoggingManager loggingManager) {
        this.loggingManager = loggingManager;
    }
}

