/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.json;

import com.ejie.x38.json.JSONArray;
import com.ejie.x38.json.JSONObject;
import com.ejie.x38.json.JSONWriter;
import java.io.StringWriter;
import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

public class MessageWriter
extends JSONWriter {
    public MessageWriter() {
        super(new StringWriter());
    }

    public MessageWriter startMessageList() {
        this.array();
        return this;
    }

    public MessageWriter endMessageList() {
        this.endArray();
        return this;
    }

    public MessageWriter addMessage(String ... messageList) {
        String[] stringArray = messageList;
        int n = messageList.length;
        int n2 = 0;
        while (n2 < n) {
            String message = stringArray[n2];
            this.value(message);
            ++n2;
        }
        return this;
    }

    public MessageWriter addMessage(MessageSource messageSource, String ... messageList) {
        Locale locale = LocaleContextHolder.getLocale();
        String[] stringArray = messageList;
        int n = messageList.length;
        int n2 = 0;
        while (n2 < n) {
            String message = stringArray[n2];
            this.value(messageSource.getMessage(message, null, locale));
            ++n2;
        }
        return this;
    }

    public MessageWriter addMessage(MessageSource messageSource, String message, Object[] messageParams) {
        Locale locale = LocaleContextHolder.getLocale();
        this.value(messageSource.getMessage(message, messageParams, locale));
        return this;
    }

    public MessageWriter addComplexMessage(String message) {
        return this.addComplexMessage(null, message, null, null, false);
    }

    public MessageWriter addComplexMessage(String message, boolean i18nRupResource) {
        return this.addComplexMessage(null, message, null, null, i18nRupResource);
    }

    public MessageWriter addComplexMessage(String message, String style) {
        return this.addComplexMessage(null, message, null, style, false);
    }

    public MessageWriter addComplexMessage(MessageSource messageSource, String message) {
        return this.addComplexMessage(messageSource, message, null, null, false);
    }

    public MessageWriter addComplexMessage(MessageSource messageSource, String message, String style) {
        return this.addComplexMessage(messageSource, message, null, style, false);
    }

    public MessageWriter addComplexMessage(MessageSource messageSource, Object[] messageParams, String message) {
        return this.addComplexMessage(messageSource, message, messageParams, null, false);
    }

    public MessageWriter addComplexMessage(MessageSource messageSource, String message, Object[] messageParams, String style) {
        return this.addComplexMessage(messageSource, message, messageParams, style, false);
    }

    public MessageWriter addComplexMessage(MessageSource messageSource, String message, Object[] messageParams, String style, boolean i18nRupResource) {
        this.object();
        this.key(i18nRupResource ? "i18nCaption" : "label");
        if (messageSource != null) {
            Locale locale = LocaleContextHolder.getLocale();
            this.value(messageSource.getMessage(message, messageParams, locale));
        } else {
            this.value(message);
        }
        if (style != null) {
            this.key("style").value(style);
        }
        this.endObject();
        return this;
    }

    public MessageWriter startSubLevel() {
        this.array();
        return this;
    }

    public MessageWriter endSubLevel() {
        this.endArray();
        return this;
    }

    public String toString() {
        return this.mode == 'd' ? this.writer.toString() : null;
    }

    public JSONArray getJSONArray() {
        return new JSONArray(this.toString());
    }

    public JSONObject getJSONObject() {
        return new JSONObject(this.toString());
    }
}

