/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.dto;

import com.ejie.x38.dto.Pagination;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.BeanUtils;

public class PaginationManager
implements Serializable {
    private static final long serialVersionUID = 2127819481595995328L;

    public static StringBuilder getPaginationQuery(Pagination pagination, StringBuilder query) {
        return PaginationManager.getQueryForPagination(pagination, query, false);
    }

    protected static StringBuilder getQueryForPagination(Pagination pagination, StringBuilder query, boolean isJerarquia) {
        query.append((CharSequence)PaginationManager.getOrderBy(pagination, isJerarquia));
        StringBuilder paginationQuery = new StringBuilder();
        Long rows = pagination.getRows();
        Long page = pagination.getPage();
        if (page != null && rows != null) {
            paginationQuery.append("SELECT * FROM (SELECT rownum rnum, a.*  FROM (" + query + ")a) where rnum > " + rows * (page - 1L) + " and rnum < " + (rows * page + 1L));
        } else if (rows != null) {
            paginationQuery.append("SELECT * FROM (SELECT rownum rnum, a.*  FROM (" + query + ")a) where rnum > 0 and rnum < " + (rows + 1L));
        } else {
            return query;
        }
        return paginationQuery;
    }

    protected static StringBuilder getOrderBy(Pagination pagination, boolean isJerarquia) {
        StringBuilder orderBy = new StringBuilder();
        if (pagination.getSidx() != null) {
            if (!isJerarquia) {
                orderBy.append(" ORDER BY ");
            } else {
                orderBy.append("\n\t").append("order siblings by ");
            }
            orderBy.append(pagination.getSidx());
            orderBy.append(" ");
            orderBy.append(pagination.getSord());
            if (isJerarquia) {
                orderBy.append("\n");
            }
        }
        return orderBy;
    }

    protected static StringBuilder getMultiselectionSelectOutter(Pagination pagination) {
        return new StringBuilder().append(" , page, pageLine, tableLine ");
    }

    protected static StringBuilder getMultiselectionSelectInner(Pagination pagination) {
        return new StringBuilder().append(" , ceil(rownum/").append(pagination.getRows()).append(") page, case when (mod(rownum,").append(pagination.getRows()).append(")=0) then '").append(pagination.getRows()).append("' else TO_CHAR(mod(rownum,").append(pagination.getRows()).append(")) end as pageLine, rownum as tableLine ");
    }

    public static <T> StringBuilder getSearchQuery(StringBuilder query, Pagination<T> pagination, Class<T> clazz, List<Object> paramList, String searchSQL, List<Object> searchParamList, String ... pkList) {
        String pkStr = PaginationManager.strArrayToCommaSeparatedStr(pkList);
        StringBuilder sbSQL = new StringBuilder();
        sbSQL.append("\n").append("select ").append(pkStr).append((CharSequence)PaginationManager.getMultiselectionSelectOutter(pagination)).append("from ( ");
        sbSQL.append("\n\t").append("select ").append(pkStr).append((CharSequence)PaginationManager.getMultiselectionSelectInner(pagination));
        sbSQL.append("\n\t").append("from (").append((CharSequence)query);
        sbSQL.append("\n\t").append((CharSequence)PaginationManager.getOrderBy(pagination, false)).append(") ");
        sbSQL.append("\n").append(") ");
        sbSQL.append("\n").append("where 1=1 ");
        sbSQL.append("\n\t").append(searchSQL);
        paramList.addAll(searchParamList);
        return sbSQL;
    }

    public static <T> StringBuilder getReorderQuery(StringBuilder query, Pagination<T> pagination, Class<T> clazz, List<Object> paramList, String ... pkList) {
        String pkStr = PaginationManager.strArrayToCommaSeparatedStr(pkList);
        StringBuilder sbSQL = new StringBuilder();
        sbSQL.append("\n").append("select ").append(pkStr).append((CharSequence)PaginationManager.getMultiselectionSelectOutter(pagination)).append("from ( ");
        sbSQL.append("\n\t").append("select ").append(pkStr).append((CharSequence)PaginationManager.getMultiselectionSelectInner(pagination));
        sbSQL.append("\n\t").append("from (").append((CharSequence)query);
        sbSQL.append("\n\t").append((CharSequence)PaginationManager.getOrderBy(pagination, false)).append(") ");
        sbSQL.append("\n").append(") ");
        sbSQL.append("\n").append("where ");
        sbSQL.append("(").append(pkStr).append(") ");
        sbSQL.append(pagination.getMultiselection().getSelectedAll() != false ? " NOT IN " : " IN (");
        for (T selectedBean : pagination.getMultiselection().getSelected(clazz)) {
            sbSQL.append("(");
            int i = 0;
            while (i < pkList.length) {
                String prop = pagination.getMultiselection().getPkNames().get(i);
                sbSQL.append("?").append(",");
                try {
                    paramList.add(BeanUtils.getProperty(selectedBean, prop));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                ++i;
            }
            sbSQL.deleteCharAt(sbSQL.length() - 1);
            sbSQL.append("),");
        }
        sbSQL.deleteCharAt(sbSQL.length() - 1);
        sbSQL.append(")");
        return sbSQL;
    }

    private static String strArrayToCommaSeparatedStr(String[] strArray) {
        StringBuilder retStr = new StringBuilder();
        String[] stringArray = strArray;
        int n = strArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            retStr.append(str).append(",");
            ++n2;
        }
        retStr.deleteCharAt(retStr.length() - 1);
        return retStr.toString();
    }

    public static List<?> getPaginationList(Pagination pagination, List<?> list) {
        ArrayList returnList = new ArrayList();
        Long rows = pagination.getRows();
        Long page = pagination.getPage();
        if (page != null && rows != null) {
            int i = (int)(rows * (page - 1L));
            while ((long)i < rows * page) {
                returnList.add(list.get(i));
                ++i;
            }
        } else if (rows != null) {
            int i = 0;
            while ((long)i < rows) {
                returnList.add(list.get(i));
                ++i;
            }
        } else {
            return list;
        }
        return returnList;
    }

    public static StringBuilder getReorderQuery(Pagination pagination, StringBuilder query, String ... pkCols) {
        StringBuilder reorderQuery = new StringBuilder();
        if (pagination.getSidx() != null) {
            reorderQuery.append(" ORDER BY ");
            reorderQuery.append(pagination.getSidx());
            reorderQuery.append(" ");
            reorderQuery.append(pagination.getSord());
            query.append((CharSequence)reorderQuery);
        }
        reorderQuery = new StringBuilder();
        reorderQuery.append(" SELECT * FROM (SELECT rownum rnum, a.*  FROM (" + query + ")a) ");
        reorderQuery.append(" WHERE ID IN (");
        reorderQuery.deleteCharAt(reorderQuery.length() - 1);
        reorderQuery.append(") ");
        return reorderQuery;
    }
}

