/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.control.exception.handler;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.ModelAndView;

public class MvcExceptionHandler {
    private ReloadableResourceBundleMessageSource messageSource;

    public MvcExceptionHandler(ReloadableResourceBundleMessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @ExceptionHandler
    public ModelAndView handleException(Exception exception, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Locale locale = LocaleContextHolder.getLocale();
        String exceptionClassName = exception.getClass().getSimpleName();
        if (request.getHeaders("X-Requested-With").hasMoreElements()) {
            String content = this.messageSource.getMessage(exceptionClassName, null, exception.getMessage(), locale);
            response.setStatus(406);
            response.setContentLength(content.getBytes(Charset.forName(response.getCharacterEncoding())).length);
            response.getWriter().print(content);
            response.flushBuffer();
            return null;
        }
        return MvcExceptionHandler.handle(exception, request, response);
    }

    public static ModelAndView handle(Exception exception, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("error");
        modelAndView.addObject("exception_name", exception.getClass().getName());
        modelAndView.addObject("exception_message", exception.getMessage());
        StringBuilder sbTrace = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement trace = stackTraceElementArray[n2];
            sbTrace.append(trace.toString()).append("</br>");
            ++n2;
        }
        modelAndView.addObject("exception_trace", sbTrace);
        return modelAndView;
    }
}

