/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.control.exception.handler;

import com.ejie.x38.control.exception.handler.MvcExceptionHandler;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.servlet.ModelAndView;

public class MvcAccessDeniedExceptionHandler {
    private ReloadableResourceBundleMessageSource messageSource;

    public MvcAccessDeniedExceptionHandler(ReloadableResourceBundleMessageSource messageSource) {
        this.messageSource = messageSource;
    }

    @ExceptionHandler(value={AccessDeniedException.class})
    public ModelAndView handleAccessDeniedException(AccessDeniedException accessDeniedException, HttpServletRequest request, HttpServletResponse response) throws IOException {
        Locale locale = LocaleContextHolder.getLocale();
        String exceptionClassName = accessDeniedException.getClass().getSimpleName();
        if (request.getHeaders("X-Requested-With").hasMoreElements()) {
            String content = this.messageSource.getMessage(exceptionClassName, null, accessDeniedException.getMessage(), locale);
            response.setStatus(401);
            response.setContentLength(content.getBytes(Charset.forName(response.getCharacterEncoding())).length);
            response.getWriter().print(content);
            response.flushBuffer();
            return null;
        }
        return MvcExceptionHandler.handle(accessDeniedException, request, response);
    }
}

