/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.control.exception;

import com.ejie.x38.control.exception.MvcExceptionResolver;
import com.ejie.x38.control.exception.handler.MvcAccessDeniedExceptionHandler;
import com.ejie.x38.control.exception.handler.MvcExceptionHandler;
import com.ejie.x38.control.exception.handler.MvcValidationExceptionHandler;
import com.ejie.x38.validation.ValidationManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.stereotype.Component;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.HandlerExceptionResolver;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurationSupport;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

@Component
public class MvcExceptionResolverConfig
extends WebMvcConfigurationSupport {
    @Autowired
    private WebApplicationContext webApplicationContext;
    private List<Object> handlers = new ArrayList<Object>();
    private boolean disable_accessDenied;
    private boolean disable_validation;

    public void setHandlers(List<Object> handlers) {
        this.handlers = handlers;
    }

    public void setDisable_accessDenied(boolean disable_accessDenied) {
        this.disable_accessDenied = disable_accessDenied;
    }

    public void setDisable_validation(boolean disable_validation) {
        this.disable_validation = disable_validation;
    }

    @PostConstruct
    public void postConstruct() {
        String war = this.webApplicationContext.getServletContext().getContextPath().substring(1);
        try {
            this.webApplicationContext.getBean("requestMappingHandlerAdapter");
        }
        catch (Exception e) {
            throw new IllegalStateException("No se puede crear el bean 'MvcExceptionResolverConfig' en el fichero mvc-config.xml del proyecto <" + war + ">. Falta definir el bean 'requestMappingHandlerAdapter' de tipo 'RequestMappingHandlerAdapter'");
        }
        try {
            this.webApplicationContext.getBean("messageSource");
        }
        catch (Exception e) {
            throw new IllegalStateException("No se puede crear el bean 'MvcExceptionResolverConfig' en el fichero mvc-config.xml del proyecto <" + war + ">. Falta definir el bean 'messageSource' de tipo 'ReloadableResourceBundleMessageSource'");
        }
        try {
            this.webApplicationContext.getBean("validationManager");
        }
        catch (Exception e) {
            throw new IllegalStateException("No se puede crear el bean 'MvcExceptionResolverConfig' en el fichero validation-config.xml del proyecto <" + war + ">. Falta definir el bean 'validationManager' de tipo 'com.ejie.x38.validation.ValidationManager'");
        }
    }

    @Override
    public void configureMessageConverters(List<HttpMessageConverter<?>> converters) {
        RequestMappingHandlerAdapter requestMethodHandlerAdapter = this.webApplicationContext.getBean(RequestMappingHandlerAdapter.class);
        for (HttpMessageConverter<?> httpMessageConverter : requestMethodHandlerAdapter.getMessageConverters()) {
            converters.add(httpMessageConverter);
        }
    }

    @Override
    public void configureHandlerExceptionResolvers(List<HandlerExceptionResolver> exceptionResolvers) {
        MvcExceptionResolver customResolver = new MvcExceptionResolver();
        List<Object> exceptionHandlers = this.handlers;
        if (!this.disable_validation) {
            ValidationManager validationManager = (ValidationManager)this.webApplicationContext.getBean("validationManager");
            exceptionHandlers.add(0, new MvcValidationExceptionHandler(validationManager));
        }
        ReloadableResourceBundleMessageSource messageSource = (ReloadableResourceBundleMessageSource)this.webApplicationContext.getBean("messageSource");
        if (!this.disable_accessDenied) {
            exceptionHandlers.add(0, new MvcAccessDeniedExceptionHandler(messageSource));
        }
        exceptionHandlers.add(new MvcExceptionHandler(messageSource));
        customResolver.setExceptionHandlers(exceptionHandlers);
        customResolver.setMessageConverters(this.getMessageConverters());
        customResolver.afterPropertiesSet();
        exceptionResolvers.add(customResolver);
    }
}

