/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38.control;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.annotation.PostConstruct;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.web.servlet.i18n.CookieLocaleResolver;
import org.springframework.web.servlet.support.RequestContextUtils;

public class MvcInterceptor
extends HandlerInterceptorAdapter {
    @Autowired
    private WebApplicationContext webApplicationContext;
    private String paramName = "locale";
    private String defaultLanguage;
    private String defaultLayout;
    private String availableLangs;
    private String portalCookie;

    @PostConstruct
    public void postConstruct() {
        ArrayList<String> properties = new ArrayList<String>();
        if (this.defaultLanguage == null) {
            properties.add("defaultLanguage");
        }
        if (this.defaultLayout == null) {
            properties.add("defaultLayout");
        }
        if (this.availableLangs == null) {
            properties.add("availableLangs");
        }
        if (!properties.isEmpty()) {
            String war = this.webApplicationContext.getServletContext().getContextPath().substring(1);
            throw new IllegalStateException("No se ha definido correctamente el bean 'MvcInterceptor' en el fichero mvc-config.xml del proyecto <" + war + ">. Revisar propiedad(es):" + ((Object)properties).toString());
        }
    }

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        Locale locale = null;
        if (this.portalCookie == null) {
            String languageParam = request.getParameter(this.paramName);
            if (languageParam != null && this.availableLangs.contains(languageParam)) {
                locale = new Locale(languageParam);
            } else {
                String cookieName = ((CookieLocaleResolver)RequestContextUtils.getLocaleResolver(request)).getCookieName();
                Cookie cookie = this.getLanguageCookie(request.getCookies(), cookieName, Arrays.asList(this.availableLangs.trim().split("\\s*,\\s*")));
                locale = cookie != null ? new Locale(cookie.getValue()) : new Locale(this.defaultLanguage);
            }
        } else {
            Cookie[] cookies = request.getCookies();
            String cookieValue = "";
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if (cookie.getName().equals(this.portalCookie)) {
                    cookieValue = cookie.getValue();
                    break;
                }
                ++n2;
            }
            locale = new Locale(cookieValue.substring(cookieValue.indexOf("_") + 1));
        }
        LocaleContextHolder.setLocale(locale);
        ((CookieLocaleResolver)RequestContextUtils.getLocaleResolver(request)).setLocale(request, response, locale);
        return true;
    }

    private Cookie getLanguageCookie(Cookie[] cookies, String cookieName, List<String> availableLangs) {
        if (cookies != null) {
            Cookie[] cookieArray = cookies;
            int n = cookies.length;
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = cookieArray[n2];
                if (cookie.getName().equals(cookieName) && availableLangs.contains(cookie.getValue())) {
                    return cookie;
                }
                ++n2;
            }
        }
        return null;
    }

    public void setParamName(String paramName) {
        this.paramName = paramName;
    }

    public String getParamName() {
        return this.paramName;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    public String getDefaultLayout() {
        return this.defaultLayout;
    }

    public void setDefaultLayout(String defaultLayout) {
        this.defaultLayout = defaultLayout;
    }

    public String getAvailableLangs() {
        return this.availableLangs;
    }

    public void setAvailableLangs(String availableLangs) {
        this.availableLangs = availableLangs;
    }

    public String getPortalCookie() {
        return this.portalCookie;
    }

    public void setPortalCookie(String portalCookie) {
        this.portalCookie = portalCookie;
    }
}

