/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38;

import com.ejie.x38.security.Credentials;
import com.ejie.x38.util.ManagementUrl;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextImpl;

public class UdaListener
implements ServletContextListener,
HttpSessionListener,
ServletRequestListener {
    Logger logger = LoggerFactory.getLogger(UdaListener.class);

    public void contextDestroyed(ServletContextEvent arg0) {
    }

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        this.logger.debug("WAR Context is being initialized");
    }

    public void sessionCreated(HttpSessionEvent sessionEvent) {
        this.logger.debug("Session " + sessionEvent.getSession().getId() + " has been created");
        sessionEvent.getSession().setAttribute("udaTimeStamp", (Object)System.currentTimeMillis());
    }

    public void sessionDestroyed(HttpSessionEvent sessionEvent) {
        this.logger.debug("Session " + sessionEvent.getSession().getId() + " has been destroyed");
        sessionEvent.getSession().removeAttribute("udaTimeStamp");
    }

    public void requestInitialized(ServletRequestEvent sre) {
        ServletRequest request = sre.getServletRequest();
        HttpServletRequest httpServletRequest = null;
        StringBuilder logMessage = new StringBuilder();
        HttpSession httpSession = null;
        SecurityContextImpl securityContext = null;
        Credentials credentials = null;
        Authentication authentication = null;
        MDC.put("IPClient", request.getRemoteAddr());
        MDC.put("noInternalAcces", "httpAcces");
        if (request instanceof HttpServletRequest) {
            httpServletRequest = (HttpServletRequest)request;
            if (httpServletRequest.getSession(false) != null) {
                httpSession = ((HttpServletRequest)request).getSession(false);
                securityContext = (SecurityContextImpl)httpSession.getAttribute("SPRING_SECURITY_CONTEXT");
                if (securityContext != null && (authentication = securityContext.getAuthentication()) != null) {
                    credentials = (Credentials)authentication.getCredentials();
                }
                if (credentials != null) {
                    MDC.put("user", credentials.getUserName());
                    MDC.put("session", credentials.getUidSession());
                    MDC.put("position", credentials.getPosition());
                } else if (httpSession.getAttribute("UserName") != null) {
                    MDC.put("user", (String)httpSession.getAttribute("UserName"));
                    MDC.put("session", (String)httpSession.getAttribute("UidSession"));
                    MDC.put("position", (String)httpSession.getAttribute("Position"));
                }
            }
            logMessage.append("The application has just received a HTTP request from the IP ");
            logMessage.append(request.getRemoteAddr());
            logMessage.append(" to the URL ");
            logMessage.append(ManagementUrl.getUrl(httpServletRequest));
        } else {
            logMessage.append("The application has just received a non-HTTP request from the IP ");
            logMessage.append(request.getRemoteAddr());
        }
        this.logger.info(logMessage.toString());
    }

    public void requestDestroyed(ServletRequestEvent sre) {
        ServletRequest request = sre.getServletRequest();
        HttpServletRequest httpServletRequest = null;
        StringBuilder logMessage = new StringBuilder();
        if (request instanceof HttpServletRequest) {
            httpServletRequest = (HttpServletRequest)request;
            logMessage.append("The application has responded a HTTP request from the IP ");
            logMessage.append(request.getRemoteAddr());
            logMessage.append(" to the URL ");
            logMessage.append(ManagementUrl.getUrl(httpServletRequest));
        } else {
            logMessage.append("The application has responded a non-HTTP request from the IP ");
            logMessage.append(request.getRemoteAddr());
        }
        this.logger.info(logMessage.toString());
        MDC.clear();
    }
}

