/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38;

import com.ejie.x38.serialization.ThreadSafeCache;
import com.ejie.x38.util.StackTraceManager;
import com.ejie.x38.util.ThreadStorageManager;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.DelegatingFilterProxy;

public class UdaFilter
extends DelegatingFilterProxy {
    private static final Logger logger = LoggerFactory.getLogger(UdaFilter.class);

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        try {
            try {
                String rupMultiModelHeader;
                logger.debug("New request with UDA identificator " + ThreadStorageManager.getCurrentThreadId() + " has started");
                String rupHeader = httpServletRequest.getHeader("RUP");
                if (rupHeader != null) {
                    ThreadSafeCache.addValue("RUP", "RUP");
                    HashMap map = new ObjectMapper().readValue(rupHeader, HashMap.class);
                    for (Map.Entry entry : map.entrySet()) {
                        ThreadSafeCache.addValue((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                if ((rupMultiModelHeader = httpServletRequest.getHeader("RUP_MULTI_ENTITY")) != null) {
                    ThreadSafeCache.addValue("RUP_MULTI_ENTITY", "RUP_MULTI_ENTITY");
                }
                filterChain.doFilter(request, response);
                logger.debug("Request with UDA identificator " + ThreadStorageManager.getCurrentThreadId() + " has ended");
            }
            catch (Exception exception) {
                logger.error(StackTraceManager.getStackTrace(exception));
                try {
                    if (!response.isCommitted()) {
                        HttpServletRequest req = (HttpServletRequest)request;
                        HttpServletResponse res = (HttpServletResponse)response;
                        StringBuilder error = new StringBuilder(req.getContextPath());
                        error.append("/error?exception_name=").append(exception.getClass().getName());
                        error.append("&exception_message=").append(exception.getMessage());
                        error.append("&exception_trace=");
                        int outLength = error.length();
                        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
                        int n = stackTraceElementArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            StackTraceElement trace = stackTraceElementArray[n2];
                            if ((outLength = outLength + 5 + trace.toString().length()) > 2043) break;
                            error.append(trace.toString()).append("</br>");
                            ++n2;
                        }
                        res.sendRedirect(error.toString());
                    }
                }
                catch (Exception exc) {
                    logger.error("Problem with sending of the response", exc);
                }
            }
        }
        finally {
            ThreadStorageManager.clearCurrentThreadId();
            ThreadSafeCache.clearCurrentThreadCache();
        }
    }
}

