/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.x38;

import com.ejie.x38.util.IframeXHREmulationUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.springframework.web.filter.DelegatingFilterProxy;

public class IframeXHREmulationFilter
extends DelegatingFilterProxy {
    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (IframeXHREmulationUtils.isIframeEmulationRequired(request)) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)response;
            GenericResponseWrapper wrapper = new GenericResponseWrapper(httpServletResponse);
            filterChain.doFilter(request, (ServletResponse)wrapper);
            IframeXHREmulationUtils.writeIframeHttpStatus(httpServletResponse, wrapper.getData(), wrapper.getStatus());
        } else {
            filterChain.doFilter(request, response);
        }
    }

    private class FilterServletOutputStream
    extends ServletOutputStream {
        private DataOutputStream stream;

        public FilterServletOutputStream(OutputStream output) {
            this.stream = new DataOutputStream(output);
        }

        public void write(int b) throws IOException {
            this.stream.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.stream.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.stream.write(b, off, len);
        }
    }

    private class GenericResponseWrapper
    extends HttpServletResponseWrapper {
        private ByteArrayOutputStream output;
        private String contentType;
        private int httpStatus;

        public GenericResponseWrapper(HttpServletResponse response) {
            super(response);
            this.output = new ByteArrayOutputStream();
        }

        public byte[] getData() {
            return this.output.toByteArray();
        }

        public ServletOutputStream getOutputStream() {
            return new FilterServletOutputStream(this.output);
        }

        public PrintWriter getWriter() {
            return new PrintWriter((OutputStream)this.getOutputStream(), true);
        }

        public void setContentType(String type) {
            this.contentType = type;
            super.setContentType(type);
        }

        public String getContentType() {
            return this.contentType;
        }

        public void sendError(int sc) throws IOException {
            this.httpStatus = sc;
            super.sendError(sc);
        }

        public void sendError(int sc, String msg) throws IOException {
            this.httpStatus = sc;
            super.sendError(sc, msg);
        }

        public void setStatus(int sc) {
            this.httpStatus = sc;
        }

        public int getStatus() {
            return this.httpStatus;
        }
    }
}

