/*
 * Decompiled with CFR 0.152.
 */
package com.ejie.y31.service;

import com.ejie.y31.exception.Y31JanoServiceFileNameFormatException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.Normalizer;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;

public class Y31JanoServiceTool {
    private static Random randomGenerator = new Random();

    public static String xml2String(Document d) {
        OutputFormat format = new OutputFormat(d);
        StringWriter stringOut = new StringWriter();
        XMLSerializer serial = new XMLSerializer((Writer)stringOut, format);
        String s = null;
        try {
            serial.serialize(d);
            s = stringOut.toString();
            stringOut.flush();
            stringOut.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        return s;
    }

    public static String path2MetaDataPath(String path) throws Y31JanoServiceFileNameFormatException {
        String s = Y31JanoServiceTool.cleanDataPath(path);
        s = Y31JanoServiceTool.prepareMetadataPath(s);
        return s;
    }

    public static String cleanMetadataPath(String path) {
        String a = Y31JanoServiceTool.cleanPath(path, "/metadata_user");
        a = Y31JanoServiceTool.cleanPath(a, "/metadata");
        return a;
    }

    public static String cleanDataPath(String path) {
        String a = Y31JanoServiceTool.cleanPath(path, "/data_user");
        a = Y31JanoServiceTool.cleanPath(a, "/data");
        return a;
    }

    public static String cleanUserPath(String path) {
        if (path.startsWith("/user")) {
            return path.replaceAll("/user", "");
        }
        return path;
    }

    public static String cleanAllPath(String path) {
        return Y31JanoServiceTool.cleanDataPath(Y31JanoServiceTool.cleanMetadataPath(path));
    }

    private static String cleanPath(String path, String pattern) {
        String a = path;
        a = a.replaceAll(pattern, "");
        return a;
    }

    public static String prepareDataPath(String path) {
        if (path.startsWith("/user/") || path.equals("/user")) {
            return "/data_user" + path;
        }
        return "/data" + path;
    }

    public static String prepareMetadataPath(String path) {
        if (path.startsWith("/user/") || path.equals("/user")) {
            return "/metadata_user" + path + ".json";
        }
        return "/metadata" + path + ".json";
    }

    public static String normalize(String i) throws Y31JanoServiceFileNameFormatException {
        return Y31JanoServiceTool.normalize(i, true);
    }

    public static String normalize(String i, boolean preserveName) throws Y31JanoServiceFileNameFormatException {
        if (!i.startsWith("/metadata_user") && !i.startsWith("/metadata")) {
            String temp = Normalizer.normalize(i, Normalizer.Form.NFD);
            Pattern pattern = Pattern.compile("\\p{InCombiningDiacriticalMarks}+");
            String s = pattern.matcher(temp).replaceAll("").replaceAll(" ", "-");
            s = s.replaceAll("[^a-zA-Z0-9\\-_\\/\\.]", "");
            if (!preserveName) {
                Pattern p = Pattern.compile(".*(-[0-9]{13}-[0-9]{7})\\.[a-z]{2,}$");
                Matcher m = p.matcher(s);
                if (m.matches()) {
                    s = s.replaceAll(m.group(1), Y31JanoServiceTool.getUniqueName());
                } else if (s.lastIndexOf(".") > 0) {
                    s = s.substring(0, s.lastIndexOf(".")) + Y31JanoServiceTool.getUniqueName() + s.substring(s.lastIndexOf("."), s.length());
                } else {
                    throw new Y31JanoServiceFileNameFormatException("el path no es un path valido, el fichero debe tener extension" + s);
                }
            }
            s = Y31JanoServiceTool.prepareDataPath(s);
            return s;
        }
        return i;
    }

    public static String getUniqueName() {
        long randomInt = randomGenerator.nextInt(10000000);
        DecimalFormat df = new DecimalFormat("0000000");
        String r = df.format(randomInt);
        String s = "-" + System.currentTimeMillis() + "-" + r;
        return s;
    }

    public static String getFileNameFromCompletPath(String path) throws Y31JanoServiceFileNameFormatException {
        if (path.lastIndexOf("\\.") >= 0 && path.lastIndexOf(".") < path.length()) {
            throw new Y31JanoServiceFileNameFormatException("el nombre del fichero no se ajusta  al patron nombre.ext");
        }
        if (path.lastIndexOf("/") < 0) {
            return path;
        }
        String fileName = path.substring(path.lastIndexOf("/") + 1, path.length());
        return fileName;
    }

    public static String getPathFromCompletPath(String path) throws Y31JanoServiceFileNameFormatException {
        if (path.lastIndexOf("\\.") >= 0 && path.lastIndexOf(".") < path.length()) {
            throw new Y31JanoServiceFileNameFormatException("el nombre del fichero no se ajusta  al patron nombre.ext");
        }
        if (path.lastIndexOf("/") < 0) {
            return path;
        }
        String folder = path.substring(0, path.lastIndexOf("/"));
        folder = Y31JanoServiceTool.cleanDataPath(folder);
        return folder;
    }

    public static void main(String[] args) {
    }
}

