--
-- Create Schema Script
--   Database Version            : 12.2.0.1.0
--   Database Compatible Level   : 12.2.0.1.0
--   Script Compatible Level     : 12.2.0.1.0
--   Toad Version                : 12.12.0.39
--   DB Connect String           : SUA.EUSTAT.ES
--   Schema                      : GEDW
--   Script Created by           : GEDW
--   Script Created at           : 19/05/2022 9:47:05
--   Notes                       : 
--

-- Object Counts: 
--   Directories: 26 
--   Indexes: 18        Columns: 24         
--   Object Privileges: 19 
--   Packages: 1        Lines of Code: 205 
--   Package Bodies: 1  Lines of Code: 8386132 
--   Procedures: 2      Lines of Code: 964 
--   Sequences: 1 
--   Synonym: 95 
--   Tables: 19         Columns: 74         Constraints: 60     
--   Views: 4           Columns: 65         


-- "Set define off" turns off substitution variables.
Set define off; 

--
-- DATA_PUMP_DIR  (Directory) 
--
CREATE OR REPLACE DIRECTORY 
DATA_PUMP_DIR AS 
'/oracle/dbbase/admin/SUA/dpdump/';


--
-- DATA_PUMP_DIR_EXPORT  (Directory) 
--
CREATE OR REPLACE DIRECTORY 
DATA_PUMP_DIR_EXPORT AS 
'/exp/SUA/backups';


--
-- DATA_PUMP_DIR_MIGRACION  (Directory) 
--
CREATE OR REPLACE DIRECTORY 
DATA_PUMP_DIR_MIGRACION AS 
'/exp/SUA/migracion';


--
-- DATA_PUMP_DIR_RECUPERACIONES  (Directory) 
--
CREATE OR REPLACE DIRECTORY 
DATA_PUMP_DIR_RECUPERACIONES AS 
'/recuperaciones';


--
-- DBMS_OPTIM_ADMINDIR  (Directory) 
--
CREATE OR REPLACE DIRECTORY 
DBMS_OPTIM_ADMINDIR AS 
'/oracle/db/app/product/12.2.0/dbhome_2004/rdbms/admin';


--
-- DBMS_OPTIM_LOGDIR  (Directory) 
--
CREATE OR REPLACE DIRECTORY 
DBMS_OPTIM_LOGDIR AS 
'/oracle/db/app/product/12.2.0/dbhome_2004/cfgtoollogs';


--
-- DBREPLAY_SUA1  (Directory) 
--
CREATE OR REPLACE DIRECTORY 
DBREPLAY_SUA1 AS 
'/batera_pruebas/dbreplay_sua1';


--
-- DBREPLAY_SUA2  (Directory) 
--
CREATE OR REPLACE DIRECTORY 
DBREPLAY_SUA2 AS 
'/batera_pruebas/dbreplay_sua2';


--
-- DIR_EXPORT_TMP  (Directory) 
--
CREATE OR REPLACE DIRECTORY 
DIR_EXPORT_TMP AS 
'/aplic_eustat/export-tmp';


--
-- DPEXPORTS  (Directory) 
--
CREATE OR REPLACE DIRECTORY 
DPEXPORTS AS 
'/recuperaciones/';


--
-- EXPORT  (Directory) 
--
CREATE OR REPLACE DIRECTORY 
EXPORT AS 
'/exp/SUA/';


--
-- EXPORTS_DIR  (Directory) 
--
CREATE OR REPLACE DIRECTORY 
EXPORTS_DIR AS 
'/oradata/exp_adm/exports/';


--
-- LAST_BACKUP_DIR  (Directory) 
--
CREATE OR REPLACE DIRECTORY 
LAST_BACKUP_DIR AS 
'/oradata/exp_adm/backups/SUA';


--
-- OPATCH_INST_DIR  (Directory) 
--
CREATE OR REPLACE DIRECTORY 
OPATCH_INST_DIR AS 
'/oracle/db/app/product/12.2.0/dbhome_2004/OPatch';


--
-- OPATCH_LOG_DIR  (Directory) 
--
CREATE OR REPLACE DIRECTORY 
OPATCH_LOG_DIR AS 
'/oracle/db/app/product/12.2.0/dbhome_2004/rdbms/log';


--
-- OPATCH_SCRIPT_DIR  (Directory) 
--
CREATE OR REPLACE DIRECTORY 
OPATCH_SCRIPT_DIR AS 
'/oracle/db/app/product/12.2.0/dbhome_2004/QOpatch';


--
-- ORACLE_BASE  (Directory) 
--
CREATE OR REPLACE DIRECTORY 
ORACLE_BASE AS 
'/oracle/dbbase';


--
-- ORACLE_HOME  (Directory) 
--
CREATE OR REPLACE DIRECTORY 
ORACLE_HOME AS 
'/oracle/db/app/product/12.2.0/dbhome_1';


--
-- ORACLE_OCM_CONFIG_DIR  (Directory) 
--
CREATE OR REPLACE DIRECTORY 
ORACLE_OCM_CONFIG_DIR AS 
'/oracle/db/app/product/12.2.0/dbhome_1/ccr/state';


--
-- ORACLE_OCM_CONFIG_DIR2  (Directory) 
--
CREATE OR REPLACE DIRECTORY 
ORACLE_OCM_CONFIG_DIR2 AS 
'/oracle/db/app/product/12.2.0/dbhome_1/ccr/state';


--
-- ORA_DBMS_FCP_ADMINDIR  (Directory) 
--
CREATE OR REPLACE DIRECTORY 
ORA_DBMS_FCP_ADMINDIR AS 
'/oracle/db/app/product/12.2.0/dbhome_1/rdbms/admin';


--
-- ORA_DBMS_FCP_LOGDIR  (Directory) 
--
CREATE OR REPLACE DIRECTORY 
ORA_DBMS_FCP_LOGDIR AS 
'/oracle/db/app/product/12.2.0/dbhome_1/cfgtoollogs';


--
-- RECUPERACIONES_DIR  (Directory) 
--
CREATE OR REPLACE DIRECTORY 
RECUPERACIONES_DIR AS 
'/oradata/exp_adm/recuperaciones/';


--
-- USU_DIR  (Directory) 
--
CREATE OR REPLACE DIRECTORY 
USU_DIR AS 
'/aplic_eustat/temp';


--
-- XMLDIR  (Directory) 
--
CREATE OR REPLACE DIRECTORY 
XMLDIR AS 
'/oracle/db/app/product/12.2.0/dbhome_1/rdbms/xml';


--
-- XSDDIR  (Directory) 
--
CREATE OR REPLACE DIRECTORY 
XSDDIR AS 
'/oracle/db/app/product/12.2.0/dbhome_1/rdbms/xml/schema';


--
-- SEQ_GEDW71T00  (Sequence) 
--
CREATE SEQUENCE GEDW.SEQ_GEDW71T00
  START WITH 684
  MAXVALUE 9999999999999999999999999999
  MINVALUE 1
  NOCYCLE
  NOCACHE
  NOORDER
  NOKEEP
  GLOBAL;


--
-- GEDW01T00  (Table) 
--
CREATE TABLE GEDW.GEDW01T00
(
  CODUSU    NUMBER(3)                           NOT NULL,
  NUMC      VARCHAR2(10 BYTE)                   NOT NULL,
  PASSWORD  VARCHAR2(10 BYTE)                   NOT NULL,
  NOMB      VARCHAR2(25 BYTE),
  APE1      VARCHAR2(30 BYTE),
  APE2      VARCHAR2(30 BYTE)
)
TABLESPACE GEDW
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOCOMPRESS ;

COMMENT ON TABLE GEDW.GEDW01T00 IS 'Tabla de usuarios';

COMMENT ON COLUMN GEDW.GEDW01T00.CODUSU IS 'Cdigo identificativo';

COMMENT ON COLUMN GEDW.GEDW01T00.NUMC IS 'Usuario';

COMMENT ON COLUMN GEDW.GEDW01T00.PASSWORD IS 'Password';

COMMENT ON COLUMN GEDW.GEDW01T00.NOMB IS 'Nombre';

COMMENT ON COLUMN GEDW.GEDW01T00.APE1 IS 'Apellido1';

COMMENT ON COLUMN GEDW.GEDW01T00.APE2 IS 'Apellido2';


--
-- GEDW02T00  (Table) 
--
CREATE TABLE GEDW.GEDW02T00
(
  CODUSU  NUMBER(3),
  CODOPE  VARCHAR2(10 BYTE),
  PERFIL  NUMBER(2),
  ACTIVO  VARCHAR2(1 BYTE)
)
TABLESPACE GEDW
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOCOMPRESS ;

COMMENT ON TABLE GEDW.GEDW02T00 IS 'Tabla con la relacin entre usuarios y operacion';

COMMENT ON COLUMN GEDW.GEDW02T00.CODUSU IS 'Cdigo usuario';

COMMENT ON COLUMN GEDW.GEDW02T00.CODOPE IS 'Cdigo operacin';

COMMENT ON COLUMN GEDW.GEDW02T00.PERFIL IS 'Perfil de usuario (0-Encuestadores 1-Eustat 2 -Responsables)';

COMMENT ON COLUMN GEDW.GEDW02T00.ACTIVO IS 'Indicador de usuario activo (S-Si,N-No)';


--
-- GEDW60T00  (Table) 
--
CREATE TABLE GEDW.GEDW60T00
(
  CODSIT      NUMBER(2)                         NOT NULL,
  SIT_LITCAS  VARCHAR2(50 BYTE)                 NOT NULL,
  SIT_LITEUS  VARCHAR2(50 BYTE)                 NOT NULL
)
TABLESPACE GEDW
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOCOMPRESS ;

COMMENT ON TABLE GEDW.GEDW60T00 IS 'Situaciones de la vivienda';

COMMENT ON COLUMN GEDW.GEDW60T00.CODSIT IS 'Codigo de la situacion';

COMMENT ON COLUMN GEDW.GEDW60T00.SIT_LITCAS IS 'Descripcion en castellano de la situacion';

COMMENT ON COLUMN GEDW.GEDW60T00.SIT_LITEUS IS 'Descripcion en euskera de la situacion';


--
-- GEDW61T00  (Table) 
--
CREATE TABLE GEDW.GEDW61T00
(
  CODRVIV       VARCHAR2(2 BYTE)                NOT NULL,
  RVIV_LITCAS   VARCHAR2(50 BYTE)               NOT NULL,
  RVIV_LITEUS   VARCHAR2(50 BYTE)               NOT NULL,
  RVIV_CODISER  VARCHAR2(3 BYTE)
)
TABLESPACE GEDW
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOCOMPRESS ;

COMMENT ON TABLE GEDW.GEDW61T00 IS 'Resultado vivienda';

COMMENT ON COLUMN GEDW.GEDW61T00.CODRVIV IS 'Codigo del Resultado vivienda';

COMMENT ON COLUMN GEDW.GEDW61T00.RVIV_LITCAS IS 'Descripcion en castellano del Resultado vivienda';

COMMENT ON COLUMN GEDW.GEDW61T00.RVIV_LITEUS IS 'Descripcion en euskera del Resultado vivienda';

COMMENT ON COLUMN GEDW.GEDW61T00.RVIV_CODISER IS 'Cdigo ISER';


--
-- GEDW61T01  (Table) 
--
CREATE TABLE GEDW.GEDW61T01
(
  RVIVOPE_CODRVIV  VARCHAR2(2 BYTE)             NOT NULL,
  RVIVOPE_CODOPE   VARCHAR2(10 BYTE)            NOT NULL
)
TABLESPACE GEDW
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOCOMPRESS ;

COMMENT ON TABLE GEDW.GEDW61T01 IS 'Resultado de vivienda especfico de la operacin';

COMMENT ON COLUMN GEDW.GEDW61T01.RVIVOPE_CODRVIV IS 'Resultado de Vivienda. Correspondencia con GEDW60T00';

COMMENT ON COLUMN GEDW.GEDW61T01.RVIVOPE_CODOPE IS 'Cdigo de operacin';


--
-- GEDW62T00  (Table) 
--
CREATE TABLE GEDW.GEDW62T00
(
  CODRCON       VARCHAR2(2 BYTE)                NOT NULL,
  RCON_LITCAS   VARCHAR2(50 BYTE)               NOT NULL,
  RCON_LITEUS   VARCHAR2(50 BYTE)               NOT NULL,
  RCON_CODISER  VARCHAR2(3 BYTE)
)
TABLESPACE GEDW
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOCOMPRESS ;

COMMENT ON TABLE GEDW.GEDW62T00 IS 'Resultado contacto';

COMMENT ON COLUMN GEDW.GEDW62T00.CODRCON IS 'Codigo del Resultado vivienda';

COMMENT ON COLUMN GEDW.GEDW62T00.RCON_LITCAS IS 'Descripcion en castellano del Resultado vivienda';

COMMENT ON COLUMN GEDW.GEDW62T00.RCON_LITEUS IS 'Descripcion en euskera del Resultado vivienda';

COMMENT ON COLUMN GEDW.GEDW62T00.RCON_CODISER IS 'Cdigo ISER';


--
-- GEDW63T00  (Table) 
--
CREATE TABLE GEDW.GEDW63T00
(
  CODRCUE       VARCHAR2(2 BYTE)                NOT NULL,
  RCUE_LITCAS   VARCHAR2(50 BYTE)               NOT NULL,
  RCUE_LITEUS   VARCHAR2(50 BYTE)               NOT NULL,
  RCUE_CODISER  VARCHAR2(3 BYTE)
)
TABLESPACE GEDW
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOCOMPRESS ;

COMMENT ON TABLE GEDW.GEDW63T00 IS 'Resultado de cuestionarios';

COMMENT ON COLUMN GEDW.GEDW63T00.CODRCUE IS 'Codigo del estado';

COMMENT ON COLUMN GEDW.GEDW63T00.RCUE_LITCAS IS 'Descripcion en castellano del estado';

COMMENT ON COLUMN GEDW.GEDW63T00.RCUE_LITEUS IS 'Descripcion en euskera del estado';

COMMENT ON COLUMN GEDW.GEDW63T00.RCUE_CODISER IS 'Cdigo ISER';


--
-- GEDW63T01  (Table) 
--
CREATE TABLE GEDW.GEDW63T01
(
  RCUESTOPE_CODRCUEST  VARCHAR2(2 BYTE)         NOT NULL,
  RCUESTOPE_CODOPE     VARCHAR2(10 BYTE)        NOT NULL
)
TABLESPACE GEDW
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOCOMPRESS ;

COMMENT ON TABLE GEDW.GEDW63T01 IS 'Resultado de cuestionario especfico de la operacin';


--
-- GEDW64T00  (Table) 
--
CREATE TABLE GEDW.GEDW64T00
(
  CODLNAC      VARCHAR2(2 BYTE)                 NOT NULL,
  LNAC_LITCAS  VARCHAR2(50 BYTE)                NOT NULL,
  LNAC_LITEUS  VARCHAR2(50 BYTE)                NOT NULL
)
TABLESPACE GEDW
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOCOMPRESS ;

COMMENT ON TABLE GEDW.GEDW64T00 IS 'Lugares de nacimiento';

COMMENT ON COLUMN GEDW.GEDW64T00.CODLNAC IS 'Codigo del lugar';

COMMENT ON COLUMN GEDW.GEDW64T00.LNAC_LITCAS IS 'Descripcion en castellano del lugar';

COMMENT ON COLUMN GEDW.GEDW64T00.LNAC_LITEUS IS 'Descripcion en euskera del lugar';


--
-- GEDW65T00  (Table) 
--
CREATE TABLE GEDW.GEDW65T00
(
  CODNACI      VARCHAR2(2 BYTE)                 NOT NULL,
  NACI_LITCAS  VARCHAR2(50 BYTE)                NOT NULL,
  NACI_LITEUS  VARCHAR2(50 BYTE)                NOT NULL
)
TABLESPACE GEDW
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOCOMPRESS ;

COMMENT ON TABLE GEDW.GEDW65T00 IS 'Nacionalidad';

COMMENT ON COLUMN GEDW.GEDW65T00.CODNACI IS 'Codigo de nacionalidad';

COMMENT ON COLUMN GEDW.GEDW65T00.NACI_LITCAS IS 'Descripcion en castellano de nacionalidad';

COMMENT ON COLUMN GEDW.GEDW65T00.NACI_LITEUS IS 'Descripcion en euskera de nacionalidad';


--
-- GEDW66T00  (Table) 
--
CREATE TABLE GEDW.GEDW66T00
(
  CODFORM      VARCHAR2(2 BYTE)                 NOT NULL,
  FORM_LITCAS  VARCHAR2(50 BYTE)                NOT NULL,
  FORM_LITEUS  VARCHAR2(50 BYTE)                NOT NULL
)
TABLESPACE GEDW
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOCOMPRESS ;

COMMENT ON TABLE GEDW.GEDW66T00 IS 'Mtodo o forma de cumplimentacin';

COMMENT ON COLUMN GEDW.GEDW66T00.CODFORM IS 'Codigo de Forma de cumplimentacin';

COMMENT ON COLUMN GEDW.GEDW66T00.FORM_LITCAS IS 'Descripcion en castellano de Forma de cumplimentacin';

COMMENT ON COLUMN GEDW.GEDW66T00.FORM_LITEUS IS 'Descripcion en euskera de Forma de cumplimentacin';


--
-- GEDW67T00  (Table) 
--
CREATE TABLE GEDW.GEDW67T00
(
  CODREPP      VARCHAR2(2 BYTE)                 NOT NULL,
  REPP_LITCAS  VARCHAR2(50 BYTE)                NOT NULL,
  REPP_LITEUS  VARCHAR2(50 BYTE)                NOT NULL
)
TABLESPACE GEDW
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOCOMPRESS ;

COMMENT ON TABLE GEDW.GEDW67T00 IS 'Parentesco  Relacin con la primera persona';

COMMENT ON COLUMN GEDW.GEDW67T00.CODREPP IS 'Codigo de Parentesco';

COMMENT ON COLUMN GEDW.GEDW67T00.REPP_LITCAS IS 'Descripcion en castellano de Parentesco';

COMMENT ON COLUMN GEDW.GEDW67T00.REPP_LITEUS IS 'Descripcion en euskera de Parentesco';


--
-- GEDW68T00  (Table) 
--
CREATE TABLE GEDW.GEDW68T00
(
  CODPINC      VARCHAR2(2 BYTE)                 NOT NULL,
  PINC_LITCAS  VARCHAR2(50 BYTE)                NOT NULL
)
TABLESPACE GEDW
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOCOMPRESS ;

COMMENT ON TABLE GEDW.GEDW68T00 IS 'Incidencias que pasarn al siguiente panel como incidencias';

COMMENT ON COLUMN GEDW.GEDW68T00.CODPINC IS 'Codigo de la incidencia (asociado a resultado de vivienda)';

COMMENT ON COLUMN GEDW.GEDW68T00.PINC_LITCAS IS 'Descripcion en castellano del Resultado vivienda';


--
-- GEDW69T00  (Table) 
--
CREATE TABLE GEDW.GEDW69T00
(
  CODOPE  VARCHAR2(10 BYTE)                     NOT NULL,
  NOMEXC  VARCHAR2(100 BYTE)                    NOT NULL
)
TABLESPACE GEDW
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOCOMPRESS ;

COMMENT ON COLUMN GEDW.GEDW69T00.CODOPE IS 'Nombre de operacin ';

COMMENT ON COLUMN GEDW.GEDW69T00.NOMEXC IS 'Nombre de excel por operacin al cual tiene acceso';


--
-- GEDW70T00  (Table) 
--
CREATE TABLE GEDW.GEDW70T00
(
  CODUSU  NUMBER(3),
  CODOPE  VARCHAR2(10 BYTE),
  LOTE    NUMBER(2)
)
TABLESPACE GEDW
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOCOMPRESS ;


--
-- GEDW71T00  (Table) 
--
CREATE TABLE GEDW.GEDW71T00
(
  IDDESCARGA  NUMBER                            NOT NULL,
  OPERACION   VARCHAR2(10 BYTE),
  AENC        NUMBER,
  TENC        NUMBER,
  SENC        NUMBER,
  FECHA       DATE,
  NUMVIV      NUMBER,
  NUMIND      NUMBER,
  CODUSU      NUMBER
)
TABLESPACE GEDW
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOCOMPRESS ;

COMMENT ON TABLE GEDW.GEDW71T00 IS 'Registro de descargas de la muestra';

COMMENT ON COLUMN GEDW.GEDW71T00.IDDESCARGA IS 'Identificador de descarga de la muestra';

COMMENT ON COLUMN GEDW.GEDW71T00.OPERACION IS 'ID de operacin';

COMMENT ON COLUMN GEDW.GEDW71T00.AENC IS 'Ao de la muestra';

COMMENT ON COLUMN GEDW.GEDW71T00.TENC IS 'trimestre de la muestra';

COMMENT ON COLUMN GEDW.GEDW71T00.SENC IS 'semana de la muestra';

COMMENT ON COLUMN GEDW.GEDW71T00.FECHA IS 'Fecha de descarga de la muestra';

COMMENT ON COLUMN GEDW.GEDW71T00.NUMVIV IS 'Nmero de viviendas descargadas';

COMMENT ON COLUMN GEDW.GEDW71T00.NUMIND IS 'Nmero de individuos descargados';

COMMENT ON COLUMN GEDW.GEDW71T00.CODUSU IS 'Id del usuario que ha descargado la muestra';


--
-- GEDW89T00  (Table) 
--
CREATE TABLE GEDW.GEDW89T00
(
  PCA_ID      INTEGER                           NOT NULL,
  PCA_CABCAS  VARCHAR2(50 BYTE),
  PCA_CABEUS  VARCHAR2(50 BYTE),
  PCA_IDENC   VARCHAR2(10 BYTE),
  PCA_PERFIL  VARCHAR2(2 BYTE)
)
TABLESPACE GEDW
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOCOMPRESS ;

COMMENT ON COLUMN GEDW.GEDW89T00.PCA_ID IS 'Cdigo identificativo';

COMMENT ON COLUMN GEDW.GEDW89T00.PCA_CABCAS IS 'Contenido ttulo cabecera castellano';

COMMENT ON COLUMN GEDW.GEDW89T00.PCA_CABEUS IS 'Contenido ttulo cabecera euskera';

COMMENT ON COLUMN GEDW.GEDW89T00.PCA_IDENC IS 'Identificativo de encuesta';

COMMENT ON COLUMN GEDW.GEDW89T00.PCA_PERFIL IS 'Perfil ';


--
-- GEDW90T00  (Table) 
--
CREATE TABLE GEDW.GEDW90T00
(
  PNL_ID       INTEGER,
  PNL_CABID    INTEGER,
  PNL_CONTCAS  VARCHAR2(2000 BYTE),
  PNL_CONTEUS  VARCHAR2(2000 BYTE),
  PNL_ORDEN    INTEGER,
  PNL_IDAYUDA  VARCHAR2(100 BYTE),
  PNL_IDENC    VARCHAR2(10 BYTE),
  PNL_PERFIL   VARCHAR2(2 BYTE)
)
TABLESPACE GEDW
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOCOMPRESS ;

COMMENT ON COLUMN GEDW.GEDW90T00.PNL_ID IS 'Cdigo identificativo';

COMMENT ON COLUMN GEDW.GEDW90T00.PNL_CABID IS 'Cdigo identificativo cabecera';

COMMENT ON COLUMN GEDW.GEDW90T00.PNL_CONTCAS IS 'Contenido castellano';

COMMENT ON COLUMN GEDW.GEDW90T00.PNL_CONTEUS IS 'Contenido euskera';

COMMENT ON COLUMN GEDW.GEDW90T00.PNL_ORDEN IS 'Orden de aparicin';

COMMENT ON COLUMN GEDW.GEDW90T00.PNL_IDAYUDA IS 'Id paso de cuestionario en el que debe aparecer. Vacio si debe aparecer en todos';

COMMENT ON COLUMN GEDW.GEDW90T00.PNL_IDENC IS 'Identificador encuesta';

COMMENT ON COLUMN GEDW.GEDW90T00.PNL_PERFIL IS 'Perfil';


--
-- GEDW91T00  (Table) 
--
CREATE TABLE GEDW.GEDW91T00
(
  CAB_ID      INTEGER,
  CAB_LITCAS  VARCHAR2(50 BYTE),
  CAB_LITEUS  VARCHAR2(50 BYTE),
  CAB_URL     VARCHAR2(200 BYTE)
)
TABLESPACE GEDW
PCTUSED    0
PCTFREE    10
INITRANS   1
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           )
NOCOMPRESS ;

COMMENT ON TABLE GEDW.GEDW91T00 IS 'Datos de cabecera (Ayuda,Accesibilidad,Contacto..)';


--
-- GEDW01I00  (Index) 
--
CREATE UNIQUE INDEX GEDW.GEDW01I00 ON GEDW.GEDW01T00
(CODUSU)
TABLESPACE GEDW
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           );

--
-- GEDW02I00  (Index) 
--
CREATE UNIQUE INDEX GEDW.GEDW02I00 ON GEDW.GEDW02T00
(CODUSU, CODOPE)
TABLESPACE GEDW
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           );

--
-- GEDW60I00  (Index) 
--
CREATE UNIQUE INDEX GEDW.GEDW60I00 ON GEDW.GEDW60T00
(CODSIT)
TABLESPACE GEDW
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           );

--
-- GEDW61I00  (Index) 
--
CREATE UNIQUE INDEX GEDW.GEDW61I00 ON GEDW.GEDW61T00
(CODRVIV)
TABLESPACE GEDW
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           );

--
-- GEDW61I01  (Index) 
--
CREATE UNIQUE INDEX GEDW.GEDW61I01 ON GEDW.GEDW61T01
(RVIVOPE_CODRVIV, RVIVOPE_CODOPE)
TABLESPACE GEDW
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           );

--
-- GEDW62I00  (Index) 
--
CREATE UNIQUE INDEX GEDW.GEDW62I00 ON GEDW.GEDW62T00
(CODRCON)
TABLESPACE GEDW
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           );

--
-- GEDW63I00  (Index) 
--
CREATE UNIQUE INDEX GEDW.GEDW63I00 ON GEDW.GEDW63T00
(CODRCUE)
TABLESPACE GEDW
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           );

--
-- GEDW63I01  (Index) 
--
CREATE UNIQUE INDEX GEDW.GEDW63I01 ON GEDW.GEDW63T01
(RCUESTOPE_CODRCUEST, RCUESTOPE_CODOPE)
TABLESPACE GEDW
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           );

--
-- GEDW64I00  (Index) 
--
CREATE UNIQUE INDEX GEDW.GEDW64I00 ON GEDW.GEDW64T00
(CODLNAC)
TABLESPACE GEDW
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           );

--
-- GEDW65I00  (Index) 
--
CREATE UNIQUE INDEX GEDW.GEDW65I00 ON GEDW.GEDW65T00
(CODNACI)
TABLESPACE GEDW
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           );

--
-- GEDW66I00  (Index) 
--
CREATE UNIQUE INDEX GEDW.GEDW66I00 ON GEDW.GEDW66T00
(CODFORM)
TABLESPACE GEDW
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           );

--
-- GEDW69I00  (Index) 
--
CREATE UNIQUE INDEX GEDW.GEDW69I00 ON GEDW.GEDW69T00
(CODOPE, NOMEXC)
TABLESPACE GEDW
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           );

--
-- GEDW70I00  (Index) 
--
CREATE UNIQUE INDEX GEDW.GEDW70I00 ON GEDW.GEDW70T00
(CODUSU, CODOPE, LOTE)
TABLESPACE GEDW
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           );

--
-- GEDW71T00_PK  (Index) 
--
CREATE UNIQUE INDEX GEDW.GEDW71T00_PK ON GEDW.GEDW71T00
(IDDESCARGA)
TABLESPACE GEDW
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           );

--
-- GEDW89T00_PK  (Index) 
--
CREATE UNIQUE INDEX GEDW.GEDW89T00_PK ON GEDW.GEDW89T00
(PCA_ID)
TABLESPACE GEDW
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           );

--
-- GEDW90I00  (Index) 
--
CREATE UNIQUE INDEX GEDW.GEDW90I00 ON GEDW.GEDW90T00
(PNL_ID)
TABLESPACE GEDW
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           );

--
-- GEDW91I00  (Index) 
--
CREATE UNIQUE INDEX GEDW.GEDW91I00 ON GEDW.GEDW91T00
(CAB_ID)
TABLESPACE GEDW
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           );

--
-- PK_GEDW67T00  (Index) 
--
CREATE UNIQUE INDEX GEDW.PK_GEDW67T00 ON GEDW.GEDW68T00
(CODPINC)
TABLESPACE GEDW
PCTFREE    10
INITRANS   2
MAXTRANS   255
STORAGE    (
            INITIAL          64K
            NEXT             1M
            MINEXTENTS       1
            MAXEXTENTS       UNLIMITED
            PCTINCREASE      0
            BUFFER_POOL      DEFAULT
           );

--
-- ACCESOS  (Synonym) 
--
CREATE SYNONYM GEDW.ACCESOS FOR TRAZAS.TRZW52T00;


--
-- COMARCAS  (Synonym) 
--
CREATE SYNONYM GEDW.COMARCAS FOR TERRITORIO_SII.MTP_COMARCA;


--
-- CVLW01T00  (Synonym) 
--
CREATE SYNONYM GEDW.CVLW01T00 FOR CVLW.CVLW01T00;


--
-- CVLW02T00  (Synonym) 
--
CREATE SYNONYM GEDW.CVLW02T00 FOR CVLW.CVLW02T00;


--
-- CVLW03T00  (Synonym) 
--
CREATE SYNONYM GEDW.CVLW03T00 FOR CVLW.CVLW03T00;


--
-- CVLW07T00  (Synonym) 
--
CREATE SYNONYM GEDW.CVLW07T00 FOR CVLW.CVLW07T00;


--
-- CVLW11T01  (Synonym) 
--
CREATE SYNONYM GEDW.CVLW11T01 FOR CVLW.CVLW11T01;


--
-- CVLW12T01  (Synonym) 
--
CREATE SYNONYM GEDW.CVLW12T01 FOR CVLW.CVLW12T01;


--
-- CVLW13T01  (Synonym) 
--
CREATE SYNONYM GEDW.CVLW13T01 FOR CVLW.CVLW13T01;


--
-- ECSW01T00  (Synonym) 
--
CREATE SYNONYM GEDW.ECSW01T00 FOR ECSW.ECSW01T00;


--
-- ECSW02T00  (Synonym) 
--
CREATE SYNONYM GEDW.ECSW02T00 FOR ECSW.ECSW02T00;


--
-- ECSW03T00  (Synonym) 
--
CREATE SYNONYM GEDW.ECSW03T00 FOR ECSW.ECSW03T00;


--
-- ECSW07T00  (Synonym) 
--
CREATE SYNONYM GEDW.ECSW07T00 FOR ECSW.ECSW07T00;


--
-- ECSW11T01  (Synonym) 
--
CREATE SYNONYM GEDW.ECSW11T01 FOR ECSW.ECSW11T01;


--
-- ECVW01T00  (Synonym) 
--
CREATE SYNONYM GEDW.ECVW01T00 FOR ECVW.ECVW01T00;


--
-- ECVW02T00  (Synonym) 
--
CREATE SYNONYM GEDW.ECVW02T00 FOR ECVW.ECVW02T00;


--
-- ECVW03T00  (Synonym) 
--
CREATE SYNONYM GEDW.ECVW03T00 FOR ECVW.ECVW03T00;


--
-- ECVW07T00  (Synonym) 
--
CREATE SYNONYM GEDW.ECVW07T00 FOR ECVW.ECVW07T00;


--
-- ECVW11T00  (Synonym) 
--
CREATE SYNONYM GEDW.ECVW11T00 FOR ECVW.ECVW11T00;


--
-- ECVW11T01  (Synonym) 
--
CREATE SYNONYM GEDW.ECVW11T01 FOR ECVW.ECVW11T01;


--
-- EDVW01T00  (Synonym) 
--
CREATE SYNONYM GEDW.EDVW01T00 FOR EDVW.EDVW01T00;


--
-- EDVW02T00  (Synonym) 
--
CREATE SYNONYM GEDW.EDVW02T00 FOR EDVW.EDVW02T00;


--
-- EDVW03T00  (Synonym) 
--
CREATE SYNONYM GEDW.EDVW03T00 FOR EDVW.EDVW03T00;


--
-- EDVW04T00  (Synonym) 
--
CREATE SYNONYM GEDW.EDVW04T00 FOR EDVW.EDVW04T00;


--
-- EDVW04T01  (Synonym) 
--
CREATE SYNONYM GEDW.EDVW04T01 FOR EDVW.EDVW04T00;


--
-- EDVW07T00  (Synonym) 
--
CREATE SYNONYM GEDW.EDVW07T00 FOR EDVW.EDVW07T00;


--
-- EDVW11T00  (Synonym) 
--
CREATE SYNONYM GEDW.EDVW11T00 FOR EDVW.EDVW11T00;


--
-- EDVW11T01  (Synonym) 
--
CREATE SYNONYM GEDW.EDVW11T01 FOR EDVW.EDVW11T01;


--
-- EDVW12T01  (Synonym) 
--
CREATE SYNONYM GEDW.EDVW12T01 FOR EDVW.EDVW12T01;


--
-- EDVW12T11  (Synonym) 
--
CREATE SYNONYM GEDW.EDVW12T11 FOR EDVW.EDVW12T11;


--
-- EMAFW01T00  (Synonym) 
--
CREATE SYNONYM GEDW.EMAFW01T00 FOR EMAFW.EMAFW01T00;


--
-- EMAFW02T00  (Synonym) 
--
CREATE SYNONYM GEDW.EMAFW02T00 FOR EMAFW.EMAFW02T00;


--
-- EMAFW03T00  (Synonym) 
--
CREATE SYNONYM GEDW.EMAFW03T00 FOR EMAFW.EMAFW03T00;


--
-- EMAFW07T00  (Synonym) 
--
CREATE SYNONYM GEDW.EMAFW07T00 FOR EMAFW.EMAFW07T00;


--
-- EMAFW11T00  (Synonym) 
--
CREATE SYNONYM GEDW.EMAFW11T00 FOR EMAFW.EMAFW11T00;


--
-- EMAFW11T01  (Synonym) 
--
CREATE SYNONYM GEDW.EMAFW11T01 FOR EMAFW.EMAFW11T01;


--
-- EMAFW12T00  (Synonym) 
--
CREATE SYNONYM GEDW.EMAFW12T00 FOR EMAFW.EMAFW12T00;


--
-- EMAFW13T00  (Synonym) 
--
CREATE SYNONYM GEDW.EMAFW13T00 FOR EMAFW.EMAFW13T00;


--
-- EMAFW14T00  (Synonym) 
--
CREATE SYNONYM GEDW.EMAFW14T00 FOR EMAFW.EMAFW14T00;


--
-- EMAFW15T00  (Synonym) 
--
CREATE SYNONYM GEDW.EMAFW15T00 FOR EMAFW.EMAFW15T00;


--
-- EMAFW16T00  (Synonym) 
--
CREATE SYNONYM GEDW.EMAFW16T00 FOR EMAFW.EMAFW16T00;


--
-- EMAFW17T00  (Synonym) 
--
CREATE SYNONYM GEDW.EMAFW17T00 FOR EMAFW.EMAFW17T00;


--
-- EMAFW64T00  (Synonym) 
--
CREATE SYNONYM GEDW.EMAFW64T00 FOR EMAFW.EMAFW64T00;


--
-- EMAFW65T00  (Synonym) 
--
CREATE SYNONYM GEDW.EMAFW65T00 FOR EMAFW.EMAFW65T00;


--
-- EMAFW67T00  (Synonym) 
--
CREATE SYNONYM GEDW.EMAFW67T00 FOR EMAFW.EMAFW67T00;


--
-- EPTW01T00  (Synonym) 
--
CREATE SYNONYM GEDW.EPTW01T00 FOR EPTW.EPTW01T00;


--
-- EPTW02T00  (Synonym) 
--
CREATE SYNONYM GEDW.EPTW02T00 FOR EPTW.EPTW02T00;


--
-- EPTW03T00  (Synonym) 
--
CREATE SYNONYM GEDW.EPTW03T00 FOR EPTW.EPTW03T00;


--
-- EPTW07T00  (Synonym) 
--
CREATE SYNONYM GEDW.EPTW07T00 FOR EPTW.EPTW07T00;


--
-- EPTW11T00  (Synonym) 
--
CREATE SYNONYM GEDW.EPTW11T00 FOR EPTW.EPTW11T00;


--
-- EPTW11T01  (Synonym) 
--
CREATE SYNONYM GEDW.EPTW11T01 FOR EPTW.EPTW11T01;


--
-- EPTW12T00  (Synonym) 
--
CREATE SYNONYM GEDW.EPTW12T00 FOR EPTW.EPTW12T00;


--
-- EPTW12T01  (Synonym) 
--
CREATE SYNONYM GEDW.EPTW12T01 FOR EPTW.EPTW12T01;


--
-- EPTW80T01  (Synonym) 
--
CREATE SYNONYM GEDW.EPTW80T01 FOR EPTW.EPTW80T01;


--
-- ERRORES_CIERRE  (Synonym) 
--
CREATE SYNONYM GEDW.ERRORES_CIERRE FOR PRAW.ERRORES_CIERRE;


--
-- ESIFW01T00  (Synonym) 
--
CREATE SYNONYM GEDW.ESIFW01T00 FOR ESIFW.ESIFW01T00;


--
-- ESIFW02T00  (Synonym) 
--
CREATE SYNONYM GEDW.ESIFW02T00 FOR ESIFW.ESIFW02T00;


--
-- ESIFW03T00  (Synonym) 
--
CREATE SYNONYM GEDW.ESIFW03T00 FOR ESIFW.ESIFW03T00;


--
-- ESIFW04T00  (Synonym) 
--
CREATE SYNONYM GEDW.ESIFW04T00 FOR ESIFW.ESIFW04T00;


--
-- ESIFW04T01  (Synonym) 
--
CREATE SYNONYM GEDW.ESIFW04T01 FOR ESIFW.ESIFW04T01;


--
-- ESIFW05T00  (Synonym) 
--
CREATE SYNONYM GEDW.ESIFW05T00 FOR ESIFW.ESIFW05T00;


--
-- ESIFW05T01  (Synonym) 
--
CREATE SYNONYM GEDW.ESIFW05T01 FOR ESIFW.ESIFW05T01;


--
-- ESIFW05T02  (Synonym) 
--
CREATE SYNONYM GEDW.ESIFW05T02 FOR ESIFW.ESIFW05T02;


--
-- ESIFW06T00  (Synonym) 
--
CREATE SYNONYM GEDW.ESIFW06T00 FOR ESIFW.ESIFW06T00;


--
-- ESIFW06T01  (Synonym) 
--
CREATE SYNONYM GEDW.ESIFW06T01 FOR ESIFW.ESIFW06T01;


--
-- ESIFW07T00  (Synonym) 
--
CREATE SYNONYM GEDW.ESIFW07T00 FOR ESIFW.ESIFW07T00;


--
-- ESIFW11T00  (Synonym) 
--
CREATE SYNONYM GEDW.ESIFW11T00 FOR ESIFW.ESIFW11T00;


--
-- ESIFW11T01  (Synonym) 
--
CREATE SYNONYM GEDW.ESIFW11T01 FOR ESIFW.ESIFW11T01;


--
-- GEDW88T00  (Synonym) 
--
CREATE SYNONYM GEDW.GEDW88T00 FOR SARW.SARW88T00;


--
-- GEDW96T00  (Synonym) 
--
CREATE SYNONYM GEDW.GEDW96T00 FOR SARW.GEDW96T00;


--
-- LITERALES_NOCODIFICADOS  (Synonym) 
--
CREATE SYNONYM GEDW.LITERALES_NOCODIFICADOS FOR ESIFW.LITERALES_NOCODIFICADOS;


--
-- MUNICIPIOS  (Synonym) 
--
CREATE SYNONYM GEDW.MUNICIPIOS FOR TERRITORIO_SII.MTP_MUNICIPIO;


--
-- PRAW01T00  (Synonym) 
--
CREATE SYNONYM GEDW.PRAW01T00 FOR PRAW.PRAW01T00;


--
-- PRAW02T00  (Synonym) 
--
CREATE SYNONYM GEDW.PRAW02T00 FOR PRAW.PRAW02T00;


--
-- PRAW03T00  (Synonym) 
--
CREATE SYNONYM GEDW.PRAW03T00 FOR PRAW.PRAW03T00;


--
-- PRAW04T00  (Synonym) 
--
CREATE SYNONYM GEDW.PRAW04T00 FOR PRAW.PRAW04T00;


--
-- PRAW05T00  (Synonym) 
--
CREATE SYNONYM GEDW.PRAW05T00 FOR PRAW.PRAW05T00;


--
-- PRAW11T00  (Synonym) 
--
CREATE SYNONYM GEDW.PRAW11T00 FOR PRAW.PRAW11T00;


--
-- PRAW11T01  (Synonym) 
--
CREATE SYNONYM GEDW.PRAW11T01 FOR PRAW.PRAW11T01;


--
-- PRAW15T00  (Synonym) 
--
CREATE SYNONYM GEDW.PRAW15T00 FOR PRAW.PRAW15T00;


--
-- PRAW16T00  (Synonym) 
--
CREATE SYNONYM GEDW.PRAW16T00 FOR PRAW.PRAW16T00;


--
-- PRAW17T00  (Synonym) 
--
CREATE SYNONYM GEDW.PRAW17T00 FOR PRAW.PRAW17T00;


--
-- PRAW18T00  (Synonym) 
--
CREATE SYNONYM GEDW.PRAW18T00 FOR PRAW.PRAW18T00;


--
-- PRAW19T00  (Synonym) 
--
CREATE SYNONYM GEDW.PRAW19T00 FOR PRAW.PRAW19T00;


--
-- PRAW20T00  (Synonym) 
--
CREATE SYNONYM GEDW.PRAW20T00 FOR PRAW.PRAW20T00;


--
-- PRAW21T00  (Synonym) 
--
CREATE SYNONYM GEDW.PRAW21T00 FOR PRAW.PRAW21T00;


--
-- PROVINCIAS  (Synonym) 
--
CREATE SYNONYM GEDW.PROVINCIAS FOR TERRITORIO_SII.MTP_PROVINCIA;


--
-- SEQ_ACCESOS  (Synonym) 
--
CREATE SYNONYM GEDW.SEQ_ACCESOS FOR TRAZAS.SEQ_TRZW52T00;


--
-- SHPW01T00  (Synonym) 
--
CREATE SYNONYM GEDW.SHPW01T00 FOR SHPW.SHPW01T00;


--
-- SHPW02T00  (Synonym) 
--
CREATE SYNONYM GEDW.SHPW02T00 FOR SHPW.SHPW02T00;


--
-- SHPW03T00  (Synonym) 
--
CREATE SYNONYM GEDW.SHPW03T00 FOR SHPW.SHPW03T00;


--
-- SHPW11T01  (Synonym) 
--
CREATE SYNONYM GEDW.SHPW11T01 FOR SHPW.SHPW11T01;


--
-- TIPOERROR  (Synonym) 
--
CREATE SYNONYM GEDW.TIPOERROR FOR TRAZAS.TRZW50T00;


--
-- TIPOTRAZA  (Synonym) 
--
CREATE SYNONYM GEDW.TIPOTRAZA FOR TRAZAS.TRZW51T00;


--
-- VERIFICAR_SITIO  (Synonym) 
--
CREATE SYNONYM GEDW.VERIFICAR_SITIO FOR ESIFW.VERIFICAR_SITIO;


--
-- P_GED_INTERFACE  (Package) 
--
CREATE OR REPLACE PACKAGE GEDW.P_GED_INTERFACE AS

    TYPE RREGISTRO IS RECORD (
            TERH VARCHAR2(2),
            COMR VARCHAR2(2),
            SENC NUMBER(2),
            CAMPO NUMBER(4),
            FINALIZADA NUMBER(4),
            INCIDENCIAS NUMBER(4),
            SINCODIFICAR NUMBER(4) 
    );
    TYPE TDATOS_RETORNO IS TABLE OF RREGISTRO;

  PROCEDURE GED_REC_INDICADORES (IDIOMA               IN     VARCHAR2 DEFAULT 'C',                                   
                                   OP_ANIO              IN     NUMBER,
                                   TRIMESTRE            IN     NUMBER,
                                   OP_OPERACION         IN     VARCHAR2,
                                   OP_SUBOPERACION      IN     VARCHAR2,
                                   INSPECTOR            IN     VARCHAR2,
                                   R_L_HABITABLE             OUT NUMBER,
                                   R_L_VACIA        OUT NUMBER,
                                   R_L_TEMPORAL            OUT NUMBER,
                                   R_L_REFORMA             OUT NUMBER,
                                   R_L_RUINOSA              OUT NUMBER,
                                   R_L_CONSTRUCCION              OUT NUMBER,
                                   R_L_OTROS_FINES           OUT NUMBER,
                                   R_L_INACCESIBLE           OUT NUMBER,
                                   R_L_ILOCALIZADA           OUT NUMBER,
                                   R_L_NOCLASIFICABLE           OUT NUMBER,
                                   R_L_EXCLUIDA           OUT NUMBER,
                                   R_L_DESAPARECIDA           OUT NUMBER,
                                   
                                   R_C_CONTACTADA           OUT NUMBER,
                                   R_C_NOCONTACTADA           OUT NUMBER,                                   
                                   NUM_CONTACTOS       OUT NUMBER,
                                   
                                   S_CAMPO           OUT NUMBER,
                                   S_FINALIZADA           OUT NUMBER,
                                   S_PARCIAL           OUT NUMBER,
                                   S_INCIDENCIAS         OUT NUMBER,
                                   S_FAMILIAR        OUT NUMBER,
                                   S_FUERAPLAZO        OUT NUMBER,
                                   S_CUMPLI_SCODIFICAR      OUT NUMBER,
                                   S_CUMPLI_SVALIDAR      OUT NUMBER,
                                   S_CODIFICADA       OUT NUMBER,
                                   S_CUMPLI_FUERAPLAZO        OUT NUMBER,                                   
                                   
                                   T_CON_FAM_VISITA        OUT NUMBER,
                                   T_CON_FAM_TELEFONO      OUT NUMBER,
                                   T_CON_FAM_WEB           OUT NUMBER,
                                   T_CON_FAM_OTRO           OUT NUMBER,
                                   
                                   T_CON_PER_VISITA        OUT NUMBER,
                                   T_CON_PER_TELEFONO      OUT NUMBER,
                                   T_CON_PER_WEB           OUT NUMBER,
                                   T_CON_PER_OTRO           OUT NUMBER,
                                   
                                   R_CUE_FAM_PENDIENTE           OUT NUMBER,
                                   R_CUE_FAM_COMPLETO           OUT NUMBER,
                                   R_CUE_FAM_NEGATIVA           OUT NUMBER,
                                   R_CUE_FAM_VACACIONES           OUT NUMBER,
                                   R_CUE_FAM_AUSENCIA           OUT NUMBER,
                                   R_CUE_FAM_RECUP_TITU           OUT NUMBER,
                                   R_CUE_FAM_OTRAS           OUT NUMBER,
                                   R_CUE_FAM_INCOMPLETO           OUT NUMBER,
                                   
                                   R_CUE_PER_PENDIENTE           OUT NUMBER,
                                   R_CUE_PER_COMPLETO           OUT NUMBER,
                                   R_CUE_PER_NEGATIVA           OUT NUMBER,
                                   R_CUE_PER_VACACIONES           OUT NUMBER,
                                   R_CUE_PER_AUSENCIA           OUT NUMBER,
                                   R_CUE_PER_RECUP_TITU           OUT NUMBER,
                                   R_CUE_PER_OTRAS           OUT NUMBER,
                                   R_CUE_PER_INCOMPLETO           OUT NUMBER,
                                   
                                   ENC_SUPERVISADAS        OUT NUMBER,
                                   TOTAL_MUESTRA           OUT NUMBER,
                                   TOTAL_MUESTRA_MAS15           OUT NUMBER,
                                   CODERROR                OUT NUMBER,
                                   MENSAJERROR             OUT VARCHAR2)
    ;
    
    PROCEDURE GED_REC_INDICADORES_INFCAE 
                                  (IDIOMA               IN     VARCHAR2 DEFAULT 'C',                                   
                                   OP_ANIO              IN     NUMBER,
                                   TRIMESTRE            IN     NUMBER,
                                   OP_OPERACION         IN     VARCHAR2,
                                   OP_SUBOPERACION      IN     VARCHAR2,
                                   R_L_HABITABLE_A             OUT NUMBER,
                                   R_L_VACIA_A        OUT NUMBER,
                                   R_L_TEMPORAL_A            OUT NUMBER,
                                   R_L_REFORMA_A             OUT NUMBER,
                                   R_L_RUINOSA_A              OUT NUMBER,
                                   R_L_CONSTRUCCION_A              OUT NUMBER,
                                   R_L_OTROS_FINES_A           OUT NUMBER,
                                   R_L_INACCESIBLE_A           OUT NUMBER,
                                   R_L_ILOCALIZADA_A           OUT NUMBER,
                                   R_L_NOCLASIFICABLE_A           OUT NUMBER,
                                   R_L_EXCLUIDA_A           OUT NUMBER,
                                   R_L_DESAPARECIDA_A           OUT NUMBER,
                                   R_L_HABITABLE_B             OUT NUMBER,
                                   R_L_VACIA_B        OUT NUMBER,
                                   R_L_TEMPORAL_B            OUT NUMBER,
                                   R_L_REFORMA_B             OUT NUMBER,
                                   R_L_RUINOSA_B              OUT NUMBER,
                                   R_L_CONSTRUCCION_B              OUT NUMBER,
                                   R_L_OTROS_FINES_B           OUT NUMBER,
                                   R_L_INACCESIBLE_B           OUT NUMBER,
                                   R_L_ILOCALIZADA_B           OUT NUMBER,
                                   R_L_NOCLASIFICABLE_B           OUT NUMBER,
                                   R_L_EXCLUIDA_B           OUT NUMBER,
                                   R_L_DESAPARECIDA_B           OUT NUMBER,
                                   R_L_HABITABLE_G             OUT NUMBER,
                                   R_L_VACIA_G        OUT NUMBER,
                                   R_L_TEMPORAL_G            OUT NUMBER,
                                   R_L_REFORMA_G             OUT NUMBER,
                                   R_L_RUINOSA_G              OUT NUMBER,
                                   R_L_CONSTRUCCION_G              OUT NUMBER,
                                   R_L_OTROS_FINES_G           OUT NUMBER,
                                   R_L_INACCESIBLE_G           OUT NUMBER,
                                   R_L_ILOCALIZADA_G           OUT NUMBER,
                                   R_L_NOCLASIFICABLE_G           OUT NUMBER,
                                   R_L_EXCLUIDA_G           OUT NUMBER,                          
                                   R_L_DESAPARECIDA_G           OUT NUMBER,     
                                   
                                   T_CON_FAM_VISITA_A        OUT NUMBER,
                                   T_CON_FAM_TELEFONO_A      OUT NUMBER,
                                   T_CON_FAM_WEB_A           OUT NUMBER,
                                   T_CON_FAM_OTRO_A           OUT NUMBER,
                                   T_CON_FAM_VISITA_B        OUT NUMBER,
                                   T_CON_FAM_TELEFONO_B      OUT NUMBER,
                                   T_CON_FAM_WEB_B           OUT NUMBER,
                                   T_CON_FAM_OTRO_B           OUT NUMBER,
                                   T_CON_FAM_VISITA_G        OUT NUMBER,
                                   T_CON_FAM_TELEFONO_G      OUT NUMBER,
                                   T_CON_FAM_WEB_G           OUT NUMBER,
                                   T_CON_FAM_OTRO_G           OUT NUMBER,
                                   
                                   T_CON_PER_VISITA_A        OUT NUMBER,
                                   T_CON_PER_TELEFONO_A      OUT NUMBER,
                                   T_CON_PER_WEB_A           OUT NUMBER,
                                   T_CON_PER_OTRO_A           OUT NUMBER,
                                   T_CON_PER_VISITA_B        OUT NUMBER,
                                   T_CON_PER_TELEFONO_B      OUT NUMBER,
                                   T_CON_PER_WEB_B           OUT NUMBER,
                                   T_CON_PER_OTRO_B           OUT NUMBER,
                                   T_CON_PER_VISITA_G        OUT NUMBER,
                                   T_CON_PER_TELEFONO_G      OUT NUMBER,
                                   T_CON_PER_WEB_G           OUT NUMBER,
                                   T_CON_PER_OTRO_G           OUT NUMBER,
                                   
                                   R_CUE_FAM_PENDIENTE_A    OUT NUMBER,
                                   R_CUE_FAM_COMPLETO_A     OUT NUMBER,
                                   R_CUE_FAM_INCOMPLETO_A   OUT NUMBER,
                                   R_CUE_FAM_RESTO_A    OUT NUMBER,
                                   R_CUE_FAM_PENDIENTE_B    OUT NUMBER,
                                   R_CUE_FAM_COMPLETO_B     OUT NUMBER,
                                   R_CUE_FAM_INCOMPLETO_B   OUT NUMBER,
                                   R_CUE_FAM_RESTO_B    OUT NUMBER,
                                   R_CUE_FAM_PENDIENTE_G    OUT NUMBER,
                                   R_CUE_FAM_COMPLETO_G     OUT NUMBER,
                                   R_CUE_FAM_INCOMPLETO_G   OUT NUMBER,
                                   R_CUE_FAM_RESTO_G    OUT NUMBER,
                                   
                                   R_CUE_PER_PENDIENTE_A    OUT NUMBER,
                                   R_CUE_PER_COMPLETO_A     OUT NUMBER,
                                   R_CUE_PER_INCOMPLETO_A   OUT NUMBER,
                                   R_CUE_PER_RESTO_A    OUT NUMBER,
                                   R_CUE_PER_PENDIENTE_B    OUT NUMBER,
                                   R_CUE_PER_COMPLETO_B     OUT NUMBER,
                                   R_CUE_PER_INCOMPLETO_B   OUT NUMBER,
                                   R_CUE_PER_RESTO_B    OUT NUMBER,
                                   R_CUE_PER_PENDIENTE_G    OUT NUMBER,
                                   R_CUE_PER_COMPLETO_G     OUT NUMBER,
                                   R_CUE_PER_INCOMPLETO_G   OUT NUMBER,
                                   R_CUE_PER_RESTO_G    OUT NUMBER,
                                   
                                   TOTAL_MUESTRA_A           OUT NUMBER,
                                   TOTAL_MUESTRA_B           OUT NUMBER,
                                   TOTAL_MUESTRA_G           OUT NUMBER,
                                   CODERROR                OUT NUMBER,
                                   MENSAJERROR             OUT VARCHAR2);  

PROCEDURE GED_REC_INDICADORES_INFSEMANA 
                                  (IDIOMA               IN     VARCHAR2 DEFAULT 'C',                                   
                                   OP_ANIO              IN     NUMBER,
                                   TRIMESTRE            IN     NUMBER,
                                   OP_OPERACION         IN     VARCHAR2,
                                   OP_SUBOPERACION      IN     VARCHAR2,
                                   CDATOS               OUT TDATOS_RETORNO,
                                   MAXSEMANA            OUT NUMBER,
                                   CODERROR                OUT NUMBER,
                                   MENSAJERROR             OUT VARCHAR2);  

PROCEDURE GED_REC_INDICADORES_INFCOMARCA 
                                  (IDIOMA               IN     VARCHAR2 DEFAULT 'C',                                   
                                   OP_ANIO              IN     NUMBER,
                                   TRIMESTRE            IN     NUMBER,
                                   OP_OPERACION         IN     VARCHAR2,
                                   OP_SUBOPERACION      IN     VARCHAR2,
                                   CDATOS               OUT TDATOS_RETORNO,
                                   CODERROR                OUT NUMBER,
                                   MENSAJERROR             OUT VARCHAR2);

END P_GED_INTERFACE;
/


--
-- P_GED_INTERFACE  (Package Body) 
--
CREATE OR REPLACE PACKAGE BODY GEDW.P_GED_INTERFACE AS

  PROCEDURE GED_REC_INDICADORES (IDIOMA               IN     VARCHAR2 DEFAULT 'C',                                   
                                   OP_ANIO              IN     NUMBER,
                                   TRIMESTRE            IN     NUMBER,
                                   OP_OPERACION         IN     VARCHAR2,
                                   OP_SUBOPERACION      IN     VARCHAR2,
                                   INSPECTOR            IN     VARCHAR2,
                                   R_L_HABITABLE             OUT NUMBER,
                                   R_L_VACIA        OUT NUMBER,
                                   R_L_TEMPORAL            OUT NUMBER,
                                   R_L_REFORMA             OUT NUMBER,
                                   R_L_RUINOSA              OUT NUMBER,
                                   R_L_CONSTRUCCION              OUT NUMBER,
                                   R_L_OTROS_FINES           OUT NUMBER,
                                   R_L_INACCESIBLE           OUT NUMBER,
                                   R_L_ILOCALIZADA           OUT NUMBER,
                                   R_L_NOCLASIFICABLE           OUT NUMBER,
                                   R_L_EXCLUIDA           OUT NUMBER,
                                   R_L_DESAPARECIDA           OUT NUMBER,
                                   
                                   R_C_CONTACTADA           OUT NUMBER,
                                   R_C_NOCONTACTADA           OUT NUMBER,                                   
                                   NUM_CONTACTOS       OUT NUMBER,
                                   
                                   S_CAMPO           OUT NUMBER,
                                   S_FINALIZADA           OUT NUMBER,
                                   S_PARCIAL           OUT NUMBER,
                                   S_INCIDENCIAS         OUT NUMBER,
                                   S_FAMILIAR        OUT NUMBER,
                                   S_FUERAPLAZO        OUT NUMBER,
                                   S_CUMPLI_SCODIFICAR      OUT NUMBER,
                                   S_CUMPLI_SVALIDAR      OUT NUMBER,
                                   S_CODIFICADA       OUT NUMBER,
                                   S_CUMPLI_FUERAPLAZO        OUT NUMBER,                                   
                                   
                                   T_CON_FAM_VISITA        OUT NUMBER,
                                   T_CON_FAM_TELEFONO      OUT NUMBER,
                                   T_CON_FAM_WEB           OUT NUMBER,
                                   T_CON_FAM_OTRO           OUT NUMBER,
                                   
                                   T_CON_PER_VISITA        OUT NUMBER,
                                   T_CON_PER_TELEFONO      OUT NUMBER,
                                   T_CON_PER_WEB           OUT NUMBER,
                                   T_CON_PER_OTRO           OUT NUMBER,
                                   
                                   R_CUE_FAM_PENDIENTE           OUT NUMBER,
                                   R_CUE_FAM_COMPLETO           OUT NUMBER,
                                   R_CUE_FAM_NEGATIVA           OUT NUMBER,
                                   R_CUE_FAM_VACACIONES           OUT NUMBER,
                                   R_CUE_FAM_AUSENCIA           OUT NUMBER,
                                   R_CUE_FAM_RECUP_TITU           OUT NUMBER,
                                   R_CUE_FAM_OTRAS           OUT NUMBER,
                                   R_CUE_FAM_INCOMPLETO           OUT NUMBER,
                                   
                                   R_CUE_PER_PENDIENTE           OUT NUMBER,
                                   R_CUE_PER_COMPLETO           OUT NUMBER,
                                   R_CUE_PER_NEGATIVA           OUT NUMBER,
                                   R_CUE_PER_VACACIONES           OUT NUMBER,
                                   R_CUE_PER_AUSENCIA           OUT NUMBER,
                                   R_CUE_PER_RECUP_TITU           OUT NUMBER,
                                   R_CUE_PER_OTRAS           OUT NUMBER,
                                   R_CUE_PER_INCOMPLETO           OUT NUMBER,
                                   
                                   ENC_SUPERVISADAS        OUT NUMBER,
                                   TOTAL_MUESTRA           OUT NUMBER,
                                   TOTAL_MUESTRA_MAS15           OUT NUMBER,
                                   CODERROR                OUT NUMBER,
                                   MENSAJERROR             OUT VARCHAR2)
    IS
        /*
        Funcin: GED_REC_INDICADORES
        Autor:   SERIKAT
        Fecha Creacin: 23/11/2015
        Ultima Modificacin:
        Descripcin: Devuelve los contadores para los indicadores de la operacin pasada.
        */


        nCONT                  NUMBER;
        vSENTENCIA             VARCHAR2 (32767);

        sTEMP                  VARCHAR2 (50);
        sCOND                  VARCHAR2 (100);
        bNULO                  BOOLEAN;
        I                      NUMBER;
        
        vALIAS                 VARCHAR2(5);
        bTRIMESTRAL            BOOLEAN;

       
    BEGIN
        CODERROR := 0;
        MENSAJERROR := ' ';

       R_L_HABITABLE        := 0;
       R_L_VACIA            := 0;
       R_L_TEMPORAL         := 0;
       R_L_REFORMA          := 0;
       R_L_RUINOSA          := 0;
       R_L_CONSTRUCCION     := 0;
       R_L_OTROS_FINES      := 0;
       R_L_INACCESIBLE      := 0;
       R_L_ILOCALIZADA      := 0;
       R_L_NOCLASIFICABLE   := 0;
       R_L_EXCLUIDA         := 0;
       R_L_DESAPARECIDA         := 0;
                                   
       R_C_CONTACTADA       := 0;
       R_C_NOCONTACTADA     := 0;                                   
       NUM_CONTACTOS        := 0;
                                   
       S_CAMPO              := 0;
       S_FINALIZADA         := 0;
       S_PARCIAL            := 0;
       S_INCIDENCIAS        := 0;
       S_FAMILIAR           := 0;
       S_FUERAPLAZO         := 0;
       S_CUMPLI_SCODIFICAR  := 0;
       S_CUMPLI_SVALIDAR    := 0;
       S_CODIFICADA         := 0;
       S_CUMPLI_FUERAPLAZO  := 0;                                   
                                   
       T_CON_FAM_VISITA     := 0;
       T_CON_FAM_TELEFONO   := 0;
       T_CON_FAM_WEB        := 0;
       T_CON_FAM_OTRO        := 0;
                                   
       T_CON_PER_VISITA     := 0;
       T_CON_PER_TELEFONO   := 0;
       T_CON_PER_WEB        := 0;
       T_CON_PER_OTRO        := 0;
                                   
       R_CUE_FAM_PENDIENTE  := 0;
       R_CUE_FAM_COMPLETO   := 0;
       R_CUE_FAM_NEGATIVA   := 0;
       R_CUE_FAM_VACACIONES := 0;
       R_CUE_FAM_AUSENCIA   := 0;
       R_CUE_FAM_RECUP_TITU := 0;
       R_CUE_FAM_OTRAS      := 0;
       R_CUE_FAM_INCOMPLETO := 0;
                                   
       R_CUE_PER_PENDIENTE  := 0;
       R_CUE_PER_COMPLETO   := 0;
       R_CUE_PER_NEGATIVA   := 0;
       R_CUE_PER_VACACIONES := 0;
       R_CUE_PER_AUSENCIA   := 0;
       R_CUE_PER_RECUP_TITU := 0;
       R_CUE_PER_OTRAS      := 0;
       R_CUE_PER_INCOMPLETO := 0;
                                   
       ENC_SUPERVISADAS     := 0;
       TOTAL_MUESTRA        := 0;
       TOTAL_MUESTRA_MAS15 := 0;
       sTEMP := '1';
       IF OP_OPERACION = '050403' THEN
            vALIAS := 'PRA';
            bTRIMESTRAL := TRUE;
       ELSIF OP_OPERACION = '220122' THEN
            vALIAS := 'ESIF';
            bTRIMESTRAL := TRUE;
       ELSIF OP_OPERACION = '010313' THEN
            vALIAS := 'EDV';
            bTRIMESTRAL := FALSE;
       END IF;
       sTEMP := '2';
       IF vALIAS IS NOT NULL THEN
            sTEMP := '3';
            --Resultado de la Localizacin - localizada habitable
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W01T00 ';               
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND   TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND   RESULT = ''00''';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO R_L_HABITABLE USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO R_L_HABITABLE USING OP_ANIO;
            END IF;
            sTEMP := '4';
            --Resultado de la Localizacin - localizada deshabitada
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W01T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND   TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND   RESULT = ''10''';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO R_L_VACIA USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO R_L_VACIA USING OP_ANIO;
            END IF;
            sTEMP := '5';
            --Resultado de la Localizacin - localizada vivienda temporal
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W01T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND   TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND   RESULT = ''08''';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO R_L_TEMPORAL USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO R_L_TEMPORAL USING OP_ANIO;
            END IF;
            sTEMP := '6';
            --Resultado de la Localizacin - en reforma
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W01T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND   TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND   RESULT = ''04''';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO R_L_REFORMA USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO R_L_REFORMA USING OP_ANIO;
            END IF;
            sTEMP := '7';
            --Resultado de la Localizacin - ruinosa
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W01T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND   TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND   RESULT = ''05''';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO R_L_RUINOSA USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO R_L_RUINOSA USING OP_ANIO;
            END IF;
            sTEMP := '8';
             --Resultado de la Localizacin - construccin
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W01T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND   TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND   RESULT = ''06''';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO R_L_CONSTRUCCION USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO R_L_CONSTRUCCION USING OP_ANIO;
            END IF;
            sTEMP := '9';
            --Resultado de la Localizacin - otros fines
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W01T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND   TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND   RESULT = ''09''';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO R_L_OTROS_FINES USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO R_L_OTROS_FINES USING OP_ANIO;
            END IF;
            sTEMP := '10';
            --Resultado de la Localizacin - inaccesible
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W01T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND   TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND   RESULT = ''07''';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO R_L_INACCESIBLE USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO R_L_INACCESIBLE USING OP_ANIO;
            END IF;
            sTEMP := '11';
            --Resultado de la Localizacin - ilocalizada
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W01T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND   TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND   RESULT = ''01''';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO R_L_ILOCALIZADA USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO R_L_ILOCALIZADA USING OP_ANIO;
            END IF;
            sTEMP := '12';
            --Resultado de la Localizacin - no calificable
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W01T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND   TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND   RESULT = ''20''';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO R_L_NOCLASIFICABLE USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO R_L_NOCLASIFICABLE USING OP_ANIO;
            END IF;
            sTEMP := '13';
            --Resultado de la Localizacin - excluida
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W01T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND   TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND   RESULT = ''55''';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO R_L_EXCLUIDA USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO R_L_EXCLUIDA USING OP_ANIO;
            END IF;
            sTEMP := '14';
             --Resultado de la Localizacin - DESAPARECIDA
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W01T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND   TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND   RESULT = ''03''';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO R_L_DESAPARECIDA USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO R_L_DESAPARECIDA USING OP_ANIO;
            END IF;
            sTEMP := '15';
           
       
            --Resultado del contacto - contactada
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W01T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND   TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND   RCONT = ''00''';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO R_C_CONTACTADA USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO R_C_CONTACTADA USING OP_ANIO;
            END IF;
            sTEMP := '16';
            --Resultado del contacto - NO contactada
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W01T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND   TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND   RCONT = ''01''';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO R_C_NOCONTACTADA USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO R_C_NOCONTACTADA USING OP_ANIO;
            END IF;
            sTEMP := '17';
            --Resultado del contacto - nmero de contactos
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W01T00 ';
            vSENTENCIA := vSENTENCIA || 'JOIN ' || vALIAS || 'W03T00 ON ' || vALIAS || 'W03T00.NUMC = ' || vALIAS || 'W01T00.NUMC ';
            vSENTENCIA := vSENTENCIA || 'AND ' || vALIAS || 'W03T00.ANIO = ' || vALIAS || 'W01T00.AENC '; 
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND ' || vALIAS || 'W03T00.TRIM = ' || vALIAS || 'W01T00.TENC '; END IF;
            vSENTENCIA := vSENTENCIA || 'WHERE  AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND   TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND   (OBSERV IS NULL OR OBSERV not like ''Acceso del%'')';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO NUM_CONTACTOS USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO NUM_CONTACTOS USING OP_ANIO;
            END IF;
            sTEMP := '18';
            
            --Situacin de la recogida - en campo
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W01T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND   TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND   SITUAC = ''1''';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO S_CAMPO USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO S_CAMPO USING OP_ANIO;
            END IF;
            sTEMP := '19';
            --Situacin de la recogida - finalizada
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W01T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND   TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND   SITUAC = ''2''';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO S_FINALIZADA USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO S_FINALIZADA USING OP_ANIO;
            END IF;
            sTEMP := '20';
            --Situacin de la recogida - finalizada parcial
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W01T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND   TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND   SITUAC = ''3''';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO S_PARCIAL USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO S_PARCIAL USING OP_ANIO;
            END IF;
            sTEMP := '21';
            --Situacin de la recogida - finalizada con incidencias
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W01T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND   TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND   SITUAC = ''4''';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO S_INCIDENCIAS USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO S_INCIDENCIAS USING OP_ANIO;
            END IF;
            sTEMP := '22';
            --Situacin de la recogida - finalizada solo familiar
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W01T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND   TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND   SITUAC = ''10''';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO S_FAMILIAR USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO S_FAMILIAR USING OP_ANIO;
            END IF;
            sTEMP := '23';
            --Situacin de la recogida - finalizada fuera de plazo
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W01T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND   TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND   SITUAC = ''7''';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO S_FUERAPLAZO USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO S_FUERAPLAZO USING OP_ANIO;
            END IF;
            sTEMP := '24';
            --Situacin de la recogida - cumplimentada sin codificar
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W01T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND   TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND   SITUAC = ''5''';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO S_CUMPLI_SCODIFICAR USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO S_CUMPLI_SCODIFICAR USING OP_ANIO;
            END IF;
            sTEMP := '25';
            --Situacin de la recogida - cumplimentada sin validar
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W01T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND   TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND   SITUAC = ''8''';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO S_CUMPLI_SVALIDAR USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO S_CUMPLI_SVALIDAR USING OP_ANIO;
            END IF;
            sTEMP := '26';
            --Situacin de la recogida - codificada
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W01T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND   TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND   SITUAC = ''9''';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO S_CODIFICADA USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO S_CODIFICADA USING OP_ANIO;
            END IF;
            sTEMP := '27';
            --Situacin de la recogida - cumplimentada fuera de plazo
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W01T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND   TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND   SITUAC = ''6''';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO S_CUMPLI_FUERAPLAZO USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO S_CUMPLI_FUERAPLAZO USING OP_ANIO;
            END IF;
            sTEMP := '28';
            
            
            --mtodo de la entrevista - familiar - telfono              
            vSENTENCIA := 'SELECT COUNT(*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ( ';
            vSENTENCIA := vSENTENCIA || 'SELECT NUMC ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W02T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND FORMFAM = ''1'' ';
            --AND INDFAM = 'S' AND RESFAM = '00'
            vSENTENCIA := vSENTENCIA || 'GROUP BY NUMC)';            
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO T_CON_FAM_TELEFONO USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO T_CON_FAM_TELEFONO USING OP_ANIO;
            END IF;
            sTEMP := '29';
            --mtodo de la entrevista - familiar - visita  
            vSENTENCIA := 'SELECT COUNT(*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ( ';
            vSENTENCIA := vSENTENCIA || 'SELECT NUMC ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W02T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND FORMFAM = ''2'' ';
            --AND INDFAM = 'S' AND RESFAM = '00'
            vSENTENCIA := vSENTENCIA || 'GROUP BY NUMC)';            
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO T_CON_FAM_VISITA USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO T_CON_FAM_VISITA USING OP_ANIO;
            END IF;
            sTEMP := '30';
            --mtodo de la entrevista - familiar - web  
            vSENTENCIA := 'SELECT COUNT(*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ( ';
            vSENTENCIA := vSENTENCIA || 'SELECT NUMC ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W02T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND FORMFAM = ''3'' ';
            --AND INDFAM = 'S' AND RESFAM = '00'
            vSENTENCIA := vSENTENCIA || 'GROUP BY NUMC)';           
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO T_CON_FAM_WEB USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO T_CON_FAM_WEB USING OP_ANIO;
            END IF;
            sTEMP := '31';
            --mtodo de la entrevista - familiar - otro
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ( ';
            vSENTENCIA := vSENTENCIA || 'SELECT A.NUMC ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W02T00 A ';
            vSENTENCIA := vSENTENCIA || 'JOIN ' || vALIAS || 'W01T00 B ON A.NUMC = B.NUMC ';
            vSENTENCIA := vSENTENCIA || 'WHERE A.AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND A.TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND NVL(A.FORMFAM, '' '') = '' '' ';      
            --AND INDFAM = 'S' AND RESFAM = '00'
            vSENTENCIA := vSENTENCIA || 'AND B.AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND   B.TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND   B.RESULT = ''00'' ';
            vSENTENCIA := vSENTENCIA || 'GROUP BY A.NUMC)';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO T_CON_FAM_OTRO USING OP_ANIO, TRIMESTRE, OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO T_CON_FAM_OTRO USING OP_ANIO;
            END IF;
            sTEMP := '32';
            --mtodo de la entrevista - individual - telfono  
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W02T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND  TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND  FORMPER = ''1''';
            --AND INDPER = 'S' AND RESPER = '00';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO T_CON_PER_TELEFONO USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO T_CON_PER_TELEFONO USING OP_ANIO;
            END IF;
            sTEMP := '33';
            --mtodo de la entrevista - individual - visita  
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W02T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND  TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND  FORMPER = ''2''';
            --AND INDPER = 'S' AND RESPER = '00';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO T_CON_PER_VISITA USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO T_CON_PER_VISITA USING OP_ANIO;
            END IF;
            sTEMP := '34';
            --mtodo de la entrevista - individual - web  
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W02T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND  TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND  FORMPER = ''3''';
            --AND INDPER = 'S' AND RESPER = '00';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO T_CON_PER_WEB USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO T_CON_PER_WEB USING OP_ANIO;
            END IF;
            sTEMP := '35';
            --mtodo de la entrevista - individual - otro
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W02T00 A ';
            vSENTENCIA := vSENTENCIA || 'JOIN ' || vALIAS || 'W01T00 B ON A.NUMC = B.NUMC ';
            vSENTENCIA := vSENTENCIA || 'WHERE A.AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND A.TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND NVL(A.FORMPER, '' '') = '' '' ';
            --AND INDPER = 'S' AND RESPER = '00'
            vSENTENCIA := vSENTENCIA || 'AND B.AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND   B.TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND   B.RESULT = ''00''';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO T_CON_PER_OTRO USING OP_ANIO, TRIMESTRE,OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO T_CON_PER_OTRO USING OP_ANIO;
            END IF;
            sTEMP := '36';
            
            --resultado del cuestionario - familiar - pendiente de rellenar  
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ( ';
            vSENTENCIA := vSENTENCIA || 'SELECT NUMC ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W02T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND RESFAM = ''0'' ';
            vSENTENCIA := vSENTENCIA || 'GROUP BY NUMC)';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO R_CUE_FAM_PENDIENTE USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO R_CUE_FAM_PENDIENTE USING OP_ANIO;
            END IF;
            sTEMP := '37';
            --resultado del cuestionario - familiar - completo  
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ( ';
            vSENTENCIA := vSENTENCIA || 'SELECT NUMC ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W02T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND RESFAM = ''00'' ';
            vSENTENCIA := vSENTENCIA || 'GROUP BY NUMC)';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO R_CUE_FAM_COMPLETO USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO R_CUE_FAM_COMPLETO USING OP_ANIO;
            END IF;
            sTEMP := '38';
            --resultado del cuestionario - familiar - negativa  
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ( ';
            vSENTENCIA := vSENTENCIA || 'SELECT NUMC ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W02T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND RESFAM = ''11'' ';
            vSENTENCIA := vSENTENCIA || 'GROUP BY NUMC)';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO R_CUE_FAM_NEGATIVA USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO R_CUE_FAM_NEGATIVA USING OP_ANIO;
            END IF; 
            sTEMP := '39';
            --resultado del cuestionario - familiar - vacaciones  
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ( ';
            vSENTENCIA := vSENTENCIA || 'SELECT NUMC ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W02T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND RESFAM = ''12'' ';
            vSENTENCIA := vSENTENCIA || 'GROUP BY NUMC)';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO R_CUE_FAM_VACACIONES USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO R_CUE_FAM_VACACIONES USING OP_ANIO;
            END IF; 
            sTEMP := '40';
            --resultado del cuestionario - familiar - ausencia prolongada  
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ( ';
            vSENTENCIA := vSENTENCIA || 'SELECT NUMC ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W02T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND RESFAM = ''13'' ';
            vSENTENCIA := vSENTENCIA || 'GROUP BY NUMC)';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO R_CUE_FAM_AUSENCIA USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO R_CUE_FAM_AUSENCIA USING OP_ANIO;
            END IF; 
            sTEMP := '41';
            --resultado del cuestionario - familiar - recuperacin titular  
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ( ';
            vSENTENCIA := vSENTENCIA || 'SELECT NUMC ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W02T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND RESFAM = ''15'' ';
            vSENTENCIA := vSENTENCIA || 'GROUP BY NUMC)';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO R_CUE_FAM_RECUP_TITU USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO R_CUE_FAM_RECUP_TITU USING OP_ANIO;
            END IF;
            sTEMP := '42';
            --resultado del cuestionario - familiar - otras incidencias  
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ( ';
            vSENTENCIA := vSENTENCIA || 'SELECT NUMC ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W02T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND RESFAM = ''19'' ';
            vSENTENCIA := vSENTENCIA || 'GROUP BY NUMC)';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO R_CUE_FAM_OTRAS USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO R_CUE_FAM_OTRAS USING OP_ANIO;
            END IF;
            sTEMP := '43';
            --resultado del cuestionario - familiar - incompleto  
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ( ';
            vSENTENCIA := vSENTENCIA || 'SELECT NUMC ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W02T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND RESFAM = ''99'' ';
            vSENTENCIA := vSENTENCIA || 'GROUP BY NUMC)';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO R_CUE_FAM_INCOMPLETO USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO R_CUE_FAM_INCOMPLETO USING OP_ANIO;
            END IF; 
            sTEMP := '44';
            
            --resultado del cuestionario - individual - pendiente de rellenar  
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W02T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND   TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND   RESPER = ''0''';                          
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO R_CUE_PER_PENDIENTE USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO R_CUE_PER_PENDIENTE USING OP_ANIO;
            END IF; 
            sTEMP := '45';
            --resultado del cuestionario - individual - completo  
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W02T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND   TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND   RESPER = ''00''';                      
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO R_CUE_PER_COMPLETO USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO R_CUE_PER_COMPLETO USING OP_ANIO;
            END IF; 
            sTEMP := '46';
            --resultado del cuestionario - individual - negativa  
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W02T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND   TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND   RESPER = ''11''';                      
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO R_CUE_PER_NEGATIVA USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO R_CUE_PER_NEGATIVA USING OP_ANIO;
            END IF; 
            sTEMP := '47';
            --resultado del cuestionario - individual - vacaciones  
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W02T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND   TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND   RESPER = ''12''';                      
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO R_CUE_PER_VACACIONES USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO R_CUE_PER_VACACIONES USING OP_ANIO;
            END IF; 
            sTEMP := '48';
            --resultado del cuestionario - individual - ausencia prolongada  
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W02T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND   TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND   RESPER = ''13''';               
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO R_CUE_PER_AUSENCIA USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO R_CUE_PER_AUSENCIA USING OP_ANIO;
            END IF; 
            sTEMP := '49';
            --resultado del cuestionario - individual - recuperacin titular  
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W02T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND   TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND   RESPER = ''15''';    
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO R_CUE_PER_RECUP_TITU USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO R_CUE_PER_RECUP_TITU USING OP_ANIO;
            END IF; 
            sTEMP := '50';
            --resultado del cuestionario - individual - otras incidencias  
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W02T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND   TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND   RESPER = ''19''';    
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO R_CUE_PER_OTRAS USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO R_CUE_PER_OTRAS USING OP_ANIO;
            END IF; 
            sTEMP := '51';
            --resultado del cuestionario - individual - incompleto  
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W02T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND   TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND   RESPER = ''99''';    
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO R_CUE_PER_INCOMPLETO USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO R_CUE_PER_INCOMPLETO USING OP_ANIO;
            END IF; 
            sTEMP := '52';

            --total de la muestra
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W01T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND   TENC = :TRIMESTRE'; END IF;
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO TOTAL_MUESTRA USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO TOTAL_MUESTRA USING OP_ANIO;
            END IF; 
            sTEMP := '53';
            vSENTENCIA := 'SELECT COUNT (*) ';
            vSENTENCIA := vSENTENCIA || 'FROM ' || vALIAS || 'W02T00 ';
            vSENTENCIA := vSENTENCIA || 'WHERE AENC = :OP_ANIO ';
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || 'AND   TENC = :TRIMESTRE '; END IF;
            vSENTENCIA := vSENTENCIA || 'AND   EDAD > 15';
            IF bTRIMESTRAL THEN 
                EXECUTE IMMEDIATE vSENTENCIA INTO TOTAL_MUESTRA_MAS15 USING OP_ANIO, TRIMESTRE;
            ELSE
                EXECUTE IMMEDIATE vSENTENCIA INTO TOTAL_MUESTRA_MAS15 USING OP_ANIO;
            END IF; 
            sTEMP := '54';
              
            --Encuestas supervisadas
            vSENTENCIA := ' SELECT COUNT(*) ';
            vSENTENCIA := vSENTENCIA || ' FROM ' || vALIAS || 'W01T00 ';
            vSENTENCIA := vSENTENCIA || ' JOIN ' || vALIAS || 'W11T00 ON ' || vALIAS || 'W11T00.NUMC = ' || vALIAS || 'W01T00.NUMC '; 
            vSENTENCIA := vSENTENCIA || ' AND ' || vALIAS || 'W11T00.AENC = ' || vALIAS || 'W01T00.AENC '; 
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || ' AND ' || vALIAS || 'W11T00.TENC = ' || vALIAS || 'W01T00.TENC '; END IF;
            vSENTENCIA := vSENTENCIA || ' WHERE ' || vALIAS || 'W01T00.AENC = '||OP_ANIO; 
            IF bTRIMESTRAL THEN vSENTENCIA := vSENTENCIA || ' AND ' || vALIAS || 'W01T00.TENC = '||TRIMESTRE; END IF;
            
            IF INSPECTOR IS NOT NULL THEN
                vSENTENCIA := vSENTENCIA || ' AND ' || vALIAS || 'W11T00.AGENTE IN (' || INSPECTOR || ') ';            
            END IF;

            EXECUTE IMMEDIATE vSENTENCIA INTO ENC_SUPERVISADAS;       
            sTEMP := '55';
       ELSE
        NULL;
        sTEMP := '99';
       END IF;                        
        
    EXCEPTION
        WHEN OTHERS THEN
            CODERROR := SQLCODE;
            MENSAJERROR := sTEMP||' '||SQLERRM||' '||vSENTENCIA;
    END GED_REC_INDICADORES;
    
    ---------------------------------------------------------------------------------------------------------------------------------
    
    PROCEDURE GED_REC_INDICADORES_INFCAE 
                                  (IDIOMA               IN     VARCHAR2 DEFAULT 'C',                                   
                                   OP_ANIO              IN     NUMBER,
                                   TRIMESTRE            IN     NUMBER,
                                   OP_OPERACION         IN     VARCHAR2,
                                   OP_SUBOPERACION      IN     VARCHAR2,
                                   R_L_HABITABLE_A             OUT NUMBER,
                                   R_L_VACIA_A        OUT NUMBER,
                                   R_L_TEMPORAL_A            OUT NUMBER,
                                   R_L_REFORMA_A             OUT NUMBER,
                                   R_L_RUINOSA_A              OUT NUMBER,
                                   R_L_CONSTRUCCION_A              OUT NUMBER,
                                   R_L_OTROS_FINES_A           OUT NUMBER,
                                   R_L_INACCESIBLE_A           OUT NUMBER,
                                   R_L_ILOCALIZADA_A           OUT NUMBER,
                                   R_L_NOCLASIFICABLE_A           OUT NUMBER,
                                   R_L_EXCLUIDA_A           OUT NUMBER,
                                   R_L_DESAPARECIDA_A           OUT NUMBER,
                                   R_L_HABITABLE_B             OUT NUMBER,
                                   R_L_VACIA_B        OUT NUMBER,
                                   R_L_TEMPORAL_B            OUT NUMBER,
                                   R_L_REFORMA_B             OUT NUMBER,
                                   R_L_RUINOSA_B              OUT NUMBER,
                                   R_L_CONSTRUCCION_B              OUT NUMBER,
                                   R_L_OTROS_FINES_B           OUT NUMBER,
                                   R_L_INACCESIBLE_B           OUT NUMBER,
                                   R_L_ILOCALIZADA_B           OUT NUMBER,
                                   R_L_NOCLASIFICABLE_B           OUT NUMBER,
                                   R_L_EXCLUIDA_B           OUT NUMBER,
                                   R_L_DESAPARECIDA_B           OUT NUMBER,
                                   R_L_HABITABLE_G             OUT NUMBER,
                                   R_L_VACIA_G        OUT NUMBER,
                                   R_L_TEMPORAL_G            OUT NUMBER,
                                   R_L_REFORMA_G             OUT NUMBER,
                                   R_L_RUINOSA_G              OUT NUMBER,
                                   R_L_CONSTRUCCION_G              OUT NUMBER,
                                   R_L_OTROS_FINES_G           OUT NUMBER,
                                   R_L_INACCESIBLE_G           OUT NUMBER,
                                   R_L_ILOCALIZADA_G           OUT NUMBER,
                                   R_L_NOCLASIFICABLE_G           OUT NUMBER,
                                   R_L_EXCLUIDA_G           OUT NUMBER,                               
                                   R_L_DESAPARECIDA_G           OUT NUMBER,
                                   
                                   T_CON_FAM_VISITA_A        OUT NUMBER,
                                   T_CON_FAM_TELEFONO_A      OUT NUMBER,
                                   T_CON_FAM_WEB_A           OUT NUMBER,
                                   T_CON_FAM_OTRO_A           OUT NUMBER,
                                   T_CON_FAM_VISITA_B        OUT NUMBER,
                                   T_CON_FAM_TELEFONO_B      OUT NUMBER,
                                   T_CON_FAM_WEB_B           OUT NUMBER,
                                   T_CON_FAM_OTRO_B           OUT NUMBER,
                                   T_CON_FAM_VISITA_G        OUT NUMBER,
                                   T_CON_FAM_TELEFONO_G      OUT NUMBER,
                                   T_CON_FAM_WEB_G           OUT NUMBER,
                                   T_CON_FAM_OTRO_G           OUT NUMBER,
                                   
                                   T_CON_PER_VISITA_A        OUT NUMBER,
                                   T_CON_PER_TELEFONO_A      OUT NUMBER,
                                   T_CON_PER_WEB_A           OUT NUMBER,
                                   T_CON_PER_OTRO_A           OUT NUMBER,
                                   T_CON_PER_VISITA_B        OUT NUMBER,
                                   T_CON_PER_TELEFONO_B      OUT NUMBER,
                                   T_CON_PER_WEB_B           OUT NUMBER,
                                   T_CON_PER_OTRO_B           OUT NUMBER,
                                   T_CON_PER_VISITA_G        OUT NUMBER,
                                   T_CON_PER_TELEFONO_G      OUT NUMBER,
                                   T_CON_PER_WEB_G           OUT NUMBER,
                                   T_CON_PER_OTRO_G           OUT NUMBER,
                                   
                                   R_CUE_FAM_PENDIENTE_A    OUT NUMBER,
                                   R_CUE_FAM_COMPLETO_A     OUT NUMBER,
                                   R_CUE_FAM_INCOMPLETO_A   OUT NUMBER,
                                   R_CUE_FAM_RESTO_A    OUT NUMBER,
                                   R_CUE_FAM_PENDIENTE_B    OUT NUMBER,
                                   R_CUE_FAM_COMPLETO_B     OUT NUMBER,
                                   R_CUE_FAM_INCOMPLETO_B   OUT NUMBER,
                                   R_CUE_FAM_RESTO_B    OUT NUMBER,
                                   R_CUE_FAM_PENDIENTE_G    OUT NUMBER,
                                   R_CUE_FAM_COMPLETO_G     OUT NUMBER,
                                   R_CUE_FAM_INCOMPLETO_G   OUT NUMBER,
                                   R_CUE_FAM_RESTO_G    OUT NUMBER,
                                   
                                   R_CUE_PER_PENDIENTE_A    OUT NUMBER,
                                   R_CUE_PER_COMPLETO_A     OUT NUMBER,
                                   R_CUE_PER_INCOMPLETO_A   OUT NUMBER,
                                   R_CUE_PER_RESTO_A    OUT NUMBER,
                                   R_CUE_PER_PENDIENTE_B    OUT NUMBER,
                                   R_CUE_PER_COMPLETO_B     OUT NUMBER,
                                   R_CUE_PER_INCOMPLETO_B   OUT NUMBER,
                                   R_CUE_PER_RESTO_B    OUT NUMBER,
                                   R_CUE_PER_PENDIENTE_G    OUT NUMBER,
                                   R_CUE_PER_COMPLETO_G     OUT NUMBER,
                                   R_CUE_PER_INCOMPLETO_G   OUT NUMBER,
                                   R_CUE_PER_RESTO_G    OUT NUMBER,
                                   
                                   TOTAL_MUESTRA_A           OUT NUMBER,
                                   TOTAL_MUESTRA_B           OUT NUMBER,
                                   TOTAL_MUESTRA_G           OUT NUMBER,
                                   CODERROR                OUT NUMBER,
                                   MENSAJERROR             OUT VARCHAR2)
    IS
        /*
        Funcin: GED_REC_INDICADORES_INFCAE
        Autor:   SERIKAT
        Fecha Creacin: 22/02/2016
        Ultima Modificacin:
        Descripcin: Devuelve los datos para mostrar el informe de la CAE desglosado por provincias
        */


        nCONT                  NUMBER;
        vSENTENCIA             VARCHAR2 (32767);

        sTEMP                  VARCHAR2 (50);
        sCOND                  VARCHAR2 (100);
        bNULO                  BOOLEAN;
        I                      NUMBER;
        
        NTEMP                  NUMBER;

       
    BEGIN
        CODERROR := 0;
        MENSAJERROR := ' ';

       R_L_HABITABLE_A        := 0;
       R_L_VACIA_A            := 0;
       R_L_TEMPORAL_A         := 0;
       R_L_REFORMA_A          := 0;
       R_L_RUINOSA_A          := 0;
       R_L_CONSTRUCCION_A     := 0;
       R_L_OTROS_FINES_A      := 0;
       R_L_INACCESIBLE_A      := 0;
       R_L_ILOCALIZADA_A      := 0;
       R_L_NOCLASIFICABLE_A   := 0;
       R_L_EXCLUIDA_A         := 0;
       R_L_DESAPARECIDA_A         := 0;
       
       R_L_HABITABLE_B        := 0;
       R_L_VACIA_B            := 0;
       R_L_TEMPORAL_B         := 0;
       R_L_REFORMA_B          := 0;
       R_L_RUINOSA_B          := 0;
       R_L_CONSTRUCCION_B     := 0;
       R_L_OTROS_FINES_B      := 0;
       R_L_INACCESIBLE_B      := 0;
       R_L_ILOCALIZADA_B      := 0;
       R_L_NOCLASIFICABLE_B   := 0;
       R_L_EXCLUIDA_B         := 0;
       R_L_DESAPARECIDA_B         := 0;
       
       R_L_HABITABLE_G        := 0;
       R_L_VACIA_G            := 0;
       R_L_TEMPORAL_G         := 0;
       R_L_REFORMA_G          := 0;
       R_L_RUINOSA_G          := 0;
       R_L_CONSTRUCCION_G     := 0;
       R_L_OTROS_FINES_G      := 0;
       R_L_INACCESIBLE_G      := 0;
       R_L_ILOCALIZADA_G      := 0;
       R_L_NOCLASIFICABLE_G   := 0;
       R_L_EXCLUIDA_G         := 0;
       R_L_DESAPARECIDA_G         := 0;
                                                               
       T_CON_FAM_VISITA_A     := 0;
       T_CON_FAM_TELEFONO_A   := 0;
       T_CON_FAM_WEB_A        := 0;
       T_CON_FAM_OTRO_A        := 0;
       
       T_CON_FAM_VISITA_B     := 0;
       T_CON_FAM_TELEFONO_B   := 0;
       T_CON_FAM_WEB_B        := 0;
       T_CON_FAM_OTRO_B        := 0;
       
       T_CON_FAM_VISITA_G     := 0;
       T_CON_FAM_TELEFONO_G   := 0;
       T_CON_FAM_WEB_G        := 0;
       T_CON_FAM_OTRO_G        := 0;
                                   
       T_CON_PER_VISITA_A     := 0;
       T_CON_PER_TELEFONO_A   := 0;
       T_CON_PER_WEB_A        := 0;
       T_CON_PER_OTRO_A        := 0;
       
       T_CON_PER_VISITA_B     := 0;
       T_CON_PER_TELEFONO_B   := 0;
       T_CON_PER_WEB_B        := 0;
       T_CON_PER_OTRO_B        := 0;
       
       T_CON_PER_VISITA_G     := 0;
       T_CON_PER_TELEFONO_G   := 0;
       T_CON_PER_WEB_G        := 0;
       T_CON_PER_OTRO_G        := 0;
       
       R_CUE_FAM_PENDIENTE_A    := 0;
       R_CUE_FAM_COMPLETO_A     := 0;
       R_CUE_FAM_INCOMPLETO_A   := 0;
       R_CUE_FAM_RESTO_A    := 0;
       
       R_CUE_FAM_PENDIENTE_B    := 0;
       R_CUE_FAM_COMPLETO_B     := 0;
       R_CUE_FAM_INCOMPLETO_B   := 0;
       R_CUE_FAM_RESTO_B    := 0;
       
       R_CUE_FAM_PENDIENTE_G    := 0;
       R_CUE_FAM_COMPLETO_G     := 0;
       R_CUE_FAM_INCOMPLETO_G   := 0;
       R_CUE_FAM_RESTO_G    := 0;
       
       R_CUE_PER_PENDIENTE_A    := 0;
       R_CUE_PER_COMPLETO_A     := 0;
       R_CUE_PER_INCOMPLETO_A   := 0;
       R_CUE_PER_RESTO_A    := 0;
       
       R_CUE_PER_PENDIENTE_B    := 0;
       R_CUE_PER_COMPLETO_B     := 0;
       R_CUE_PER_INCOMPLETO_B   := 0;
       R_CUE_PER_RESTO_B    := 0;
       
       R_CUE_PER_PENDIENTE_G    := 0;
       R_CUE_PER_COMPLETO_G     := 0;
       R_CUE_PER_INCOMPLETO_G   := 0;
       R_CUE_PER_RESTO_G    := 0;
                                   
       TOTAL_MUESTRA_A        := 0;
       TOTAL_MUESTRA_B        := 0;
       TOTAL_MUESTRA_G        := 0;
       
       IF OP_OPERACION = '050403' THEN

        
            --Resultado de la Localizacin - localizada habitable
            SELECT COUNT (*)
              INTO R_L_HABITABLE_A
              FROM PRAW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '00'
             AND   TERH = '01';
             
            SELECT COUNT (*)
              INTO R_L_HABITABLE_B
              FROM PRAW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '00'
             AND   TERH = '48';
             
            SELECT COUNT (*)
              INTO R_L_HABITABLE_G
              FROM PRAW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '00'
             AND   TERH = '20';

            --Resultado de la Localizacin - localizada deshabitada
            SELECT COUNT (*)
              INTO R_L_VACIA_A
              FROM PRAW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '10'
             AND   TERH = '01';
             
            SELECT COUNT (*)
              INTO R_L_VACIA_B
              FROM PRAW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '10'
             AND   TERH = '48';
             
            SELECT COUNT (*)
              INTO R_L_VACIA_G
              FROM PRAW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '10'
             AND   TERH = '20';

            --Resultado de la Localizacin - localizada vivienda temporal
            SELECT COUNT (*)
              INTO R_L_TEMPORAL_A
              FROM PRAW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '08'
             AND   TERH = '01';
             
            SELECT COUNT (*)
              INTO R_L_TEMPORAL_B
              FROM PRAW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '08'
             AND   TERH = '48';
             
            SELECT COUNT (*)
              INTO R_L_TEMPORAL_G
              FROM PRAW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '08'
             AND   TERH = '20';

            --Resultado de la Localizacin - en reforma
            SELECT COUNT (*)
              INTO R_L_REFORMA_A
              FROM PRAW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '04'
             AND   TERH = '01';
             
            SELECT COUNT (*)
              INTO R_L_REFORMA_B
              FROM PRAW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '04'
             AND   TERH = '48';
             
            SELECT COUNT (*)
              INTO R_L_REFORMA_G
              FROM PRAW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '04'
             AND   TERH = '20';

            --Resultado de la Localizacin - ruinosa
            SELECT COUNT (*)
              INTO R_L_RUINOSA_A
              FROM PRAW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '05'
             AND   TERH = '01';
             
            SELECT COUNT (*)
              INTO R_L_RUINOSA_B
              FROM PRAW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '05'
             AND   TERH = '48';
             
            SELECT COUNT (*)
              INTO R_L_RUINOSA_G
              FROM PRAW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '05'
             AND   TERH = '20';
             
             --Resultado de la Localizacin - construccin
            SELECT COUNT (*)
              INTO R_L_CONSTRUCCION_A
              FROM PRAW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '06'
             AND   TERH = '01';
             
            SELECT COUNT (*)
              INTO R_L_CONSTRUCCION_B
              FROM PRAW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '06'
             AND   TERH = '48';
             
            SELECT COUNT (*)
              INTO R_L_CONSTRUCCION_G
              FROM PRAW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '06'
             AND   TERH = '20';

            --Resultado de la Localizacin - otros fines
            SELECT COUNT (*)
              INTO R_L_OTROS_FINES_A
              FROM PRAW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '09'
             AND   TERH = '01';
             
             SELECT COUNT (*)
              INTO R_L_OTROS_FINES_B
              FROM PRAW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '09'
             AND   TERH = '48';
             
            SELECT COUNT (*)
              INTO R_L_OTROS_FINES_G
              FROM PRAW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '09'
             AND   TERH = '20';

            --Resultado de la Localizacin - inaccesible
            SELECT COUNT (*)
              INTO R_L_INACCESIBLE_A
              FROM PRAW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '07'
             AND   TERH = '01';
             
            SELECT COUNT (*)
              INTO R_L_INACCESIBLE_B
              FROM PRAW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '07'
             AND   TERH = '48';
             
            SELECT COUNT (*)
              INTO R_L_INACCESIBLE_G
              FROM PRAW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '07'
             AND   TERH = '20';
            
            --Resultado de la Localizacin - ilocalizada
            SELECT COUNT (*)
              INTO R_L_ILOCALIZADA_A
              FROM PRAW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '01'
             AND   TERH = '01';
             
            SELECT COUNT (*)
              INTO R_L_ILOCALIZADA_B
              FROM PRAW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '01'
             AND   TERH = '48';
             
            SELECT COUNT (*)
              INTO R_L_ILOCALIZADA_G
              FROM PRAW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '01'
             AND   TERH = '20';
            
            --Resultado de la Localizacin - no calificable
            SELECT COUNT (*)
              INTO R_L_NOCLASIFICABLE_A
              FROM PRAW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '20'
             AND   TERH = '01';
             
            SELECT COUNT (*)
              INTO R_L_NOCLASIFICABLE_B
              FROM PRAW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '20'
             AND   TERH = '48';
             
            SELECT COUNT (*)
              INTO R_L_NOCLASIFICABLE_G
              FROM PRAW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '20'
             AND   TERH = '20';
            
            --Resultado de la Localizacin - excluida
            SELECT COUNT (*)
              INTO R_L_EXCLUIDA_A
              FROM PRAW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '55'
             AND   TERH = '01';
             
            SELECT COUNT (*)
              INTO R_L_EXCLUIDA_B
              FROM PRAW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '55'
             AND   TERH = '48';
             
            SELECT COUNT (*)
              INTO R_L_EXCLUIDA_G
              FROM PRAW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '55'
             AND   TERH = '20';
             
             --Resultado de la Localizacin - DESAPARECIDA
            SELECT COUNT (*)
              INTO R_L_DESAPARECIDA_A
              FROM PRAW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '03'
             AND   TERH = '01';
             
            SELECT COUNT (*)
              INTO R_L_DESAPARECIDA_B
              FROM PRAW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '03'
             AND   TERH = '48';
             
            SELECT COUNT (*)
              INTO R_L_DESAPARECIDA_G
              FROM PRAW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '03'
             AND   TERH = '20';

     
            
            --mtodo de la entrevista - familiar - telfono                                  
            SELECT COUNT(*)
                INTO T_CON_FAM_TELEFONO_A
                FROM (
                    SELECT A.NUMC              
                     FROM PRAW02T00 A
                     JOIN PRAW01T00 ON PRAW01T00.NUMC = A.NUMC  
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND PRAW01T00.AENC = OP_ANIO
                      AND PRAW01T00.TENC = TRIMESTRE
                      AND FORMFAM = '1'
                      --AND INDFAM = 'S' AND RESFAM = '00'
                      AND   TERH = '01'
                    GROUP BY A.NUMC);
            
            SELECT COUNT(*)
                INTO T_CON_FAM_TELEFONO_B
                FROM (
                    SELECT A.NUMC              
                     FROM PRAW02T00 A
                     JOIN PRAW01T00 ON PRAW01T00.NUMC = A.NUMC  
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND PRAW01T00.AENC = OP_ANIO
                      AND PRAW01T00.TENC = TRIMESTRE
                      AND FORMFAM = '1'
                      --AND INDFAM = 'S' AND RESFAM = '00'
                      AND   TERH = '48'
                    GROUP BY A.NUMC);
                    
            SELECT COUNT(*)
                INTO T_CON_FAM_TELEFONO_G
                FROM (
                    SELECT A.NUMC              
                     FROM PRAW02T00 A
                     JOIN PRAW01T00 ON PRAW01T00.NUMC = A.NUMC  
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND PRAW01T00.AENC = OP_ANIO
                      AND PRAW01T00.TENC = TRIMESTRE
                      AND FORMFAM = '1'
                      --AND INDFAM = 'S' AND RESFAM = '00'
                      AND   TERH = '20'
                    GROUP BY A.NUMC);                    
            
            --mtodo de la entrevista - familiar - visita  
            SELECT COUNT(*)
                INTO T_CON_FAM_VISITA_A
                FROM (
                    SELECT A.NUMC              
                     FROM PRAW02T00 A
                     JOIN PRAW01T00 ON PRAW01T00.NUMC = A.NUMC  
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND PRAW01T00.AENC = OP_ANIO
                      AND PRAW01T00.TENC = TRIMESTRE
                      AND FORMFAM = '2'
                      --AND INDFAM = 'S' AND RESFAM = '00'
                      AND   TERH = '01'
                    GROUP BY A.NUMC);
            
            SELECT COUNT(*)
                INTO T_CON_FAM_VISITA_B
                FROM (
                    SELECT A.NUMC              
                     FROM PRAW02T00 A
                     JOIN PRAW01T00 ON PRAW01T00.NUMC = A.NUMC  
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND PRAW01T00.AENC = OP_ANIO
                      AND PRAW01T00.TENC = TRIMESTRE
                      AND FORMFAM = '2'
                      --AND INDFAM = 'S' AND RESFAM = '00'
                      AND   TERH = '48'
                    GROUP BY A.NUMC);
                    
            SELECT COUNT(*)
                INTO T_CON_FAM_VISITA_G
                FROM (
                    SELECT A.NUMC              
                     FROM PRAW02T00 A
                     JOIN PRAW01T00 ON PRAW01T00.NUMC = A.NUMC  
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND PRAW01T00.AENC = OP_ANIO
                      AND PRAW01T00.TENC = TRIMESTRE
                      AND FORMFAM = '2'
                      --AND INDFAM = 'S' AND RESFAM = '00'
                      AND   TERH = '20'
                    GROUP BY A.NUMC);
            
            --mtodo de la entrevista - familiar - web  
            SELECT COUNT(*)
                INTO T_CON_FAM_WEB_A
                FROM (
                    SELECT A.NUMC              
                     FROM PRAW02T00 A
                     JOIN PRAW01T00 ON PRAW01T00.NUMC = A.NUMC  
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND PRAW01T00.AENC = OP_ANIO
                      AND PRAW01T00.TENC = TRIMESTRE
                      AND FORMFAM = '3'
                      --AND INDFAM = 'S' AND RESFAM = '00'
                      AND   TERH = '01'
                    GROUP BY A.NUMC);
            
            SELECT COUNT(*)
                INTO T_CON_FAM_WEB_B
                FROM (
                    SELECT A.NUMC              
                     FROM PRAW02T00 A
                     JOIN PRAW01T00 ON PRAW01T00.NUMC = A.NUMC  
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND PRAW01T00.AENC = OP_ANIO
                      AND PRAW01T00.TENC = TRIMESTRE
                      AND FORMFAM = '3'
                      --AND INDFAM = 'S' AND RESFAM = '00'
                      AND   TERH = '48'
                    GROUP BY A.NUMC);
                    
            SELECT COUNT(*)
                INTO T_CON_FAM_WEB_G
                FROM (
                    SELECT A.NUMC              
                     FROM PRAW02T00 A
                     JOIN PRAW01T00 ON PRAW01T00.NUMC = A.NUMC  
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND PRAW01T00.AENC = OP_ANIO
                      AND PRAW01T00.TENC = TRIMESTRE
                      AND FORMFAM = '3'
                      --AND INDFAM = 'S' AND RESFAM = '00'
                      AND   TERH = '20'
                    GROUP BY A.NUMC);
            
            --mtodo de la entrevista - familiar - otro
            SELECT COUNT (*)
              INTO T_CON_FAM_OTRO_A
                  FROM (                      
                    SELECT A.NUMC              
                     FROM PRAW02T00 A
                     JOIN PRAW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND NVL(A.FORMFAM, ' ') = ' '      
                      --AND INDFAM = 'S' AND RESFAM = '00'
                      AND B.AENC = OP_ANIO
                      AND   B.TENC = TRIMESTRE
                      AND   B.RESULT = '00'    
                      AND   TERH = '01'           
                    GROUP BY A.NUMC);
            
            SELECT COUNT (*)
              INTO T_CON_FAM_OTRO_B
                  FROM (                      
                    SELECT A.NUMC              
                     FROM PRAW02T00 A
                     JOIN PRAW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND NVL(A.FORMFAM, ' ') = ' '      
                      --AND INDFAM = 'S' AND RESFAM = '00'
                      AND B.AENC = OP_ANIO
                      AND   B.TENC = TRIMESTRE
                      AND   B.RESULT = '00'    
                      AND   TERH = '48'           
                    GROUP BY A.NUMC);
            
            SELECT COUNT (*)
              INTO T_CON_FAM_OTRO_G
                  FROM (                      
                    SELECT A.NUMC              
                     FROM PRAW02T00 A
                     JOIN PRAW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND NVL(A.FORMFAM, ' ') = ' '      
                      --AND INDFAM = 'S' AND RESFAM = '00'
                      AND B.AENC = OP_ANIO
                      AND   B.TENC = TRIMESTRE
                      AND   B.RESULT = '00'    
                      AND   TERH = '20'           
                    GROUP BY A.NUMC);
            
            --mtodo de la entrevista - individual - telfono  
            SELECT COUNT (*)
              INTO T_CON_PER_TELEFONO_A
              FROM PRAW02T00 A
              JOIN PRAW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
              AND  A.TENC = TRIMESTRE
              AND  B.AENC = OP_ANIO
              AND  B.TENC = TRIMESTRE
              AND  FORMPER = '1'
              AND  TERH = '01';
            
            SELECT COUNT (*)
              INTO T_CON_PER_TELEFONO_B
              FROM PRAW02T00 A
              JOIN PRAW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
              AND  A.TENC = TRIMESTRE
              AND  B.AENC = OP_ANIO
              AND  B.TENC = TRIMESTRE
              AND  FORMPER = '1'
              AND  TERH = '48';
            
            SELECT COUNT (*)
              INTO T_CON_PER_TELEFONO_G
              FROM PRAW02T00 A
              JOIN PRAW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
              AND  A.TENC = TRIMESTRE
              AND  B.AENC = OP_ANIO
              AND  B.TENC = TRIMESTRE
              AND  FORMPER = '1'
              AND  TERH = '20';
            
            --mtodo de la entrevista - individual - visita  
            SELECT COUNT (*)
              INTO T_CON_PER_TELEFONO_A
              FROM PRAW02T00 A
              JOIN PRAW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
              AND  A.TENC = TRIMESTRE
              AND  B.AENC = OP_ANIO
              AND  B.TENC = TRIMESTRE
              AND  FORMPER = '2'
              AND  TERH = '01';
            
            SELECT COUNT (*)
              INTO T_CON_PER_TELEFONO_B
              FROM PRAW02T00 A
              JOIN PRAW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
              AND  A.TENC = TRIMESTRE
              AND  B.AENC = OP_ANIO
              AND  B.TENC = TRIMESTRE
              AND  FORMPER = '2'
              AND  TERH = '48';
            
            SELECT COUNT (*)
              INTO T_CON_PER_TELEFONO_G
              FROM PRAW02T00 A
              JOIN PRAW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
              AND  A.TENC = TRIMESTRE
              AND  B.AENC = OP_ANIO
              AND  B.TENC = TRIMESTRE
              AND  FORMPER = '2'
              AND  TERH = '20';
            
            --mtodo de la entrevista - individual - web  
            SELECT COUNT (*)
              INTO T_CON_PER_TELEFONO_A
              FROM PRAW02T00 A
              JOIN PRAW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
              AND  A.TENC = TRIMESTRE
              AND  B.AENC = OP_ANIO
              AND  B.TENC = TRIMESTRE
              AND  FORMPER = '3'
              AND  TERH = '01';
            
            SELECT COUNT (*)
              INTO T_CON_PER_TELEFONO_B
              FROM PRAW02T00 A
              JOIN PRAW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
              AND  A.TENC = TRIMESTRE
              AND  B.AENC = OP_ANIO
              AND  B.TENC = TRIMESTRE
              AND  FORMPER = '3'
              AND  TERH = '48';
            
            SELECT COUNT (*)
              INTO T_CON_PER_TELEFONO_G
              FROM PRAW02T00 A
              JOIN PRAW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
              AND  A.TENC = TRIMESTRE
              AND  B.AENC = OP_ANIO
              AND  B.TENC = TRIMESTRE
              AND  FORMPER = '3'
              AND  TERH = '20';
            
            
            --mtodo de la entrevista - individual - otro
            SELECT COUNT (*)
              INTO T_CON_PER_OTRO_A
              FROM PRAW02T00 A
              JOIN PRAW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
              AND  A.TENC = TRIMESTRE
              AND  B.AENC = OP_ANIO
              AND  B.TENC = TRIMESTRE
              AND  NVL(A.FORMPER, ' ') = ' '
              AND  B.RESULT = '00' 
              AND  B.TERH = '01';
            
            SELECT COUNT (*)
              INTO T_CON_PER_OTRO_B
              FROM PRAW02T00 A
              JOIN PRAW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
              AND  A.TENC = TRIMESTRE
              AND  B.AENC = OP_ANIO
              AND  B.TENC = TRIMESTRE
              AND  NVL(A.FORMPER, ' ') = ' '
              AND  B.RESULT = '00'
              AND  B.TERH = '48';
            
            SELECT COUNT (*)
              INTO T_CON_PER_OTRO_G
              FROM PRAW02T00 A
              JOIN PRAW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
              AND  A.TENC = TRIMESTRE
              AND  B.AENC = OP_ANIO
              AND  B.TENC = TRIMESTRE
              AND  NVL(A.FORMPER, ' ') = ' '
              AND  B.RESULT = '00'
              AND  B.TERH = '20';            
            
            --resultado del cuestionario - familiar - pendiente de rellenar  
            SELECT COUNT (*)
              INTO R_CUE_FAM_PENDIENTE_A
              FROM (
                    SELECT A.NUMC              
                     FROM PRAW02T00 A
                     JOIN PRAW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND  B.AENC = OP_ANIO
                      AND  B.TENC = TRIMESTRE
                      AND A.RESFAM = '0'    
                      AND B.TERH = '01'         
                    GROUP BY A.NUMC);
                    
            SELECT COUNT (*)
              INTO R_CUE_FAM_PENDIENTE_B
              FROM (
                    SELECT A.NUMC              
                     FROM PRAW02T00 A
                     JOIN PRAW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND  B.AENC = OP_ANIO
                      AND  B.TENC = TRIMESTRE
                      AND A.RESFAM = '0'    
                      AND B.TERH = '48'         
                    GROUP BY A.NUMC);
            
            SELECT COUNT (*)
              INTO R_CUE_FAM_PENDIENTE_G
              FROM (
                    SELECT A.NUMC              
                     FROM PRAW02T00 A
                     JOIN PRAW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND  B.AENC = OP_ANIO
                      AND  B.TENC = TRIMESTRE
                      AND A.RESFAM = '0'    
                      AND B.TERH = '20'         
                    GROUP BY A.NUMC);
       
            --resultado del cuestionario - familiar - completo  
            SELECT COUNT (*)
              INTO R_CUE_FAM_COMPLETO_A
              FROM (
                    SELECT A.NUMC              
                     FROM PRAW02T00 A
                     JOIN PRAW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND  B.AENC = OP_ANIO
                      AND  B.TENC = TRIMESTRE
                      AND A.RESFAM = '00'
                      AND B.TERH = '01'             
                    GROUP BY A.NUMC);
            
            SELECT COUNT (*)
              INTO R_CUE_FAM_COMPLETO_B
              FROM (
                    SELECT A.NUMC              
                     FROM PRAW02T00 A
                     JOIN PRAW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND  B.AENC = OP_ANIO
                      AND  B.TENC = TRIMESTRE
                      AND A.RESFAM = '00'
                      AND B.TERH = '48'             
                    GROUP BY A.NUMC);
            
            SELECT COUNT (*)
              INTO R_CUE_FAM_COMPLETO_G
              FROM (
                    SELECT A.NUMC              
                     FROM PRAW02T00 A
                     JOIN PRAW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND  B.AENC = OP_ANIO
                      AND  B.TENC = TRIMESTRE
                      AND A.RESFAM = '00'
                      AND B.TERH = '20'             
                    GROUP BY A.NUMC);
            
            --resultado del cuestionario - familiar - incompleto  
            SELECT COUNT (*)
              INTO R_CUE_FAM_INCOMPLETO_A
              FROM (
                    SELECT A.NUMC              
                     FROM PRAW02T00 A
                     JOIN PRAW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND  B.AENC = OP_ANIO
                      AND  B.TENC = TRIMESTRE
                      AND A.RESFAM = '99'
                      AND B.TERH = '01'             
                    GROUP BY A.NUMC);
            
            SELECT COUNT (*)
              INTO R_CUE_FAM_INCOMPLETO_B
              FROM (
                    SELECT A.NUMC              
                     FROM PRAW02T00 A
                     JOIN PRAW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND  B.AENC = OP_ANIO
                      AND  B.TENC = TRIMESTRE
                      AND A.RESFAM = '99'
                      AND B.TERH = '48'             
                    GROUP BY A.NUMC);
            
            SELECT COUNT (*)
              INTO R_CUE_FAM_INCOMPLETO_G
              FROM (
                    SELECT A.NUMC              
                     FROM PRAW02T00 A
                     JOIN PRAW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND  B.AENC = OP_ANIO
                      AND  B.TENC = TRIMESTRE
                      AND A.RESFAM = '99'
                      AND B.TERH = '20'             
                    GROUP BY A.NUMC);
            
            --resultado del cuestionario - familiar - negativa  
            SELECT COUNT (*)
              INTO NTEMP
              FROM (
                    SELECT A.NUMC              
                     FROM PRAW02T00 A
                     JOIN PRAW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND  B.AENC = OP_ANIO
                      AND  B.TENC = TRIMESTRE
                      AND A.RESFAM = '11'
                      AND B.TERH = '01'             
                    GROUP BY A.NUMC);
            R_CUE_FAM_RESTO_A := R_CUE_FAM_RESTO_A + NTEMP;
            
            SELECT COUNT (*)
              INTO NTEMP
              FROM (
                    SELECT A.NUMC              
                     FROM PRAW02T00 A
                     JOIN PRAW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND  B.AENC = OP_ANIO
                      AND  B.TENC = TRIMESTRE
                      AND A.RESFAM = '11'
                      AND B.TERH = '48'             
                    GROUP BY A.NUMC);
            R_CUE_FAM_RESTO_B := R_CUE_FAM_RESTO_B + NTEMP;
            
            SELECT COUNT (*)
              INTO NTEMP
              FROM (
                    SELECT A.NUMC              
                     FROM PRAW02T00 A
                     JOIN PRAW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND  B.AENC = OP_ANIO
                      AND  B.TENC = TRIMESTRE
                      AND A.RESFAM = '11'
                      AND B.TERH = '20'             
                    GROUP BY A.NUMC);
            R_CUE_FAM_RESTO_G := R_CUE_FAM_RESTO_G + NTEMP;
            
            --resultado del cuestionario - familiar - vacaciones  
            SELECT COUNT (*)
              INTO NTEMP
              FROM (
                    SELECT A.NUMC              
                     FROM PRAW02T00 A
                     JOIN PRAW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND  B.AENC = OP_ANIO
                      AND  B.TENC = TRIMESTRE
                      AND A.RESFAM = '12'
                      AND B.TERH = '01'             
                    GROUP BY A.NUMC);
            R_CUE_FAM_RESTO_A := R_CUE_FAM_RESTO_A + NTEMP;
            
            SELECT COUNT (*)
              INTO NTEMP
              FROM (
                    SELECT A.NUMC              
                     FROM PRAW02T00 A
                     JOIN PRAW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND  B.AENC = OP_ANIO
                      AND  B.TENC = TRIMESTRE
                      AND A.RESFAM = '12'
                      AND B.TERH = '48'             
                    GROUP BY A.NUMC);
            R_CUE_FAM_RESTO_B := R_CUE_FAM_RESTO_B + NTEMP;
            
            SELECT COUNT (*)
              INTO NTEMP
              FROM (
                    SELECT A.NUMC              
                     FROM PRAW02T00 A
                     JOIN PRAW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND  B.AENC = OP_ANIO
                      AND  B.TENC = TRIMESTRE
                      AND A.RESFAM = '12'
                      AND B.TERH = '20'             
                    GROUP BY A.NUMC);
            R_CUE_FAM_RESTO_G := R_CUE_FAM_RESTO_G + NTEMP;
            
            --resultado del cuestionario - familiar - ausencia prolongada  
            SELECT COUNT (*)
              INTO NTEMP
              FROM (
                    SELECT A.NUMC              
                     FROM PRAW02T00 A
                     JOIN PRAW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND  B.AENC = OP_ANIO
                      AND  B.TENC = TRIMESTRE
                      AND A.RESFAM = '13'
                      AND B.TERH = '01'             
                    GROUP BY A.NUMC);
            R_CUE_FAM_RESTO_A := R_CUE_FAM_RESTO_A + NTEMP;
            
            SELECT COUNT (*)
              INTO NTEMP
              FROM (
                    SELECT A.NUMC              
                     FROM PRAW02T00 A
                     JOIN PRAW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND  B.AENC = OP_ANIO
                      AND  B.TENC = TRIMESTRE
                      AND A.RESFAM = '13'
                      AND B.TERH = '48'             
                    GROUP BY A.NUMC);
            R_CUE_FAM_RESTO_B := R_CUE_FAM_RESTO_B + NTEMP;
            
            SELECT COUNT (*)
              INTO NTEMP
              FROM (
                    SELECT A.NUMC              
                     FROM PRAW02T00 A
                     JOIN PRAW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND  B.AENC = OP_ANIO
                      AND  B.TENC = TRIMESTRE
                      AND A.RESFAM = '13'
                      AND B.TERH = '20'             
                    GROUP BY A.NUMC);
            R_CUE_FAM_RESTO_G := R_CUE_FAM_RESTO_G + NTEMP;
             
            --resultado del cuestionario - familiar - otras incidencias  
            SELECT COUNT (*)
              INTO NTEMP
              FROM (
                    SELECT A.NUMC              
                     FROM PRAW02T00 A
                     JOIN PRAW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND  B.AENC = OP_ANIO
                      AND  B.TENC = TRIMESTRE
                      AND A.RESFAM = '19'
                      AND B.TERH = '01'             
                    GROUP BY A.NUMC);
             R_CUE_FAM_RESTO_A := R_CUE_FAM_RESTO_A + NTEMP;
             
             SELECT COUNT (*)
              INTO NTEMP
              FROM (
                    SELECT A.NUMC              
                     FROM PRAW02T00 A
                     JOIN PRAW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND  B.AENC = OP_ANIO
                      AND  B.TENC = TRIMESTRE
                      AND A.RESFAM = '19'
                      AND B.TERH = '48'             
                    GROUP BY A.NUMC);
             R_CUE_FAM_RESTO_B := R_CUE_FAM_RESTO_B + NTEMP;
             
             SELECT COUNT (*)
              INTO NTEMP
              FROM (
                    SELECT A.NUMC              
                     FROM PRAW02T00 A
                     JOIN PRAW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND  B.AENC = OP_ANIO
                      AND  B.TENC = TRIMESTRE
                      AND A.RESFAM = '19'
                      AND B.TERH = '20'             
                    GROUP BY A.NUMC);
             R_CUE_FAM_RESTO_G := R_CUE_FAM_RESTO_G + NTEMP;
             
             --resultado del cuestionario - individual - pendiente de rellenar  
            SELECT COUNT (*)
              INTO R_CUE_PER_PENDIENTE_A
              FROM PRAW02T00 A
              JOIN PRAW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND  B.AENC = OP_ANIO
             AND  B.TENC = TRIMESTRE
             AND   A.RESPER = '0'
             AND   B.TERH = '01';
             
            SELECT COUNT (*)
              INTO R_CUE_PER_PENDIENTE_B
              FROM PRAW02T00 A
              JOIN PRAW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND  B.AENC = OP_ANIO
             AND  B.TENC = TRIMESTRE
             AND   A.RESPER = '0'
             AND   B.TERH = '48';
             
            SELECT COUNT (*)
              INTO R_CUE_PER_PENDIENTE_G
              FROM PRAW02T00 A
              JOIN PRAW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND  B.AENC = OP_ANIO
             AND  B.TENC = TRIMESTRE
             AND   A.RESPER = '0'
             AND   B.TERH = '20';
       
            --resultado del cuestionario - individual - completo  
            SELECT COUNT (*)
              INTO R_CUE_PER_COMPLETO_A
              FROM PRAW02T00 A
              JOIN PRAW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND  B.AENC = OP_ANIO
             AND  B.TENC = TRIMESTRE
             AND   A.RESPER = '00'
             AND   B.TERH = '01';
             
            SELECT COUNT (*)
              INTO R_CUE_PER_COMPLETO_B
              FROM PRAW02T00 A
              JOIN PRAW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND  B.AENC = OP_ANIO
             AND  B.TENC = TRIMESTRE
             AND   A.RESPER = '00'
             AND   B.TERH = '48';
             
            SELECT COUNT (*)
              INTO R_CUE_PER_COMPLETO_G
              FROM PRAW02T00 A
              JOIN PRAW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND  B.AENC = OP_ANIO
             AND  B.TENC = TRIMESTRE
             AND   A.RESPER = '00'
             AND   B.TERH = '20';
             
             --resultado del cuestionario - individual - incompleto  
            SELECT COUNT (*)
              INTO R_CUE_PER_INCOMPLETO_A
              FROM PRAW02T00 A
              JOIN PRAW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND  B.AENC = OP_ANIO
             AND  B.TENC = TRIMESTRE
             AND   A.RESPER = '99'
             AND  B.TERH = '01';
            
            SELECT COUNT (*)
              INTO R_CUE_PER_INCOMPLETO_B
              FROM PRAW02T00 A
              JOIN PRAW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND  B.AENC = OP_ANIO
             AND  B.TENC = TRIMESTRE
             AND   A.RESPER = '99'
             AND  B.TERH = '48';
            
            SELECT COUNT (*)
              INTO R_CUE_PER_INCOMPLETO_G
              FROM PRAW02T00 A
              JOIN PRAW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND  B.AENC = OP_ANIO
             AND  B.TENC = TRIMESTRE
             AND   A.RESPER = '99'
             AND  B.TERH = '20';
             
            --resultado del cuestionario - individual - negativa  
            SELECT COUNT (*)
              INTO nTEMP
              FROM PRAW02T00 A
              JOIN PRAW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND   B.AENC = OP_ANIO
             AND   B.TENC = TRIMESTRE
             AND   A.RESPER = '11'
             AND   B.TERH = '01';
            R_CUE_PER_RESTO_A := R_CUE_PER_RESTO_A + nTEMP;
            
            SELECT COUNT (*)
              INTO nTEMP
              FROM PRAW02T00 A
              JOIN PRAW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND   B.AENC = OP_ANIO
             AND   B.TENC = TRIMESTRE
             AND   A.RESPER = '11'
             AND   B.TERH = '48';
            R_CUE_PER_RESTO_B := R_CUE_PER_RESTO_B + nTEMP;
            
            SELECT COUNT (*)
              INTO nTEMP
              FROM PRAW02T00 A
              JOIN PRAW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND   B.AENC = OP_ANIO
             AND   B.TENC = TRIMESTRE
             AND   A.RESPER = '11'
             AND   B.TERH = '20';
            R_CUE_PER_RESTO_G := R_CUE_PER_RESTO_G + nTEMP;
            
            --resultado del cuestionario - individual - vacaciones  
            SELECT COUNT (*)
              INTO nTEMP
              FROM PRAW02T00 A
              JOIN PRAW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND  B.AENC = OP_ANIO
             AND  B.TENC = TRIMESTRE
             AND   A.RESPER = '12'
             AND  B.TERH = '01';
            R_CUE_PER_RESTO_A := R_CUE_PER_RESTO_A + nTEMP;
            
            SELECT COUNT (*)
              INTO nTEMP
              FROM PRAW02T00 A
              JOIN PRAW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND  B.AENC = OP_ANIO
             AND  B.TENC = TRIMESTRE
             AND   A.RESPER = '12'
             AND  B.TERH = '48';
            R_CUE_PER_RESTO_B := R_CUE_PER_RESTO_B + nTEMP;
            
            SELECT COUNT (*)
              INTO nTEMP
              FROM PRAW02T00 A
              JOIN PRAW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND  B.AENC = OP_ANIO
             AND  B.TENC = TRIMESTRE
             AND   A.RESPER = '12'
             AND  B.TERH = '20';
            R_CUE_PER_RESTO_G := R_CUE_PER_RESTO_G + nTEMP;
            
            --resultado del cuestionario - individual - ausencia prolongada  
            SELECT COUNT (*)
              INTO nTEMP
              FROM PRAW02T00 A
              JOIN PRAW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND  B.AENC = OP_ANIO
             AND  B.TENC = TRIMESTRE
             AND   A.RESPER = '13'
             AND  TERH = '01';
            R_CUE_PER_RESTO_A := R_CUE_PER_RESTO_A + nTEMP;
            
            SELECT COUNT (*)
              INTO nTEMP
              FROM PRAW02T00 A
              JOIN PRAW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND  B.AENC = OP_ANIO
             AND  B.TENC = TRIMESTRE
             AND   A.RESPER = '13'
             AND  TERH = '48';
            R_CUE_PER_RESTO_B := R_CUE_PER_RESTO_B + nTEMP;
            
            SELECT COUNT (*)
              INTO nTEMP
              FROM PRAW02T00 A
              JOIN PRAW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND  B.AENC = OP_ANIO
             AND  B.TENC = TRIMESTRE
             AND   A.RESPER = '13'
             AND  TERH = '20';
            R_CUE_PER_RESTO_G := R_CUE_PER_RESTO_G + nTEMP; 
           
            --resultado del cuestionario - individual - otras incidencias  
            SELECT COUNT (*)
              INTO nTEMP
              FROM PRAW02T00 A
              JOIN PRAW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND  B.AENC = OP_ANIO
             AND  B.TENC = TRIMESTRE
             AND   A.RESPER = '19'
             AND  B.TERH = '01';
            R_CUE_PER_RESTO_A := R_CUE_PER_RESTO_A + nTEMP;
            
            SELECT COUNT (*)
              INTO nTEMP
              FROM PRAW02T00 A
              JOIN PRAW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND  B.AENC = OP_ANIO
             AND  B.TENC = TRIMESTRE
             AND   A.RESPER = '19'
             AND  B.TERH = '48';
            R_CUE_PER_RESTO_B := R_CUE_PER_RESTO_B + nTEMP; 
            
            SELECT COUNT (*)
              INTO nTEMP
              FROM PRAW02T00 A
              JOIN PRAW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND  B.AENC = OP_ANIO
             AND  B.TENC = TRIMESTRE
             AND   A.RESPER = '19'
             AND  B.TERH = '20';
            R_CUE_PER_RESTO_G := R_CUE_PER_RESTO_G + nTEMP; 
            
            --total de la muestra
            SELECT COUNT (*)
              INTO TOTAL_MUESTRA_A
              FROM PRAW01T00
              WHERE AENC = OP_ANIO
              AND   TENC = TRIMESTRE
              AND   TERH = '01';
            
            SELECT COUNT (*)
              INTO TOTAL_MUESTRA_B
              FROM PRAW01T00
              WHERE AENC = OP_ANIO
              AND   TENC = TRIMESTRE
              AND   TERH = '48';

            SELECT COUNT (*)
              INTO TOTAL_MUESTRA_G
              FROM PRAW01T00
              WHERE AENC = OP_ANIO
              AND   TENC = TRIMESTRE
              AND   TERH = '20';
           
             
       ELSIF OP_OPERACION = '220122' THEN
        
            --Resultado de la Localizacin - localizada habitable
            SELECT COUNT (*)
              INTO R_L_HABITABLE_A
              FROM ESIFW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '00'
             AND   TERH = '01';
             
            SELECT COUNT (*)
              INTO R_L_HABITABLE_B
              FROM ESIFW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '00'
             AND   TERH = '48';
             
            SELECT COUNT (*)
              INTO R_L_HABITABLE_G
              FROM ESIFW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '00'
             AND   TERH = '20';

            --Resultado de la Localizacin - localizada deshabitada
            SELECT COUNT (*)
              INTO R_L_VACIA_A
              FROM ESIFW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '10'
             AND   TERH = '01';
             
            SELECT COUNT (*)
              INTO R_L_VACIA_B
              FROM ESIFW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '10'
             AND   TERH = '48';
             
            SELECT COUNT (*)
              INTO R_L_VACIA_G
              FROM ESIFW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '10'
             AND   TERH = '20';

            --Resultado de la Localizacin - localizada vivienda temporal
            SELECT COUNT (*)
              INTO R_L_TEMPORAL_A
              FROM ESIFW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '08'
             AND   TERH = '01';
             
            SELECT COUNT (*)
              INTO R_L_TEMPORAL_B
              FROM ESIFW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '08'
             AND   TERH = '48';
             
            SELECT COUNT (*)
              INTO R_L_TEMPORAL_G
              FROM ESIFW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '08'
             AND   TERH = '20';

            --Resultado de la Localizacin - en reforma
            SELECT COUNT (*)
              INTO R_L_REFORMA_A
              FROM ESIFW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '04'
             AND   TERH = '01';
             
            SELECT COUNT (*)
              INTO R_L_REFORMA_B
              FROM ESIFW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '04'
             AND   TERH = '48';
             
            SELECT COUNT (*)
              INTO R_L_REFORMA_G
              FROM ESIFW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '04'
             AND   TERH = '20';

            --Resultado de la Localizacin - ruinosa
            SELECT COUNT (*)
              INTO R_L_RUINOSA_A
              FROM ESIFW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '05'
             AND   TERH = '01';
             
            SELECT COUNT (*)
              INTO R_L_RUINOSA_B
              FROM ESIFW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '05'
             AND   TERH = '48';
             
            SELECT COUNT (*)
              INTO R_L_RUINOSA_G
              FROM ESIFW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '05'
             AND   TERH = '20';
             
             --Resultado de la Localizacin - construccin
            SELECT COUNT (*)
              INTO R_L_CONSTRUCCION_A
              FROM ESIFW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '06'
             AND   TERH = '01';
             
            SELECT COUNT (*)
              INTO R_L_CONSTRUCCION_B
              FROM ESIFW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '06'
             AND   TERH = '48';
             
            SELECT COUNT (*)
              INTO R_L_CONSTRUCCION_G
              FROM ESIFW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '06'
             AND   TERH = '20';

            --Resultado de la Localizacin - otros fines
            SELECT COUNT (*)
              INTO R_L_OTROS_FINES_A
              FROM ESIFW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '09'
             AND   TERH = '01';
             
             SELECT COUNT (*)
              INTO R_L_OTROS_FINES_B
              FROM ESIFW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '09'
             AND   TERH = '48';
             
            SELECT COUNT (*)
              INTO R_L_OTROS_FINES_G
              FROM ESIFW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '09'
             AND   TERH = '20';

            --Resultado de la Localizacin - inaccesible
            SELECT COUNT (*)
              INTO R_L_INACCESIBLE_A
              FROM ESIFW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '07'
             AND   TERH = '01';
             
            SELECT COUNT (*)
              INTO R_L_INACCESIBLE_B
              FROM ESIFW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '07'
             AND   TERH = '48';
             
            SELECT COUNT (*)
              INTO R_L_INACCESIBLE_G
              FROM ESIFW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '07'
             AND   TERH = '20';
            
            --Resultado de la Localizacin - ilocalizada
            SELECT COUNT (*)
              INTO R_L_ILOCALIZADA_A
              FROM ESIFW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '01'
             AND   TERH = '01';
             
            SELECT COUNT (*)
              INTO R_L_ILOCALIZADA_B
              FROM ESIFW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '01'
             AND   TERH = '48';
             
            SELECT COUNT (*)
              INTO R_L_ILOCALIZADA_G
              FROM ESIFW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '01'
             AND   TERH = '20';
            
            --Resultado de la Localizacin - no calificable
            SELECT COUNT (*)
              INTO R_L_NOCLASIFICABLE_A
              FROM ESIFW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '20'
             AND   TERH = '01';
             
            SELECT COUNT (*)
              INTO R_L_NOCLASIFICABLE_B
              FROM ESIFW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '20'
             AND   TERH = '48';
             
            SELECT COUNT (*)
              INTO R_L_NOCLASIFICABLE_G
              FROM ESIFW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '20'
             AND   TERH = '20';
            
            --Resultado de la Localizacin - excluida
            SELECT COUNT (*)
              INTO R_L_EXCLUIDA_A
              FROM ESIFW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '55'
             AND   TERH = '01';
             
            SELECT COUNT (*)
              INTO R_L_EXCLUIDA_B
              FROM ESIFW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '55'
             AND   TERH = '48';
             
            SELECT COUNT (*)
              INTO R_L_EXCLUIDA_G
              FROM ESIFW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '55'
             AND   TERH = '20';                                                
             
             --Resultado de la Localizacin - DESAPARECIDA
            SELECT COUNT (*)
              INTO R_L_DESAPARECIDA_A
              FROM ESIFW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '03'
             AND   TERH = '01';
             
            SELECT COUNT (*)
              INTO R_L_DESAPARECIDA_B
              FROM ESIFW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '03'
             AND   TERH = '48';
             
            SELECT COUNT (*)
              INTO R_L_DESAPARECIDA_G
              FROM ESIFW01T00               
             WHERE AENC = OP_ANIO
             AND   TENC = TRIMESTRE
             AND   RESULT = '03'
             AND   TERH = '20';
            
            
            
            --mtodo de la entrevista - familiar - telfono              
            SELECT COUNT(*)
                INTO T_CON_FAM_TELEFONO_A
                FROM (
                    SELECT A.NUMC              
                     FROM ESIFW02T00 A
                     JOIN ESIFW01T00 ON ESIFW01T00.NUMC = A.NUMC  
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND ESIFW01T00.AENC = OP_ANIO
                      AND ESIFW01T00.TENC = TRIMESTRE
                      AND FORMFAM = '1'
                      --AND INDFAM = 'S' AND RESFAM = '00'
                      AND   TERH = '01'
                    GROUP BY A.NUMC);
            
            SELECT COUNT(*)
                INTO T_CON_FAM_TELEFONO_B
                FROM (
                    SELECT A.NUMC              
                     FROM ESIFW02T00 A
                     JOIN ESIFW01T00 ON ESIFW01T00.NUMC = A.NUMC  
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND ESIFW01T00.AENC = OP_ANIO
                      AND ESIFW01T00.TENC = TRIMESTRE
                      AND FORMFAM = '1'
                      --AND INDFAM = 'S' AND RESFAM = '00'
                      AND   TERH = '48'
                    GROUP BY A.NUMC);
                    
            SELECT COUNT(*)
                INTO T_CON_FAM_TELEFONO_G
                FROM (
                    SELECT A.NUMC              
                     FROM ESIFW02T00 A
                     JOIN ESIFW01T00 ON ESIFW01T00.NUMC = A.NUMC  
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND ESIFW01T00.AENC = OP_ANIO
                      AND ESIFW01T00.TENC = TRIMESTRE
                      AND FORMFAM = '1'
                      --AND INDFAM = 'S' AND RESFAM = '00'
                      AND   TERH = '20'
                    GROUP BY A.NUMC);     
            
            --mtodo de la entrevista - familiar - visita  
            SELECT COUNT(*)
                INTO T_CON_FAM_VISITA_A
                FROM (
                    SELECT A.NUMC              
                     FROM ESIFW02T00 A
                     JOIN ESIFW01T00 ON ESIFW01T00.NUMC = A.NUMC  
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND ESIFW01T00.AENC = OP_ANIO
                      AND ESIFW01T00.TENC = TRIMESTRE
                      AND FORMFAM = '2'
                      --AND INDFAM = 'S' AND RESFAM = '00'
                      AND   TERH = '01'
                    GROUP BY A.NUMC);
            
            SELECT COUNT(*)
                INTO T_CON_FAM_VISITA_B
                FROM (
                    SELECT A.NUMC              
                     FROM ESIFW02T00 A
                     JOIN ESIFW01T00 ON ESIFW01T00.NUMC = A.NUMC  
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND ESIFW01T00.AENC = OP_ANIO
                      AND ESIFW01T00.TENC = TRIMESTRE
                      AND FORMFAM = '2'
                      --AND INDFAM = 'S' AND RESFAM = '00'
                      AND   TERH = '48'
                    GROUP BY A.NUMC);
                    
            SELECT COUNT(*)
                INTO T_CON_FAM_VISITA_G
                FROM (
                    SELECT A.NUMC              
                     FROM ESIFW02T00 A
                     JOIN ESIFW01T00 ON ESIFW01T00.NUMC = A.NUMC  
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND ESIFW01T00.AENC = OP_ANIO
                      AND ESIFW01T00.TENC = TRIMESTRE
                      AND FORMFAM = '2'
                      --AND INDFAM = 'S' AND RESFAM = '00'
                      AND   TERH = '20'
                    GROUP BY A.NUMC);
            
            --mtodo de la entrevista - familiar - web  
            SELECT COUNT(*)
                INTO T_CON_FAM_WEB_A
                FROM (
                    SELECT A.NUMC              
                     FROM ESIFW02T00 A
                     JOIN ESIFW01T00 ON ESIFW01T00.NUMC = A.NUMC  
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND ESIFW01T00.AENC = OP_ANIO
                      AND ESIFW01T00.TENC = TRIMESTRE
                      AND FORMFAM = '3'
                      --AND INDFAM = 'S' AND RESFAM = '00'
                      AND   TERH = '01'
                    GROUP BY A.NUMC);
            
            SELECT COUNT(*)
                INTO T_CON_FAM_WEB_B
                FROM (
                    SELECT A.NUMC              
                     FROM ESIFW02T00 A
                     JOIN ESIFW01T00 ON ESIFW01T00.NUMC = A.NUMC  
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND ESIFW01T00.AENC = OP_ANIO
                      AND ESIFW01T00.TENC = TRIMESTRE
                      AND FORMFAM = '3'
                      --AND INDFAM = 'S' AND RESFAM = '00'
                      AND   TERH = '48'
                    GROUP BY A.NUMC);
                    
            SELECT COUNT(*)
                INTO T_CON_FAM_WEB_G
                FROM (
                    SELECT A.NUMC              
                     FROM ESIFW02T00 A
                     JOIN ESIFW01T00 ON ESIFW01T00.NUMC = A.NUMC  
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND ESIFW01T00.AENC = OP_ANIO
                      AND ESIFW01T00.TENC = TRIMESTRE
                      AND FORMFAM = '3'
                      --AND INDFAM = 'S' AND RESFAM = '00'
                      AND   TERH = '20'
                    GROUP BY A.NUMC);
            
            --mtodo de la entrevista - familiar - otro
            SELECT COUNT (*)
              INTO T_CON_FAM_OTRO_A
                  FROM (                      
                    SELECT A.NUMC              
                     FROM ESIFW02T00 A
                     JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND NVL(A.FORMFAM, ' ') = ' '      
                      --AND INDFAM = 'S' AND RESFAM = '00'
                      AND B.AENC = OP_ANIO
                      AND   B.TENC = TRIMESTRE
                      AND   B.RESULT = '00'    
                      AND   TERH = '01'           
                    GROUP BY A.NUMC);
            
            SELECT COUNT (*)
              INTO T_CON_FAM_OTRO_B
                  FROM (                      
                    SELECT A.NUMC              
                     FROM ESIFW02T00 A
                     JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND NVL(A.FORMFAM, ' ') = ' '      
                      --AND INDFAM = 'S' AND RESFAM = '00'
                      AND B.AENC = OP_ANIO
                      AND   B.TENC = TRIMESTRE
                      AND   B.RESULT = '00'    
                      AND   TERH = '48'           
                    GROUP BY A.NUMC);
            
            SELECT COUNT (*)
              INTO T_CON_FAM_OTRO_G
                  FROM (                      
                    SELECT A.NUMC              
                     FROM ESIFW02T00 A
                     JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND NVL(A.FORMFAM, ' ') = ' '      
                      --AND INDFAM = 'S' AND RESFAM = '00'
                      AND B.AENC = OP_ANIO
                      AND   B.TENC = TRIMESTRE
                      AND   B.RESULT = '00'    
                      AND   TERH = '20'           
                    GROUP BY A.NUMC);
            
            --mtodo de la entrevista - individual - telfono  
            SELECT COUNT (*)
              INTO T_CON_PER_TELEFONO_A
              FROM ESIFW02T00 A
              JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
              AND  A.TENC = TRIMESTRE
              AND  B.AENC = OP_ANIO
              AND  B.TENC = TRIMESTRE
              AND  FORMPER = '1'
              AND  B.TERH = '01';
            
            SELECT COUNT (*)
              INTO T_CON_PER_TELEFONO_B
              FROM ESIFW02T00 A
              JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
              AND  A.TENC = TRIMESTRE
              AND  B.AENC = OP_ANIO
              AND  B.TENC = TRIMESTRE
              AND  FORMPER = '1'
              AND  B.TERH = '48';
            
            SELECT COUNT (*)
              INTO T_CON_PER_TELEFONO_G
              FROM ESIFW02T00 A
              JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
              AND  A.TENC = TRIMESTRE
              AND  B.AENC = OP_ANIO
              AND  B.TENC = TRIMESTRE
              AND  FORMPER = '1'
              AND  B.TERH = '20';
            
            
            --mtodo de la entrevista - individual - visita  
            SELECT COUNT (*)
              INTO T_CON_PER_VISITA_A
              FROM ESIFW02T00 A
              JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
              AND  A.TENC = TRIMESTRE
              AND  B.AENC = OP_ANIO
              AND  B.TENC = TRIMESTRE
              AND  FORMPER = '2'
              AND  B.TERH = '01';
            
            SELECT COUNT (*)
              INTO T_CON_PER_VISITA_B
              FROM ESIFW02T00 A
              JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
              AND  A.TENC = TRIMESTRE
              AND  B.AENC = OP_ANIO
              AND  B.TENC = TRIMESTRE
              AND  FORMPER = '2'
              AND  B.TERH = '48';
            
            SELECT COUNT (*)
              INTO T_CON_PER_VISITA_G
              FROM ESIFW02T00 A
              JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
              AND  A.TENC = TRIMESTRE
              AND  B.AENC = OP_ANIO
              AND  B.TENC = TRIMESTRE
              AND  FORMPER = '2'
              AND  B.TERH = '20';
            
            --mtodo de la entrevista - individual - web  
            SELECT COUNT (*)
              INTO T_CON_PER_WEB_A
              FROM ESIFW02T00 A
              JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
              AND  A.TENC = TRIMESTRE
              AND  B.AENC = OP_ANIO
              AND  B.TENC = TRIMESTRE
              AND  FORMPER = '3'
              AND  B.TERH = '01';
            
            SELECT COUNT (*)
              INTO T_CON_PER_WEB_B
              FROM ESIFW02T00 A
              JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
              AND  A.TENC = TRIMESTRE
              AND  B.AENC = OP_ANIO
              AND  B.TENC = TRIMESTRE
              AND  FORMPER = '3'
              AND  B.TERH = '48';
            
            SELECT COUNT (*)
              INTO T_CON_PER_WEB_G
              FROM ESIFW02T00 A
              JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
              AND  A.TENC = TRIMESTRE
              AND  B.AENC = OP_ANIO
              AND  B.TENC = TRIMESTRE
              AND  FORMPER = '3'
              AND  B.TERH = '20';
            
            --mtodo de la entrevista - individual - otro
            SELECT COUNT (*)
              INTO T_CON_PER_OTRO_A
              FROM ESIFW02T00 A
              JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
              AND  A.TENC = TRIMESTRE
              AND  B.AENC = OP_ANIO
              AND  B.TENC = TRIMESTRE
              AND  NVL(A.FORMPER, ' ') = ' '
              AND  B.RESULT = '00' 
              AND  B.TERH = '01';
            
            SELECT COUNT (*)
              INTO T_CON_PER_OTRO_B
              FROM ESIFW02T00 A
              JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
              AND  A.TENC = TRIMESTRE
              AND  B.AENC = OP_ANIO
              AND  B.TENC = TRIMESTRE
              AND  NVL(A.FORMPER, ' ') = ' '
              AND  B.RESULT = '00'
              AND  B.TERH = '48';
            
            SELECT COUNT (*)
              INTO T_CON_PER_OTRO_G
              FROM ESIFW02T00 A
              JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
              AND  A.TENC = TRIMESTRE
              AND  B.AENC = OP_ANIO
              AND  B.TENC = TRIMESTRE
              AND  NVL(A.FORMPER, ' ') = ' '
              AND  B.RESULT = '00'
              AND  B.TERH = '20';                        

            --resultado del cuestionario - familiar - pendiente de rellenar  
            SELECT COUNT (*)
              INTO R_CUE_FAM_PENDIENTE_A
              FROM (
                    SELECT A.NUMC              
                     FROM ESIFW02T00 A
                     JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND B.AENC = OP_ANIO
                      AND B.TENC = TRIMESTRE
                      AND A.RESFAM = '0'    
                      AND B.TERH = '01'         
                    GROUP BY A.NUMC);
                    
            SELECT COUNT (*)
              INTO R_CUE_FAM_PENDIENTE_B
              FROM (
                    SELECT A.NUMC              
                     FROM ESIFW02T00 A
                     JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND B.AENC = OP_ANIO
                      AND B.TENC = TRIMESTRE
                      AND A.RESFAM = '0'    
                      AND B.TERH = '48'         
                    GROUP BY A.NUMC);
            
            SELECT COUNT (*)
              INTO R_CUE_FAM_PENDIENTE_G
              FROM (
                    SELECT A.NUMC              
                     FROM ESIFW02T00 A
                     JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND B.AENC = OP_ANIO
                      AND B.TENC = TRIMESTRE
                      AND A.RESFAM = '0'    
                      AND B.TERH = '20'         
                    GROUP BY A.NUMC);
       
            --resultado del cuestionario - familiar - completo  
            SELECT COUNT (*)
              INTO R_CUE_FAM_COMPLETO_A
              FROM (
                    SELECT A.NUMC              
                     FROM ESIFW02T00 A
                     JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND B.AENC = OP_ANIO
                      AND B.TENC = TRIMESTRE
                      AND A.RESFAM = '00'
                      AND B.TERH = '01'             
                    GROUP BY A.NUMC);
            
            SELECT COUNT (*)
              INTO R_CUE_FAM_COMPLETO_B
              FROM (
                    SELECT A.NUMC              
                     FROM ESIFW02T00 A
                     JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND B.AENC = OP_ANIO
                      AND B.TENC = TRIMESTRE
                      AND A.RESFAM = '00'
                      AND B.TERH = '48'             
                    GROUP BY A.NUMC);
            
            SELECT COUNT (*)
              INTO R_CUE_FAM_COMPLETO_G
              FROM (
                    SELECT A.NUMC              
                     FROM ESIFW02T00 A
                     JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND B.AENC = OP_ANIO
                      AND B.TENC = TRIMESTRE
                      AND A.RESFAM = '00'
                      AND B.TERH = '20'             
                    GROUP BY A.NUMC);
            
            --resultado del cuestionario - familiar - incompleto  
            SELECT COUNT (*)
              INTO R_CUE_FAM_INCOMPLETO_A
              FROM (
                    SELECT A.NUMC              
                     FROM ESIFW02T00 A
                     JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND B.AENC = OP_ANIO
                      AND B.TENC = TRIMESTRE
                      AND A.RESFAM = '99'
                      AND B.TERH = '01'             
                    GROUP BY A.NUMC);
            
            SELECT COUNT (*)
              INTO R_CUE_FAM_INCOMPLETO_B
              FROM (
                    SELECT A.NUMC              
                     FROM ESIFW02T00 A
                     JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND B.AENC = OP_ANIO
                      AND B.TENC = TRIMESTRE
                      AND A.RESFAM = '99'
                      AND B.TERH = '48'             
                    GROUP BY A.NUMC);
            
            SELECT COUNT (*)
              INTO R_CUE_FAM_INCOMPLETO_G
              FROM (
                    SELECT A.NUMC              
                     FROM ESIFW02T00 A
                     JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND B.AENC = OP_ANIO
                      AND B.TENC = TRIMESTRE
                      AND A.RESFAM = '99'
                      AND B.TERH = '20'             
                    GROUP BY A.NUMC);
            
            --resultado del cuestionario - familiar - negativa  
            SELECT COUNT (*)
              INTO NTEMP
              FROM (
                    SELECT A.NUMC              
                     FROM ESIFW02T00 A
                     JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND B.AENC = OP_ANIO
                      AND B.TENC = TRIMESTRE
                      AND A.RESFAM = '11'
                      AND B.TERH = '01'             
                    GROUP BY A.NUMC);
            R_CUE_FAM_RESTO_A := R_CUE_FAM_RESTO_A + NTEMP;
            
            SELECT COUNT (*)
              INTO NTEMP
              FROM (
                    SELECT A.NUMC              
                     FROM ESIFW02T00 A
                     JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND B.AENC = OP_ANIO
                      AND B.TENC = TRIMESTRE
                      AND A.RESFAM = '11'
                      AND B.TERH = '48'             
                    GROUP BY A.NUMC);
            R_CUE_FAM_RESTO_B := R_CUE_FAM_RESTO_B + NTEMP;
            
            SELECT COUNT (*)
              INTO NTEMP
              FROM (
                    SELECT A.NUMC              
                     FROM ESIFW02T00 A
                     JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND B.AENC = OP_ANIO
                      AND B.TENC = TRIMESTRE
                      AND A.RESFAM = '11'
                      AND B.TERH = '20'             
                    GROUP BY A.NUMC);
            R_CUE_FAM_RESTO_G := R_CUE_FAM_RESTO_G + NTEMP;
            
            --resultado del cuestionario - familiar - vacaciones  
            SELECT COUNT (*)
              INTO NTEMP
              FROM (
                    SELECT A.NUMC              
                     FROM ESIFW02T00 A
                     JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND B.AENC = OP_ANIO
                      AND B.TENC = TRIMESTRE
                      AND A.RESFAM = '12'
                      AND B.TERH = '01'             
                    GROUP BY A.NUMC);
            R_CUE_FAM_RESTO_A := R_CUE_FAM_RESTO_A + NTEMP;
            
            SELECT COUNT (*)
              INTO NTEMP
              FROM (
                    SELECT A.NUMC              
                     FROM ESIFW02T00 A
                     JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND B.AENC = OP_ANIO
                      AND B.TENC = TRIMESTRE
                      AND A.RESFAM = '12'
                      AND B.TERH = '48'             
                    GROUP BY A.NUMC);
            R_CUE_FAM_RESTO_B := R_CUE_FAM_RESTO_B + NTEMP;
            
            SELECT COUNT (*)
              INTO NTEMP
              FROM (
                    SELECT A.NUMC              
                     FROM ESIFW02T00 A
                     JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND B.AENC = OP_ANIO
                      AND B.TENC = TRIMESTRE
                      AND A.RESFAM = '12'
                      AND B.TERH = '20'             
                    GROUP BY A.NUMC);
            R_CUE_FAM_RESTO_G := R_CUE_FAM_RESTO_G + NTEMP;
            
            --resultado del cuestionario - familiar - ausencia prolongada  
            SELECT COUNT (*)
              INTO NTEMP
              FROM (
                    SELECT A.NUMC              
                     FROM ESIFW02T00 A
                     JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND B.AENC = OP_ANIO
                      AND B.TENC = TRIMESTRE
                      AND A.RESFAM = '13'
                      AND B.TERH = '01'             
                    GROUP BY A.NUMC);
            R_CUE_FAM_RESTO_A := R_CUE_FAM_RESTO_A + NTEMP;
            
            SELECT COUNT (*)
              INTO NTEMP
              FROM (
                    SELECT A.NUMC              
                     FROM ESIFW02T00 A
                     JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND B.AENC = OP_ANIO
                      AND B.TENC = TRIMESTRE
                      AND A.RESFAM = '13'
                      AND B.TERH = '48'             
                    GROUP BY A.NUMC);
            R_CUE_FAM_RESTO_B := R_CUE_FAM_RESTO_B + NTEMP;
            
            SELECT COUNT (*)
              INTO NTEMP
              FROM (
                    SELECT A.NUMC              
                     FROM ESIFW02T00 A
                     JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND B.AENC = OP_ANIO
                      AND B.TENC = TRIMESTRE
                      AND A.RESFAM = '13'
                      AND B.TERH = '20'             
                    GROUP BY A.NUMC);
            R_CUE_FAM_RESTO_G := R_CUE_FAM_RESTO_G + NTEMP;
             
            --resultado del cuestionario - familiar - otras incidencias  
            SELECT COUNT (*)
              INTO NTEMP
              FROM (
                    SELECT A.NUMC              
                     FROM ESIFW02T00 A
                     JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND B.AENC = OP_ANIO
                      AND B.TENC = TRIMESTRE
                      AND A.RESFAM = '19'
                      AND B.TERH = '01'             
                    GROUP BY A.NUMC);
             R_CUE_FAM_RESTO_A := R_CUE_FAM_RESTO_A + NTEMP;
             
             SELECT COUNT (*)
              INTO NTEMP
              FROM (
                    SELECT A.NUMC              
                     FROM ESIFW02T00 A
                     JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND B.AENC = OP_ANIO
                      AND B.TENC = TRIMESTRE
                      AND A.RESFAM = '19'
                      AND B.TERH = '48'             
                    GROUP BY A.NUMC);
             R_CUE_FAM_RESTO_B := R_CUE_FAM_RESTO_B + NTEMP;
             
             SELECT COUNT (*)
              INTO NTEMP
              FROM (
                    SELECT A.NUMC              
                     FROM ESIFW02T00 A
                     JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND A.TENC = TRIMESTRE
                      AND B.AENC = OP_ANIO
                      AND B.TENC = TRIMESTRE
                      AND A.RESFAM = '19'
                      AND B.TERH = '20'             
                    GROUP BY A.NUMC);
             R_CUE_FAM_RESTO_G := R_CUE_FAM_RESTO_G + NTEMP;
            
             --resultado del cuestionario - individual - pendiente de rellenar  
            SELECT COUNT (*)
              INTO R_CUE_PER_PENDIENTE_A
              FROM ESIFW02T00 A
              JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND  B.AENC = OP_ANIO
             AND  B.TENC = TRIMESTRE
             AND   A.RESPER = '0'
             AND   B.TERH = '01';
             
            SELECT COUNT (*)
              INTO R_CUE_PER_PENDIENTE_B
              FROM ESIFW02T00 A
              JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND  B.AENC = OP_ANIO
             AND  B.TENC = TRIMESTRE
             AND   A.RESPER = '0'
             AND   B.TERH = '48';
             
            SELECT COUNT (*)
              INTO R_CUE_PER_PENDIENTE_G
              FROM ESIFW02T00 A
              JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND  B.AENC = OP_ANIO
             AND  B.TENC = TRIMESTRE
             AND   A.RESPER = '0'
             AND   B.TERH = '20';
       
            --resultado del cuestionario - individual - completo  
            SELECT COUNT (*)
              INTO R_CUE_PER_COMPLETO_A
              FROM ESIFW02T00 A
              JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND  B.AENC = OP_ANIO
             AND  B.TENC = TRIMESTRE
             AND   A.RESPER = '00'
             AND   B.TERH = '01';
             
            SELECT COUNT (*)
              INTO R_CUE_PER_COMPLETO_B
              FROM ESIFW02T00 A
              JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND  B.AENC = OP_ANIO
             AND  B.TENC = TRIMESTRE
             AND   A.RESPER = '00'
             AND   B.TERH = '48';
             
            SELECT COUNT (*)
              INTO R_CUE_PER_COMPLETO_G
              FROM ESIFW02T00 A
              JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND  B.AENC = OP_ANIO
             AND  B.TENC = TRIMESTRE
             AND   A.RESPER = '00'
             AND   B.TERH = '20';
             
             --resultado del cuestionario - individual - incompleto  
            SELECT COUNT (*)
              INTO R_CUE_PER_INCOMPLETO_A
              FROM ESIFW02T00 A
              JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND  B.AENC = OP_ANIO
             AND  B.TENC = TRIMESTRE
             AND   A.RESPER = '99'
             AND  B.TERH = '01';
            
            SELECT COUNT (*)
              INTO R_CUE_PER_INCOMPLETO_B
              FROM ESIFW02T00 A
              JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND  B.AENC = OP_ANIO
             AND  B.TENC = TRIMESTRE
             AND   A.RESPER = '99'
             AND  B.TERH = '48';
            
            SELECT COUNT (*)
              INTO R_CUE_PER_INCOMPLETO_G
              FROM ESIFW02T00 A
              JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND  B.AENC = OP_ANIO
             AND  B.TENC = TRIMESTRE
             AND   A.RESPER = '99'
             AND  B.TERH = '20';
             
            --resultado del cuestionario - individual - negativa  
            SELECT COUNT (*)
              INTO nTEMP
              FROM ESIFW02T00 A
              JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND   B.AENC = OP_ANIO
             AND   B.TENC = TRIMESTRE
             AND   A.RESPER = '11'
             AND   B.TERH = '01';
            R_CUE_PER_RESTO_A := R_CUE_PER_RESTO_A + nTEMP;
            
            SELECT COUNT (*)
              INTO nTEMP
              FROM ESIFW02T00 A
              JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND   B.AENC = OP_ANIO
             AND   B.TENC = TRIMESTRE
             AND   A.RESPER = '11'
             AND   B.TERH = '48';
            R_CUE_PER_RESTO_B := R_CUE_PER_RESTO_B + nTEMP;
            
            SELECT COUNT (*)
              INTO nTEMP
              FROM ESIFW02T00 A
              JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND   B.AENC = OP_ANIO
             AND   B.TENC = TRIMESTRE
             AND   A.RESPER = '11'
             AND   B.TERH = '20';
            R_CUE_PER_RESTO_G := R_CUE_PER_RESTO_G + nTEMP;
            
            --resultado del cuestionario - individual - vacaciones  
            SELECT COUNT (*)
              INTO nTEMP
              FROM ESIFW02T00 A
              JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND  B.AENC = OP_ANIO
             AND  B.TENC = TRIMESTRE
             AND   A.RESPER = '12'
             AND  B.TERH = '01';
            R_CUE_PER_RESTO_A := R_CUE_PER_RESTO_A + nTEMP;
            
            SELECT COUNT (*)
              INTO nTEMP
              FROM ESIFW02T00 A
              JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND  B.AENC = OP_ANIO
             AND  B.TENC = TRIMESTRE
             AND   A.RESPER = '12'
             AND  B.TERH = '48';
            R_CUE_PER_RESTO_B := R_CUE_PER_RESTO_B + nTEMP;
            
            SELECT COUNT (*)
              INTO nTEMP
              FROM ESIFW02T00 A
              JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND  B.AENC = OP_ANIO
             AND  B.TENC = TRIMESTRE
             AND   A.RESPER = '12'
             AND  B.TERH = '20';
            R_CUE_PER_RESTO_G := R_CUE_PER_RESTO_G + nTEMP;
            
            --resultado del cuestionario - individual - ausencia prolongada  
            SELECT COUNT (*)
              INTO nTEMP
              FROM ESIFW02T00 A
              JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND  B.AENC = OP_ANIO
             AND  B.TENC = TRIMESTRE
             AND   A.RESPER = '13'
             AND  TERH = '01';
            R_CUE_PER_RESTO_A := R_CUE_PER_RESTO_A + nTEMP;
            
            SELECT COUNT (*)
              INTO nTEMP
              FROM ESIFW02T00 A
              JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND  B.AENC = OP_ANIO
             AND  B.TENC = TRIMESTRE
             AND   A.RESPER = '13'
             AND  TERH = '48';
            R_CUE_PER_RESTO_B := R_CUE_PER_RESTO_B + nTEMP;
            
            SELECT COUNT (*)
              INTO nTEMP
              FROM ESIFW02T00 A
              JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND  B.AENC = OP_ANIO
             AND  B.TENC = TRIMESTRE
             AND   A.RESPER = '13'
             AND  TERH = '20';
            R_CUE_PER_RESTO_G := R_CUE_PER_RESTO_G + nTEMP; 
           
            --resultado del cuestionario - individual - otras incidencias  
            SELECT COUNT (*)
              INTO nTEMP
              FROM ESIFW02T00 A
              JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND  B.AENC = OP_ANIO
             AND  B.TENC = TRIMESTRE
             AND   A.RESPER = '19'
             AND  B.TERH = '01';
            R_CUE_PER_RESTO_A := R_CUE_PER_RESTO_A + nTEMP;
            
            SELECT COUNT (*)
              INTO nTEMP
              FROM ESIFW02T00 A
              JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND  B.AENC = OP_ANIO
             AND  B.TENC = TRIMESTRE
             AND   A.RESPER = '19'
             AND  B.TERH = '48';
            R_CUE_PER_RESTO_B := R_CUE_PER_RESTO_B + nTEMP; 
            
            SELECT COUNT (*)
              INTO nTEMP
              FROM ESIFW02T00 A
              JOIN ESIFW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   A.TENC = TRIMESTRE
             AND  B.AENC = OP_ANIO
             AND  B.TENC = TRIMESTRE
             AND   A.RESPER = '19'
             AND  B.TERH = '20';
            R_CUE_PER_RESTO_G := R_CUE_PER_RESTO_G + nTEMP; 
            
            --total de la muestra
            SELECT COUNT (*)
              INTO TOTAL_MUESTRA_A
              FROM ESIFW01T00
              WHERE AENC = OP_ANIO
              AND   TENC = TRIMESTRE
              AND   TERH = '01';
            
            SELECT COUNT (*)
              INTO TOTAL_MUESTRA_B
              FROM ESIFW01T00
              WHERE AENC = OP_ANIO
              AND   TENC = TRIMESTRE
              AND   TERH = '48';

            SELECT COUNT (*)
              INTO TOTAL_MUESTRA_G
              FROM ESIFW01T00
              WHERE AENC = OP_ANIO
              AND   TENC = TRIMESTRE
              AND   TERH = '20';
       
       ELSIF OP_OPERACION = '010313' THEN
              
            --Resultado de la Localizacin - localizada habitable
            SELECT COUNT (*)
              INTO R_L_HABITABLE_A
              FROM EDVW01T00               
             WHERE AENC = OP_ANIO
             AND   RESULT = '00'
             AND   TERH = '01';
             
            SELECT COUNT (*)
              INTO R_L_HABITABLE_B
              FROM EDVW01T00               
             WHERE AENC = OP_ANIO
             AND   RESULT = '00'
             AND   TERH = '48';
             
            SELECT COUNT (*)
              INTO R_L_HABITABLE_G
              FROM EDVW01T00               
             WHERE AENC = OP_ANIO
             AND   RESULT = '00'
             AND   TERH = '20';

            --Resultado de la Localizacin - localizada deshabitada
            SELECT COUNT (*)
              INTO R_L_VACIA_A
              FROM EDVW01T00               
             WHERE AENC = OP_ANIO
             AND   RESULT = '10'
             AND   TERH = '01';
             
            SELECT COUNT (*)
              INTO R_L_VACIA_B
              FROM EDVW01T00               
             WHERE AENC = OP_ANIO
             AND   RESULT = '10'
             AND   TERH = '48';
             
            SELECT COUNT (*)
              INTO R_L_VACIA_G
              FROM EDVW01T00               
             WHERE AENC = OP_ANIO
             AND   RESULT = '10'
             AND   TERH = '20';

            --Resultado de la Localizacin - localizada vivienda temporal
            SELECT COUNT (*)
              INTO R_L_TEMPORAL_A
              FROM EDVW01T00               
             WHERE AENC = OP_ANIO
             AND   RESULT = '08'
             AND   TERH = '01';
             
            SELECT COUNT (*)
              INTO R_L_TEMPORAL_B
              FROM EDVW01T00               
             WHERE AENC = OP_ANIO
             AND   RESULT = '08'
             AND   TERH = '48';
             
            SELECT COUNT (*)
              INTO R_L_TEMPORAL_G
              FROM EDVW01T00               
             WHERE AENC = OP_ANIO
             AND   RESULT = '08'
             AND   TERH = '20';

            --Resultado de la Localizacin - en reforma
            SELECT COUNT (*)
              INTO R_L_REFORMA_A
              FROM EDVW01T00               
             WHERE AENC = OP_ANIO
             AND   RESULT = '04'
             AND   TERH = '01';
             
            SELECT COUNT (*)
              INTO R_L_REFORMA_B
              FROM EDVW01T00               
             WHERE AENC = OP_ANIO
             AND   RESULT = '04'
             AND   TERH = '48';
             
            SELECT COUNT (*)
              INTO R_L_REFORMA_G
              FROM EDVW01T00               
             WHERE AENC = OP_ANIO
             AND   RESULT = '04'
             AND   TERH = '20';

            --Resultado de la Localizacin - ruinosa
            SELECT COUNT (*)
              INTO R_L_RUINOSA_A
              FROM EDVW01T00               
             WHERE AENC = OP_ANIO
             AND   RESULT = '05'
             AND   TERH = '01';
             
            SELECT COUNT (*)
              INTO R_L_RUINOSA_B
              FROM EDVW01T00               
             WHERE AENC = OP_ANIO
             AND   RESULT = '05'
             AND   TERH = '48';
             
            SELECT COUNT (*)
              INTO R_L_RUINOSA_G
              FROM EDVW01T00               
             WHERE AENC = OP_ANIO
             AND   RESULT = '05'
             AND   TERH = '20';
             
             --Resultado de la Localizacin - construccin
            SELECT COUNT (*)
              INTO R_L_CONSTRUCCION_A
              FROM EDVW01T00               
             WHERE AENC = OP_ANIO
             AND   RESULT = '06'
             AND   TERH = '01';
             
            SELECT COUNT (*)
              INTO R_L_CONSTRUCCION_B
              FROM EDVW01T00               
             WHERE AENC = OP_ANIO
             AND   RESULT = '06'
             AND   TERH = '48';
             
            SELECT COUNT (*)
              INTO R_L_CONSTRUCCION_G
              FROM EDVW01T00               
             WHERE AENC = OP_ANIO
             AND   RESULT = '06'
             AND   TERH = '20';

            --Resultado de la Localizacin - otros fines
            SELECT COUNT (*)
              INTO R_L_OTROS_FINES_A
              FROM EDVW01T00               
             WHERE AENC = OP_ANIO
             AND   RESULT = '09'
             AND   TERH = '01';
             
             SELECT COUNT (*)
              INTO R_L_OTROS_FINES_B
              FROM EDVW01T00               
             WHERE AENC = OP_ANIO
             AND   RESULT = '09'
             AND   TERH = '48';
             
            SELECT COUNT (*)
              INTO R_L_OTROS_FINES_G
              FROM EDVW01T00               
             WHERE AENC = OP_ANIO
             AND   RESULT = '09'
             AND   TERH = '20';

            --Resultado de la Localizacin - inaccesible
            SELECT COUNT (*)
              INTO R_L_INACCESIBLE_A
              FROM EDVW01T00               
             WHERE AENC = OP_ANIO
             AND   RESULT = '07'
             AND   TERH = '01';
             
            SELECT COUNT (*)
              INTO R_L_INACCESIBLE_B
              FROM EDVW01T00               
             WHERE AENC = OP_ANIO
             AND   RESULT = '07'
             AND   TERH = '48';
             
            SELECT COUNT (*)
              INTO R_L_INACCESIBLE_G
              FROM EDVW01T00               
             WHERE AENC = OP_ANIO
             AND   RESULT = '07'
             AND   TERH = '20';
            
            --Resultado de la Localizacin - ilocalizada
            SELECT COUNT (*)
              INTO R_L_ILOCALIZADA_A
              FROM EDVW01T00               
             WHERE AENC = OP_ANIO
             AND   RESULT = '01'
             AND   TERH = '01';
             
            SELECT COUNT (*)
              INTO R_L_ILOCALIZADA_B
              FROM EDVW01T00               
             WHERE AENC = OP_ANIO
             AND   RESULT = '01'
             AND   TERH = '48';
             
            SELECT COUNT (*)
              INTO R_L_ILOCALIZADA_G
              FROM EDVW01T00               
             WHERE AENC = OP_ANIO
             AND   RESULT = '01'
             AND   TERH = '20';
            
            --Resultado de la Localizacin - no calificable
            SELECT COUNT (*)
              INTO R_L_NOCLASIFICABLE_A
              FROM EDVW01T00               
             WHERE AENC = OP_ANIO
             AND   RESULT = '20'
             AND   TERH = '01';
             
            SELECT COUNT (*)
              INTO R_L_NOCLASIFICABLE_B
              FROM EDVW01T00               
             WHERE AENC = OP_ANIO
             AND   RESULT = '20'
             AND   TERH = '48';
             
            SELECT COUNT (*)
              INTO R_L_NOCLASIFICABLE_G
              FROM EDVW01T00               
             WHERE AENC = OP_ANIO
             AND   RESULT = '20'
             AND   TERH = '20';
            
            --Resultado de la Localizacin - excluida
            SELECT COUNT (*)
              INTO R_L_EXCLUIDA_A
              FROM EDVW01T00               
             WHERE AENC = OP_ANIO
             AND   RESULT = '55'
             AND   TERH = '01';
             
            SELECT COUNT (*)
              INTO R_L_EXCLUIDA_B
              FROM EDVW01T00               
             WHERE AENC = OP_ANIO
             AND   RESULT = '55'
             AND   TERH = '48';
             
            SELECT COUNT (*)
              INTO R_L_EXCLUIDA_G
              FROM EDVW01T00               
             WHERE AENC = OP_ANIO
             AND   RESULT = '55'
             AND   TERH = '20';                                                
             
             --Resultado de la Localizacin - DESAPARECIDA
            SELECT COUNT (*)
              INTO R_L_DESAPARECIDA_A
              FROM EDVW01T00               
             WHERE AENC = OP_ANIO
             AND   RESULT = '03'
             AND   TERH = '01';
             
            SELECT COUNT (*)
              INTO R_L_DESAPARECIDA_B
              FROM EDVW01T00               
             WHERE AENC = OP_ANIO
             AND   RESULT = '03'
             AND   TERH = '48';
             
            SELECT COUNT (*)
              INTO R_L_DESAPARECIDA_G
              FROM EDVW01T00               
             WHERE AENC = OP_ANIO
             AND   RESULT = '03'
             AND   TERH = '20';
            
            
            
            --mtodo de la entrevista - familiar - telfono              
            SELECT COUNT(*)
                INTO T_CON_FAM_TELEFONO_A
                FROM (
                    SELECT A.NUMC              
                     FROM EDVW02T00 A
                     JOIN EDVW01T00 ON EDVW01T00.NUMC = A.NUMC  
                    WHERE A.AENC = OP_ANIO
                      AND EDVW01T00.AENC = OP_ANIO
                      AND FORMFAM = '1'
                      --AND INDFAM = 'S' AND RESFAM = '00'
                      AND   TERH = '01'
                    GROUP BY A.NUMC);
            
            SELECT COUNT(*)
                INTO T_CON_FAM_TELEFONO_B
                FROM (
                    SELECT A.NUMC              
                     FROM EDVW02T00 A
                     JOIN EDVW01T00 ON EDVW01T00.NUMC = A.NUMC  
                    WHERE A.AENC = OP_ANIO
                      AND EDVW01T00.AENC = OP_ANIO
                      AND FORMFAM = '1'
                      --AND INDFAM = 'S' AND RESFAM = '00'
                      AND   TERH = '48'
                    GROUP BY A.NUMC);
                    
            SELECT COUNT(*)
                INTO T_CON_FAM_TELEFONO_G
                FROM (
                    SELECT A.NUMC              
                     FROM EDVW02T00 A
                     JOIN EDVW01T00 ON EDVW01T00.NUMC = A.NUMC  
                    WHERE A.AENC = OP_ANIO
                      AND EDVW01T00.AENC = OP_ANIO
                      AND FORMFAM = '1'
                      --AND INDFAM = 'S' AND RESFAM = '00'
                      AND   TERH = '20'
                    GROUP BY A.NUMC);     
            
            --mtodo de la entrevista - familiar - visita  
            SELECT COUNT(*)
                INTO T_CON_FAM_VISITA_A
                FROM (
                    SELECT A.NUMC              
                     FROM EDVW02T00 A
                     JOIN EDVW01T00 ON EDVW01T00.NUMC = A.NUMC  
                    WHERE A.AENC = OP_ANIO
                      AND EDVW01T00.AENC = OP_ANIO
                      AND FORMFAM = '2'
                      --AND INDFAM = 'S' AND RESFAM = '00'
                      AND   TERH = '01'
                    GROUP BY A.NUMC);
            
            SELECT COUNT(*)
                INTO T_CON_FAM_VISITA_B
                FROM (
                    SELECT A.NUMC              
                     FROM EDVW02T00 A
                     JOIN EDVW01T00 ON EDVW01T00.NUMC = A.NUMC  
                    WHERE A.AENC = OP_ANIO
                      AND EDVW01T00.AENC = OP_ANIO
                      AND FORMFAM = '2'
                      --AND INDFAM = 'S' AND RESFAM = '00'
                      AND   TERH = '48'
                    GROUP BY A.NUMC);
                    
            SELECT COUNT(*)
                INTO T_CON_FAM_VISITA_G
                FROM (
                    SELECT A.NUMC              
                     FROM EDVW02T00 A
                     JOIN EDVW01T00 ON EDVW01T00.NUMC = A.NUMC  
                    WHERE A.AENC = OP_ANIO
                      AND EDVW01T00.AENC = OP_ANIO
                      AND FORMFAM = '2'
                      --AND INDFAM = 'S' AND RESFAM = '00'
                      AND   TERH = '20'
                    GROUP BY A.NUMC);
            
            --mtodo de la entrevista - familiar - web  
            SELECT COUNT(*)
                INTO T_CON_FAM_WEB_A
                FROM (
                    SELECT A.NUMC              
                     FROM EDVW02T00 A
                     JOIN EDVW01T00 ON EDVW01T00.NUMC = A.NUMC  
                    WHERE A.AENC = OP_ANIO
                      AND EDVW01T00.AENC = OP_ANIO
                      AND FORMFAM = '3'
                      --AND INDFAM = 'S' AND RESFAM = '00'
                      AND   TERH = '01'
                    GROUP BY A.NUMC);
            
            SELECT COUNT(*)
                INTO T_CON_FAM_WEB_B
                FROM (
                    SELECT A.NUMC              
                     FROM EDVW02T00 A
                     JOIN EDVW01T00 ON EDVW01T00.NUMC = A.NUMC  
                    WHERE A.AENC = OP_ANIO
                      AND EDVW01T00.AENC = OP_ANIO
                      AND FORMFAM = '3'
                      --AND INDFAM = 'S' AND RESFAM = '00'
                      AND   TERH = '48'
                    GROUP BY A.NUMC);
                    
            SELECT COUNT(*)
                INTO T_CON_FAM_WEB_G
                FROM (
                    SELECT A.NUMC              
                     FROM EDVW02T00 A
                     JOIN EDVW01T00 ON EDVW01T00.NUMC = A.NUMC  
                    WHERE A.AENC = OP_ANIO
                      AND EDVW01T00.AENC = OP_ANIO
                      AND FORMFAM = '3'
                      --AND INDFAM = 'S' AND RESFAM = '00'
                      AND   TERH = '20'
                    GROUP BY A.NUMC);
            
            --mtodo de la entrevista - familiar - otro
            SELECT COUNT (*)
              INTO T_CON_FAM_OTRO_A
                  FROM (                      
                    SELECT A.NUMC              
                     FROM EDVW02T00 A
                     JOIN EDVW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND NVL(A.FORMFAM, ' ') = ' '      
                      --AND INDFAM = 'S' AND RESFAM = '00'
                      AND B.AENC = OP_ANIO
                      AND   B.RESULT = '00'    
                      AND   TERH = '01'           
                    GROUP BY A.NUMC);
            
            SELECT COUNT (*)
              INTO T_CON_FAM_OTRO_B
                  FROM (                      
                    SELECT A.NUMC              
                     FROM EDVW02T00 A
                     JOIN EDVW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND NVL(A.FORMFAM, ' ') = ' '      
                      --AND INDFAM = 'S' AND RESFAM = '00'
                      AND B.AENC = OP_ANIO
                      AND   B.RESULT = '00'    
                      AND   TERH = '48'           
                    GROUP BY A.NUMC);
            
            SELECT COUNT (*)
              INTO T_CON_FAM_OTRO_G
                  FROM (                      
                    SELECT A.NUMC              
                     FROM EDVW02T00 A
                     JOIN EDVW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND NVL(A.FORMFAM, ' ') = ' '      
                      --AND INDFAM = 'S' AND RESFAM = '00'
                      AND B.AENC = OP_ANIO
                      AND   B.RESULT = '00'    
                      AND   TERH = '20'           
                    GROUP BY A.NUMC);
            
            --mtodo de la entrevista - individual - telfono  
            SELECT COUNT (*)
              INTO T_CON_PER_TELEFONO_A
              FROM EDVW02T00 A
              JOIN EDVW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
              AND  B.AENC = OP_ANIO
              AND  FORMPER = '1'
              AND  B.TERH = '01';
            
            SELECT COUNT (*)
              INTO T_CON_PER_TELEFONO_B
              FROM EDVW02T00 A
              JOIN EDVW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
              AND  B.AENC = OP_ANIO
              AND  FORMPER = '1'
              AND  B.TERH = '48';
            
            SELECT COUNT (*)
              INTO T_CON_PER_TELEFONO_G
              FROM EDVW02T00 A
              JOIN EDVW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
              AND  B.AENC = OP_ANIO
              AND  FORMPER = '1'
              AND  B.TERH = '20';
            
            
            --mtodo de la entrevista - individual - visita  
            SELECT COUNT (*)
              INTO T_CON_PER_VISITA_A
              FROM EDVW02T00 A
              JOIN EDVW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
              AND  B.AENC = OP_ANIO
              AND  FORMPER = '2'
              AND  B.TERH = '01';
            
            SELECT COUNT (*)
              INTO T_CON_PER_VISITA_B
              FROM EDVW02T00 A
              JOIN EDVW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
              AND  B.AENC = OP_ANIO
              AND  FORMPER = '2'
              AND  B.TERH = '48';
            
            SELECT COUNT (*)
              INTO T_CON_PER_VISITA_G
              FROM EDVW02T00 A
              JOIN EDVW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
              AND  B.AENC = OP_ANIO
              AND  FORMPER = '2'
              AND  B.TERH = '20';
            
            --mtodo de la entrevista - individual - web  
            SELECT COUNT (*)
              INTO T_CON_PER_WEB_A
              FROM EDVW02T00 A
              JOIN EDVW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
              AND  B.AENC = OP_ANIO
              AND  FORMPER = '3'
              AND  B.TERH = '01';
            
            SELECT COUNT (*)
              INTO T_CON_PER_WEB_B
              FROM EDVW02T00 A
              JOIN EDVW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
              AND  B.AENC = OP_ANIO
              AND  FORMPER = '3'
              AND  B.TERH = '48';
            
            SELECT COUNT (*)
              INTO T_CON_PER_WEB_G
              FROM EDVW02T00 A
              JOIN EDVW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
              AND  B.AENC = OP_ANIO
              AND  FORMPER = '3'
              AND  B.TERH = '20';
            
            --mtodo de la entrevista - individual - otro
            SELECT COUNT (*)
              INTO T_CON_PER_OTRO_A
              FROM EDVW02T00 A
              JOIN EDVW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
              AND  B.AENC = OP_ANIO
              AND  NVL(A.FORMPER, ' ') = ' '
              AND  B.RESULT = '00' 
              AND  B.TERH = '01';
            
            SELECT COUNT (*)
              INTO T_CON_PER_OTRO_B
              FROM EDVW02T00 A
              JOIN EDVW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
              AND  B.AENC = OP_ANIO
              AND  NVL(A.FORMPER, ' ') = ' '
              AND  B.RESULT = '00'
              AND  B.TERH = '48';
            
            SELECT COUNT (*)
              INTO T_CON_PER_OTRO_G
              FROM EDVW02T00 A
              JOIN EDVW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
              AND  B.AENC = OP_ANIO
              AND  NVL(A.FORMPER, ' ') = ' '
              AND  B.RESULT = '00'
              AND  B.TERH = '20';                        

            --resultado del cuestionario - familiar - pendiente de rellenar  
            SELECT COUNT (*)
              INTO R_CUE_FAM_PENDIENTE_A
              FROM (
                    SELECT A.NUMC              
                     FROM EDVW02T00 A
                     JOIN EDVW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND B.AENC = OP_ANIO
                      AND A.RESFAM = '0'    
                      AND B.TERH = '01'         
                    GROUP BY A.NUMC);
                    
            SELECT COUNT (*)
              INTO R_CUE_FAM_PENDIENTE_B
              FROM (
                    SELECT A.NUMC              
                     FROM EDVW02T00 A
                     JOIN EDVW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND B.AENC = OP_ANIO
                      AND A.RESFAM = '0'    
                      AND B.TERH = '48'         
                    GROUP BY A.NUMC);
            
            SELECT COUNT (*)
              INTO R_CUE_FAM_PENDIENTE_G
              FROM (
                    SELECT A.NUMC              
                     FROM EDVW02T00 A
                     JOIN EDVW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND B.AENC = OP_ANIO
                      AND A.RESFAM = '0'    
                      AND B.TERH = '20'         
                    GROUP BY A.NUMC);
       
            --resultado del cuestionario - familiar - completo  
            SELECT COUNT (*)
              INTO R_CUE_FAM_COMPLETO_A
              FROM (
                    SELECT A.NUMC              
                     FROM EDVW02T00 A
                     JOIN EDVW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND B.AENC = OP_ANIO
                      AND A.RESFAM = '00'
                      AND B.TERH = '01'             
                    GROUP BY A.NUMC);
            
            SELECT COUNT (*)
              INTO R_CUE_FAM_COMPLETO_B
              FROM (
                    SELECT A.NUMC              
                     FROM EDVW02T00 A
                     JOIN EDVW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND B.AENC = OP_ANIO
                      AND A.RESFAM = '00'
                      AND B.TERH = '48'             
                    GROUP BY A.NUMC);
            
            SELECT COUNT (*)
              INTO R_CUE_FAM_COMPLETO_G
              FROM (
                    SELECT A.NUMC              
                     FROM EDVW02T00 A
                     JOIN EDVW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND B.AENC = OP_ANIO
                      AND A.RESFAM = '00'
                      AND B.TERH = '20'             
                    GROUP BY A.NUMC);
            
            --resultado del cuestionario - familiar - incompleto  
            SELECT COUNT (*)
              INTO R_CUE_FAM_INCOMPLETO_A
              FROM (
                    SELECT A.NUMC              
                     FROM EDVW02T00 A
                     JOIN EDVW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND B.AENC = OP_ANIO
                      AND A.RESFAM = '99'
                      AND B.TERH = '01'             
                    GROUP BY A.NUMC);
            
            SELECT COUNT (*)
              INTO R_CUE_FAM_INCOMPLETO_B
              FROM (
                    SELECT A.NUMC              
                     FROM EDVW02T00 A
                     JOIN EDVW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND B.AENC = OP_ANIO
                      AND A.RESFAM = '99'
                      AND B.TERH = '48'             
                    GROUP BY A.NUMC);
            
            SELECT COUNT (*)
              INTO R_CUE_FAM_INCOMPLETO_G
              FROM (
                    SELECT A.NUMC              
                     FROM EDVW02T00 A
                     JOIN EDVW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND B.AENC = OP_ANIO
                      AND A.RESFAM = '99'
                      AND B.TERH = '20'             
                    GROUP BY A.NUMC);
            
            --resultado del cuestionario - familiar - negativa  
            SELECT COUNT (*)
              INTO NTEMP
              FROM (
                    SELECT A.NUMC              
                     FROM EDVW02T00 A
                     JOIN EDVW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND B.AENC = OP_ANIO
                      AND A.RESFAM = '11'
                      AND B.TERH = '01'             
                    GROUP BY A.NUMC);
            R_CUE_FAM_RESTO_A := R_CUE_FAM_RESTO_A + NTEMP;
            
            SELECT COUNT (*)
              INTO NTEMP
              FROM (
                    SELECT A.NUMC              
                     FROM EDVW02T00 A
                     JOIN EDVW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND B.AENC = OP_ANIO
                      AND A.RESFAM = '11'
                      AND B.TERH = '48'             
                    GROUP BY A.NUMC);
            R_CUE_FAM_RESTO_B := R_CUE_FAM_RESTO_B + NTEMP;
            
            SELECT COUNT (*)
              INTO NTEMP
              FROM (
                    SELECT A.NUMC              
                     FROM EDVW02T00 A
                     JOIN EDVW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND B.AENC = OP_ANIO
                      AND A.RESFAM = '11'
                      AND B.TERH = '20'             
                    GROUP BY A.NUMC);
            R_CUE_FAM_RESTO_G := R_CUE_FAM_RESTO_G + NTEMP;
            
            --resultado del cuestionario - familiar - vacaciones  
            SELECT COUNT (*)
              INTO NTEMP
              FROM (
                    SELECT A.NUMC              
                     FROM EDVW02T00 A
                     JOIN EDVW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND B.AENC = OP_ANIO
                      AND A.RESFAM = '12'
                      AND B.TERH = '01'             
                    GROUP BY A.NUMC);
            R_CUE_FAM_RESTO_A := R_CUE_FAM_RESTO_A + NTEMP;
            
            SELECT COUNT (*)
              INTO NTEMP
              FROM (
                    SELECT A.NUMC              
                     FROM EDVW02T00 A
                     JOIN EDVW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND B.AENC = OP_ANIO
                      AND A.RESFAM = '12'
                      AND B.TERH = '48'             
                    GROUP BY A.NUMC);
            R_CUE_FAM_RESTO_B := R_CUE_FAM_RESTO_B + NTEMP;
            
            SELECT COUNT (*)
              INTO NTEMP
              FROM (
                    SELECT A.NUMC              
                     FROM EDVW02T00 A
                     JOIN EDVW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND B.AENC = OP_ANIO
                      AND A.RESFAM = '12'
                      AND B.TERH = '20'             
                    GROUP BY A.NUMC);
            R_CUE_FAM_RESTO_G := R_CUE_FAM_RESTO_G + NTEMP;
            
            --resultado del cuestionario - familiar - ausencia prolongada  
            SELECT COUNT (*)
              INTO NTEMP
              FROM (
                    SELECT A.NUMC              
                     FROM EDVW02T00 A
                     JOIN EDVW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND B.AENC = OP_ANIO
                      AND A.RESFAM = '13'
                      AND B.TERH = '01'             
                    GROUP BY A.NUMC);
            R_CUE_FAM_RESTO_A := R_CUE_FAM_RESTO_A + NTEMP;
            
            SELECT COUNT (*)
              INTO NTEMP
              FROM (
                    SELECT A.NUMC              
                     FROM EDVW02T00 A
                     JOIN EDVW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND B.AENC = OP_ANIO
                      AND A.RESFAM = '13'
                      AND B.TERH = '48'             
                    GROUP BY A.NUMC);
            R_CUE_FAM_RESTO_B := R_CUE_FAM_RESTO_B + NTEMP;
            
            SELECT COUNT (*)
              INTO NTEMP
              FROM (
                    SELECT A.NUMC              
                     FROM EDVW02T00 A
                     JOIN EDVW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND B.AENC = OP_ANIO
                      AND A.RESFAM = '13'
                      AND B.TERH = '20'             
                    GROUP BY A.NUMC);
            R_CUE_FAM_RESTO_G := R_CUE_FAM_RESTO_G + NTEMP;
             
            --resultado del cuestionario - familiar - otras incidencias  
            SELECT COUNT (*)
              INTO NTEMP
              FROM (
                    SELECT A.NUMC              
                     FROM EDVW02T00 A
                     JOIN EDVW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND B.AENC = OP_ANIO
                      AND A.RESFAM = '19'
                      AND B.TERH = '01'             
                    GROUP BY A.NUMC);
             R_CUE_FAM_RESTO_A := R_CUE_FAM_RESTO_A + NTEMP;
             
             SELECT COUNT (*)
              INTO NTEMP
              FROM (
                    SELECT A.NUMC              
                     FROM EDVW02T00 A
                     JOIN EDVW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND B.AENC = OP_ANIO
                      AND A.RESFAM = '19'
                      AND B.TERH = '48'             
                    GROUP BY A.NUMC);
             R_CUE_FAM_RESTO_B := R_CUE_FAM_RESTO_B + NTEMP;
             
             SELECT COUNT (*)
              INTO NTEMP
              FROM (
                    SELECT A.NUMC              
                     FROM EDVW02T00 A
                     JOIN EDVW01T00 B ON A.NUMC = B.NUMC
                    WHERE A.AENC = OP_ANIO
                      AND B.AENC = OP_ANIO
                      AND A.RESFAM = '19'
                      AND B.TERH = '20'             
                    GROUP BY A.NUMC);
             R_CUE_FAM_RESTO_G := R_CUE_FAM_RESTO_G + NTEMP;
            
             --resultado del cuestionario - individual - pendiente de rellenar  
            SELECT COUNT (*)
              INTO R_CUE_PER_PENDIENTE_A
              FROM EDVW02T00 A
              JOIN EDVW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND  B.AENC = OP_ANIO
             AND   A.RESPER = '0'
             AND   B.TERH = '01';
             
            SELECT COUNT (*)
              INTO R_CUE_PER_PENDIENTE_B
              FROM EDVW02T00 A
              JOIN EDVW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND  B.AENC = OP_ANIO
             AND   A.RESPER = '0'
             AND   B.TERH = '48';
             
            SELECT COUNT (*)
              INTO R_CUE_PER_PENDIENTE_G
              FROM EDVW02T00 A
              JOIN EDVW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND  B.AENC = OP_ANIO
             AND   A.RESPER = '0'
             AND   B.TERH = '20';
       
            --resultado del cuestionario - individual - completo  
            SELECT COUNT (*)
              INTO R_CUE_PER_COMPLETO_A
              FROM EDVW02T00 A
              JOIN EDVW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND  B.AENC = OP_ANIO
             AND   A.RESPER = '00'
             AND   B.TERH = '01';
             
            SELECT COUNT (*)
              INTO R_CUE_PER_COMPLETO_B
              FROM EDVW02T00 A
              JOIN EDVW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND  B.AENC = OP_ANIO
             AND   A.RESPER = '00'
             AND   B.TERH = '48';
             
            SELECT COUNT (*)
              INTO R_CUE_PER_COMPLETO_G
              FROM EDVW02T00 A
              JOIN EDVW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND  B.AENC = OP_ANIO
             AND   A.RESPER = '00'
             AND   B.TERH = '20';
             
             --resultado del cuestionario - individual - incompleto  
            SELECT COUNT (*)
              INTO R_CUE_PER_INCOMPLETO_A
              FROM EDVW02T00 A
              JOIN EDVW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND  B.AENC = OP_ANIO
             AND   A.RESPER = '99'
             AND  B.TERH = '01';
            
            SELECT COUNT (*)
              INTO R_CUE_PER_INCOMPLETO_B
              FROM EDVW02T00 A
              JOIN EDVW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND  B.AENC = OP_ANIO
             AND   A.RESPER = '99'
             AND  B.TERH = '48';
            
            SELECT COUNT (*)
              INTO R_CUE_PER_INCOMPLETO_G
              FROM EDVW02T00 A
              JOIN EDVW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND  B.AENC = OP_ANIO
             AND   A.RESPER = '99'
             AND  B.TERH = '20';
             
            --resultado del cuestionario - individual - negativa  
            SELECT COUNT (*)
              INTO nTEMP
              FROM EDVW02T00 A
              JOIN EDVW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   B.AENC = OP_ANIO
             AND   A.RESPER = '11'
             AND   B.TERH = '01';
            R_CUE_PER_RESTO_A := R_CUE_PER_RESTO_A + nTEMP;
            
            SELECT COUNT (*)
              INTO nTEMP
              FROM EDVW02T00 A
              JOIN EDVW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   B.AENC = OP_ANIO
             AND   A.RESPER = '11'
             AND   B.TERH = '48';
            R_CUE_PER_RESTO_B := R_CUE_PER_RESTO_B + nTEMP;
            
            SELECT COUNT (*)
              INTO nTEMP
              FROM EDVW02T00 A
              JOIN EDVW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND   B.AENC = OP_ANIO
             AND   A.RESPER = '11'
             AND   B.TERH = '20';
            R_CUE_PER_RESTO_G := R_CUE_PER_RESTO_G + nTEMP;
            
            --resultado del cuestionario - individual - vacaciones  
            SELECT COUNT (*)
              INTO nTEMP
              FROM EDVW02T00 A
              JOIN EDVW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND  B.AENC = OP_ANIO
             AND   A.RESPER = '12'
             AND  B.TERH = '01';
            R_CUE_PER_RESTO_A := R_CUE_PER_RESTO_A + nTEMP;
            
            SELECT COUNT (*)
              INTO nTEMP
              FROM EDVW02T00 A
              JOIN EDVW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND  B.AENC = OP_ANIO
             AND   A.RESPER = '12'
             AND  B.TERH = '48';
            R_CUE_PER_RESTO_B := R_CUE_PER_RESTO_B + nTEMP;
            
            SELECT COUNT (*)
              INTO nTEMP
              FROM EDVW02T00 A
              JOIN EDVW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND  B.AENC = OP_ANIO
             AND   A.RESPER = '12'
             AND  B.TERH = '20';
            R_CUE_PER_RESTO_G := R_CUE_PER_RESTO_G + nTEMP;
            
            --resultado del cuestionario - individual - ausencia prolongada  
            SELECT COUNT (*)
              INTO nTEMP
              FROM EDVW02T00 A
              JOIN EDVW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND  B.AENC = OP_ANIO
             AND   A.RESPER = '13'
             AND  TERH = '01';
            R_CUE_PER_RESTO_A := R_CUE_PER_RESTO_A + nTEMP;
            
            SELECT COUNT (*)
              INTO nTEMP
              FROM EDVW02T00 A
              JOIN EDVW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND  B.AENC = OP_ANIO
             AND   A.RESPER = '13'
             AND  TERH = '48';
            R_CUE_PER_RESTO_B := R_CUE_PER_RESTO_B + nTEMP;
            
            SELECT COUNT (*)
              INTO nTEMP
              FROM EDVW02T00 A
              JOIN EDVW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND  B.AENC = OP_ANIO
             AND   A.RESPER = '13'
             AND  TERH = '20';
            R_CUE_PER_RESTO_G := R_CUE_PER_RESTO_G + nTEMP; 
           
            --resultado del cuestionario - individual - otras incidencias  
            SELECT COUNT (*)
              INTO nTEMP
              FROM EDVW02T00 A
              JOIN EDVW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND  B.AENC = OP_ANIO
             AND   A.RESPER = '19'
             AND  B.TERH = '01';
            R_CUE_PER_RESTO_A := R_CUE_PER_RESTO_A + nTEMP;
            
            SELECT COUNT (*)
              INTO nTEMP
              FROM EDVW02T00 A
              JOIN EDVW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND  B.AENC = OP_ANIO
             AND   A.RESPER = '19'
             AND  B.TERH = '48';
            R_CUE_PER_RESTO_B := R_CUE_PER_RESTO_B + nTEMP; 
            
            SELECT COUNT (*)
              INTO nTEMP
              FROM EDVW02T00 A
              JOIN EDVW01T00 B ON A.NUMC = B.NUMC
             WHERE A.AENC = OP_ANIO
             AND  B.AENC = OP_ANIO
             AND   A.RESPER = '19'
             AND  B.TERH = '20';
            R_CUE_PER_RESTO_G := R_CUE_PER_RESTO_G + nTEMP; 
            
            --total de la muestra
            SELECT COUNT (*)
              INTO TOTAL_MUESTRA_A
              FROM EDVW01T00
              WHERE AENC = OP_ANIO
              AND   TERH = '01';
            
            SELECT COUNT (*)
              INTO TOTAL_MUESTRA_B
              FROM EDVW01T00
              WHERE AENC = OP_ANIO
              AND   TERH = '48';

            SELECT COUNT (*)
              INTO TOTAL_MUESTRA_G
              FROM EDVW01T00
              WHERE AENC = OP_ANIO
              AND   TERH = '20';
       
       ELSE
        NULL;
       END IF;                        
        
    EXCEPTION
        WHEN OTHERS THEN
            CODERROR := SQLCODE;
            MENSAJERROR := SQLERRM;
    END GED_REC_INDICADORES_INFCAE;

    PROCEDURE GED_REC_INDICADORES_INFSEMANA 
                                  (IDIOMA               IN     VARCHAR2 DEFAULT 'C',                                   
                                   OP_ANIO              IN     NUMBER,
                                   TRIMESTRE            IN     NUMBER,
                                   OP_OPERACION         IN     VARCHAR2,
                                   OP_SUBOPERACION      IN     VARCHAR2,
                                   CDATOS               OUT TDATOS_RETORNO,
                                   MAXSEMANA            OUT NUMBER,
                                   CODERROR                OUT NUMBER,
                                   MENSAJERROR             OUT VARCHAR2)
    IS
        /*
        Funcin: GED_REC_INDICADORES_INFSEMANA
        Autor:   SERIKAT
        Fecha Creacin: 26/05/2016
        Ultima Modificacin:
        Descripcin: Devuelve los datos para mostrar el informe por semanas
        */
        
    BEGIN
        CODERROR := 0;
        MENSAJERROR := ' ';
        MAXSEMANA := 0;
        
        IF OP_OPERACION = '050403' THEN
        
            SELECT MAX(SENC) INTO MAXSEMANA
            FROM PRAW01T00
            WHERE AENC = OP_ANIO
            AND   TENC = TRIMESTRE;

            SELECT TERH, '00', SENC, SUM(CAMPO) AS "CAMPO", SUM(FINALIZADA) AS "FINALIZADA", SUM(INCIDENCIAS) AS "INCIDENCIAS", SUM(SINCODIFICAR) AS "SINCODIFICAR"
            BULK COLLECT INTO CDATOS
            FROM(
                SELECT TERH, '00', SENC, COUNT(*) AS CAMPO, 0 AS FINALIZADA, 0 AS INCIDENCIAS, 0 AS SINCODIFICAR
                  FROM PRAW01T00               
                 WHERE AENC = OP_ANIO
                 AND   TENC = TRIMESTRE
                 AND   SITUAC = '1'
                 GROUP BY TERH, SENC
                UNION
                SELECT TERH, '00', SENC, 0 AS CAMPO, COUNT(*) AS FINALIZADA, 0 AS INCIDENCIAS, 0 AS SINCODIFICAR
                  FROM PRAW01T00               
                 WHERE AENC = OP_ANIO
                 AND   TENC = TRIMESTRE
                 AND   SITUAC = '2'
                 GROUP BY TERH, SENC
                UNION
                SELECT TERH, '00', SENC, 0 AS CAMPO, 0 AS FINALIZADA, COUNT(*) AS INCIDENCIAS, 0 AS SINCODIFICAR
                  FROM PRAW01T00               
                 WHERE AENC = OP_ANIO
                 AND   TENC = TRIMESTRE
                 AND   SITUAC = '4'
                 GROUP BY TERH, SENC
                UNION
                SELECT TERH, '00', SENC, 0 AS CAMPO, 0 AS FINALIZADA, 0 AS INCIDENCIAS,COUNT(*) AS SINCODIFICAR 
                  FROM PRAW01T00               
                 WHERE AENC = OP_ANIO
                 AND   TENC = TRIMESTRE
                 AND   SITUAC = '5'
                 GROUP BY TERH, SENC
            )
            GROUP BY TERH, SENC
            ORDER BY TERH, SENC;
            
        ELSIF OP_OPERACION = '220122' THEN
            SELECT MAX(SENC) INTO MAXSEMANA
            FROM ESIFW01T00
            WHERE AENC = OP_ANIO
            AND   TENC = TRIMESTRE;
        
            SELECT TERH, '00', SENC, SUM(CAMPO) AS "CAMPO", SUM(FINALIZADA) AS "FINALIZADA", SUM(INCIDENCIAS) AS "INCIDENCIAS", SUM(SINCODIFICAR) AS "SINCODIFICAR"
            BULK COLLECT INTO CDATOS
            FROM(
                SELECT TERH, '00', SENC, COUNT(*) AS CAMPO, 0 AS FINALIZADA, 0 AS INCIDENCIAS, 0 AS SINCODIFICAR
                  FROM ESIFW01T00               
                 WHERE AENC = OP_ANIO
                 AND   TENC = TRIMESTRE
                 AND   SITUAC = '1'
                 GROUP BY TERH, SENC
                UNION
                SELECT TERH, '00', SENC, 0 AS CAMPO, COUNT(*) AS FINALIZADA, 0 AS INCIDENCIAS, 0 AS SINCODIFICAR
                  FROM ESIFW01T00               
                 WHERE AENC = OP_ANIO
                 AND   TENC = TRIMESTRE
                 AND   SITUAC = '2'
                 GROUP BY TERH, SENC
                UNION
                SELECT TERH, '00', SENC, 0 AS CAMPO, 0 AS FINALIZADA, COUNT(*) AS INCIDENCIAS, 0 AS SINCODIFICAR
                  FROM ESIFW01T00               
                 WHERE AENC = OP_ANIO
                 AND   TENC = TRIMESTRE
                 AND   SITUAC = '4'
                 GROUP BY TERH, SENC
                UNION
                SELECT TERH, '00', SENC, 0 AS CAMPO, 0 AS FINALIZADA, 0 AS INCIDENCIAS,COUNT(*) AS SINCODIFICAR 
                  FROM ESIFW01T00               
                 WHERE AENC = OP_ANIO
                 AND   TENC = TRIMESTRE
                 AND   SITUAC = '5'
                 GROUP BY TERH, SENC
            )
            GROUP BY TERH, SENC
            ORDER BY TERH, SENC;        
        
        ELSE
            SELECT '00', '00', 0, 0 AS "CAMPO", 0 AS "FINALIZADA", 0 AS "INCIDENCIAS", 0 AS "SINCODIFICAR"
            BULK COLLECT INTO CDATOS
            FROM DUAL;
        END IF;
        
    EXCEPTION
        WHEN OTHERS THEN
            CODERROR := SQLCODE;
            MENSAJERROR := SQLERRM;
    END GED_REC_INDICADORES_INFSEMANA;
    --------------------------------------------------------------------------------------------------
    PROCEDURE GED_REC_INDICADORES_INFCOMARCA 
                                  (IDIOMA               IN     VARCHAR2 DEFAULT 'C',                                   
                                   OP_ANIO              IN     NUMBER,
                                   TRIMESTRE            IN     NUMBER,
                                   OP_OPERACION         IN     VARCHAR2,
                                   OP_SUBOPERACION      IN     VARCHAR2,
                                   CDATOS               OUT TDATOS_RETORNO,
                                   CODERROR                OUT NUMBER,
                                   MENSAJERROR             OUT VARCHAR2)
    IS
        /*
        Funcin: GED_REC_INDICADORES_INFCOMARCA
        Autor:   SERIKAT
        Fecha Creacin: 27/05/2016
        Ultima Modificacin:
        Descripcin: Devuelve los datos para mostrar el informe por comarcas
        */
        
    BEGIN
        CODERROR := 0;
        MENSAJERROR := ' ';
        
        IF OP_OPERACION = '050403' THEN
                    
            SELECT TERH, MUN_COMR, 0, SUM(CAMPO) AS "CAMPO", SUM(FINALIZADA) AS "FINALIZADA", SUM(INCIDENCIAS) AS "INCIDENCIAS", SUM(SINCODIFICAR) AS "SINCODIFICAR"
            BULK COLLECT INTO CDATOS
            FROM(
                SELECT TERH, MUN_COMR, COUNT(*) AS CAMPO, 0 AS FINALIZADA, 0 AS INCIDENCIAS, 0 AS SINCODIFICAR
                  FROM PRAW01T00
                  JOIN TERRITORIO_SII.MTP_MUNICIPIO ON MUN_PROV = TERH AND MUN_MUNI = MUNR
                 WHERE AENC = OP_ANIO
                 AND   TENC = TRIMESTRE
                 AND   SITUAC = '1'
                 GROUP BY TERH, MUN_COMR
                UNION
                SELECT TERH, MUN_COMR, 0 AS CAMPO, COUNT(*) AS FINALIZADA, 0 AS INCIDENCIAS, 0 AS SINCODIFICAR
                  FROM PRAW01T00
                  JOIN TERRITORIO_SII.MTP_MUNICIPIO ON MUN_PROV = TERH AND MUN_MUNI = MUNR
                 WHERE AENC = OP_ANIO
                 AND   TENC = TRIMESTRE
                 AND   SITUAC = '2'
                 GROUP BY TERH, MUN_COMR
                UNION
                SELECT TERH, MUN_COMR, 0 AS CAMPO, 0 AS FINALIZADA, COUNT(*) AS INCIDENCIAS, 0 AS SINCODIFICAR
                  FROM PRAW01T00
                  JOIN TERRITORIO_SII.MTP_MUNICIPIO ON MUN_PROV = TERH AND MUN_MUNI = MUNR
                 WHERE AENC = OP_ANIO
                 AND   TENC = TRIMESTRE
                 AND   SITUAC = '4'
                 GROUP BY TERH, MUN_COMR
                UNION
                SELECT TERH, MUN_COMR, 0 AS CAMPO, 0 AS FINALIZADA, 0 AS INCIDENCIAS,COUNT(*) AS SINCODIFICAR 
                  FROM PRAW01T00
                  JOIN TERRITORIO_SII.MTP_MUNICIPIO ON MUN_PROV = TERH AND MUN_MUNI = MUNR
                 WHERE AENC = OP_ANIO
                 AND   TENC = TRIMESTRE
                 AND   SITUAC = '5'
                 GROUP BY TERH, MUN_COMR
            )
            GROUP BY TERH, MUN_COMR;
            
        ELSIF OP_OPERACION = '220122' THEN
            
            SELECT TERH, MUN_COMR, 0, SUM(CAMPO) AS "CAMPO", SUM(FINALIZADA) AS "FINALIZADA", SUM(INCIDENCIAS) AS "INCIDENCIAS", SUM(SINCODIFICAR) AS "SINCODIFICAR"
            BULK COLLECT INTO CDATOS
            FROM(
                SELECT TERH, MUN_COMR, COUNT(*) AS CAMPO, 0 AS FINALIZADA, 0 AS INCIDENCIAS, 0 AS SINCODIFICAR
                  FROM ESIFW01T00
                  JOIN TERRITORIO_SII.MTP_MUNICIPIO ON MUN_PROV = TERH AND MUN_MUNI = MUNR
                 WHERE AENC = OP_ANIO
                 AND   TENC = TRIMESTRE
                 AND   SITUAC = '1'
                 GROUP BY TERH, MUN_COMR
                UNION
                SELECT TERH, MUN_COMR, 0 AS CAMPO, COUNT(*) AS FINALIZADA, 0 AS INCIDENCIAS, 0 AS SINCODIFICAR
                  FROM ESIFW01T00
                  JOIN TERRITORIO_SII.MTP_MUNICIPIO ON MUN_PROV = TERH AND MUN_MUNI = MUNR
                 WHERE AENC = OP_ANIO
                 AND   TENC = TRIMESTRE
                 AND   SITUAC = '2'
                 GROUP BY TERH, MUN_COMR
                UNION
                SELECT TERH, MUN_COMR, 0 AS CAMPO, 0 AS FINALIZADA, COUNT(*) AS INCIDENCIAS, 0 AS SINCODIFICAR
                  FROM ESIFW01T00
                  JOIN TERRITORIO_SII.MTP_MUNICIPIO ON MUN_PROV = TERH AND MUN_MUNI = MUNR
                 WHERE AENC = OP_ANIO
                 AND   TENC = TRIMESTRE
                 AND   SITUAC = '4'
                 GROUP BY TERH, MUN_COMR
                UNION
                SELECT TERH, MUN_COMR, 0 AS CAMPO, 0 AS FINALIZADA, 0 AS INCIDENCIAS,COUNT(*) AS SINCODIFICAR 
                  FROM ESIFW01T00
                  JOIN TERRITORIO_SII.MTP_MUNICIPIO ON MUN_PROV = TERH AND MUN_MUNI = MUNR
                 WHERE AENC = OP_ANIO
                 AND   TENC = TRIMESTRE
                 AND   SITUAC = '5'
                 GROUP BY TERH, MUN_COMR
            )
            GROUP BY TERH, MUN_COMR;
        
        ELSIF OP_OPERACION = '010313' THEN
        
            SELECT TERH, MUN_COMR, 0, SUM(CAMPO) AS "CAMPO", SUM(FINALIZADA) AS "FINALIZADA", SUM(INCIDENCIAS) AS "INCIDENCIAS", SUM(SINCODIFICAR) AS "SINCODIFICAR"
            BULK COLLECT INTO CDATOS
            FROM(
                SELECT TERH, MUN_COMR, COUNT(*) AS CAMPO, 0 AS FINALIZADA, 0 AS INCIDENCIAS, 0 AS SINCODIFICAR
                  FROM EDVW01T00
                  JOIN TERRITORIO_SII.MTP_MUNICIPIO ON MUN_PROV = TERH AND MUN_MUNI = MUNR
                 WHERE AENC = OP_ANIO
                 AND   SITUAC = '1'
                 GROUP BY TERH, MUN_COMR
                UNION
                SELECT TERH, MUN_COMR, 0 AS CAMPO, COUNT(*) AS FINALIZADA, 0 AS INCIDENCIAS, 0 AS SINCODIFICAR
                  FROM EDVW01T00
                  JOIN TERRITORIO_SII.MTP_MUNICIPIO ON MUN_PROV = TERH AND MUN_MUNI = MUNR
                 WHERE AENC = OP_ANIO
                 AND   SITUAC = '2'
                 GROUP BY TERH, MUN_COMR
                UNION
                SELECT TERH, MUN_COMR, 0 AS CAMPO, 0 AS FINALIZADA, COUNT(*) AS INCIDENCIAS, 0 AS SINCODIFICAR
                  FROM EDVW01T00
                  JOIN TERRITORIO_SII.MTP_MUNICIPIO ON MUN_PROV = TERH AND MUN_MUNI = MUNR
                 WHERE AENC = OP_ANIO
                 AND   SITUAC = '4'
                 GROUP BY TERH, MUN_COMR
                UNION
                SELECT TERH, MUN_COMR, 0 AS CAMPO, 0 AS FINALIZADA, 0 AS INCIDENCIAS,COUNT(*) AS SINCODIFICAR 
                  FROM EDVW01T00
                  JOIN TERRITORIO_SII.MTP_MUNICIPIO ON MUN_PROV = TERH AND MUN_MUNI = MUNR
                 WHERE AENC = OP_ANIO
                 AND   SITUAC = '5'
                 GROUP BY TERH, MUN_COMR
            )
            GROUP BY TERH, MUN_COMR;
        
        ELSE
            SELECT '00', '00', 0, 0 AS "CAMPO", 0 AS "FINALIZADA", 0 AS "INCIDENCIAS", 0 AS "SINCODIFICAR"
            BULK COLLECT INTO CDATOS
            FROM DUAL;
        END IF;
        
    EXCEPTION
        WHEN OTHERS THEN
            CODERROR := SQLCODE;
            MENSAJERROR := SQLERRM;
    END GED_REC_INDICADORES_INFCOMARCA;

END P_GED_INTERFACE;
/


--
-- CIERRE_MENSUAL  (Procedure) 
--
CREATE OR REPLACE PROCEDURE GEDW."CIERRE_MENSUAL" (
   anio   IN   VARCHAR2,
   mes    IN   VARCHAR2
)
IS
   tmpvar   NUMBER;
/******************************************************************************/
BEGIN
   DECLARE
      varnumc                     praw01t00.numc%TYPE;
      varidev                     praw01t00.idev%TYPE; 
      varaenc                     praw01t00.aenc%TYPE;
      varturn                     praw01t00.turn%TYPE;
      vartenc                     praw01t00.tenc%TYPE;
      varsenc                     praw01t00.senc%TYPE;
      vartipe                     praw01t00.tipe%TYPE;
      varterh                     praw01t00.terh%TYPE;
      varmunr                     praw01t00.munr%TYPE;
      vardist                     praw01t00.dist%TYPE;
      varsecc                     praw01t00.secc%TYPE;
      varnoma                     praw01t00.noma%TYPE;
      vardirec                    praw01t00.direc%TYPE;
      varlcdir                    praw01t00.lcdir%TYPE;
      varlentp                    praw01t00.lentp%TYPE;
      varcodp                     praw01t00.codp%TYPE;
      varlmun                     praw01t00.lmun%TYPE;
      varlter                     praw01t00.lter%TYPE;
      varnind                     praw02t00.nind%TYPE;
      varnomb                     praw02t00.nomb%TYPE;
      varape1                     praw02t00.ape1%TYPE;
      varape2                     praw02t00.ape2%TYPE;
      varlnac                     praw02t00.lnac%TYPE;
      varfnac                     praw02t00.fnac%TYPE;
      varsexo                     praw02t00.sexo%TYPE;
      vardni                      praw02t00.dni%TYPE;
      varnaci                     praw02t00.naci%TYPE;
      varfref                     praw01t00.fref%TYPE;
      rnumcactual                 praw01t00.numc%TYPE     := 0;
      raencactual                 praw01t00.aenc%TYPE     := 0;
      rtencactual                 praw01t00.tenc%TYPE     := 0;
      situacion_encampo           praw01t00.situac%TYPE   := 1; 
      strerror                    VARCHAR2 (1024);
      strupdate                   VARCHAR2 (1024);
      numcaux                     praw01t00.numc%TYPE;
      perfil_encuestado           INT                     := 4;
      situac_noencuestable        praw01t00.situac%TYPE   := 7;
      pendienterellenar           praw02t00.resper%TYPE   := 0; 
      aencact                     praw01t00.aenc%TYPE;
      rdni                        praw02t00.dni%TYPE;
      ind_si_lit                  VARCHAR2 (2)            := 'S';
      ind_no_lit                  VARCHAR2 (2)            := 'N';
      ind_nocontactado            VARCHAR2 (2)            := '01';
      ind_empadronado             VARCHAR2 (1)            := 1;
      edad_anos                   praw02t00.edad%TYPE;
      edad_quin                   praw02t00.quin%TYPE;
      ind_permanece               VARCHAR2 (1)            := 1;
      vardini                     praw01t00.dini%TYPE;
      vardfin                     praw01t00.dfin%TYPE;
      valorini_turn               VARCHAR2 (1)            := 1;
      valorfin_turn               VARCHAR2 (1)            := 1;
      varnore                     VARCHAR2 (1)            := 1;
      auxdiasemana                VARCHAR2 (1)            := 1;
      varute                      praw01t00.ute%TYPE;
      en_campo                    praw01t00.situac%TYPE   := 1;
      finalizada                  praw01t00.situac%TYPE   := 2;
      finalizada_fuera_plazo      praw01t00.situac%TYPE   := 7;
      finalizada_incidencias      praw01t00.situac%TYPE   := 4;
      vbisiesto                   BOOLEAN;
      varauxnumc_nuevo            praw01t00.numc%TYPE     := 0;
      varauxanio_nuevo            praw01t00.aenc%TYPE     := 0;
      varauxtrim_nuevo            praw01t00.tenc%TYPE     := 0;
      resultado_ilocalizable      praw01t00.RESULT%TYPE   := '01';
      resultado_desaparecido      praw01t00.RESULT%TYPE   := '03';
      resultado_ruinosa           praw01t00.RESULT%TYPE   := '05';
      resultado_otrosfines        praw01t00.RESULT%TYPE   := '09';
      varauxsituacion             praw01t00.situac%TYPE   := NULL;
      varauxresultado             praw01t00.RESULT%TYPE   := NULL;
      varauxnoma                  praw01t00.noma%TYPE   := NULL;
      varic                       praw01t00.ic%TYPE   := NULL;
      varic                       praw01t00.icnombre%TYPE   := NULL;
      varicemail                  praw01t00.icemail%TYPE   := NULL;
      varictlfno                  praw01t00.ictlfno%TYPE   := NULL;
      varicrelacion               praw01t00.icrelacion%TYPE   := NULL;
      varicobsevaciones           praw01t00.icobservaciones%TYPE   := NULL;
/* Declaracion de cursores */
        -- Este cursor obtiene la entrada de pra
      CURSOR c_vivienda (panio IN VARCHAR2,pmes IN VARCHAR2)
      IS
         SELECT   numc, aenc, tenc, tipe, senc, turn, nore, idev, 
                  terh, munr, dist, secc, noma, direc, lcdir, lentp, codp,
                  lmun, lter, fref, dini, dfin, matr, phij, mhij, otro,
                  relaf1, relaf2, relaf3, relaf4, situac, RESULT, rcont,
                  defcolec, ute,ic, icnombre, ictlfno, icemail, icrelacion, icobservaciones
             FROM praw01t00
            WHERE TO_CHAR (fref, 'YYYY')= panio 
              AND TO_CHAR (fref, 'MM') = pmes
              AND turn < 8
              AND (   situac = en_campo
                   OR situac = finalizada
                   OR situac = finalizada_fuera_plazo
                   OR situac = finalizada_incidencias  
                  )
         ORDER BY numc, aenc, tenc;

      -- Cursor para obtener los individuos pertenecientes a ese Numc
      CURSOR c_individuos (
         pnumc   IN   praw02t00.numc%TYPE,
         paenc   IN   praw02t00.aenc%TYPE,
         ptenc   IN   praw02t00.tenc%TYPE
      )
      IS
         SELECT   numc, nind, aenc, formfam, resper, resfam, nomb, ape1, ape2,
                  indper, edad, sexo, dni, fnac, sita, lnac, naci, indfam,
                  infper, repp, conyu, madre, padre, orden, PASSWORD, nprf,
                  formper, motbaj, tenc, tipe, ssoc, lanbide, siem, pptr,
                  tiprg, tcon, quin,cl_upb ,tlfno1,tlfno2,email
             FROM praw.praw02t00
            WHERE numc = pnumc AND aenc = paenc AND tenc = ptenc AND sita <> 3
         ORDER BY numc, nind;

      CURSOR c_incidencias_traspaso (presultado IN VARCHAR2)
      IS
         SELECT codpinc
           FROM GEDW68T00
          WHERE codpinc = presultado;
          
        CURSOR c_noma (
         pnumc   IN   praw02t00.numc%TYPE,
         paenc   IN   praw02t00.aenc%TYPE,
         ptenc   IN   praw02t00.tenc%TYPE 
      )
      IS
         SELECT  RTRIM(nomb || ' ' ||  ape1 || ' ' || ape2) AS noma  
         FROM praw.praw02t00
            WHERE numc = pnumc AND aenc = paenc AND tenc = ptenc AND sita <> 3 AND nprf = 'S'
         ORDER BY numc, nind;    
          
   BEGIN
      /* eliminamos la informacin de errores */
      DELETE FROM errores_cierre
            WHERE tipo = 'M';

      FOR r_vivienda IN c_vivienda (anio,mes)
      LOOP
         /*si no he tratado ya esa vivienda*/
         IF (   r_vivienda.numc <> rnumcactual
             OR r_vivienda.aenc <> raencactual
             OR r_vivienda.tenc <> rtencactual
            )
         THEN
            BEGIN
               /*Clculo de dinicial y dfinal respecto a fecha de referencia*/
               auxdiasemana := NULL;

/*              hasta 20201216
               IF (r_vivienda.tenc = 4)
               THEN
                   en el cuarto trimestre se hace un tratamiento especial dependiendo de si es bisiesto o no
                  IF r_vivienda.aenc MOD 4 = 0
                  THEN
                     IF     (r_vivienda.aenc MOD 100 = 0)
                        AND NOT (r_vivienda.aenc MOD 400 = 0)
                     THEN
                        vbisiesto := FALSE;
                     ELSE
                        vbisiesto := TRUE;
                     END IF;
                  ELSE
                     vbisiesto := FALSE;
                  END IF;

                  
                  --fllanosm 20201117 se modifica para que sume 92 aunque sea bisiesto
                  --IF vbisiesto THEN
                  --     SELECT r_vivienda.fref + 93
                  --     INTO varfref
                  --     FROM DUAL;
                  --ELSE
                     SELECT r_vivienda.fref + 92
                       INTO varfref
                       FROM DUAL;
                  --END IF;
               ELSE
                   --en el resto de casos se suma 91 dias
                  SELECT r_vivienda.fref + 91
                    INTO varfref
                    FROM DUAL;
               END IF;
*/
               -- Se hace este cambio pq se ha decidido saltar el 1-jul en los aos bisiestos
               IF (r_vivienda.tenc = 4) THEN
                    varfref := r_vivienda.fref + 92;
               ELSIF (r_vivienda.tenc IN (1, 3)) THEN
                    varfref := r_vivienda.fref + 91;
               ELSE--trimestre 2
                   -- en el SEGUNDO trimestre se hace un tratamiento especial dependiendo de si es bisiesto o no
                  IF r_vivienda.aenc MOD 4 = 0 THEN
                     IF (r_vivienda.aenc MOD 100 = 0) AND NOT (r_vivienda.aenc MOD 400 = 0) THEN
                        vbisiesto := FALSE;
                     ELSE
                        vbisiesto := TRUE;
                     END IF;
                  ELSE
                     vbisiesto := FALSE;
                  END IF;     
                  IF vbisiesto THEN
                    varfref := r_vivienda.fref + 92;
                  ELSE
                    varfref := r_vivienda.fref + 91;
                  END IF;
                           
               END IF;


               IF (r_vivienda.tenc = 4)
               THEN
                  varauxanio_nuevo := r_vivienda.aenc + 1;
                  varauxtrim_nuevo := 1;
               ELSE
                  varauxanio_nuevo := r_vivienda.aenc;
                  varauxtrim_nuevo := r_vivienda.tenc + 1;
               END IF;

               SELECT (TRUNC (varfref) - TRUNC (varfref, 'iw') + 1)
                 INTO auxdiasemana
                 FROM DUAL;

               /* si es domingo ese es el dia de inicio */
               IF (auxdiasemana = 7)
               THEN
                  vardini := varfref;

                  SELECT varfref + 6
                    INTO vardfin
                    FROM DUAL;
               ELSE
                  SELECT varfref - auxdiasemana
                    INTO vardini
                    FROM DUAL;

                  SELECT vardini + 6
                    INTO vardfin
                    FROM DUAL;
               END IF;

               varnore := r_vivienda.nore;

               IF (   r_vivienda.situac = finalizada
                   OR r_vivienda.situac = finalizada_fuera_plazo
                  )
               THEN
                  varnore := varnore + 1;
               END IF;

               varauxsituacion := situacion_encampo;
               varauxresultado := NULL;

               IF (r_vivienda.situac = finalizada_incidencias)
               THEN
                   FOR r_incidencia IN c_incidencias_traspaso (r_vivienda.RESULT)
                   LOOP
                   BEGIN
                     varauxsituacion := finalizada_incidencias;
                     varauxresultado := r_incidencia.codpinc; 
                           END;
               END LOOP;
               END IF; 
                
                varauxnoma := r_vivienda.noma;
               
               FOR r_noma IN c_noma (r_vivienda.numc,r_vivienda.aenc,r_vivienda.tenc)
                   LOOP
                   BEGIN
                     varauxnoma := r_noma.noma; 
                      EXCEPTION
                      WHEN OTHERS
                        THEN
                           strerror := SQLERRM;
                           END;
               END LOOP;
               

               INSERT INTO praw01t00
                           (numc, idev,
                              aenc,
                            tenc, senc,
                            turn, tipe, nore,
                            terh, munr,
                            dist, secc,
                            noma, direc,
                            lcdir, lentp,
                            codp, lmun,
                            lter, situac,
                            RESULT, defcolec, rcont,
                            fref, dini, dfin, ute,
                            ic,icnombre,ictlfno, icemail, icrelacion,icobservaciones
                           )
                    VALUES (r_vivienda.numc, r_vivienda.idev,
                              varauxanio_nuevo,
                            varauxtrim_nuevo, r_vivienda.senc,
                            r_vivienda.turn + 1, r_vivienda.tipe, varnore,
                            r_vivienda.terh, r_vivienda.munr,
                            r_vivienda.dist, r_vivienda.secc,
                            varauxnoma, r_vivienda.direc,
                            r_vivienda.lcdir, r_vivienda.lentp,
                            r_vivienda.codp, r_vivienda.lmun,
                            r_vivienda.lter, varauxsituacion,
                            varauxresultado, ind_no_lit, ind_nocontactado,
                            varfref, vardini, vardfin, r_vivienda.ute,
                             r_vivienda.ic, r_vivienda.icnombre, r_vivienda.ictlfno, r_vivienda.icemail, r_vivienda.icrelacion, r_vivienda.icobservaciones
                           );

               rnumcactual := r_vivienda.numc;
               raencactual := r_vivienda.aenc;
               rtencactual := r_vivienda.tenc;

               BEGIN
                  /* ahora tratamos los individuos de esa vivienda*/
                  FOR r_individuos IN c_individuos (rnumcactual,
                                                    raencactual,
                                                    rtencactual
                                                   )
                  LOOP
                     BEGIN
                        INSERT INTO praw02t00
                                    (numc, nind,
                                     aenc, tenc,
                                     formfam, formper, resper, resfam,
                                     nomb, ape1,
                                     ape2, indper,
                                     edad, sexo,
                                     dni, fnac,
                                     sita, lnac,
                                     naci, indfam, infper,
                                     repp, conyu, madre, padre, orden,
                                     PASSWORD,
                                     nprf, siem,cl_upb ,tlfno1,tlfno2,email
                                    )
                             VALUES (r_individuos.numc, r_individuos.nind,
                                     varauxanio_nuevo, varauxtrim_nuevo,
                                     NULL, NULL, NULL, pendienterellenar,
                                     r_individuos.nomb, r_individuos.ape1,
                                     r_individuos.ape2, ind_si_lit,
                                     r_individuos.edad, r_individuos.sexo,
                                     r_individuos.dni, r_individuos.fnac,
                                     ind_permanece, r_individuos.lnac,
                                     r_individuos.naci, ind_no_lit, NULL,
                                     NULL, NULL, NULL, NULL, NULL,
                                     TO_CHAR (r_individuos.fnac, 'DDMMYYYY'),
                                     NULL, ind_empadronado,r_individuos.cl_upb ,r_individuos.tlfno1,r_individuos.tlfno2,r_individuos.email
                                    );

                        COMMIT;
                     EXCEPTION
                        WHEN OTHERS
                        THEN
                           strerror := SQLERRM;

                           INSERT INTO errores_cierre
                                       (fecha, tipo,
                                        error,
                                        numc,
                                        aenc,
                                        TRIM, nind
                                       )
                                VALUES (SYSDATE, 'M',
                                           '  No se pudo insertar en la tabla de individuos el individuo: '
                                        || '. Ocurrio el siguiente error: '
                                        || strerror,
                                        r_individuos.numc,
                                        r_individuos.aenc,
                                        r_individuos.tenc, r_individuos.nind
                                       );

                           /*si se produce un error al cargar un individuo borro su vivienda*/
                           DELETE FROM praw01t00 viv
                                 WHERE viv.numc = r_individuos.numc
                                   AND viv.aenc = varauxanio_nuevo
                                   AND viv.tenc = varauxtrim_nuevo;

                           DELETE FROM praw02t00 ind
                                 WHERE ind.numc = r_individuos.numc
                                   AND ind.aenc = varauxanio_nuevo
                                   AND ind.tenc = varauxtrim_nuevo;

                           COMMIT;
                           EXIT;
                     END;
                  END LOOP;
               END;
            EXCEPTION
               WHEN OTHERS
               THEN
                  strerror := SQLERRM;

                  INSERT INTO errores_cierre
                              (fecha, tipo,
                               error,
                               numc, aenc,
                               TRIM, nind
                              )
                       VALUES (SYSDATE, 'M',
                                  'No se pudo insertar en la tabla de viviendas la vivienda: '
                               || '. Ocurrio el siguiente error: '
                               || strerror,
                               r_vivienda.numc, r_vivienda.aenc,
                               r_vivienda.tenc, NULL
                              );

                  COMMIT;
            END;
         END IF;

         strerror := '';
      END LOOP;
   END;
EXCEPTION
   WHEN NO_DATA_FOUND
   THEN
      NULL;
   WHEN OTHERS
   THEN
      -- Consider logging the error and then re-raise
      RAISE;
END Cierre_Mensual;
/


--
-- CODIFICADOR_LITERALES  (Procedure) 
--
CREATE OR REPLACE PROCEDURE GEDW.Codificador_Literales (tipo IN VARCHAR2)
IS
   tmpvar   NUMBER;
/******************************************************************************
   NAME:       CODIFICAR_LITERALES
   PURPOSE:

   REVISIONS:
   Ver        Date        Author           Description
   ---------  ----------  ---------------  ------------------------------------
   1.0        17/09/2014          1. Created this procedure.

   NOTES:

   Automatically available Auto Replace Keywords:
      Object Name:     CODIFICAR_LITERALES
      Sysdate:         17/09/2014
      Date and Time:   17/09/2014, 12:31:41, and 17/09/2014 12:31:41
      Username:         (set in TOAD Options, Procedure Editor)
      Table Name:       (set in the "New PL/SQL Object" dialog)

******************************************************************************/
BEGIN
   -- Cursor para obtener los individuos pertenecientes a ese Numc
   DECLARE
      varcod       praw19t00.cod%TYPE;
      varliteral   praw19t00.literal%TYPE;
      vartipo      praw19t00.tipo%TYPE;
      varrazon     praw19t00.razon%TYPE;
      varerror     praw19t00.error%TYPE;
      ptipo        praw19t00.tipo%TYPE;
      varauxcod    praw19t00.cod%TYPE;
      strerror     VARCHAR2 (1024);
      varanio      praw01t00.aenc%TYPE;
      vartrim      praw01t00.tenc%TYPE;
      varnumc      praw01t00.numc%TYPE;
      varsituac    praw01t00.situac%TYPE;
      varnumcaux   praw01t00.numc%TYPE;

      CURSOR c_codificacion (ptipo IN praw19t00.tipo%TYPE)
      IS
         SELECT   cod, literal, tipo, razon, error,litact
             FROM praw19t00
            WHERE tipo = ptipo
         ORDER BY cod, literal, tipo;

      CURSOR c_viviendas_finalizada
      IS
         SELECT DISTINCT b.aenc, b.tenc, b.numc
                    FROM praw11t01 a, praw01t00 b
                   WHERE a.aenc = b.aenc
                     AND a.tenc = b.tenc
                     AND a.numc = b.numc
                     AND (   (    empl = 'S'
                              AND (    (    prof2 IS NOT NULL
                                        AND lprof2 IS NOT NULL
                                       )
                                   AND (    ract2 IS NOT NULL
                                        AND lract2 IS NOT NULL
                                       )
                                  )
                             )
                          OR (    empoc = 'S'
                              AND (    (    prof3 IS NOT NULL
                                        AND lprof3 IS NOT NULL
                                       )
                                   AND (    ract3 IS NOT NULL
                                        AND lract3 IS NOT NULL
                                       )
                                  )
                             )
                          OR (    afam = 'S'
                              AND (    (    prof1 IS NOT NULL
                                        AND lprof1 IS NOT NULL
                                       )
                                   AND (    ract1 IS NOT NULL
                                        AND lract1 IS NOT NULL
                                       )
                                  )
                             )
                          OR (    (lprof4 IS NOT NULL AND prof4 IS NOT NULL)
                              AND (lract4 IS NOT NULL AND ract4 IS NOT NULL)
                             )
                         )
                     AND (situac = 5);

      CURSOR c_viviendas_finfuera
      IS
         SELECT DISTINCT b.aenc, b.tenc, b.numc
                    FROM praw11t01 a, praw01t00 b
                   WHERE a.aenc = b.aenc
                     AND a.tenc = b.tenc
                     AND a.numc = b.numc
                     AND (   (    empl = 'S'
                              AND (    (    prof2 IS NOT NULL
                                        AND lprof2 IS NOT NULL
                                       )
                                   AND (    ract2 IS NOT NULL
                                        AND lract2 IS NOT NULL
                                       )
                                  )
                             )
                          OR (    empoc = 'S'
                              AND (    (    prof3 IS NOT NULL
                                        AND lprof3 IS NOT NULL
                                       )
                                   AND (    ract3 IS NOT NULL
                                        AND lract3 IS NOT NULL
                                       )
                                  )
                             )
                          OR (    afam = 'S'
                              AND (    (    prof1 IS NOT NULL
                                        AND lprof1 IS NOT NULL
                                       )
                                   AND (    ract1 IS NOT NULL
                                        AND lract1 IS NOT NULL
                                       )
                                  )
                             )
                          OR (    (lprof4 IS NOT NULL AND prof4 IS NOT NULL)
                              AND (lract4 IS NOT NULL AND ract4 IS NOT NULL)
                             )
                         )
                     AND (situac = 6);
   BEGIN
      ptipo := tipo;

      /* ahora tratamos los registros de ese tipo*/
      FOR r_trat_codificacion IN c_codificacion (ptipo)
      LOOP
         IF c_codificacion%FOUND
         THEN
            IF (tipo = 'P')
            THEN
               /* tratamiento profesiones */
               BEGIN
                  /* compruebo que el codigo introducido es vlido  existe en PRAW04T00 */
                  SELECT cno11
                    INTO varauxcod
                    FROM praw04t00
                   WHERE cno11 = r_trat_codificacion.cod;

                  BEGIN
                     /* compruebo que ese literal no existe ya previamente en la tabla de profesiones (praw17t00)*/
                     SELECT cno11
                       INTO varauxcod
                       FROM praw17t00
                      WHERE UPPER(literal) = UPPER(r_trat_codificacion.literal)
                      AND UPPER(LITACT) = UPPER(r_trat_codificacion.litact);

                     /* el codigo  pertenece ya en la tabla de profesiones (praw17t00) */
                     UPDATE praw19t00
                        SET error =
                               'El literal introducido ya ha sido codificado previamente'
                      WHERE cod = r_trat_codificacion.cod
                        AND  UPPER(literal) =  UPPER(r_trat_codificacion.literal)
                        AND  UPPER(LITACT) =  UPPER(r_trat_codificacion.litact);
                  EXCEPTION
                     WHEN OTHERS
                     THEN
                        /* registro vlido */
                        BEGIN
                           INSERT INTO praw17t00
                                       (cno11,
                                        literal,
                                        litact
                                       )
                                VALUES (r_trat_codificacion.cod,
                                        r_trat_codificacion.literal,
                                         r_trat_codificacion.litact
                                       );

                           UPDATE praw11t01
                              SET prof1 = r_trat_codificacion.cod
                            WHERE UPPER(lprof1) = UPPER(r_trat_codificacion.literal)
                            AND UPPER(lract1) = UPPER(r_trat_codificacion.litact);

                           UPDATE praw11t01
                              SET prof2 = r_trat_codificacion.cod
                            WHERE UPPER(lprof2) = UPPER(r_trat_codificacion.literal)
                            AND UPPER(lract2) = UPPER(r_trat_codificacion.litact);

                           UPDATE praw11t01
                              SET prof3 = r_trat_codificacion.cod
                            WHERE UPPER(lprof3) = UPPER(r_trat_codificacion.literal)
                            AND UPPER(lract3) = UPPER(r_trat_codificacion.litact);
                            
                           UPDATE praw11t01
                              SET prof4 = r_trat_codificacion.cod
                            WHERE UPPER(lprof4) = UPPER(r_trat_codificacion.literal) 
                            AND UPPER(lract4) = UPPER(r_trat_codificacion.litact);

                           /* borramos de la tabla de codificacion el registro porque ya lo hemos tratado*/
                           DELETE FROM praw19t00
                                 WHERE cod = r_trat_codificacion.cod
                                   AND UPPER(literal) = UPPER(r_trat_codificacion.literal) 
                        AND UPPER(LITACT) = UPPER(r_trat_codificacion.litact);
                        
                        EXCEPTION
                           WHEN OTHERS
                           THEN
                              strerror := SQLERRM;

                              UPDATE praw19t00
                                 SET error = strerror
                               WHERE cod = r_trat_codificacion.cod
                                 AND  UPPER(literal) =  UPPER(r_trat_codificacion.literal)
                                 AND  UPPER(LITACT) =  UPPER(r_trat_codificacion.litact);
                        END;
                  END;
               EXCEPTION
                  WHEN OTHERS
                  THEN
                     /* el codigo no pertenece a un codigo vlido */
                     UPDATE praw19t00
                        SET error =
                               'El cdigo introducido no pertenece al listado de profesiones admitidas'
                      WHERE cod = r_trat_codificacion.cod
                        AND UPPER(literal) = UPPER(r_trat_codificacion.literal)
                        AND UPPER(LITACT) = UPPER(r_trat_codificacion.litact);
               END;
            /* fin  tratamiento profesiones */
            ELSE
               /* tratamiento actividades */
               BEGIN
                  /* compruebo que el codigo introducido es vlido  existe en PRAW04T00 */
                  SELECT cnae09
                    INTO varauxcod
                    FROM praw05t00
                   WHERE cnae09 = r_trat_codificacion.cod;

                  BEGIN
                     /* compruebo que ese literal y la razon no existen ya previamente en la tabla de actividades (praw18t00)*/
                     SELECT cnae09
                       INTO varauxcod
                       FROM praw18t00
                      WHERE UPPER(literal) = UPPER(r_trat_codificacion.literal)
                        AND UPPER(razon) = UPPER(r_trat_codificacion.razon);

                     /* el codigo  pertenece ya en la tabla de actividades (praw18t00) */
                     IF r_trat_codificacion.razon IS NULL
                     THEN
                        UPDATE praw19t00
                           SET error =
                                  'El literal introducido ya ha sido codificado previamente'
                         WHERE cod = r_trat_codificacion.cod
                           AND UPPER(literal) = UPPER(r_trat_codificacion.literal)
                           AND razon IS NULL;
                     ELSE
                        UPDATE praw19t00
                           SET error =
                                  'El literal introducido ya ha sido codificado previamente'
                         WHERE cod = r_trat_codificacion.cod
                           AND UPPER(literal) = UPPER(r_trat_codificacion.literal)
                           AND UPPER(razon) = UPPER(r_trat_codificacion.razon);
                     END IF;
                  EXCEPTION
                     WHEN OTHERS
                     THEN
                        /* registro vlido */
                        BEGIN
                           INSERT INTO praw18t00
                                       (cnae09,
                                        literal,
                                        razon
                                       )
                                VALUES (r_trat_codificacion.cod,
                                        r_trat_codificacion.literal,
                                        r_trat_codificacion.razon
                                       );

                           IF r_trat_codificacion.razon IS NULL
                           THEN
                              UPDATE praw11t01
                                 SET ract1 = r_trat_codificacion.cod
                               WHERE UPPER(lract1) = UPPER(r_trat_codificacion.literal)
                                 AND razs1 IS NULL;

                              UPDATE praw11t01
                                 SET ract2 = r_trat_codificacion.cod
                               WHERE UPPER(lract2) = UPPER(r_trat_codificacion.literal)
                                 AND razs2 IS NULL;

                              UPDATE praw11t01
                                 SET ract3 = r_trat_codificacion.cod
                               WHERE UPPER(lract3) = UPPER(r_trat_codificacion.literal)
                                 AND razs3 IS NULL;

                              UPDATE praw11t01
                                 SET ract4 = r_trat_codificacion.cod
                               WHERE lract4 IS NULL
                               AND razs4 IS NULL;

                              /* borramos de la tabla de codificacion el registro porque ya lo hemos tratado*/
                              DELETE FROM praw19t00
                                    WHERE cod = r_trat_codificacion.cod
                                      AND UPPER(literal) =
                                                   UPPER(r_trat_codificacion.literal)
                                      AND razon IS NULL;
                           ELSE
                              UPDATE praw11t01
                                 SET ract1 = r_trat_codificacion.cod
                               WHERE UPPER(lract1) = UPPER(r_trat_codificacion.literal)
                                 AND UPPER(razs1) = UPPER(r_trat_codificacion.razon);

                              UPDATE praw11t01
                                 SET ract2 = r_trat_codificacion.cod
                              WHERE UPPER(lract2) = UPPER(r_trat_codificacion.literal)
                                 AND UPPER(razs2) = UPPER(r_trat_codificacion.razon);

                              UPDATE praw11t01
                                 SET ract3 = r_trat_codificacion.cod
                               WHERE UPPER(lract3) = UPPER(r_trat_codificacion.literal)
                                 AND UPPER(razs3) = UPPER(r_trat_codificacion.razon);

                              UPDATE praw11t01
                                 SET ract4 = r_trat_codificacion.cod
                               WHERE UPPER(lract4) = UPPER(r_trat_codificacion.literal)
                                 AND UPPER(razs4) = UPPER(r_trat_codificacion.razon);

                              /* borramos de la tabla de codificacion el registro porque ya lo hemos tratado*/
                              DELETE FROM praw19t00
                                    WHERE cod = r_trat_codificacion.cod
                                      AND uPPER(literal) =
                                                   UPPER(r_trat_codificacion.literal)
                                      AND UPPER(razon) = UPPER(r_trat_codificacion.razon);
                           END IF;
                        EXCEPTION
                           WHEN OTHERS
                           THEN
                              strerror := SQLERRM;

                              UPDATE praw19t00
                                 SET error = strerror
                               WHERE cod = r_trat_codificacion.cod
                                 AND UPPER(literal) = UPPER(r_trat_codificacion.literal)
                                 AND UPPER(razon) = UPPER(r_trat_codificacion.razon);

                              IF r_trat_codificacion.razon IS NULL
                              THEN
                                 UPDATE praw19t00
                                    SET error = strerror
                                  WHERE cod = r_trat_codificacion.cod
                                    AND UPPER(literal) = UPPER(r_trat_codificacion.literal)
                                    AND razon IS NULL;
                              ELSE
                                 UPDATE praw19t00
                                    SET error = strerror
                                  WHERE cod = r_trat_codificacion.cod
                                    AND UPPER(literal) = UPPER(r_trat_codificacion.literal)
                                    AND UPPER(razon) = UPPER(r_trat_codificacion.razon);
                              END IF;
                        END;
                  END;
               EXCEPTION
                  WHEN OTHERS
                  THEN
                     /* el codigo no pertenece a un codigo vlido */
                     IF r_trat_codificacion.razon IS NULL
                     THEN
                        UPDATE praw19t00
                           SET error =
                                  'El cdigo introducido no pertenece al listado de actividades admitidas'
                         WHERE cod = r_trat_codificacion.cod
                            AND UPPER(literal) = UPPER(r_trat_codificacion.literal)
                                    AND razon IS NULL;
                     ELSE
                        UPDATE praw19t00
                           SET error =
                                  'El cdigo introducido no pertenece al listado de actividades admitidas'
                         WHERE cod = r_trat_codificacion.cod
                           AND UPPER(literal) = UPPER(r_trat_codificacion.literal)
                                    AND UPPER(razon) = UPPER(r_trat_codificacion.razon);
                     END IF;
               END;
            /* fin  tratamiento actividades */
            END IF;
         END IF;
      END LOOP;

      BEGIN
         /* cuando termino todo el tratamiento reviso las viviendas para si procede cambiar la situacion de aquellas que se hayan codificado */
         OPEN c_viviendas_finalizada;

         LOOP
            FETCH c_viviendas_finalizada
             INTO varanio, vartrim, varnumc;

            IF c_viviendas_finalizada%FOUND
            THEN
               BEGIN
                  SELECT DISTINCT b.numc
                             INTO varnumcaux
                             FROM praw11t01 a, praw01t00 b
                            WHERE b.aenc = a.aenc
                              AND b.tenc = a.tenc
                              AND b.numc = a.numc
                              AND (   (    empl = 'S'
                                       AND (   (    prof2 IS NULL
                                                AND lprof2 IS NOT NULL
                                               )
                                            OR (    ract2 IS NULL
                                                AND lract2 IS NOT NULL
                                               )
                                           )
                                      )
                                   OR (    empoc = 'S'
                                       AND (   (    prof3 IS NULL
                                                AND lprof3 IS NOT NULL
                                               )
                                            OR (    ract3 IS NULL
                                                AND lract3 IS NOT NULL
                                               )
                                           )
                                      )
                                   OR (    afam = 'S'
                                       AND (   (    prof1 IS NULL
                                                AND lprof1 IS NOT NULL
                                               )
                                            OR (    ract1 IS NULL
                                                AND lract1 IS NOT NULL
                                               )
                                           )
                                      )
                                   OR ((   (    lprof4 IS NOT NULL
                                            AND prof4 IS NULL
                                           )
                                        OR (    lract4 IS NOT NULL
                                            AND ract4 IS NULL
                                           )
                                       )
                                      )
                                  )
                              AND (situac = 5)
                              AND b.aenc = varanio
                              AND b.tenc = vartrim
                              AND b.numc = varnumc; 
               EXCEPTION
                  WHEN NO_DATA_FOUND
                  THEN
                     UPDATE praw01t00
                     SET situac = 2
                   WHERE aenc = varanio AND numc = varnumc AND tenc = vartrim;
       
               END;
            END IF;

            EXIT WHEN c_viviendas_finalizada%NOTFOUND;
         END LOOP;

         CLOSE c_viviendas_finalizada;
      END;

      BEGIN
         /* cuando termino todo el tratamiento reviso las viviendas para si procede cambiar la situacion de aquellas que se hayan codificado */
         OPEN c_viviendas_finfuera;

         LOOP
            FETCH c_viviendas_finfuera
             INTO varanio, vartrim, varnumc;

            IF c_viviendas_finfuera%FOUND
            THEN
               BEGIN
                  SELECT DISTINCT b.numc
                             INTO varnumcaux
                             FROM praw11t01 a, praw01t00 b
                            WHERE b.aenc = a.aenc
                              AND b.tenc = a.tenc
                              AND b.numc = a.numc
                              AND (   (    empl = 'S'
                                       AND (   (    prof2 IS NULL
                                                AND lprof2 IS NOT NULL
                                               )
                                            OR (    ract2 IS NULL
                                                AND lract2 IS NOT NULL
                                               )
                                           )
                                      )
                                   OR (    empoc = 'S'
                                       AND (   (    prof3 IS NULL
                                                AND lprof3 IS NOT NULL
                                               )
                                            OR (    ract3 IS NULL
                                                AND lract3 IS NOT NULL
                                               )
                                           )
                                      )
                                   OR (    afam = 'S'
                                       AND (   (    prof1 IS NULL
                                                AND lprof1 IS NOT NULL
                                               )
                                            OR (    ract1 IS NULL
                                                AND lract1 IS NOT NULL
                                               )
                                           )
                                      )
                                   OR ((   (    lprof4 IS NOT NULL
                                            AND prof4 IS NULL
                                           )
                                        OR (    lract4 IS NOT NULL
                                            AND ract4 IS NULL
                                           )
                                       )
                                      )
                                  )
                              AND (situac = 6)
                              AND b.aenc = varanio
                              AND b.tenc = vartrim
                              AND b.numc = varnumc;

                  EXCEPTION
                  WHEN NO_DATA_FOUND
                  THEN
                     UPDATE praw01t00
                     SET situac = 7
                   WHERE aenc = varanio AND numc = varnumc AND tenc = vartrim;
               END;
            END IF;

            EXIT WHEN c_viviendas_finfuera%NOTFOUND;
         END LOOP;

         CLOSE c_viviendas_finfuera;
      END;
   COMMIT;
   END;
EXCEPTION
   WHEN NO_DATA_FOUND
   THEN
   ROLLBACK;
      NULL;
   WHEN OTHERS
   THEN
      ROLLBACK;
      -- Consider logging the error and then re-raise
      RAISE;
END Codificador_Literales;
/


--
-- EPTW12T01VIEW  (View) 
--
CREATE OR REPLACE FORCE VIEW GEDW.EPTW12T01VIEW
(AENC, TENC, NUMC, ORDACT, LUGAR, 
 H_INIC, H_FIN, ACTP3, ACTS3, COMP, 
 COMP_1, FINAL, DURACION)
BEQUEATH DEFINER
AS 
SELECT AENC,
          TENC,
          NUMC,
          ORDACT,
          LUGAR,
          H_INIC,
          H_FIN,
          ACTP3,
          ACTS3,
          COMP,
          COMP_1,
          FINAL,
            (    REGEXP_SUBSTR (
                    CASE WHEN H_FIN = '00:00' THEN '24:00' ELSE H_FIN END,
                    '[^:]+',
                    1,
                    1)
               * 60
             + REGEXP_SUBSTR (H_FIN,
                              '[^:]+',
                              1,
                              2))
          - (    REGEXP_SUBSTR (H_INIC,
                                '[^:]+',
                                1,
                                1)
               * 60
             + REGEXP_SUBSTR (H_INIC,
                              '[^:]+',
                              1,
                              2))
             AS DURACION
     FROM EPTW12T01;


--
-- VW_ECVW_VAL_GENERAL  (View) 
--
CREATE OR REPLACE FORCE VIEW GEDW.VW_ECVW_VAL_GENERAL
(NUMC, AENC, TAMANO_FAMILIAR, TOTAL_SERVICIO_DOMESTICO)
BEQUEATH DEFINER
AS 
SELECT VIV.NUMC,
          VIV.AENC,
          (SELECT COUNT (IND.SITA)
             FROM ECVW02T00 IND
            WHERE     VIV.NUMC = IND.NUMC
                  AND VIV.AENC = IND.AENC
                  AND (IND.SITA = '1' OR IND.SITA = '2'))
             AS TAMANO_FAMILIAR,
          (SELECT COUNT (IND.REPP)
             FROM ECVW02T00 IND
            WHERE     VIV.NUMC = IND.NUMC
                  AND VIV.AENC = IND.AENC
                  AND IND.REPP = '9')
             AS TOTAL_SERVICIO_DOMESTICO
     FROM ECVW01T00 VIV;


--
-- VW_MUESTRA  (View) 
--
CREATE OR REPLACE FORCE VIEW GEDW.VW_MUESTRA
(NUMC, NIND, NOMB, APE1, APE2, 
 SEXO, FNAC, SITA, TERH, MUNR, 
 AENC, TENC, SENC, NOMA, DIREC, 
 CODP, LMUN, LTER, LCDIR, LENTP, 
 FREF, DINI, DFIN, TURN, TLFNO1, 
 TLFNO2, EMAIL, IDIOMA, IC, ICNOMBRE, 
 ICEMAIL, ICRELACION, ICOBSERVACIONES, ICTLFNO)
BEQUEATH DEFINER
AS 
SELECT t02.numc,
            t02.nind,
            t02.nomb,
            t02.ape1,
            t02.ape2,
            t02.sexo,
            t02.fnac,
            t02.sita,
            t01.terh,
            t01.munr,
            t01.aenc,
            t01.tenc,
            t01.senc,
            t01.noma,
            t01.direc,
            t01.codp,
            t01.lmun,
            t01.lter,
            t01.lcdir,
            t01.lentp,
            t01.fref,
            t01.dini,
            t01.dfin,
            t01.TURN,
            t02.tlfno1,
            t02.tlfno2,
            t02.EMAIL,
            idioma,
            t01.ic,
            t01.icemail,
            t01.icnombre,
            t01.icrelacion,
            t01.icobservaciones,
            t01.ictlfno
       FROM PRAW02T00 t02,
            PRAW01T00 t01,
            (SELECT IDIOMA, aenc, tenc, numc, nind FROM PRAW11T01)
            cuest_trimant
      WHERE     t01.numc = t02.numc
            AND t01.aenc = t02.aenc
            AND t01.tenc = t02.tenc
            AND cuest_trimant.numc(+) = t02.numc
            AND cuest_trimant.nind(+) = t02.nind
            AND cuest_trimant.aenc(+) =
                   (CASE TO_NUMBER (t02.tenc)
                       WHEN 1 THEN (t02.aenc - 1)
                       ELSE t02.aenc
                    END)
            AND cuest_trimant.tenc(+) =
                   (CASE TO_NUMBER (t02.tenc)
                       WHEN 1 THEN 4
                       ELSE (TO_NUMBER (t02.tenc) - 1)
                    END)
   ORDER BY t01.FREF, TO_NUMBER (t02.NUMC), TO_NUMBER (t02.NIND);

COMMENT ON TABLE GEDW.VW_MUESTRA IS 'Vista para la descarga de la muestra de la PRA desde la aplicacin PRAW por parte del responsable de los encustadores';


--
-- EPTW_TOTALES_DIARIO  (View) 
--
CREATE OR REPLACE FORCE VIEW GEDW.EPTW_TOTALES_DIARIO
(AENC, TENC, NUMC, TOTAL_ACTIVIDADES, TOTAL_MINUTOS, 
 VECES_HA_TRABAJADO, TOTAL_ACTIVIDADES_TRABAJO, TOTAL_SIN_INTERVALO, VECES_HA_DORMIDO, VECES_HA_COMIDO, 
 VECES_ASEADO, ACTIVIDADES_REPETIDAS, FALTAN_TRAYECTOS_LEVES, FALTAN_TRAYECTOS_GRAVES)
BEQUEATH DEFINER
AS 
SELECT e1.AENC,
            e1.TENC,
            e1.NUMC,
            COUNT (e1.ORDACT) AS TOTAL_ACTIVIDADES,
            SUM (e1.DURACION) AS TOTAL_MINUTOS,
            SUM (TRABAJAR) VECES_HA_TRABAJADO,
            SUM (ACTIVIDADES_TRABAJO) TOTAL_ACTIVIDADES_TRABAJO,
            SUM (TIENE_CONTINUACION) TOTAL_SIN_INTERVALO,
            SUM (DORMIR) VECES_HA_DORMIDO,
            SUM (COMER) VECES_HA_COMIDO,
            SUM (ASEAR) VECES_ASEADO,
            SUM (MISMA_ACTIVIDAD) ACTIVIDADES_REPETIDAS,
            SUM (FALTA_TRAYECTO_LEVE) FALTAN_TRAYECTOS_LEVES,
            SUM (FALTA_TRAYECTO_GRAVE) FALTAN_TRAYECTOS_GRAVES
       FROM (SELECT AENC,
                    TENC,
                    NUMC,
                    ORDACT,
                    DURACION,
                    CASE WHEN EPTW12T01VIEW.ACTP3 LIKE '2%' THEN 1 ELSE 0 END
                       AS TRABAJAR,
                    CASE
                       WHEN    EPTW12T01VIEW.ACTP3 LIKE '21%'
                            OR EPTW12T01VIEW.ACTP3 LIKE '22%'
                            OR EPTW12T01VIEW.ACTP3 LIKE '23%'
                            OR EPTW12T01VIEW.ACTP3 LIKE '24%'
                       THEN
                          1
                       ELSE
                          0
                    END
                       AS ACTIVIDADES_TRABAJO,
                    CASE
                       WHEN EXISTS
                               (SELECT e2.ORDACT
                                  FROM EPTW12T01 e2
                                 WHERE     e2.AENC = EPTW12T01VIEW.AENC
                                       AND e2.TENC = EPTW12T01VIEW.TENC
                                       AND e2.NUMC = EPTW12T01VIEW.NUMC
                                       AND (   e2.H_INIC = EPTW12T01VIEW.H_FIN
                                            OR (    e2.H_INIC = '00:00'
                                                AND EPTW12T01VIEW.H_FIN =
                                                       '24:00')))
                       THEN
                          1
                       ELSE
                          0
                    END
                       TIENE_CONTINUACION,
                    CASE WHEN EPTW12T01VIEW.ACTP3 LIKE '111' THEN 1 ELSE 0 END
                       AS DORMIR,
                    CASE
                       WHEN EPTW12T01VIEW.ACTP3 IN ('121', '122') THEN 1
                       ELSE 0
                    END
                       AS ASEAR,
                    CASE
                       WHEN EPTW12T01VIEW.ACTP3 IN ('141',
                                                    '142',
                                                    '143',
                                                    '144',
                                                    '145',
                                                    '146',
                                                    '147',
                                                    '148')
                       THEN
                          1
                       ELSE
                          0
                    END
                       AS COMER,
                    CASE
                       WHEN EXISTS
                               (SELECT e2.ORDACT
                                  FROM EPTW12T01 e2
                                 WHERE     e2.AENC = EPTW12T01VIEW.AENC
                                       AND e2.TENC = EPTW12T01VIEW.TENC
                                       AND e2.NUMC = EPTW12T01VIEW.NUMC
                                       AND e2.H_INIC = EPTW12T01VIEW.H_FIN
                                       AND e2.ACTP3 = EPTW12T01VIEW.ACTP3
                                       AND (   e2.ACTS3 = EPTW12T01VIEW.ACTS3
                                            OR (    e2.ACTS3 IS NULL
                                                AND EPTW12T01VIEW.ACTS3 IS NULL))
                                       AND e2.LUGAR = EPTW12T01VIEW.LUGAR
                                       AND e2.COMP = EPTW12T01VIEW.COMP
                                       AND e2.COMP_1 = EPTW12T01VIEW.COMP_1)
                       THEN
                          1
                       ELSE
                          0
                    END
                       MISMA_ACTIVIDAD,
                    CASE
                       WHEN EXISTS
                               (SELECT e2.ORDACT
                                  FROM EPTW12T01 e2
                                 WHERE     e2.AENC = EPTW12T01VIEW.AENC
                                       AND e2.TENC = EPTW12T01VIEW.TENC
                                       AND e2.NUMC = EPTW12T01VIEW.NUMC
                                       AND e2.H_INIC = EPTW12T01VIEW.H_FIN
                                       AND (   (    e2.LUGAR >= '21'
                                                AND e2.LUGAR <= '81'
                                                AND (    e2.LUGAR != 31
                                                     AND e2.LUGAR != 40
                                                     AND e2.LUGAR != 41)
                                                AND EPTW12T01VIEW.LUGAR >= '11'
                                                AND EPTW12T01VIEW.LUGAR <= '19'
                                                AND e2.ACTP3 NOT LIKE '8%')
                                            OR (    EPTW12T01VIEW.LUGAR >= '21'
                                                AND EPTW12T01VIEW.LUGAR <= '81'
                                                AND (    EPTW12T01VIEW.LUGAR !=
                                                            31
                                                     AND EPTW12T01VIEW.LUGAR !=
                                                            40
                                                     AND EPTW12T01VIEW.LUGAR !=
                                                            41)
                                                AND e2.LUGAR >= '11'
                                                AND e2.LUGAR <= '19'
                                                AND EPTW12T01VIEW.ACTP3 NOT LIKE
                                                       '8%')))
                       THEN
                          1
                       ELSE
                          0
                    END
                       FALTA_TRAYECTO_LEVE,
                    CASE
                       WHEN EXISTS
                               (SELECT e2.ORDACT
                                  FROM EPTW12T01 e2
                                 WHERE     e2.AENC = EPTW12T01VIEW.AENC
                                       AND e2.TENC = EPTW12T01VIEW.TENC
                                       AND e2.NUMC = EPTW12T01VIEW.NUMC
                                       AND e2.H_INIC = EPTW12T01VIEW.H_FIN
                                       AND (   (    e2.LUGAR = '91'
                                                AND EPTW12T01VIEW.LUGAR >= '11'
                                                AND EPTW12T01VIEW.LUGAR <= '19'
                                                AND e2.ACTP3 NOT LIKE '8%')
                                            OR (    EPTW12T01VIEW.LUGAR = '91'
                                                AND e2.LUGAR >= '11'
                                                AND e2.LUGAR <= '19'
                                                AND EPTW12T01VIEW.ACTP3 NOT LIKE
                                                       '8%')))
                       THEN
                          1
                       ELSE
                          0
                    END
                       FALTA_TRAYECTO_GRAVE
               FROM EPTW12T01VIEW) e1
   GROUP BY e1.AENC, e1.TENC, e1.NUMC;


-- 
-- Non Foreign Key Constraints for Table GEDW01T00 
-- 
ALTER TABLE GEDW.GEDW01T00 ADD (
  CONSTRAINT GEDW01I00
  PRIMARY KEY
  (CODUSU)
  USING INDEX GEDW.GEDW01I00
  ENABLE VALIDATE);


-- 
-- Non Foreign Key Constraints for Table GEDW02T00 
-- 
ALTER TABLE GEDW.GEDW02T00 ADD (
  CONSTRAINT GEDW02I00
  PRIMARY KEY
  (CODUSU, CODOPE)
  USING INDEX GEDW.GEDW02I00
  ENABLE VALIDATE);


-- 
-- Non Foreign Key Constraints for Table GEDW60T00 
-- 
ALTER TABLE GEDW.GEDW60T00 ADD (
  CONSTRAINT GEDW60I00
  PRIMARY KEY
  (CODSIT)
  USING INDEX GEDW.GEDW60I00
  ENABLE VALIDATE);


-- 
-- Non Foreign Key Constraints for Table GEDW61T00 
-- 
ALTER TABLE GEDW.GEDW61T00 ADD (
  CONSTRAINT GEDW61I00
  PRIMARY KEY
  (CODRVIV)
  USING INDEX GEDW.GEDW61I00
  ENABLE VALIDATE);


-- 
-- Non Foreign Key Constraints for Table GEDW61T01 
-- 
ALTER TABLE GEDW.GEDW61T01 ADD (
  CONSTRAINT GEDW61I01
  PRIMARY KEY
  (RVIVOPE_CODRVIV, RVIVOPE_CODOPE)
  USING INDEX GEDW.GEDW61I01
  ENABLE VALIDATE);


-- 
-- Non Foreign Key Constraints for Table GEDW62T00 
-- 
ALTER TABLE GEDW.GEDW62T00 ADD (
  CONSTRAINT GEDW62I00
  PRIMARY KEY
  (CODRCON)
  USING INDEX GEDW.GEDW62I00
  ENABLE VALIDATE);


-- 
-- Non Foreign Key Constraints for Table GEDW63T00 
-- 
ALTER TABLE GEDW.GEDW63T00 ADD (
  CONSTRAINT GEDW63I00
  PRIMARY KEY
  (CODRCUE)
  USING INDEX GEDW.GEDW63I00
  ENABLE VALIDATE);


-- 
-- Non Foreign Key Constraints for Table GEDW63T01 
-- 
ALTER TABLE GEDW.GEDW63T01 ADD (
  CONSTRAINT GEDW63I01
  PRIMARY KEY
  (RCUESTOPE_CODRCUEST, RCUESTOPE_CODOPE)
  USING INDEX GEDW.GEDW63I01
  ENABLE VALIDATE);


-- 
-- Non Foreign Key Constraints for Table GEDW64T00 
-- 
ALTER TABLE GEDW.GEDW64T00 ADD (
  CONSTRAINT GEDW64I00
  PRIMARY KEY
  (CODLNAC)
  USING INDEX GEDW.GEDW64I00
  ENABLE VALIDATE);


-- 
-- Non Foreign Key Constraints for Table GEDW65T00 
-- 
ALTER TABLE GEDW.GEDW65T00 ADD (
  CONSTRAINT GEDW65I00
  PRIMARY KEY
  (CODNACI)
  USING INDEX GEDW.GEDW65I00
  ENABLE VALIDATE);


-- 
-- Non Foreign Key Constraints for Table GEDW66T00 
-- 
ALTER TABLE GEDW.GEDW66T00 ADD (
  CONSTRAINT GEDW66I00
  PRIMARY KEY
  (CODFORM)
  USING INDEX GEDW.GEDW66I00
  ENABLE VALIDATE);


-- 
-- Non Foreign Key Constraints for Table GEDW68T00 
-- 
ALTER TABLE GEDW.GEDW68T00 ADD (
  CONSTRAINT PK_GEDW67T00
  PRIMARY KEY
  (CODPINC)
  USING INDEX GEDW.PK_GEDW67T00
  ENABLE VALIDATE);


-- 
-- Non Foreign Key Constraints for Table GEDW69T00 
-- 
ALTER TABLE GEDW.GEDW69T00 ADD (
  CONSTRAINT GEDW69I00
  PRIMARY KEY
  (CODOPE, NOMEXC)
  USING INDEX GEDW.GEDW69I00
  ENABLE VALIDATE);


-- 
-- Non Foreign Key Constraints for Table GEDW70T00 
-- 
ALTER TABLE GEDW.GEDW70T00 ADD (
  CONSTRAINT GEDW70I00
  PRIMARY KEY
  (CODUSU, CODOPE, LOTE)
  USING INDEX GEDW.GEDW70I00
  ENABLE VALIDATE);


-- 
-- Non Foreign Key Constraints for Table GEDW71T00 
-- 
ALTER TABLE GEDW.GEDW71T00 ADD (
  CONSTRAINT GEDW71T00_PK
  PRIMARY KEY
  (IDDESCARGA)
  USING INDEX GEDW.GEDW71T00_PK
  ENABLE VALIDATE);


-- 
-- Non Foreign Key Constraints for Table GEDW89T00 
-- 
ALTER TABLE GEDW.GEDW89T00 ADD (
  CONSTRAINT GEDW89T00_PK
  PRIMARY KEY
  (PCA_ID)
  USING INDEX GEDW.GEDW89T00_PK
  ENABLE VALIDATE);


-- 
-- Non Foreign Key Constraints for Table GEDW90T00 
-- 
ALTER TABLE GEDW.GEDW90T00 ADD (
  CONSTRAINT GEDW90I00
  PRIMARY KEY
  (PNL_ID)
  USING INDEX GEDW.GEDW90I00
  ENABLE VALIDATE);


-- 
-- Non Foreign Key Constraints for Table GEDW91T00 
-- 
ALTER TABLE GEDW.GEDW91T00 ADD (
  CONSTRAINT GEDW91I00
  PRIMARY KEY
  (CAB_ID)
  USING INDEX GEDW.GEDW91I00
  ENABLE VALIDATE);


-- 
-- Foreign Key Constraints for Table GEDW02T00 
-- 
ALTER TABLE GEDW.GEDW02T00 ADD (
  CONSTRAINT FK_GEDW0200_01 
  FOREIGN KEY (CODUSU) 
  REFERENCES GEDW.GEDW01T00 (CODUSU)
  ENABLE VALIDATE);


-- 
-- Foreign Key Constraints for Table GEDW61T01 
-- 
ALTER TABLE GEDW.GEDW61T01 ADD (
  CONSTRAINT GEDW61T01_GEDW61T00_FK1 
  FOREIGN KEY (RVIVOPE_CODRVIV) 
  REFERENCES GEDW.GEDW61T00 (CODRVIV)
  ON DELETE CASCADE
  ENABLE VALIDATE);


-- 
-- Foreign Key Constraints for Table GEDW63T01 
-- 
ALTER TABLE GEDW.GEDW63T01 ADD (
  CONSTRAINT GEDW63T01_GEDW63T00_FK1 
  FOREIGN KEY (RCUESTOPE_CODRCUEST) 
  REFERENCES GEDW.GEDW63T00 (CODRCUE)
  ENABLE VALIDATE);


-- 
-- Foreign Key Constraints for Table GEDW71T00 
-- 
ALTER TABLE GEDW.GEDW71T00 ADD (
  CONSTRAINT GEDW71T00_GEDW01T00_FK1 
  FOREIGN KEY (CODUSU) 
  REFERENCES GEDW.GEDW01T00 (CODUSU)
  ENABLE VALIDATE);


-- 
-- Foreign Key Constraints for Table GEDW90T00 
-- 
ALTER TABLE GEDW.GEDW90T00 ADD (
  CONSTRAINT GEDW90T00_R01 
  FOREIGN KEY (PNL_CABID) 
  REFERENCES GEDW.GEDW89T00 (PCA_ID)
  ENABLE VALIDATE);


GRANT SELECT ON GEDW.GEDW64T00 TO ECSW;

GRANT SELECT ON GEDW.GEDW65T00 TO ECSW;

GRANT SELECT ON GEDW.GEDW67T00 TO ECSW;

GRANT SELECT ON GEDW.GEDW64T00 TO ECVW;

GRANT SELECT ON GEDW.GEDW65T00 TO ECVW;

GRANT SELECT ON GEDW.GEDW67T00 TO ECVW;

GRANT SELECT ON GEDW.GEDW64T00 TO EDVW;

GRANT SELECT ON GEDW.GEDW65T00 TO EDVW;

GRANT SELECT ON GEDW.GEDW67T00 TO EDVW;

GRANT SELECT ON GEDW.GEDW64T00 TO EMAFW;

GRANT SELECT ON GEDW.GEDW65T00 TO EMAFW;

GRANT SELECT ON GEDW.GEDW67T00 TO EMAFW;

GRANT SELECT ON GEDW.GEDW68T00 TO EMAFW;

GRANT SELECT ON GEDW.GEDW64T00 TO EPTW;

GRANT SELECT ON GEDW.GEDW65T00 TO EPTW;

GRANT SELECT ON GEDW.GEDW67T00 TO EPTW;

GRANT INHERIT PRIVILEGES ON USER GEDW TO PUBLIC;

GRANT SELECT ON GEDW.GEDW01T00 TO SARW;

GRANT EXECUTE ON GEDW.P_GED_INTERFACE TO AGI;

