Imports Eustat.Comun.V35.Fmk.Ng
Imports Eustat.Comun.V35.Ng.Errores
Imports Eustat.Comun.V35.Web
Imports System.Data
Imports System.Xml

Partial Class WebUserControls_MenuInfo
    Inherits System.Web.UI.UserControl

#Region "VARIABLES"
    Private mapa As Eustat.Comun.V35.Web.Map

    Private _sesion As AppSession
#End Region

    Protected Sub Page_Init(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Init
        If (_sesion Is Nothing) Then
            _sesion = New AppSession
        End If
    End Sub

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As EventArgs) Handles Me.Load
        Try
            '*** ESTILOS DEL MAPA DE NAVEGACION DEL CUESTIONARIO ***'
            Dim css As New HtmlLink()
            css.ID = "DefaultMenuInfoStyle"
            css.Href = ConfigurationManager.AppSettings("Style") + "menuinfo/eustat_menuinfo.css"
            css.Attributes.Add("rel", "stylesheet")
            css.Attributes.Add("type", "text/css")
            Page.Header.Controls.Add(css)

            'Estilo error
            css = New HtmlLink()
            css.Href = ConfigurationManager.AppSettings("Style") + "error/eustat_error.css"
            css.Attributes.Add("rel", "stylesheet")
            css.Attributes.Add("type", "text/css")
            Page.Header.Controls.AddAt(2, css)
            css.Dispose()

            '*** OBTENER REFERENCIA DEL MAPA ***'
            Dim minfo As System.Reflection.PropertyInfo = Me.Page.Master.GetType().GetProperty("GetMap", GetType(Eustat.Comun.V35.Web.Map))
            If minfo IsNot Nothing Then
                mapa = minfo.GetValue(Page.Master, Nothing)
            End If

        Catch ex As Exception
            GestionError(ex)
        End Try
    End Sub

    Protected Sub Page_PreRender(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.PreRender
        Try
            '*** BBDD ***'
            Dim pagValue As String = String.Empty
            Dim Panel As CollapsiblePanelNG = New CollapsiblePanelNG()
            
            pagValue = Me.Page.AppRelativeVirtualPath
            ' Sustituciones dinmicas del contenido de BBDD
            Dim dtAux As New DataSet
            Dim strXML = AsignarXML(Panel.Cargar(pagValue, _sesion.Operacion, _sesion.Perfil).GetXml)
            dtAux.ReadXml(New XmlTextReader(New System.IO.StringReader(strXML)))
            CollapsiblePanel1.DataSource = dtAux
            CollapsiblePanel1.DataBind()

            '*** LOGICA DE VISUALIZACION DEL PANEL PLEGABLE ***'
            Try
                If (Not Page.IsValid) Then
                    CollapsiblePanel2.NoCollapse = True
                    CollapsiblePanel1.NoCollapse = False
                    CollapseItems(CollapsiblePanel1, True)
                Else
                    CollapsiblePanel1.NoCollapse = True
                    CollapsiblePanel2.NoCollapse = False
                    CollapseItems(CollapsiblePanel2, True)
                End If
                CollapsiblePanel2.DataBind()
            Catch ex As Exception
                CollapsiblePanel1.NoCollapse = True
                CollapsiblePanel2.Visible = False
            End Try

            '*** CARGAR CONTENIDO DINAMICO DESDE PAGINAS ***'
            ScriptManager.RegisterStartupScript(Me, Me.GetType(), "loadCollapsiblePanelContent", "$(function() { $('#" & CollapsiblePanel1.ClientID & "').EWCCollapsiblePanelDynamicContent({ source: '" & Me.TemplateSourceDirectory & "', closeTxt: '" & GetLocalResourceObject("CollapsiblePanelDialogCerrar") & "'}); });" & Chr(13), True)
        Catch ex As Exception
            GestionError(ex)
        Finally
            Try
                CollapsiblePanel2.Visible = Not Page.IsValid
            Catch ex As Exception
                CollapsiblePanel1.NoCollapse = True
                CollapsiblePanel2.Visible = False
            End Try
        End Try
    End Sub

#Region "PRIVATE"
    ''' <summary>
    ''' Plegar/Desplegar los elementos de un Panel Plegable.
    ''' </summary>
    ''' <param name="panel">Panel cuyos elementos se desean plegar/desplegar.</param>
    ''' <param name="plegar">Boolean que determina la accion a llevar.
    ''' <c>True</c>: Plegar
    ''' <c>False</c>: Desplegar
    ''' </param>
    ''' <remarks></remarks>
    Private Sub CollapseItems(ByVal panel As CollapsiblePanel, ByVal plegar As Boolean)
        For Each item As Eustat.Comun.V35.Web.CollapsiblePanelItem In panel.Items
            item.Collapse = plegar
        Next
    End Sub

    ''' <summary>
    ''' Gestionar el panel plegable de ayuda cuando ocurre algun error.
    ''' </summary>
    ''' <param name="exc">Excepcion ocurrida en la generacion del panel plegable de ayuda.</param>
    ''' <remarks></remarks>
    Private Sub GestionError(ByVal exc As Exception)
        Dim excp As Exception = exc
        Dim _sesion As New AppSession
        _sesion.ErrorMessage = excp.Message
        _sesion.ErrorSource = excp.Source
        _sesion.StackTrace = excp.StackTrace

        panelError.Visible = True
        lblError.Text = "No se puede visualizar la ayuda opcional, ocurrio un error al intentar visualizar dicha informacin."

        CollapsiblePanel1.Visible = False
        Dim lista As List(Of String) = New List(Of String)
        lista.Add("Error producido al cargarse el Panel de Ayuda")
        Dim errores As ControlError = New ControlError()
        errores.Encuesta = ConfigurationManager.AppSettings("DefaultBD").ToString()
        errores.registrarError(excp, Request, lista, _sesion)
        Server.ClearError()
    End Sub
#End Region
End Class
