﻿Imports Eustat.Comun.V35.Web
Imports System.Data
Imports Eustat.Comun.V35.Fmk.Ng.MapNG

Partial Class _ctlResultados
    Inherits System.Web.UI.UserControl
    Implements IGestion


    Private _sesion As AppSession


#Region "Eventos genericos"

    Protected Sub Page_Init(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Init
        If (_sesion Is Nothing) Then
            _sesion = New AppSession
        End If
    End Sub
    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If (Not IsPostBack) Then
            'Resultado Encuesta
            Dim ResultadoVivLN As ResultadoViv = New ResultadoViv(_sesion.Operacion)
            DropDownListREncuesta.DataSource = ResultadoVivLN.GetDsResultadoViv
            DropDownListREncuesta.DataTextField = ResultadoVivLN.ColumnaDescripcion(_sesion.Idioma)
            DropDownListREncuesta.DataValueField = ResultadoVivLN.ColumnaId
            DropDownListREncuesta.DataBind()
            Dim ResultadosLN As Eustat.GEDW.V35.Ng.Resultados = New Eustat.GEDW.V35.Ng.Resultados(_sesion.Operacion, _sesion.Numc, _sesion.Aenc, _sesion.Idioma)
            DropDownListREncuesta.SelectedValue = ResultadosLN.GetDatosRviv()
            Page.Validate()
        End If
        If _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar Then
            ComprobarInformanteFam()
        Else
            Me.Label1.Visible = False
            Me.GridViewFam.Visible = False
        End If
    End Sub
#End Region

    Public Sub ComprobarInformanteFam()
        'Comprobaciones informante familiar
        If (DropDownListREncuesta.SelectedValue.Equals(Globales.RVIV_LOCALIZADA)) Then
            Dim ResultadosLN As Eustat.GEDW.V35.Ng.Resultados = New Eustat.GEDW.V35.Ng.Resultados(_sesion.Operacion, _sesion.Numc, _sesion.Aenc, _sesion.Idioma)
            'comprobar que el informante familiar es mayor de 16 años si no se ha establecido una edad minima para informante familiar y reside en la vivienda 
            If _sesion.EncuestaSeleccionadaInfo.EdadMinFam > 0 Then
                ctErrorInformanteFamBajaMenor.IsValid = Not (ResultadosLN.InformanteFamBaja())
            Else
                ctErrorInformanteFamBajaMenor.IsValid = Not ((ResultadosLN.InformanteFamMenor()) Or (ResultadosLN.InformanteFamBaja()))
            End If
        End If
    End Sub


    ''' <summary>
    ''' Cambiar el constructor por defecto de las clases de origen de datos para la consulta de viviendas
    ''' 
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Protected Sub ObjectDataSourceFam_ObjectCreating(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.ObjectDataSourceEventArgs) Handles ObjectDataSourceFam.ObjectCreating
        ' Create an instance of the business object using a non-default constructor.
        Dim e_Muestra As Eustat.GEDW.V35.Ng.Resultados = New Eustat.GEDW.V35.Ng.Resultados(_sesion.Operacion, _sesion.Numc, _sesion.Aenc, _sesion.Idioma)
        e.ObjectInstance = e_Muestra
    End Sub

    Protected Sub ObjectDataSourceInd_ObjectCreating(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.ObjectDataSourceEventArgs) Handles ObjectDataSourceInd.ObjectCreating
        ' Create an instance of the business object using a non-default constructor.
        Dim e_Muestra As Eustat.GEDW.V35.Ng.Resultados = New Eustat.GEDW.V35.Ng.Resultados(_sesion.Operacion, _sesion.Numc, _sesion.Aenc, _sesion.Idioma)
        e.ObjectInstance = e_Muestra
    End Sub


    Protected Sub GridViewFam_RowCreated(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewRowEventArgs) Handles GridViewFam.RowCreated
        If (e.Row.RowType = DataControlRowType.DataRow) Then
            Dim ctlPersonas As ctldplstPersonasViv = CType(e.Row.FindControl("ctlInformanteFam"), ctldplstPersonasViv)
            ctlPersonas.CargarDatos()
            ctlPersonas.NumFila = e.Row.RowIndex + 1
            Dim ctlResultadoFam As ctldplstResultadoC = CType(e.Row.FindControl("ctlResultadoFam"), ctldplstResultadoC)
            ctlResultadoFam.CargarDatos()
            ctlResultadoFam.NumFila = e.Row.RowIndex + 1
            Dim ctlMetodoFam As ctldplstMetodoEnt = CType(e.Row.FindControl("ctlMetodoFam"), ctldplstMetodoEnt)
            ctlMetodoFam.CargarDatos()
        End If
    End Sub



    Protected Sub GridViewInd_RowCreated(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewRowEventArgs) Handles GridViewInd.RowCreated
        If (e.Row.RowType = DataControlRowType.DataRow) Then
            Dim ctlPersonas As ctldplstPersonasViv = CType(e.Row.FindControl("ctlInformanteInd"), ctldplstPersonasViv)
            ctlPersonas.CargarDatos()
            ctlPersonas.NumFila = e.Row.RowIndex + 1
            Dim ctlResultadoInd As ctldplstResultadoC = CType(e.Row.FindControl("ctlResultadoInd"), ctldplstResultadoC)
            ctlResultadoInd.CargarDatos()
            ctlResultadoInd.NumFila = e.Row.RowIndex
            ctlResultadoInd.NumFila = e.Row.RowIndex + 1
            Dim ctlMetodoInd As ctldplstMetodoEnt = CType(e.Row.FindControl("ctlMetodoInd"), ctldplstMetodoEnt)
            ctlMetodoInd.CargarDatos()
        End If
    End Sub

    Protected Function ConvertirValorIdioma(ByVal o As Object) As String
        Dim result As String = ""
        If (Not IsDBNull(o)) Then
            If (o.ToString().Equals("es-ES")) Then
                result = GetLocalResourceObject("lblCastellano").ToString()
            ElseIf (o.ToString().Equals("eu-ES")) Then
                result = GetLocalResourceObject("lblEuskera").ToString()
            End If
        End If
        Return result
    End Function

    Protected Sub GridViewFam_RowDataBound(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewRowEventArgs) Handles GridViewFam.RowDataBound
        If (e.Row.RowType = DataControlRowType.DataRow) Then
            Dim ctlInformanteFam As ctldplstPersonasViv = CType(e.Row.FindControl("ctlInformanteFam"), ctldplstPersonasViv)
            Dim lnkbtnResumen As LinkButton = e.Row.FindControl("btnResumen")
            Dim agente As String = CType(e.Row.FindControl("lblAgente"), WebControls.Label).Text
            Dim TieneCopia As String = CType(e.Row.FindControl("lblTieneCopia"), WebControls.Label).Text

            ctlInformanteFam.EdadMinima = _sesion.EncuestaSeleccionadaInfo.EdadMinFam
            ctlInformanteFam.MostrarEdad = True
            ctlInformanteFam.CargarDatos()
            Dim ctlResultadoFam As ctldplstResultadoC = CType(e.Row.FindControl("ctlResultadoFam"), ctldplstResultadoC)
            Dim ctlMetodoFam As ctldplstMetodoEnt = CType(e.Row.FindControl("ctlMetodoFam"), ctldplstMetodoEnt)

            Dim ctlAccesoFam As ImageButton = CType(e.Row.FindControl("imgDetalleFam"), ImageButton)
            ctlAccesoFam.ImageUrl = ConfigurationManager.AppSettings("Images") & "quiz.png"
            Dim ctlCFam As String = CType(e.Row.FindControl("lblCFam"), WebControls.Label).Text
            Dim form As String = CType(e.Row.Cells(6).Controls(0), DataBoundLiteralControl).Text.Trim()
            Dim resfam As String = CType(e.Row.Cells(7).Controls(0), DataBoundLiteralControl).Text.Trim()
            ctlResultadoFam.SeleccionarValor = resfam
            ctlResultadoFam.Enabled = True
            ctlMetodoFam.SeleccionarValor = form

            If _sesion.IC.TieneIC Then
                If _sesion.GestionEncuestaMuestra.TieneInformantefamIC Then
                    ctlInformanteFam.SeleccionarValor = IC.VALOR_PERSONA_CONFIANZA
                End If
            End If
            If (resfam.Equals(Globales.COMPLETO)) Then
                LabelCPersonal.Visible = True
                GridViewInd.Visible = True
                ctlResultadoFam.Enabled = False
            Else
                GridViewInd.Visible = False
                LabelCPersonal.Visible = False
            End If
            If (Not (resfam.Equals(Globales.COMPLETO)) AndAlso Not (resfam.Equals(Globales.INCOMPLETO)) AndAlso Not (resfam.Equals(Globales.PENDIENTE))) Then
                ctlAccesoFam.Enabled = False
                ctlAccesoFam.Visible = False
                ctlInformanteFam.Enabled = False


            Else
                ctlAccesoFam.Enabled = True
                ctlAccesoFam.Visible = True
                ctlInformanteFam.Enabled = True

            End If

            
            If (DropDownListREncuesta.SelectedValue <> Globales.RVIV_LOCALIZADA) Then
                ctlInformanteFam.Enabled = False
                ctlResultadoFam.Enabled = False

                ctlAccesoFam.Enabled = False
                ctlAccesoFam.Visible = False

            Else
                If (ctlResultadoFam.SeleccionarValor.Equals(Globales.COMPLETO)) Then
                    ctlResultadoFam.Enabled = False
                End If
            End If


            If (form.Equals(Globales.FORM_WEB) Or form.Equals(Globales.FORM_MOVIL)) Then
                ctlMetodoFam.Enabled = False
            ElseIf (DropDownListREncuesta.SelectedValue = Globales.RVIV_LOCALIZADA) Then
                ctlMetodoFam.Enabled = True
            Else
                ctlMetodoFam.Enabled = False
            End If
            If (DropDownListREncuesta.SelectedValue = Globales.RVIV_LOCALIZADA) Then
                If (Not (ctlResultadoFam.SeleccionarValor.Equals(Globales.COMPLETO)) AndAlso Not (ctlResultadoFam.SeleccionarValor.Equals(Globales.INCOMPLETO)) AndAlso Not (ctlResultadoFam.SeleccionarValor.Equals(Globales.PENDIENTE))) Then
                    ctlMetodoFam.Required = False
                Else
                    ctlMetodoFam.Required = True
                End If
            End If

            'Vista encuestado
            If (DropDownListREncuesta.SelectedValue <> Globales.RVIV_LOCALIZADA) OrElse _
                ((Not (resfam.Equals(Globales.COMPLETO)) AndAlso Not (resfam.Equals(Globales.INCOMPLETO)))) Then
                lnkbtnResumen.Visible = False
            Else
                If String.IsNullOrEmpty(agente) Then
                    lnkbtnResumen.Visible = True
                ElseIf _sesion.EncuestaSeleccionadaInfo.HasCopia AndAlso TieneCopia.Equals("S") Then
                    lnkbtnResumen.Visible = True
                Else
                    lnkbtnResumen.Visible = False
                End If
            End If
        End If

    End Sub

    Protected Sub GridViewInd_RowDataBound(ByVal sender As Object, ByVal e As System.Web.UI.WebControls.GridViewRowEventArgs) Handles GridViewInd.RowDataBound
        If (e.Row.RowType = DataControlRowType.DataRow) Then
            Dim lblNind As String = CType(e.Row.FindControl("lblNind"), WebControls.Label).Text
            Dim lnkbtnResumen As LinkButton = e.Row.FindControl("btnResumen")
            Dim agente As String = CType(e.Row.FindControl("lblAgente"), WebControls.Label).Text
            Dim TieneCopia As String = CType(e.Row.FindControl("lblTieneCopia"), WebControls.Label).Text

            Dim ctlInformanteInd As ctldplstPersonasViv = CType(e.Row.FindControl("ctlInformanteInd"), ctldplstPersonasViv)
            ctlInformanteInd.EdadMinima = _sesion.EncuestaSeleccionadaInfo.EdadMinInd
            ctlInformanteInd.EdadMinimaNindIncluir = _sesion.EncuestaSeleccionadaInfo.EdadMinCuesPropio
            ctlInformanteInd.NindIncluir = lblNind
            ctlInformanteInd.MostrarEdad = True
            ctlInformanteInd.CargarDatos()
            Dim ctlResultadoInd As ctldplstResultadoC = CType(e.Row.FindControl("ctlResultadoInd"), ctldplstResultadoC)
            Dim ctlMetodoInd As ctldplstMetodoEnt = CType(e.Row.FindControl("ctlMetodoInd"), ctldplstMetodoEnt)
            Dim ctlAccesoInd As ImageButton = CType(e.Row.FindControl("imgDetalleInd"), ImageButton)
            ctlAccesoInd.ImageUrl = ConfigurationManager.AppSettings("Images") & "quiz.png"
            Dim ctlCInd As String = CType(e.Row.FindControl("lblCInd"), WebControls.Label).Text
            Dim form As String = CType(e.Row.Cells(7).Controls(0), DataBoundLiteralControl).Text.Trim()
            Dim resind As String = CType(e.Row.Cells(8).Controls(0), DataBoundLiteralControl).Text.Trim()
            If String.IsNullOrEmpty(resind) Then
                resind = Globales.PENDIENTE
            End If
            ctlResultadoInd.SeleccionarValor = resind
            ctlResultadoInd.Enabled = True
            ctlMetodoInd.SeleccionarValor = form

            If (resind.Equals(Globales.COMPLETO)) Then
                ctlResultadoInd.Enabled = False
            End If
            If (Not (resind.Equals(Globales.COMPLETO)) AndAlso Not (resind.Equals(Globales.INCOMPLETO)) AndAlso Not (resind.Equals(Globales.PENDIENTE))) Then
                ctlAccesoInd.Enabled = False
                ctlAccesoInd.Visible = False
                ctlInformanteInd.Enabled = False
            Else
                ctlAccesoInd.Enabled = DropDownListREncuesta.SelectedValue = Globales.RVIV_LOCALIZADA
                ctlAccesoInd.Visible = DropDownListREncuesta.SelectedValue = Globales.RVIV_LOCALIZADA
                ctlInformanteInd.Enabled = DropDownListREncuesta.SelectedValue = Globales.RVIV_LOCALIZADA
                ctlResultadoInd.Enabled = DropDownListREncuesta.SelectedValue = Globales.RVIV_LOCALIZADA
            End If
            If (DropDownListREncuesta.SelectedValue <> Globales.RVIV_LOCALIZADA) Then
                ctlInformanteInd.Enabled = False
                ctlResultadoInd.Enabled = False
                ctlAccesoInd.Enabled = False
                ctlAccesoInd.Visible = False
            Else
                If (ctlResultadoInd.SeleccionarValor.Equals(Globales.COMPLETO)) Then
                    ctlResultadoInd.Enabled = False
                End If
            End If
            If (form.Equals(Globales.FORM_WEB) Or form.Equals(Globales.FORM_MOVIL)) Then
                ctlMetodoInd.Enabled = False
            ElseIf (DropDownListREncuesta.SelectedValue = Globales.RVIV_LOCALIZADA) Then
                ctlMetodoInd.Enabled = True
            Else
                ctlMetodoInd.Enabled = False
            End If
            If (DropDownListREncuesta.SelectedValue = Globales.RVIV_LOCALIZADA) Then
                If (Not (ctlResultadoInd.SeleccionarValor.Equals(Globales.COMPLETO)) AndAlso Not (ctlResultadoInd.SeleccionarValor.Equals(Globales.INCOMPLETO)) AndAlso Not (ctlResultadoInd.SeleccionarValor.Equals(Globales.PENDIENTE))) Then
                    ctlMetodoInd.Required = False
                Else
                    ctlMetodoInd.Required = True
                End If
            End If

            'Vista encuestado
            If (DropDownListREncuesta.SelectedValue <> Globales.RVIV_LOCALIZADA) OrElse _
                ((Not (resind.Equals(Globales.COMPLETO)) AndAlso Not (resind.Equals(Globales.INCOMPLETO)))) Then
                lnkbtnResumen.Visible = False
            Else
                If String.IsNullOrEmpty(agente) Then
                    lnkbtnResumen.Visible = True
                ElseIf _sesion.EncuestaSeleccionadaInfo.HasCopia AndAlso TieneCopia.Equals("S") Then
                    lnkbtnResumen.Visible = True
                Else
                    lnkbtnResumen.Visible = False
                End If
            End If
        End If
    End Sub

    Protected Sub MydplstResultFam_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs, ByVal num As Integer)
        Dim comboresult As DropDownList = CType(sender, DropDownList)
        Dim ctlInformanteFam As ctldplstPersonasViv = CType(GridViewFam.Rows(num).FindControl("ctlInformanteFam"), ctldplstPersonasViv)
        Dim ctlResultadoFam As ctldplstResultadoC = CType(GridViewFam.Rows(num).FindControl("ctlResultadoFam"), ctldplstResultadoC)
        Dim ctlMetodoFam As ctldplstMetodoEnt = CType(GridViewFam.Rows(num).FindControl("ctlMetodoFam"), ctldplstMetodoEnt)
        Dim ctlAccesoFam As ImageButton = CType(GridViewFam.Rows(num).FindControl("imgDetalleFam"), ImageButton)

        If ((DropDownListREncuesta.SelectedValue <> Globales.RVIV_LOCALIZADA) Or (Not (comboresult.SelectedValue.Equals(Globales.COMPLETO)) AndAlso Not (comboresult.SelectedValue.Equals(Globales.INCOMPLETO)) AndAlso Not (comboresult.SelectedValue.Equals(Globales.PENDIENTE)))) Then
            ctlAccesoFam.Visible = False
            ctlAccesoFam.Enabled = False
            ctlInformanteFam.SeleccionarValor = -1
            ctlInformanteFam.Enabled = False    
        Else
            ctlAccesoFam.Visible = True
            ctlAccesoFam.Enabled = True
            ctlInformanteFam.Enabled = True
            ctlMetodoFam.Enabled = True
        End If

        If (DropDownListREncuesta.SelectedValue = Globales.RVIV_LOCALIZADA) Then
            If (Not (ctlResultadoFam.SeleccionarValor.Equals(Globales.COMPLETO)) AndAlso Not (ctlResultadoFam.SeleccionarValor.Equals(Globales.INCOMPLETO)) AndAlso Not (ctlResultadoFam.SeleccionarValor.Equals(Globales.PENDIENTE))) Then
                ctlMetodoFam.Required = False
            Else
                ctlMetodoFam.Required = True
            End If
        End If
        'Context.ApplicationInstance.CompleteRequest()
        _sesion.CambiosEnPagina = True
    End Sub

    Protected Sub MydplstResultInd_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs, ByVal num As Integer)
        Dim comboresult As DropDownList = CType(sender, DropDownList)
        Dim ctlInformanteInd As ctldplstPersonasViv = CType(GridViewInd.Rows(num).FindControl("ctlInformanteInd"), ctldplstPersonasViv)
        Dim ctlResultadoInd As ctldplstResultadoC = CType(GridViewInd.Rows(num).FindControl("ctlResultadoInd"), ctldplstResultadoC)
        Dim ctlMetodoInd As ctldplstMetodoEnt = CType(GridViewInd.Rows(num).FindControl("ctlMetodoInd"), ctldplstMetodoEnt)
        Dim ctlAccesoInd As ImageButton = CType(GridViewInd.Rows(num).FindControl("imgDetalleInd"), ImageButton)

        If ((DropDownListREncuesta.SelectedValue <> Globales.RVIV_LOCALIZADA) Or (Not (comboresult.SelectedValue.Equals(Globales.COMPLETO)) AndAlso Not (comboresult.SelectedValue.Equals(Globales.INCOMPLETO)) AndAlso Not (comboresult.SelectedValue.Equals(Globales.PENDIENTE)))) Then
            ctlAccesoInd.Visible = False
            ctlAccesoInd.Enabled = False
            ctlInformanteInd.SeleccionarValor = -1
            ctlInformanteInd.Enabled = False        
        Else
            ctlAccesoInd.Visible = DropDownListREncuesta.SelectedValue = Globales.RVIV_LOCALIZADA
            ctlAccesoInd.Enabled = DropDownListREncuesta.SelectedValue = Globales.RVIV_LOCALIZADA
            ctlInformanteInd.Enabled = DropDownListREncuesta.SelectedValue = Globales.RVIV_LOCALIZADA
            ctlMetodoInd.Enabled = DropDownListREncuesta.SelectedValue = Globales.RVIV_LOCALIZADA
        End If

        If (DropDownListREncuesta.SelectedValue = Globales.RVIV_LOCALIZADA) Then
            If (Not (comboresult.SelectedValue.Equals(Globales.COMPLETO)) AndAlso Not (comboresult.SelectedValue.Equals(Globales.INCOMPLETO)) AndAlso Not (comboresult.SelectedValue.Equals(Globales.PENDIENTE))) Then
                ctlMetodoInd.Required = False
            Else
                ctlMetodoInd.Required = True
            End If
        End If
        'Context.ApplicationInstance.CompleteRequest()
        _sesion.CambiosEnPagina = True
    End Sub


    Public Function GuardarCambios() As Boolean Implements IGestion.GuardarCambios
        Try
            _sesion.CambiosEnPagina = False
            Dim sit_finalizada_fam As Boolean = False
            Dim sit_finalizada_parc_ind As Boolean = False
            Dim sit_finalizada_total_ind As Boolean = False
            Dim num_finalizadas_ind As Integer = 0
            Dim num_incidencias As Integer = 0
            Dim situacion_final As String = Globales.SITUAC_ENCAMPO
            Dim resul As Boolean = False
            Dim htCambios As Hashtable = New Hashtable()
            Page.Validate()
            If (Page.IsValid) Then

                Dim ResultadosLN As Resultados = New Eustat.GEDW.V35.Ng.Resultados(_sesion.Operacion, _sesion.Numc, _sesion.Aenc, _sesion.Idioma)

                If (GridViewFam.Visible And GridViewFam.Enabled) Then
                    Dim ctlInformanteFam As ctldplstPersonasViv = CType(GridViewFam.Rows(0).FindControl("ctlInformanteFam"), ctldplstPersonasViv)
                    Dim ctlResultadoFam As ctldplstResultadoC = CType(GridViewFam.Rows(0).FindControl("ctlResultadoFam"), ctldplstResultadoC)
                    Dim ctlMetodoFam As ctldplstMetodoEnt = CType(GridViewFam.Rows(0).FindControl("ctlMetodoFam"), ctldplstMetodoEnt)
                    Dim nind As String = CType(GridViewFam.Rows(0).FindControl("lblNind"), WebControls.Label).Text
                    
                    ResultadosLN.ActualizarDatosFam(ctlInformanteFam.SeleccionarValor, ctlResultadoFam.SeleccionarValor, ctlMetodoFam.SeleccionarValor)
                    If (ctlResultadoFam.SeleccionarValor.Equals(Globales.COMPLETO)) Then
                        sit_finalizada_fam = True
                    Else
                        Dim estadoincidencia As Boolean = (Not (ctlResultadoFam.SeleccionarValor.Equals(Globales.PENDIENTE)) AndAlso Not (ctlResultadoFam.SeleccionarValor.Equals(Globales.INCOMPLETO)))
                        If (estadoincidencia) Then
                            num_incidencias = num_incidencias + 1
                        End If
                    End If
                    ComprobarInformanteFam()
                End If
                If (GridViewInd.Visible And GridViewInd.Enabled) Then
                    Dim dtAux As DataSet = ResultadosLN.obtenerEstructuraBaseInd()
                    'recorremos el grid para los casos que haya más de un informante personal
                    For Each dt As GridViewRow In GridViewInd.Rows
                        Dim ctlInformanteInd As ctldplstPersonasViv = CType(dt.FindControl("ctlInformanteInd"), ctldplstPersonasViv)
                        Dim ctlResultadoInd As ctldplstResultadoC = CType(dt.FindControl("ctlResultadoInd"), ctldplstResultadoC)
                        Dim ctlMetodoInd As ctldplstMetodoEnt = CType(dt.FindControl("ctlMetodoInd"), ctldplstMetodoEnt)
                        Dim nindInd As String = CType(dt.FindControl("lblNind"), WebControls.Label).Text
                        Dim selectedRow As DataRow = dtAux.Tables(0).Select(Resultados.IdentColumnNind & " = '" & nindInd & "'")(0)
                        selectedRow(Resultados.IdentColumnInfper) = ctlInformanteInd.SeleccionarValor
                        selectedRow(Resultados.IdentColumnResper) = ctlResultadoInd.SeleccionarValor
                        selectedRow(Resultados.IdentColumnformper) = ctlMetodoInd.SeleccionarValor
                        If (ctlResultadoInd.SeleccionarValor.Equals(Globales.COMPLETO)) Then
                            num_finalizadas_ind = num_finalizadas_ind + 1
                        Else
                            Dim estadoincidencia As Boolean = (Not (ctlResultadoInd.SeleccionarValor.Equals(Globales.PENDIENTE)) AndAlso Not (ctlResultadoInd.SeleccionarValor.Equals(Globales.INCOMPLETO)))
                            If (estadoincidencia) Then
                                num_incidencias = num_incidencias + 1
                            End If
                        End If

                    Next
                    ResultadosLN.guardarDatosPer(dtAux)
                End If
                If (DropDownListREncuesta.SelectedValue <> Globales.RVIV_LOCALIZADA OrElse (num_incidencias > 0)) Then
                    situacion_final = Globales.SITUAC_INCIDENCIAS
                Else
                    If (sit_finalizada_fam) Or (Not _sesion.EncuestaSeleccionadaInfo.HasCuestionarioFamiliar And DropDownListREncuesta.SelectedValue.Equals(Globales.RVIV_LOCALIZADA) And num_incidencias = 0) Then
                        If (num_finalizadas_ind = GridViewInd.Rows.Count) Then
                            If _sesion.EncuestaSeleccionadaInfo.HasProcesoValidacion Then
                                situacion_final = Globales.SITUAC_FINAL_SINVALIDAR
                            Else
                                situacion_final = Globales.SITUAC_FINALIZADA
                            End If
                        End If
                    End If
                End If

                ResultadosLN.ActualizarDatosRviv(DropDownListREncuesta.SelectedValue, situacion_final)
                If (sit_finalizada_fam) Then
                    LabelCPersonal.Visible = True
                    GridViewInd.Visible = True
                End If
                If (DropDownListREncuesta.SelectedValue.Equals(Globales.RVIV_LOCALIZADA)) Then
                    'Almaceno el resultado de contactado en la vivienda
                    Dim contacto As ConContactos = New ConContactos(_sesion.Operacion, _sesion.Numc, _sesion.Aenc, _sesion.Trim)
                    If (Not IsNothing(_sesion.Trim)) Then
                        contacto.ActualizarRContactoViviendaAnioTrim()
                    Else
                        contacto.ActualizarRContactoVivienda()
                    End If
                End If
                resul = True
            End If
                Return resul
        Catch ex As Exception
            Throw ex
        End Try
    End Function

    Public Function GuardarCambiosFam() As Boolean
        Try
            _sesion.CambiosEnPagina = False
            Dim sit_finalizada_fam As Boolean = False
            Dim sit_finalizada_parc_ind As Boolean = False
            Dim sit_finalizada_total_ind As Boolean = False
            Dim num_finalizadas_ind As Integer = 0
            Dim num_incidencias As Integer = 0
            Dim situacion_final As String = Globales.SITUAC_ENCAMPO
            Dim resul As Boolean = False
            Dim htCambios As Hashtable = New Hashtable()


            Dim ResultadosLN As Resultados = New Eustat.GEDW.V35.Ng.Resultados(_sesion.Operacion, _sesion.Numc, _sesion.Aenc, _sesion.Idioma)
            Dim ctlInformanteFam As ctldplstPersonasViv = CType(GridViewFam.Rows(0).FindControl("ctlInformanteFam"), ctldplstPersonasViv)
            Dim ctlResultadoFam As ctldplstResultadoC = CType(GridViewFam.Rows(0).FindControl("ctlResultadoFam"), ctldplstResultadoC)
            Dim ctlMetodoFam As ctldplstMetodoEnt = CType(GridViewFam.Rows(0).FindControl("ctlMetodoFam"), ctldplstMetodoEnt)

            Dim nind As String = CType(GridViewFam.Rows(0).FindControl("lblNind"), WebControls.Label).Text
            Page.Validate()
            If (DropDownListREncuesta.IsValid And ctlInformanteFam.isValid And ctlResultadoFam.isValid And ctlMetodoFam.isValid) Then


                ResultadosLN.ActualizarDatosFam(ctlInformanteFam.SeleccionarValor, ctlResultadoFam.SeleccionarValor, ctlMetodoFam.SeleccionarValor)
                If (ctlResultadoFam.SeleccionarValor.Equals(Globales.COMPLETO)) Then
                    sit_finalizada_fam = True
                Else
                    Dim estadoincidencia As Boolean = (Not (ctlResultadoFam.SeleccionarValor.Equals(Globales.PENDIENTE)) AndAlso Not (ctlResultadoFam.SeleccionarValor.Equals(Globales.INCOMPLETO)))
                    If (estadoincidencia) Then
                        num_incidencias = num_incidencias + 1
                    End If
                End If


                If (sit_finalizada_fam) Then
                    LabelCPersonal.Visible = True
                    GridViewInd.Visible = True
                End If
                ResultadosLN.ActualizarDatosResultViv(DropDownListREncuesta.SelectedValue)
                If (DropDownListREncuesta.SelectedValue.Equals(Globales.RVIV_LOCALIZADA)) Then
                    'Almaceno el resultado de contactado en la vivienda
                    Dim contacto As ConContactos = New ConContactos(_sesion.Operacion, _sesion.Numc, _sesion.Aenc, _sesion.Trim)
                    If (Not IsNothing(_sesion.Trim)) Then
                        contacto.ActualizarRContactoViviendaAnioTrim()
                    Else
                        contacto.ActualizarRContactoVivienda()
                    End If
                End If
                resul = True
            End If
            Return resul
        Catch ex As Exception
            Throw ex
        End Try
    End Function

    Public Function GuardarCambiosInd(ByVal dt As GridViewRow) As Boolean
        Try
            _sesion.CambiosEnPagina = False
            Dim sit_finalizada_fam As Boolean = False
            Dim sit_finalizada_parc_ind As Boolean = False
            Dim sit_finalizada_total_ind As Boolean = False
            Dim num_finalizadas_ind As Integer = 0
            Dim num_incidencias As Integer = 0
            Dim situacion_final As String = Globales.SITUAC_ENCAMPO
            Dim resul As Boolean = False
            Dim htCambios As Hashtable = New Hashtable()


            Dim ResultadosLN As Resultados = New Eustat.GEDW.V35.Ng.Resultados(_sesion.Operacion, _sesion.Numc, _sesion.Aenc, _sesion.Idioma)


            Dim dtAux As DataSet = ResultadosLN.obtenerEstructuraBaseInd()
            Dim ctlInformanteInd As ctldplstPersonasViv = CType(dt.FindControl("ctlInformanteInd"), ctldplstPersonasViv)
            Dim ctlResultadoInd As ctldplstResultadoC = CType(dt.FindControl("ctlResultadoInd"), ctldplstResultadoC)
            Dim ctlMetodoInd As ctldplstMetodoEnt = CType(dt.FindControl("ctlMetodoInd"), ctldplstMetodoEnt)

            Page.Validate()
            If (DropDownListREncuesta.IsValid And ctlInformanteInd.isValid And ctlResultadoInd.isValid And ctlMetodoInd.isValid) Then

                Dim nindInd As String = CType(dt.FindControl("lblNind"), WebControls.Label).Text
                Dim selectedRow As DataRow = dtAux.Tables(0).Select(Resultados.IdentColumnNind & " = '" & nindInd & "'")(0)
                selectedRow(Resultados.IdentColumnInfper) = ctlInformanteInd.SeleccionarValor
                selectedRow(Resultados.IdentColumnResper) = ctlResultadoInd.SeleccionarValor
                selectedRow(Resultados.IdentColumnformper) = ctlMetodoInd.SeleccionarValor
                If (ctlResultadoInd.SeleccionarValor.Equals(Globales.COMPLETO)) Then
                    num_finalizadas_ind = num_finalizadas_ind + 1
                Else
                    Dim estadoincidencia As Boolean = (Not (ctlResultadoInd.SeleccionarValor.Equals(Globales.PENDIENTE)) AndAlso Not (ctlResultadoInd.SeleccionarValor.Equals(Globales.INCOMPLETO)))
                    If (estadoincidencia) Then
                        num_incidencias = num_incidencias + 1
                    End If
                End If

                ResultadosLN.guardarDatosPer(dtAux)
                ResultadosLN.ActualizarDatosResultViv(DropDownListREncuesta.SelectedValue)
                If (DropDownListREncuesta.SelectedValue.Equals(Globales.RVIV_LOCALIZADA)) Then
                    'Almaceno el resultado de contactado en la vivienda
                    Dim contacto As ConContactos = New ConContactos(_sesion.Operacion, _sesion.Numc, _sesion.Aenc, _sesion.Trim)
                    If (Not IsNothing(_sesion.Trim)) Then
                        contacto.ActualizarRContactoViviendaAnioTrim()
                    Else
                        contacto.ActualizarRContactoVivienda()
                    End If
                End If
                resul = True
            End If

            Return resul
        Catch ex As Exception
            Throw ex
        End Try
    End Function




    'Evento para visualizar la encuesta concreta
    Protected Sub ClickFam(ByVal sender As Object, ByVal e As EventArgs)

        If _sesion.IC.TieneIC Then
            ActualizarMuestra()
        End If

        Dim img As ImageButton = CType(sender, ImageButton)
        Dim tableC As DataControlFieldCell = CType(img.Parent, DataControlFieldCell)
        Dim gridR As GridViewRow = CType(tableC.Parent, GridViewRow)
        If (GuardarCambiosFam() AndAlso GuardarCambios()) Then
            Dim ctlInformanteFam As ctldplstPersonasViv = CType(gridR.FindControl("ctlInformanteFam"), ctldplstPersonasViv)

            Dim nind As String

            nind = ctlInformanteFam.SeleccionarValor

            Dim hdnIdioma As HiddenField = CType(gridR.FindControl("hdnIdiomaFam"), HiddenField)
            Dim idioma As String = _sesion.Idioma
            If (Not String.IsNullOrEmpty(hdnIdioma.Value)) Then
                idioma = hdnIdioma.Value
            End If

            'no establecido valor de querystring por seguridad. Contactar con Eustat
            Dim querystring As String = ""

            Dim strRuta As String = "winenc = window.open('" + ObtenerURLAcceso(_sesion.Operacion, querystring, _sesion.Idioma) + "','Encuesta');"

            'Almaceno el resultado de contactado en la vivienda
            Dim contacto As ConContactos = New ConContactos(_sesion.Operacion, _sesion.Numc, _sesion.Aenc, _sesion.Trim)
            If (Not IsNothing(_sesion.Trim)) Then
                contacto.ActualizarRContactoViviendaAnioTrim()
            Else
                contacto.ActualizarRContactoVivienda()
            End If

            ScriptManager.RegisterStartupScript(Page, Page.GetType(), "newWindow", "javascrip:" & strRuta & ";", True)

            ScriptManager.RegisterStartupScript(Page, Page.GetType(), "modWindow", "javascrip:ShowPopup();", True)
        End If
    End Sub

    'Evento para visualizar la encuesta concreta
    Protected Sub ClickInd(ByVal sender As Object, ByVal e As EventArgs)
        If _sesion.IC.TieneIC Then
            ActualizarMuestra()
        End If

        Dim img As ImageButton = CType(sender, ImageButton)
        Dim tableC As DataControlFieldCell = CType(img.Parent, DataControlFieldCell)
        Dim gridR As GridViewRow = CType(tableC.Parent, GridViewRow)
        If (GuardarCambiosInd(gridR) AndAlso GuardarCambios()) Then
            Dim ctlInformanteInd As ctldplstPersonasViv = CType(gridR.FindControl("ctlInformanteInd"), ctldplstPersonasViv)
            Dim nind As String

            Dim hdnIdioma As HiddenField = CType(gridR.FindControl("hdnIdiomaInd"), HiddenField)
            Dim idioma As String = _sesion.Idioma
            If (Not String.IsNullOrEmpty(hdnIdioma.Value)) Then
                idioma = hdnIdioma.Value
            End If

            Dim queryString As String
            Dim strRuta As String


            'encuestas demograficas implementadas en Canal Web 2.0
            Dim informante As String
            informante = ctlInformanteInd.SeleccionarValor()
            Dim ctlNind As System.Web.UI.WebControls.Label = CType(gridR.FindControl("lblNind"), System.Web.UI.WebControls.Label)
            nind = ctlNind.Text
            'no establecido valor de querystring por seguridad. Contactar con Eustat
            queryString = ""

            strRuta = "winenc = window.open('" + ObtenerURLAcceso(_sesion.Operacion, queryString, _sesion.Idioma) + "','Encuesta');"

            ScriptManager.RegisterStartupScript(Page, Page.GetType(), "newWindow", "javascrip:" & strRuta & ";", True)

            ScriptManager.RegisterStartupScript(Page, Page.GetType(), "modWindow", "javascrip:ShowPopup();", True)
        End If
    End Sub

    'Evento para visualizar el resumen de la respuestas originalesdel encuestado la encuesta concreta
    Protected Sub ClickFamResumen(ByVal sender As Object, ByVal e As EventArgs)

        

        Dim btn As LinkButton = CType(sender, LinkButton)
        Dim tableC As DataControlFieldCell = CType(btn.Parent, DataControlFieldCell)
        Dim gridR As GridViewRow = CType(tableC.Parent, GridViewRow)

        Dim ctlInformanteFam As ctldplstPersonasViv = CType(gridR.FindControl("ctlInformanteFam"), ctldplstPersonasViv)

        Dim nind As String

        nind = ctlInformanteFam.SeleccionarValor

        Dim hdnIdioma As HiddenField = CType(gridR.FindControl("hdnIdiomaFam"), HiddenField)
        Dim idioma As String = _sesion.Idioma
        If (Not String.IsNullOrEmpty(hdnIdioma.Value)) Then
            idioma = hdnIdioma.Value
        End If


         'no establecido valor de querystring por seguridad. Contactar con Eustat
        Dim querystring As String = ""

        Dim strRuta As String = "winenc = window.open('" + ObtenerURLAcceso(_sesion.Operacion, querystring, _sesion.Idioma) + "','Encuesta');"

        ScriptManager.RegisterStartupScript(Page, Page.GetType(), "newWindow", "javascrip:" & strRuta & ";", True)
        ScriptManager.RegisterStartupScript(Page, Page.GetType(), "modWindow", "javascrip:ShowPopup();", True)

    End Sub

    'Evento para visualizar el resumen de la respuestas originales del encuestado la encuesta concreta
    Protected Sub ClickIndResumen(ByVal sender As Object, ByVal e As EventArgs)
        
        Dim btn As linkButton = CType(sender, linkButton)
        Dim tableC As DataControlFieldCell = CType(btn.Parent, DataControlFieldCell)
        Dim gridR As GridViewRow = CType(tableC.Parent, GridViewRow)
        
        Dim ctlInformanteInd As ctldplstPersonasViv = CType(gridR.FindControl("ctlInformanteInd"), ctldplstPersonasViv)
        Dim nind As String

        Dim hdnIdioma As HiddenField = CType(gridR.FindControl("hdnIdiomaInd"), HiddenField)
        Dim idioma As String = _sesion.Idioma
        If (Not String.IsNullOrEmpty(hdnIdioma.Value)) Then
            idioma = hdnIdioma.Value
        End If

        Dim queryString As String
        Dim strRuta As String
        Dim informante As String
            informante = ctlInformanteInd.SeleccionarValor()
            Dim ctlNind As System.Web.UI.WebControls.Label = CType(gridR.FindControl("lblNind"), System.Web.UI.WebControls.Label)
            nind = ctlNind.Text
        'no establecido valor de querystring por seguridad. Contactar con Eustat
        queryString = ""

        strRuta = "winenc = window.open('" + ObtenerURLAcceso(_sesion.Operacion, queryString, _sesion.Idioma) + "','Encuesta');"

        ScriptManager.RegisterStartupScript(Page, Page.GetType(), "newWindow", "javascrip:" & strRuta & ";", True)

        ScriptManager.RegisterStartupScript(Page, Page.GetType(), "modWindow", "javascrip:ShowPopup();", True)

    End Sub

    Protected Sub DropDownListREncuesta_SelectedIndexChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles DropDownListREncuesta.SelectedIndexChanged
        _sesion.CambiosEnPagina = True
        Dim combo As DropDownList = CType(sender, DropDownList)
        If (combo.SelectedValue <> Globales.RVIV_LOCALIZADA) Then
            GridViewFam.Enabled = False
            GridViewInd.Enabled = False
            For Each dt As GridViewRow In GridViewFam.Rows
                Dim ctlInformanteFam As ctldplstPersonasViv = CType(dt.FindControl("ctlInformanteFam"), ctldplstPersonasViv)
                Dim ctlResultadoFam As ctldplstResultadoC = CType(dt.FindControl("ctlResultadoFam"), ctldplstResultadoC)
                Dim ctlMetodoFam As ctldplstMetodoEnt = CType(dt.FindControl("ctlMetodoFam"), ctldplstMetodoEnt)

                Dim ctlAccesoFam As ImageButton = CType(dt.FindControl("imgDetalleFam"), ImageButton)
                ctlInformanteFam.Enabled = False
                ctlResultadoFam.Enabled = False
                ctlMetodoFam.Enabled = False
                If (ctlResultadoFam.SeleccionarValor.Equals(Globales.COMPLETO)) Then
                    ctlResultadoFam.Enabled = False
                End If
                If (Not (ctlResultadoFam.SeleccionarValor.Equals(Globales.COMPLETO)) AndAlso Not (ctlResultadoFam.SeleccionarValor.Equals(Globales.INCOMPLETO)) AndAlso Not (ctlResultadoFam.SeleccionarValor.Equals(Globales.PENDIENTE))) Then
                    ctlAccesoFam.Enabled = False
                    ctlAccesoFam.Visible = False
                Else
                    ctlAccesoFam.Enabled = True
                    ctlAccesoFam.Visible = True
                End If
                If (ctlMetodoFam.SeleccionarValor.Equals(Globales.FORM_WEB) Or ctlMetodoFam.SeleccionarValor.Equals(Globales.FORM_MOVIL)) Then
                    ctlMetodoFam.Enabled = False
                End If
            Next
            For Each dt As GridViewRow In GridViewInd.Rows
                Dim ctlInformanteInd As ctldplstPersonasViv = CType(dt.FindControl("ctlInformanteInd"), ctldplstPersonasViv)
                Dim ctlResultadoInd As ctldplstResultadoC = CType(dt.FindControl("ctlResultadoInd"), ctldplstResultadoC)
                Dim ctlMetodoInd As ctldplstMetodoEnt = CType(dt.FindControl("ctlMetodoInd"), ctldplstMetodoEnt)

                Dim ctlAccesoInd As ImageButton = CType(dt.FindControl("imgDetalleInd"), ImageButton)
                ctlInformanteInd.Enabled = False
                ctlResultadoInd.Enabled = False
                ctlMetodoInd.Enabled = False
                If (ctlResultadoInd.SeleccionarValor.Equals(Globales.COMPLETO)) Then
                    ctlResultadoInd.Enabled = False
                End If
                If (Not (ctlResultadoInd.SeleccionarValor.Equals(Globales.COMPLETO)) AndAlso Not (ctlResultadoInd.SeleccionarValor.Equals(Globales.INCOMPLETO)) AndAlso Not (ctlResultadoInd.SeleccionarValor.Equals(Globales.PENDIENTE))) Then
                    ctlAccesoInd.Enabled = False
                    ctlAccesoInd.Visible = False
                Else
                    ctlAccesoInd.Enabled = DropDownListREncuesta.SelectedValue = Globales.RVIV_LOCALIZADA
                    ctlAccesoInd.Visible = DropDownListREncuesta.SelectedValue = Globales.RVIV_LOCALIZADA
                End If
                If (ctlMetodoInd.SeleccionarValor.Equals(Globales.FORM_WEB) Or ctlMetodoInd.SeleccionarValor.Equals(Globales.FORM_MOVIL)) Then
                    ctlMetodoInd.Enabled = False
                End If

            Next
        Else
            GridViewFam.Enabled = True
            GridViewInd.Enabled = True
            For Each dt As GridViewRow In GridViewFam.Rows
                Dim ctlInformanteFam As ctldplstPersonasViv = CType(dt.FindControl("ctlInformanteFam"), ctldplstPersonasViv)
                Dim ctlResultadoFam As ctldplstResultadoC = CType(dt.FindControl("ctlResultadoFam"), ctldplstResultadoC)
                Dim ctlMetodoFam As ctldplstMetodoEnt = CType(dt.FindControl("ctlMetodoFam"), ctldplstMetodoEnt)
                Dim ctlAccesoFam As ImageButton = CType(dt.FindControl("imgDetalleFam"), ImageButton)
                ctlInformanteFam.Enabled = True
                ctlResultadoFam.Enabled = True
                ctlMetodoFam.Enabled = True
                If (ctlResultadoFam.SeleccionarValor.Equals(Globales.COMPLETO)) Then
                    ctlResultadoFam.Enabled = False
                End If
                If (Not (ctlResultadoFam.SeleccionarValor.Equals(Globales.COMPLETO)) AndAlso Not (ctlResultadoFam.SeleccionarValor.Equals(Globales.INCOMPLETO)) AndAlso Not (ctlResultadoFam.SeleccionarValor.Equals(Globales.PENDIENTE))) Then
                    ctlAccesoFam.Enabled = False
                    ctlAccesoFam.Visible = False
                Else
                    ctlAccesoFam.Enabled = True
                    ctlAccesoFam.Visible = True
                End If
                If (ctlMetodoFam.SeleccionarValor.Equals(Globales.FORM_WEB) Or ctlMetodoFam.SeleccionarValor.Equals(Globales.FORM_MOVIL)) Then
                    ctlMetodoFam.Enabled = False
                End If
            Next
            For Each dt As GridViewRow In GridViewInd.Rows
                Dim ctlInformanteInd As ctldplstPersonasViv = CType(dt.FindControl("ctlInformanteInd"), ctldplstPersonasViv)
                Dim ctlResultadoInd As ctldplstResultadoC = CType(dt.FindControl("ctlResultadoInd"), ctldplstResultadoC)
                Dim ctlMetodoInd As ctldplstMetodoEnt = CType(dt.FindControl("ctlMetodoInd"), ctldplstMetodoEnt)
                Dim ctlAccesoInd As ImageButton = CType(dt.FindControl("imgDetalleInd"), ImageButton)
                ctlInformanteInd.Enabled = True
                ctlResultadoInd.Enabled = True
                ctlMetodoInd.Enabled = True
                If (ctlResultadoInd.SeleccionarValor.Equals(Globales.COMPLETO)) Then
                    ctlResultadoInd.Enabled = False
                End If
                If (Not (ctlResultadoInd.SeleccionarValor.Equals(Globales.COMPLETO)) AndAlso Not (ctlResultadoInd.SeleccionarValor.Equals(Globales.INCOMPLETO)) AndAlso Not (ctlResultadoInd.SeleccionarValor.Equals(Globales.PENDIENTE))) Then
                    ctlAccesoInd.Enabled = False
                    ctlAccesoInd.Visible = False
                Else
                    ctlAccesoInd.Enabled = DropDownListREncuesta.SelectedValue = Globales.RVIV_LOCALIZADA
                    ctlAccesoInd.Visible = DropDownListREncuesta.SelectedValue = Globales.RVIV_LOCALIZADA
                End If
                If (ctlMetodoInd.SeleccionarValor.Equals(Globales.FORM_WEB) Or ctlMetodoInd.SeleccionarValor.Equals(Globales.FORM_MOVIL)) Then
                    ctlMetodoInd.Enabled = False
                End If
            Next
        End If
    End Sub

    Protected Sub ctErrorInformanteFamBajaMenor_ServerValidate(ByVal source As Object, ByVal args As System.Web.UI.WebControls.ServerValidateEventArgs) Handles ctErrorInformanteFamBajaMenor.ServerValidate

    End Sub


    Private Sub ActualizarMuestra()
        If Not (_sesion.GestionEncuestaMuestra) Is Nothing AndAlso _sesion.Numc = _sesion.GestionEncuestaMuestra.Numc And _sesion.Aenc = _sesion.GestionEncuestaMuestra.Aenc And _sesion.Trim = _sesion.GestionEncuestaMuestra.Tenc And _sesion.Semana = _sesion.GestionEncuestaMuestra.Sem Then
            _sesion.GestionEncuestaMuestra.Actualizar()
        End If
    End Sub
End Class
